/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.ccache;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.StringTokenizer;
import java.util.Vector;
import sun.security.action.GetPropertyAction;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.Realm;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.LoginOptions;
import sun.security.krb5.internal.ccache.CCacheInputStream;
import sun.security.krb5.internal.ccache.CCacheOutputStream;
import sun.security.krb5.internal.ccache.Credentials;
import sun.security.krb5.internal.ccache.CredentialsCache;
import sun.security.krb5.internal.ccache.FileCCacheConstants;
import sun.security.krb5.internal.ccache.Tag;
import sun.security.krb5.internal.util.KrbDataInputStream;

public class FileCredentialsCache
extends CredentialsCache
implements FileCCacheConstants {
    public int version;
    public Tag tag;
    public PrincipalName primaryPrincipal;
    public Realm primaryRealm;
    private Vector<Credentials> credentialsList;
    private static String dir;
    private static boolean DEBUG;

    public static synchronized FileCredentialsCache acquireInstance(PrincipalName principalName, String string) {
        block6: {
            try {
                FileCredentialsCache fileCredentialsCache = new FileCredentialsCache();
                cacheName = string == null ? fileCredentialsCache.getDefaultCacheName() : FileCredentialsCache.checkValidation(string);
                if (cacheName == null || !new File(cacheName).exists()) {
                    return null;
                }
                if (principalName != null) {
                    fileCredentialsCache.primaryPrincipal = principalName;
                    fileCredentialsCache.primaryRealm = principalName.getRealm();
                }
                fileCredentialsCache.load(cacheName);
                return fileCredentialsCache;
            }
            catch (IOException iOException) {
                if (DEBUG) {
                    iOException.printStackTrace();
                }
            }
            catch (KrbException krbException) {
                if (!DEBUG) break block6;
                krbException.printStackTrace();
            }
        }
        return null;
    }

    public static FileCredentialsCache acquireInstance() {
        return FileCredentialsCache.acquireInstance(null, null);
    }

    static synchronized FileCredentialsCache New(PrincipalName principalName, String string) {
        try {
            FileCredentialsCache fileCredentialsCache = new FileCredentialsCache();
            cacheName = FileCredentialsCache.checkValidation(string);
            if (cacheName == null) {
                return null;
            }
            fileCredentialsCache.init(principalName, cacheName);
            return fileCredentialsCache;
        }
        catch (IOException iOException) {
        }
        catch (KrbException krbException) {
            // empty catch block
        }
        return null;
    }

    static synchronized FileCredentialsCache New(PrincipalName principalName) {
        block4: {
            try {
                FileCredentialsCache fileCredentialsCache = new FileCredentialsCache();
                cacheName = fileCredentialsCache.getDefaultCacheName();
                fileCredentialsCache.init(principalName, cacheName);
                return fileCredentialsCache;
            }
            catch (IOException iOException) {
                if (DEBUG) {
                    iOException.printStackTrace();
                }
            }
            catch (KrbException krbException) {
                if (!DEBUG) break block4;
                krbException.printStackTrace();
            }
        }
        return null;
    }

    private FileCredentialsCache() {
    }

    boolean exists(String string) {
        File file = new File(string);
        return file.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void init(PrincipalName principalName, String string) throws IOException, KrbException {
        this.primaryPrincipal = principalName;
        this.primaryRealm = principalName.getRealm();
        FileOutputStream fileOutputStream = null;
        FilterOutputStream filterOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string);
            filterOutputStream = new CCacheOutputStream(fileOutputStream);
            this.version = 1283;
            ((CCacheOutputStream)filterOutputStream).writeHeader(this.primaryPrincipal, this.version);
        }
        finally {
            try {
                if (filterOutputStream != null) {
                    filterOutputStream.close();
                }
            }
            finally {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
        }
        this.load(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void load(String string) throws IOException, KrbException {
        FileInputStream fileInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            bufferedInputStream = new CCacheInputStream(fileInputStream);
            this.version = ((KrbDataInputStream)bufferedInputStream).readVersion();
            if (this.version == 1284) {
                this.tag = ((CCacheInputStream)bufferedInputStream).readTag();
            } else {
                this.tag = null;
                if (this.version == 1281 || this.version == 1282) {
                    ((KrbDataInputStream)bufferedInputStream).setNativeByteOrder();
                }
            }
            PrincipalName principalName = ((CCacheInputStream)bufferedInputStream).readPrincipal(this.version);
            if (this.primaryPrincipal != null) {
                if (!this.primaryPrincipal.match(principalName)) {
                    throw new IOException("Primary principals don't match.");
                }
            } else {
                this.primaryPrincipal = principalName;
            }
            this.primaryRealm = this.primaryPrincipal.getRealm();
            this.credentialsList = new Vector();
            while (bufferedInputStream.available() > 0) {
                Credentials credentials = ((CCacheInputStream)bufferedInputStream).readCred(this.version);
                if (credentials == null) continue;
                this.credentialsList.addElement(credentials);
            }
        }
        finally {
            try {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
            }
            finally {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
        }
    }

    public synchronized void update(Credentials credentials) {
        if (this.credentialsList != null) {
            if (this.credentialsList.isEmpty()) {
                this.credentialsList.addElement(credentials);
            } else {
                Credentials credentials2 = null;
                boolean bl = false;
                for (int i = 0; i < this.credentialsList.size(); ++i) {
                    credentials2 = this.credentialsList.elementAt(i);
                    if (!this.match(credentials.sname.getNameStrings(), credentials2.sname.getNameStrings()) || !credentials.sname.getRealmString().equalsIgnoreCase(credentials2.sname.getRealmString())) continue;
                    bl = true;
                    if (credentials.endtime.getTime() < credentials2.endtime.getTime()) continue;
                    if (DEBUG) {
                        System.out.println(" >>> FileCredentialsCache Ticket matched, overwrite the old one.");
                    }
                    this.credentialsList.removeElementAt(i);
                    this.credentialsList.addElement(credentials);
                }
                if (!bl) {
                    if (DEBUG) {
                        System.out.println(" >>> FileCredentialsCache Ticket not exactly matched, add new one into cache.");
                    }
                    this.credentialsList.addElement(credentials);
                }
            }
        }
    }

    public synchronized PrincipalName getPrimaryPrincipal() {
        return this.primaryPrincipal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void save() throws IOException, Asn1Exception {
        FileOutputStream fileOutputStream = null;
        FilterOutputStream filterOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(cacheName);
            filterOutputStream = new CCacheOutputStream(fileOutputStream);
            ((CCacheOutputStream)filterOutputStream).writeHeader(this.primaryPrincipal, this.version);
            Credentials[] credentialsArray = null;
            credentialsArray = this.getCredsList();
            if (credentialsArray != null) {
                for (int i = 0; i < credentialsArray.length; ++i) {
                    ((CCacheOutputStream)filterOutputStream).addCreds(credentialsArray[i]);
                }
            }
        }
        finally {
            try {
                if (filterOutputStream != null) {
                    filterOutputStream.close();
                }
            }
            finally {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
        }
    }

    boolean match(String[] stringArray, String[] stringArray2) {
        if (stringArray.length != stringArray2.length) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase(stringArray2[i])) continue;
            return false;
        }
        return true;
    }

    public synchronized Credentials[] getCredsList() {
        if (this.credentialsList == null || this.credentialsList.isEmpty()) {
            return null;
        }
        Credentials[] credentialsArray = new Credentials[this.credentialsList.size()];
        for (int i = 0; i < this.credentialsList.size(); ++i) {
            credentialsArray[i] = this.credentialsList.elementAt(i);
        }
        return credentialsArray;
    }

    public Credentials getCreds(LoginOptions loginOptions, PrincipalName principalName, Realm realm) {
        if (loginOptions == null) {
            return this.getCreds(principalName, realm);
        }
        Credentials[] credentialsArray = this.getCredsList();
        if (credentialsArray == null) {
            return null;
        }
        for (int i = 0; i < credentialsArray.length; ++i) {
            if (!principalName.match(credentialsArray[i].sname) || !realm.toString().equals(credentialsArray[i].srealm.toString()) || !credentialsArray[i].flags.match(loginOptions)) continue;
            return credentialsArray[i];
        }
        return null;
    }

    public Credentials getCreds(PrincipalName principalName, Realm realm) {
        Credentials[] credentialsArray = this.getCredsList();
        if (credentialsArray == null) {
            return null;
        }
        for (int i = 0; i < credentialsArray.length; ++i) {
            if (!principalName.match(credentialsArray[i].sname) || !realm.toString().equals(credentialsArray[i].srealm.toString())) continue;
            return credentialsArray[i];
        }
        return null;
    }

    public Credentials getDefaultCreds() {
        Credentials[] credentialsArray = this.getCredsList();
        if (credentialsArray == null) {
            return null;
        }
        for (int i = credentialsArray.length - 1; i >= 0; --i) {
            String[] stringArray;
            if (!credentialsArray[i].sname.toString().startsWith("krbtgt") || !(stringArray = credentialsArray[i].sname.getNameStrings())[1].equals(credentialsArray[i].srealm.toString())) continue;
            return credentialsArray[i];
        }
        return null;
    }

    public static String getDefaultCacheName() {
        String string;
        String string2;
        String string3;
        block7: {
            string3 = "krb5cc";
            String string4 = AccessController.doPrivileged(new GetPropertyAction("os.name"));
            if (string4 != null) {
                string2 = null;
                string = null;
                long l = 0L;
                if (string4.startsWith("SunOS") || string4.startsWith("Linux") || string4.startsWith("FreeBSD") || string4.startsWith("NetBSD") || string4.startsWith("OpenBSD") || string4.startsWith("Darwin")) {
                    try {
                        Class<?> clazz = Class.forName("com.sun.security.auth.module.UnixSystem");
                        Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                        Object obj = constructor.newInstance(new Object[0]);
                        Method method = clazz.getMethod("getUid", new Class[0]);
                        l = (Long)method.invoke(obj, new Object[0]);
                        String string5 = File.separator + "tmp" + File.separator + string3 + "_" + l;
                        if (DEBUG) {
                            System.out.println(">>>KinitOptions cache name is " + string5);
                        }
                        return string5;
                    }
                    catch (Exception exception) {
                        if (!DEBUG) break block7;
                        System.out.println("Exception in obtaining uid for Unix platforms Using user's home directory");
                        exception.printStackTrace();
                    }
                }
            }
        }
        string2 = AccessController.doPrivileged(new GetPropertyAction("user.name"));
        string = AccessController.doPrivileged(new GetPropertyAction("user.home"));
        if (string == null) {
            string = AccessController.doPrivileged(new GetPropertyAction("user.dir"));
        }
        String string6 = string2 != null ? string + File.separator + string3 + "_" + string2 : string + File.separator + string3;
        if (DEBUG) {
            System.out.println(">>>KinitOptions cache name is " + string6);
        }
        return string6;
    }

    public static String checkValidation(String string) {
        String string2 = null;
        if (string == null) {
            return null;
        }
        try {
            string2 = new File(string).getCanonicalPath();
            File file = new File(string2);
            if (!file.exists()) {
                File file2 = new File(file.getParent());
                if (!file2.isDirectory()) {
                    string2 = null;
                }
                file2 = null;
            }
            file = null;
        }
        catch (IOException iOException) {
            string2 = null;
        }
        return string2;
    }

    private static String exec(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        try {
            Process process = AccessController.doPrivileged(new PrivilegedAction<Process>((String[])objectArray){
                final /* synthetic */ String[] val$command;
                {
                    this.val$command = stringArray;
                }

                @Override
                public Process run() {
                    try {
                        return Runtime.getRuntime().exec(this.val$command);
                    }
                    catch (IOException iOException) {
                        if (DEBUG) {
                            iOException.printStackTrace();
                        }
                        return null;
                    }
                }
            });
            if (process == null) {
                return null;
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream(), "8859_1"));
            String string2 = null;
            if (objectArray.length == 1 && ((String)objectArray[0]).equals("/usr/bin/env")) {
                while ((string2 = bufferedReader.readLine()) != null) {
                    if (string2.length() < 11 || !string2.substring(0, 11).equalsIgnoreCase("KRB5CCNAME=")) continue;
                    string2 = string2.substring(11);
                    break;
                }
            } else {
                string2 = bufferedReader.readLine();
            }
            bufferedReader.close();
            return string2;
        }
        catch (Exception exception) {
            if (DEBUG) {
                exception.printStackTrace();
            }
            return null;
        }
    }

    static {
        DEBUG = Krb5.DEBUG;
    }
}

