/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss.spnego;

import java.io.IOException;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;
import sun.security.jgss.GSSUtil;
import sun.security.jgss.spnego.SpNegoToken;
import sun.security.util.BitArray;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;

public class NegTokenInit
extends SpNegoToken {
    private byte[] mechTypes = null;
    private Oid[] mechTypeList = null;
    private BitArray reqFlags = null;
    private byte[] mechToken = null;
    private byte[] mechListMIC = null;

    NegTokenInit(byte[] byArray, BitArray bitArray, byte[] byArray2, byte[] byArray3) {
        super(0);
        this.mechTypes = byArray;
        this.reqFlags = bitArray;
        this.mechToken = byArray2;
        this.mechListMIC = byArray3;
    }

    public NegTokenInit(byte[] byArray) throws GSSException {
        super(0);
        this.parseToken(byArray);
    }

    final byte[] encode() throws GSSException {
        try {
            DerOutputStream derOutputStream;
            DerOutputStream derOutputStream2 = new DerOutputStream();
            if (this.mechTypes != null) {
                derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)0), this.mechTypes);
            }
            if (this.reqFlags != null) {
                derOutputStream = new DerOutputStream();
                derOutputStream.putUnalignedBitString(this.reqFlags);
                derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)1), derOutputStream);
            }
            if (this.mechToken != null) {
                derOutputStream = new DerOutputStream();
                derOutputStream.putOctetString(this.mechToken);
                derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)2), derOutputStream);
            }
            if (this.mechListMIC != null) {
                if (DEBUG) {
                    System.out.println("SpNegoToken NegTokenInit: sending MechListMIC");
                }
                derOutputStream = new DerOutputStream();
                derOutputStream.putOctetString(this.mechListMIC);
                derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)3), derOutputStream);
            }
            derOutputStream = new DerOutputStream();
            derOutputStream.write((byte)48, derOutputStream2);
            return derOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new GSSException(10, -1, "Invalid SPNEGO NegTokenInit token : " + iOException.getMessage());
        }
    }

    private void parseToken(byte[] byArray) throws GSSException {
        try {
            DerValue derValue;
            DerValue derValue2 = new DerValue(byArray);
            if (!derValue2.isContextSpecific((byte)0)) {
                throw new IOException("SPNEGO NegoTokenInit : did not have right token type");
            }
            DerValue derValue3 = derValue2.data.getDerValue();
            if (derValue3.tag != 48) {
                throw new IOException("SPNEGO NegoTokenInit : did not have the Sequence tag");
            }
            if (derValue3.data.available() > 0) {
                derValue = derValue3.data.getDerValue();
                if (!derValue.isContextSpecific((byte)0)) {
                    throw new IOException("SPNEGO NegoTokenInit : did not have the right context tag for mechTypes");
                }
                DerInputStream derInputStream = derValue.data;
                this.mechTypes = derInputStream.toByteArray();
                DerValue[] derValueArray = derInputStream.getSequence(0);
                this.mechTypeList = new Oid[derValueArray.length];
                ObjectIdentifier objectIdentifier = null;
                for (int i = 0; i < derValueArray.length; ++i) {
                    objectIdentifier = derValueArray[i].getOID();
                    if (DEBUG) {
                        System.out.println("SpNegoToken NegTokenInit: reading Mechanism Oid = " + objectIdentifier);
                    }
                    this.mechTypeList[i] = new Oid(objectIdentifier.toString());
                }
            }
            if (derValue3.data.available() > 0) {
                derValue = derValue3.data.getDerValue();
                if (derValue.isContextSpecific((byte)1) && derValue3.data.available() > 0) {
                    derValue = derValue3.data.getDerValue();
                }
                if (!derValue.isContextSpecific((byte)2)) {
                    throw new IOException("SPNEGO NegoTokenInit : did not have the right context tag for mechToken");
                }
                if (DEBUG) {
                    System.out.println("SpNegoToken NegTokenInit: reading Mech Token");
                }
                this.mechToken = derValue.data.getOctetString();
            }
            if (!GSSUtil.useMSInterop() && derValue3.data.available() > 0) {
                if (DEBUG) {
                    System.out.println("SpNegoToken NegTokenInit: receiving MechListMIC");
                }
                if (!(derValue = derValue3.data.getDerValue()).isContextSpecific((byte)3)) {
                    throw new IOException("SPNEGO NegoTokenInit : did not have the right context tag for MICToken");
                }
                this.mechListMIC = derValue.data.getOctetString();
                if (DEBUG) {
                    System.out.println("SpNegoToken NegTokenInit: MechListMIC Token = " + NegTokenInit.getHexBytes(this.mechListMIC));
                }
            } else if (DEBUG) {
                System.out.println("SpNegoToken NegTokenInit : no MIC token included");
            }
        }
        catch (IOException iOException) {
            throw new GSSException(10, -1, "Invalid SPNEGO NegTokenInit token : " + iOException.getMessage());
        }
    }

    byte[] getMechTypes() {
        return this.mechTypes;
    }

    public Oid[] getMechTypeList() {
        return this.mechTypeList;
    }

    BitArray getReqFlags() {
        return this.reqFlags;
    }

    public byte[] getMechToken() {
        return this.mechToken;
    }

    byte[] getMechListMIC() {
        return this.mechListMIC;
    }
}

