/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.net.NetworkInterface;
import sun.nio.ch.Net;
import sun.nio.ch.SocketOpts;

class SocketOptsImpl
implements SocketOpts {
    private boolean reuseAddressEmulated;
    private boolean isReuseAddress;
    private final Dispatcher d;

    SocketOptsImpl(Dispatcher dispatcher) {
        this.d = dispatcher;
    }

    protected boolean getBoolean(int n) throws IOException {
        return this.d.getInt(n) > 0;
    }

    protected void setBoolean(int n, boolean bl) throws IOException {
        this.d.setInt(n, bl ? 1 : 0);
    }

    protected int getInt(int n) throws IOException {
        return this.d.getInt(n);
    }

    protected void setInt(int n, int n2) throws IOException {
        this.d.setInt(n, n2);
    }

    protected NetworkInterface getNetworkInterface(int n) throws IOException {
        throw new UnsupportedOperationException("NYI");
    }

    protected void setNetworkInterface(int n, NetworkInterface networkInterface) throws IOException {
        throw new UnsupportedOperationException("NYI");
    }

    protected void addToString(StringBuffer stringBuffer, String string) {
        char c = stringBuffer.charAt(stringBuffer.length() - 1);
        if (c != '[' && c != '=') {
            stringBuffer.append(' ');
        }
        stringBuffer.append(string);
    }

    protected void addToString(StringBuffer stringBuffer, int n) {
        this.addToString(stringBuffer, Integer.toString(n));
    }

    public boolean broadcast() throws IOException {
        return this.getBoolean(32);
    }

    public SocketOpts broadcast(boolean bl) throws IOException {
        this.setBoolean(32, bl);
        return this;
    }

    public boolean keepAlive() throws IOException {
        return this.getBoolean(8);
    }

    public SocketOpts keepAlive(boolean bl) throws IOException {
        this.setBoolean(8, bl);
        return this;
    }

    public int linger() throws IOException {
        return this.getInt(128);
    }

    public SocketOpts linger(int n) throws IOException {
        this.setInt(128, n);
        return this;
    }

    public boolean outOfBandInline() throws IOException {
        return this.getBoolean(4099);
    }

    public SocketOpts outOfBandInline(boolean bl) throws IOException {
        this.setBoolean(4099, bl);
        return this;
    }

    public int receiveBufferSize() throws IOException {
        return this.getInt(4098);
    }

    public SocketOpts receiveBufferSize(int n) throws IOException {
        if (n <= 0) {
            throw new IllegalArgumentException("Invalid receive size");
        }
        this.setInt(4098, n);
        return this;
    }

    public int sendBufferSize() throws IOException {
        return this.getInt(4097);
    }

    public SocketOpts sendBufferSize(int n) throws IOException {
        if (n <= 0) {
            throw new IllegalArgumentException("Invalid send size");
        }
        this.setInt(4097, n);
        return this;
    }

    public boolean reuseAddress() throws IOException {
        if (this.reuseAddressEmulated) {
            return this.isReuseAddress;
        }
        return this.getBoolean(4);
    }

    public SocketOpts reuseAddress(boolean bl) throws IOException {
        if (Net.useExclusiveBind() && this.d.getIsBoundCondition()) {
            this.reuseAddressEmulated = true;
            this.isReuseAddress = bl;
        } else {
            this.setBoolean(4, bl);
        }
        return this;
    }

    protected void toString(StringBuffer stringBuffer) throws IOException {
        int n;
        if (this.broadcast()) {
            this.addToString(stringBuffer, "broadcast");
        }
        if (this.keepAlive()) {
            this.addToString(stringBuffer, "keepalive");
        }
        if ((n = this.linger()) > 0) {
            this.addToString(stringBuffer, "linger=");
            this.addToString(stringBuffer, n);
        }
        if (this.outOfBandInline()) {
            this.addToString(stringBuffer, "oobinline");
        }
        if ((n = this.receiveBufferSize()) > 0) {
            this.addToString(stringBuffer, "rcvbuf=");
            this.addToString(stringBuffer, n);
        }
        if ((n = this.sendBufferSize()) > 0) {
            this.addToString(stringBuffer, "sndbuf=");
            this.addToString(stringBuffer, n);
        }
        if (this.reuseAddress()) {
            this.addToString(stringBuffer, "reuseaddr");
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getInterfaces()[0].getName());
        stringBuffer.append('[');
        int n = stringBuffer.length();
        try {
            this.toString(stringBuffer);
        }
        catch (IOException iOException) {
            stringBuffer.setLength(n);
            stringBuffer.append("closed");
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    static class IP
    extends SocketOptsImpl
    implements SocketOpts.IP {
        IP(Dispatcher dispatcher) {
            super(dispatcher);
        }

        public NetworkInterface multicastInterface() throws IOException {
            return this.getNetworkInterface(31);
        }

        public SocketOpts.IP multicastInterface(NetworkInterface networkInterface) throws IOException {
            this.setNetworkInterface(31, networkInterface);
            return this;
        }

        public boolean multicastLoop() throws IOException {
            return this.getBoolean(18);
        }

        public SocketOpts.IP multicastLoop(boolean bl) throws IOException {
            this.setBoolean(18, bl);
            return this;
        }

        public int typeOfService() throws IOException {
            return this.getInt(3);
        }

        public SocketOpts.IP typeOfService(int n) throws IOException {
            this.setInt(3, n);
            return this;
        }

        protected void toString(StringBuffer stringBuffer) throws IOException {
            super.toString(stringBuffer);
            int n = this.typeOfService();
            if (n > 0) {
                this.addToString(stringBuffer, "tos=");
                this.addToString(stringBuffer, n);
            }
        }

        public static class TCP
        extends IP
        implements SocketOpts.IP.TCP {
            TCP(Dispatcher dispatcher) {
                super(dispatcher);
            }

            public boolean noDelay() throws IOException {
                return this.getBoolean(1);
            }

            public SocketOpts.IP.TCP noDelay(boolean bl) throws IOException {
                this.setBoolean(1, bl);
                return this;
            }

            protected void toString(StringBuffer stringBuffer) throws IOException {
                super.toString(stringBuffer);
                if (this.noDelay()) {
                    this.addToString(stringBuffer, "nodelay");
                }
            }
        }
    }

    static abstract class Dispatcher {
        Dispatcher() {
        }

        abstract int getInt(int var1) throws IOException;

        abstract void setInt(int var1, int var2) throws IOException;

        abstract boolean getIsBoundCondition();
    }
}

