/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NotYetBoundException;
import java.nio.channels.UnresolvedAddressException;
import java.nio.channels.UnsupportedAddressTypeException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import sun.nio.ch.AlreadyBoundException;
import sun.nio.ch.IOUtil;
import sun.nio.ch.Util;

class Net {
    private static boolean revealLocalAddress;
    private static volatile boolean propRevealLocalAddress;
    private static final boolean exclusiveBind;

    private Net() {
    }

    static boolean useExclusiveBind() {
        return exclusiveBind;
    }

    static InetSocketAddress checkAddress(SocketAddress socketAddress) {
        if (socketAddress == null) {
            throw new IllegalArgumentException();
        }
        if (!(socketAddress instanceof InetSocketAddress)) {
            throw new UnsupportedAddressTypeException();
        }
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        if (inetSocketAddress.isUnresolved()) {
            throw new UnresolvedAddressException();
        }
        InetAddress inetAddress = inetSocketAddress.getAddress();
        if (!(inetAddress instanceof Inet4Address) && !(inetAddress instanceof Inet6Address)) {
            throw new IllegalArgumentException("Invalid address type");
        }
        return inetSocketAddress;
    }

    static InetSocketAddress asInetSocketAddress(SocketAddress socketAddress) {
        if (!(socketAddress instanceof InetSocketAddress)) {
            throw new UnsupportedAddressTypeException();
        }
        return (InetSocketAddress)socketAddress;
    }

    static void translateToSocketException(Exception exception) throws SocketException {
        if (exception instanceof SocketException) {
            throw (SocketException)exception;
        }
        Exception exception2 = exception;
        if (exception instanceof ClosedChannelException) {
            exception2 = new SocketException("Socket is closed");
        } else if (exception instanceof AlreadyBoundException) {
            exception2 = new SocketException("Already bound");
        } else if (exception instanceof NotYetBoundException) {
            exception2 = new SocketException("Socket is not bound yet");
        } else if (exception instanceof UnsupportedAddressTypeException) {
            exception2 = new SocketException("Unsupported address type");
        } else if (exception instanceof UnresolvedAddressException) {
            exception2 = new SocketException("Unresolved address");
        }
        if (exception2 != exception) {
            exception2.initCause(exception);
        }
        if (exception2 instanceof SocketException) {
            throw (SocketException)exception2;
        }
        if (exception2 instanceof RuntimeException) {
            throw (RuntimeException)exception2;
        }
        throw new Error("Untranslated exception", exception2);
    }

    static void translateException(Exception exception, boolean bl) throws IOException {
        if (exception instanceof IOException) {
            throw (IOException)exception;
        }
        if (bl && exception instanceof UnresolvedAddressException) {
            throw new UnknownHostException();
        }
        Net.translateToSocketException(exception);
    }

    static void translateException(Exception exception) throws IOException {
        Net.translateException(exception, false);
    }

    static FileDescriptor socket(boolean bl) throws IOException {
        return IOUtil.newFD(Net.socket0(bl, false));
    }

    static FileDescriptor serverSocket(boolean bl) {
        return IOUtil.newFD(Net.socket0(bl, true));
    }

    private static native int isExclusiveBindAvailable();

    private static native int socket0(boolean var0, boolean var1);

    static void bind(FileDescriptor fileDescriptor, InetAddress inetAddress, int n) throws IOException {
        Net.bind0(fileDescriptor, exclusiveBind, inetAddress, n);
    }

    private static native void bind0(FileDescriptor var0, boolean var1, InetAddress var2, int var3) throws IOException;

    static native int connect(FileDescriptor var0, InetAddress var1, int var2, int var3) throws IOException;

    private static native int localPort(FileDescriptor var0) throws IOException;

    private static native InetAddress localInetAddress(FileDescriptor var0) throws IOException;

    static InetSocketAddress localAddress(FileDescriptor fileDescriptor) {
        try {
            return new InetSocketAddress(Net.localInetAddress(fileDescriptor), Net.localPort(fileDescriptor));
        }
        catch (IOException iOException) {
            throw new Error(iOException);
        }
    }

    static int localPortNumber(FileDescriptor fileDescriptor) {
        try {
            return Net.localPort(fileDescriptor);
        }
        catch (IOException iOException) {
            throw new Error(iOException);
        }
    }

    private static native int getIntOption0(FileDescriptor var0, int var1) throws IOException;

    static int getIntOption(FileDescriptor fileDescriptor, int n) throws IOException {
        return Net.getIntOption0(fileDescriptor, n);
    }

    private static native void setIntOption0(FileDescriptor var0, int var1, int var2) throws IOException;

    static void setIntOption(FileDescriptor fileDescriptor, int n, int n2) throws IOException {
        Net.setIntOption0(fileDescriptor, n, n2);
    }

    private static native void initIDs();

    static InetSocketAddress getRevealedLocalAddress(InetSocketAddress inetSocketAddress) {
        SecurityManager securityManager = System.getSecurityManager();
        if (inetSocketAddress == null || securityManager == null) {
            return inetSocketAddress;
        }
        if (!Net.getRevealLocalAddress()) {
            try {
                securityManager.checkConnect(inetSocketAddress.getAddress().getHostAddress(), -1);
            }
            catch (SecurityException securityException) {
                inetSocketAddress = Net.getLoopbackAddress(inetSocketAddress.getPort());
            }
        }
        return inetSocketAddress;
    }

    static String getRevealedLocalAddressAsString(InetSocketAddress inetSocketAddress) {
        if (!Net.getRevealLocalAddress() && System.getSecurityManager() != null) {
            inetSocketAddress = Net.getLoopbackAddress(inetSocketAddress.getPort());
        }
        return inetSocketAddress.toString();
    }

    private static boolean getRevealLocalAddress() {
        if (!propRevealLocalAddress) {
            try {
                revealLocalAddress = Boolean.parseBoolean(AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                    @Override
                    public String run() {
                        return System.getProperty("jdk.net.revealLocalAddress");
                    }
                }));
            }
            catch (Exception exception) {
                // empty catch block
            }
            propRevealLocalAddress = true;
        }
        return revealLocalAddress;
    }

    private static InetSocketAddress getLoopbackAddress(int n) {
        try {
            return new InetSocketAddress(InetAddress.getByName(null), n);
        }
        catch (UnknownHostException unknownHostException) {
            throw new InternalError("Shouldn't reach here.");
        }
    }

    static {
        String string;
        int n = Net.isExclusiveBindAvailable();
        exclusiveBind = n >= 0 ? ((string = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("sun.net.useExclusiveBind");
            }
        })) != null ? (string.length() == 0 ? true : Boolean.parseBoolean(string)) : n == 1) : false;
        Util.load();
        Net.initIDs();
    }
}

