/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.http;

import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HttpLogFormatter
extends SimpleFormatter {
    private static volatile Pattern pattern = null;
    private static volatile Pattern cpattern = null;

    public HttpLogFormatter() {
        if (pattern == null) {
            pattern = Pattern.compile("\\{[^\\}]*\\}");
            cpattern = Pattern.compile("[^,\\] ]{2,}");
        }
    }

    public String format(LogRecord logRecord) {
        if (!"sun.net.www.http.HttpCapture".equalsIgnoreCase(logRecord.getSourceClassName())) {
            return super.format(logRecord);
        }
        String string = logRecord.getMessage();
        StringBuilder stringBuilder = new StringBuilder("HTTP: ");
        if (string.startsWith("sun.net.www.MessageHeader@")) {
            Matcher matcher = pattern.matcher(string);
            while (matcher.find()) {
                int n;
                int n2 = matcher.start();
                String string2 = string.substring(n2 + 1, (n = matcher.end()) - 1);
                if (string2.startsWith("null: ")) {
                    string2 = string2.substring(6);
                }
                if (string2.endsWith(": null")) {
                    string2 = string2.substring(0, string2.length() - 6);
                }
                stringBuilder.append("\t").append(string2).append("\n");
            }
        } else if (string.startsWith("Cookies retrieved: {")) {
            String string3 = string.substring(20);
            stringBuilder.append("Cookies from handler:\n");
            while (string3.length() >= 7) {
                String string4;
                int n;
                int n3;
                Matcher matcher;
                int n4;
                String string5;
                if (string3.startsWith("Cookie=[")) {
                    string5 = string3.substring(8);
                    n4 = string5.indexOf("Cookie2=[");
                    if (n4 > 0) {
                        string5 = string5.substring(0, n4 - 1);
                        string3 = string5.substring(n4);
                    } else {
                        string3 = "";
                    }
                    if (string5.length() < 4) continue;
                    matcher = cpattern.matcher(string5);
                    while (matcher.find()) {
                        n3 = matcher.start();
                        n = matcher.end();
                        if (n3 < 0) continue;
                        string4 = string5.substring(n3 + 1, n > 0 ? n - 1 : string5.length() - 1);
                        stringBuilder.append("\t").append(string4).append("\n");
                    }
                }
                if (!string3.startsWith("Cookie2=[")) continue;
                string5 = string3.substring(9);
                n4 = string5.indexOf("Cookie=[");
                if (n4 > 0) {
                    string5 = string5.substring(0, n4 - 1);
                    string3 = string5.substring(n4);
                } else {
                    string3 = "";
                }
                matcher = cpattern.matcher(string5);
                while (matcher.find()) {
                    n3 = matcher.start();
                    n = matcher.end();
                    if (n3 < 0) continue;
                    string4 = string5.substring(n3 + 1, n > 0 ? n - 1 : string5.length() - 1);
                    stringBuilder.append("\t").append(string4).append("\n");
                }
            }
        } else {
            stringBuilder.append(string).append("\n");
        }
        return stringBuilder.toString();
    }
}

