/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.AWTException;
import java.awt.Canvas;
import java.awt.Dialog;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.peer.TrayIconPeer;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.SunToolkit;
import sun.awt.WindowAccessor;
import sun.awt.X11.InfoWindow;
import sun.awt.X11.XBaseWindow;
import sun.awt.X11.XConfigureEvent;
import sun.awt.X11.XEmbeddedFrame;
import sun.awt.X11.XEmbeddedFramePeer;
import sun.awt.X11.XEvent;
import sun.awt.X11.XEventDispatcher;
import sun.awt.X11.XReparentEvent;
import sun.awt.X11.XSystemTrayPeer;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWM;
import sun.awt.X11.XlibWrapper;

public class XTrayIconPeer
implements TrayIconPeer,
InfoWindow.Balloon.LiveArguments,
InfoWindow.Tooltip.LiveArguments {
    private static final Logger ctrLog = Logger.getLogger("sun.awt.X11.XTrayIconPeer.centering");
    TrayIcon target;
    TrayIconEventProxy eventProxy;
    XTrayIconEmbeddedFrame eframe;
    TrayIconCanvas canvas;
    InfoWindow.Balloon balloon;
    InfoWindow.Tooltip tooltip;
    PopupMenu popup;
    String tooltipString;
    boolean isTrayIconDisplayed;
    long eframeParentID;
    final XEventDispatcher parentXED;
    final XEventDispatcher eframeXED;
    static final XEventDispatcher dummyXED = new XEventDispatcher(){

        public void dispatchEvent(XEvent xEvent) {
        }
    };
    volatile boolean isDisposed;
    boolean isParentWindowLocated;
    int old_x;
    int old_y;
    int ex_width;
    int ex_height;
    static final int TRAY_ICON_WIDTH = 24;
    static final int TRAY_ICON_HEIGHT = 24;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    XTrayIconPeer(TrayIcon trayIcon) throws AWTException {
        this.target = trayIcon;
        this.eventProxy = new TrayIconEventProxy(this);
        this.canvas = new TrayIconCanvas(trayIcon, 24, 24);
        this.eframe = new XTrayIconEmbeddedFrame();
        this.eframe.setSize(24, 24);
        this.eframe.add(this.canvas);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                XTrayIconPeer.this.eframe.setModalExclusionType(Dialog.ModalExclusionType.TOOLKIT_EXCLUDE);
                return null;
            }
        });
        this.parentXED = XWM.getWMID() != 11 ? dummyXED : new XEventDispatcher(){

            public void dispatchEvent(XEvent xEvent) {
                if (XTrayIconPeer.this.isDisposed() || xEvent.get_type() != 22) {
                    return;
                }
                XConfigureEvent xConfigureEvent = xEvent.get_xconfigure();
                if (ctrLog.isLoggable(Level.FINE)) {
                    ctrLog.log(Level.FINE, "ConfigureNotify on parent of {0}: {1}x{2}+{3}+{4} (old: {5}+{6})", new Object[]{String.valueOf(XTrayIconPeer.this), xConfigureEvent.get_width(), xConfigureEvent.get_height(), xConfigureEvent.get_x(), xConfigureEvent.get_y(), XTrayIconPeer.this.old_x, XTrayIconPeer.this.old_y});
                }
                if (xConfigureEvent.get_height() != 24 && xConfigureEvent.get_width() != 24) {
                    if (ctrLog.isLoggable(Level.FINE)) {
                        ctrLog.log(Level.FINE, "ConfigureNotify on parent of {0}. Skipping as intermediate resizing.", String.valueOf(XTrayIconPeer.this));
                    }
                    return;
                }
                if (xConfigureEvent.get_height() > 24) {
                    if (ctrLog.isLoggable(Level.FINE)) {
                        ctrLog.log(Level.FINE, "ConfigureNotify on parent of {0}. Centering by \"Y\".", String.valueOf(XTrayIconPeer.this));
                    }
                    XlibWrapper.XMoveResizeWindow(XToolkit.getDisplay(), XTrayIconPeer.this.eframeParentID, xConfigureEvent.get_x(), xConfigureEvent.get_y() + xConfigureEvent.get_height() / 2 - 12, 24, 24);
                    XTrayIconPeer.this.ex_height = xConfigureEvent.get_height();
                    XTrayIconPeer.this.ex_width = 0;
                } else if (xConfigureEvent.get_width() > 24) {
                    if (ctrLog.isLoggable(Level.FINE)) {
                        ctrLog.log(Level.FINE, "ConfigureNotify on parent of {0}. Centering by \"X\".", String.valueOf(XTrayIconPeer.this));
                    }
                    XlibWrapper.XMoveResizeWindow(XToolkit.getDisplay(), XTrayIconPeer.this.eframeParentID, xConfigureEvent.get_x() + xConfigureEvent.get_width() / 2 - 12, xConfigureEvent.get_y(), 24, 24);
                    XTrayIconPeer.this.ex_width = xConfigureEvent.get_width();
                    XTrayIconPeer.this.ex_height = 0;
                } else if (XTrayIconPeer.this.isParentWindowLocated && xConfigureEvent.get_x() != XTrayIconPeer.this.old_x && xConfigureEvent.get_y() != XTrayIconPeer.this.old_y) {
                    if (XTrayIconPeer.this.ex_height != 0) {
                        if (ctrLog.isLoggable(Level.FINE)) {
                            ctrLog.log(Level.FINE, "ConfigureNotify on parent of {0}. Move detected. Centering by \"Y\".", String.valueOf(XTrayIconPeer.this));
                        }
                        XlibWrapper.XMoveWindow(XToolkit.getDisplay(), XTrayIconPeer.this.eframeParentID, xConfigureEvent.get_x(), xConfigureEvent.get_y() + XTrayIconPeer.this.ex_height / 2 - 12);
                    } else if (XTrayIconPeer.this.ex_width != 0) {
                        if (ctrLog.isLoggable(Level.FINE)) {
                            ctrLog.log(Level.FINE, "ConfigureNotify on parent of {0}. Move detected. Centering by \"X\".", String.valueOf(XTrayIconPeer.this));
                        }
                        XlibWrapper.XMoveWindow(XToolkit.getDisplay(), XTrayIconPeer.this.eframeParentID, xConfigureEvent.get_x() + XTrayIconPeer.this.ex_width / 2 - 12, xConfigureEvent.get_y());
                    } else if (ctrLog.isLoggable(Level.FINE)) {
                        ctrLog.log(Level.FINE, "ConfigureNotify on parent of {0}. Move detected. Skipping.", String.valueOf(XTrayIconPeer.this));
                    }
                }
                XTrayIconPeer.this.old_x = xConfigureEvent.get_x();
                XTrayIconPeer.this.old_y = xConfigureEvent.get_y();
                XTrayIconPeer.this.isParentWindowLocated = true;
            }
        };
        this.eframeXED = new XEventDispatcher(){
            XTrayIconPeer xtiPeer;
            {
                this.xtiPeer = XTrayIconPeer.this;
            }

            public void dispatchEvent(XEvent xEvent) {
                if (XTrayIconPeer.this.isDisposed() || xEvent.get_type() != 21) {
                    return;
                }
                XReparentEvent xReparentEvent = xEvent.get_xreparent();
                XTrayIconPeer.this.eframeParentID = xReparentEvent.get_parent();
                if (XTrayIconPeer.this.eframeParentID == XToolkit.getDefaultRootWindow()) {
                    if (XTrayIconPeer.this.isTrayIconDisplayed) {
                        SunToolkit.executeOnEventHandlerThread(this.xtiPeer.target, new Runnable(){

                            public void run() {
                                SystemTray.getSystemTray().remove(xtiPeer.target);
                            }
                        });
                    }
                    return;
                }
                if (!XTrayIconPeer.this.isTrayIconDisplayed) {
                    XTrayIconPeer.this.addXED(XTrayIconPeer.this.eframeParentID, XTrayIconPeer.this.parentXED, 131072L);
                    XTrayIconPeer.this.isTrayIconDisplayed = true;
                    XToolkit.awtLockNotifyAll();
                }
            }
        };
        this.addXED(this.getWindow(), this.eframeXED, 131072L);
        XSystemTrayPeer.getPeerInstance().addTrayIcon(this);
        long l = System.currentTimeMillis();
        XToolkit.awtLock();
        try {
            while (!this.isTrayIconDisplayed) {
                try {
                    XToolkit.awtLockWait(2000L);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
                if (System.currentTimeMillis() - l <= 2000L) continue;
                break;
            }
            Object var8_4 = null;
        }
        catch (Throwable throwable) {
            Object var8_5 = null;
            XToolkit.awtUnlock();
            throw throwable;
        }
        XToolkit.awtUnlock();
        if (!this.isTrayIconDisplayed || this.eframeParentID == 0L || this.eframeParentID == XToolkit.getDefaultRootWindow()) {
            throw new AWTException("TrayIcon couldn't be displayed.");
        }
        this.eframe.setVisible(true);
        this.updateImage();
        this.balloon = new InfoWindow.Balloon(this.eframe, trayIcon, this);
        this.tooltip = new InfoWindow.Tooltip(this.eframe, trayIcon, this);
        this.addListeners();
    }

    public void dispose() {
        if (SunToolkit.isDispatchThreadForAppContext(this.target)) {
            this.disposeOnEDT();
        } else {
            try {
                SunToolkit.executeOnEDTAndWait(this.target, new Runnable(){

                    public void run() {
                        XTrayIconPeer.this.disposeOnEDT();
                    }
                });
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }

    private void disposeOnEDT() {
        XToolkit.awtLock();
        this.isDisposed = true;
        XToolkit.awtUnlock();
        this.removeXED(this.getWindow(), this.eframeXED);
        this.removeXED(this.eframeParentID, this.parentXED);
        this.eframe.realDispose();
        this.balloon.dispose();
        this.isTrayIconDisplayed = false;
        XToolkit.targetDisposedPeer(this.target, this);
    }

    public static void suppressWarningString(Window window) {
        WindowAccessor.setTrayIconWindow(window, true);
    }

    public void setToolTip(String string) {
        this.tooltipString = string;
    }

    public String getTooltipString() {
        return this.tooltipString;
    }

    public void updateImage() {
        Runnable runnable = new Runnable(){

            public void run() {
                XTrayIconPeer.this.canvas.updateImage(XTrayIconPeer.this.target.getImage());
            }
        };
        if (!SunToolkit.isDispatchThreadForAppContext(this.target)) {
            SunToolkit.executeOnEventHandlerThread(this.target, runnable);
        } else {
            runnable.run();
        }
    }

    public void displayMessage(String string, String string2, String string3) {
        Point point = this.getLocationOnScreen();
        Rectangle rectangle = this.eframe.getGraphicsConfiguration().getBounds();
        if (point.x >= rectangle.x && point.x < rectangle.x + rectangle.width && point.y >= rectangle.y && point.y < rectangle.y + rectangle.height) {
            this.balloon.display(string, string2, string3);
        }
    }

    public void showPopupMenu(int n, int n2) {
        if (this.isDisposed()) {
            return;
        }
        assert (SunToolkit.isDispatchThreadForAppContext(this.target));
        PopupMenu popupMenu = this.target.getPopupMenu();
        if (this.popup != popupMenu) {
            if (this.popup != null) {
                this.eframe.remove(this.popup);
            }
            if (popupMenu != null) {
                this.eframe.add(popupMenu);
            }
            this.popup = popupMenu;
        }
        if (this.popup != null) {
            Point point = ((XBaseWindow)((Object)this.eframe.getPeer())).toLocal(new Point(n, n2));
            this.popup.show(this.eframe, point.x, point.y);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addXED(long l, XEventDispatcher xEventDispatcher, long l2) {
        if (l == 0L) {
            return;
        }
        XToolkit.awtLock();
        try {
            XlibWrapper.XSelectInput(XToolkit.getDisplay(), l, l2);
            Object var7_4 = null;
        }
        catch (Throwable throwable) {
            Object var7_5 = null;
            XToolkit.awtUnlock();
            throw throwable;
        }
        XToolkit.awtUnlock();
        XToolkit.addEventDispatcher(l, xEventDispatcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeXED(long l, XEventDispatcher xEventDispatcher) {
        if (l == 0L) {
            return;
        }
        XToolkit.awtLock();
        try {
            XToolkit.removeEventDispatcher(l, xEventDispatcher);
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            XToolkit.awtUnlock();
            throw throwable;
        }
        XToolkit.awtUnlock();
    }

    private Point getLocationOnScreen() {
        return this.eframe.getLocationOnScreen();
    }

    public Rectangle getBounds() {
        Point point = this.getLocationOnScreen();
        return new Rectangle(point.x, point.y, point.x + 24, point.y + 24);
    }

    void addListeners() {
        this.canvas.addMouseListener(this.eventProxy);
        this.canvas.addMouseMotionListener(this.eventProxy);
    }

    long getWindow() {
        return ((XEmbeddedFramePeer)this.eframe.getPeer()).getWindow();
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }

    public String getActionCommand() {
        return this.target.getActionCommand();
    }

    static boolean isTrayIconStuffWindow(Window window) {
        return window instanceof InfoWindow.Tooltip || window instanceof InfoWindow.Balloon || window instanceof XTrayIconEmbeddedFrame;
    }

    public static class IconCanvas
    extends Canvas {
        volatile Image image;
        IconObserver observer;
        int width;
        int height;
        int curW;
        int curH;

        IconCanvas(int n, int n2) {
            this.width = this.curW = n;
            this.height = this.curH = n2;
        }

        public void updateImage(Image image) {
            this.image = image;
            if (this.observer == null) {
                this.observer = new IconObserver();
            }
            this.repaintImage(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void repaintImage(boolean bl) {
            Graphics graphics = this.getGraphics();
            if (graphics != null) {
                try {
                    if (this.isVisible()) {
                        if (bl) {
                            this.update(graphics);
                        } else {
                            this.paint(graphics);
                        }
                    }
                    Object var4_3 = null;
                    graphics.dispose();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    graphics.dispose();
                    throw throwable;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paint(Graphics graphics) {
            BufferedImage bufferedImage;
            Graphics2D graphics2D;
            if (graphics != null && this.curW > 0 && this.curH > 0 && (graphics2D = (bufferedImage = new BufferedImage(this.curW, this.curH, 2)).createGraphics()) != null) {
                try {
                    graphics2D.setColor(this.getBackground());
                    graphics2D.fillRect(0, 0, this.curW, this.curH);
                    graphics2D.drawImage(this.image, 0, 0, this.curW, this.curH, this.observer);
                    graphics2D.dispose();
                    graphics.drawImage(bufferedImage, 0, 0, this.curW, this.curH, null);
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    graphics2D.dispose();
                    throw throwable;
                }
                graphics2D.dispose();
                {
                }
            }
        }

        class IconObserver
        implements ImageObserver {
            IconObserver() {
            }

            public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
                if (image != IconCanvas.this.image || !IconCanvas.this.isVisible()) {
                    return false;
                }
                if ((n & 0x33) != 0) {
                    SunToolkit.executeOnEventHandlerThread(IconCanvas.this, new Runnable(){

                        public void run() {
                            IconCanvas.this.repaintImage(false);
                        }
                    });
                }
                return (n & 0x20) == 0;
            }
        }
    }

    static class TrayIconCanvas
    extends IconCanvas {
        TrayIcon target;
        boolean autosize;

        TrayIconCanvas(TrayIcon trayIcon, int n, int n2) {
            super(n, n2);
            this.target = trayIcon;
        }

        protected void repaintImage(boolean bl) {
            boolean bl2 = this.autosize;
            this.autosize = this.target.isImageAutoSize();
            this.curW = this.autosize ? this.width : this.image.getWidth(this.observer);
            this.curH = this.autosize ? this.height : this.image.getHeight(this.observer);
            super.repaintImage(bl || bl2 != this.autosize);
        }
    }

    private static class XTrayIconEmbeddedFrame
    extends XEmbeddedFrame {
        public XTrayIconEmbeddedFrame() {
            super(XToolkit.getDefaultRootWindow(), true, true);
        }

        public boolean isUndecorated() {
            return true;
        }

        public boolean isResizable() {
            return false;
        }

        public void dispose() {
        }

        public void realDispose() {
            super.dispose();
        }
    }

    static class TrayIconEventProxy
    implements MouseListener,
    MouseMotionListener {
        XTrayIconPeer xtiPeer;

        TrayIconEventProxy(XTrayIconPeer xTrayIconPeer) {
            this.xtiPeer = xTrayIconPeer;
        }

        public void handleEvent(MouseEvent mouseEvent) {
            if (mouseEvent.getID() == 506) {
                return;
            }
            if (this.xtiPeer.isDisposed()) {
                return;
            }
            Point point = XBaseWindow.toOtherWindow(this.xtiPeer.getWindow(), XToolkit.getDefaultRootWindow(), mouseEvent.getX(), mouseEvent.getY());
            if (mouseEvent.isPopupTrigger()) {
                this.xtiPeer.showPopupMenu(point.x, point.y);
            }
            mouseEvent.translatePoint(point.x - mouseEvent.getX(), point.y - mouseEvent.getY());
            mouseEvent.setSource(this.xtiPeer.target);
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(mouseEvent);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if ((mouseEvent.getClickCount() > 1 || this.xtiPeer.balloon.isVisible()) && mouseEvent.getButton() == 1) {
                ActionEvent actionEvent = new ActionEvent(this.xtiPeer.target, 1001, this.xtiPeer.target.getActionCommand(), mouseEvent.getWhen(), mouseEvent.getModifiers());
                Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(actionEvent);
            }
            if (this.xtiPeer.balloon.isVisible()) {
                this.xtiPeer.balloon.hide();
            }
            this.handleEvent(mouseEvent);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            this.xtiPeer.tooltip.enter();
            this.handleEvent(mouseEvent);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.xtiPeer.tooltip.exit();
            this.handleEvent(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.handleEvent(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.handleEvent(mouseEvent);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            this.handleEvent(mouseEvent);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            this.handleEvent(mouseEvent);
        }
    }
}

