/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.filechooser;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;

class WindowsFileSystemView
extends FileSystemView {
    private static final String newFolderString = UIManager.getString("FileChooser.win32.newFolder");
    private static final String newFolderNextString = UIManager.getString("FileChooser.win32.newFolder.subsequent");

    WindowsFileSystemView() {
    }

    public Boolean isTraversable(File file) {
        return this.isFileSystemRoot(file) || this.isComputerNode(file) || file.isDirectory();
    }

    public File getChild(File file, String string) {
        String string2;
        if (string.startsWith("\\") && !string.startsWith("\\\\") && this.isFileSystem(file) && (string2 = file.getAbsolutePath()).length() >= 2 && string2.charAt(1) == ':' && Character.isLetter(string2.charAt(0))) {
            return this.createFileObject(string2.substring(0, 2) + string);
        }
        return super.getChild(file, string);
    }

    public String getSystemTypeDescription(File file) {
        if (file != null) {
            return this.getShellFolder(file).getFolderType();
        }
        return null;
    }

    public File getHomeDirectory() {
        File[] fileArray = this.getRoots();
        return fileArray.length == 0 ? null : fileArray[0];
    }

    public File createNewFolder(File file) throws IOException {
        if (file == null) {
            throw new IOException("Containing directory is null:");
        }
        File file2 = null;
        file2 = this.createFileObject(file, newFolderString);
        for (int i = 2; file2.exists() && i < 100; ++i) {
            file2 = this.createFileObject(file, MessageFormat.format(newFolderNextString, new Integer(i)));
        }
        if (file2.exists()) {
            throw new IOException("Directory already exists:" + file2.getAbsolutePath());
        }
        file2.mkdirs();
        return file2;
    }

    public boolean isDrive(File file) {
        return this.isFileSystemRoot(file);
    }

    public boolean isFloppyDrive(File file) {
        String string = file.getAbsolutePath();
        return string != null && (string.equals("A:\\") || string.equals("B:\\"));
    }

    public File createFileObject(String string) {
        if (string.length() >= 2 && string.charAt(1) == ':' && Character.isLetter(string.charAt(0))) {
            if (string.length() == 2) {
                string = string + "\\";
            } else if (string.charAt(2) != '\\') {
                string = string.substring(0, 2) + "\\" + string.substring(2);
            }
        }
        return super.createFileObject(string);
    }

    protected File createFileSystemRoot(File file) {
        return new FileSystemView.FileSystemRoot(file){

            public boolean exists() {
                return true;
            }
        };
    }
}

