/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.ServiceConfigurationError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServiceLoader<S>
implements Iterable<S> {
    private static final String PREFIX = "META-INF/services/";
    private Class<S> service;
    private ClassLoader loader;
    private LinkedHashMap<String, S> providers = new LinkedHashMap();
    private LazyIterator lookupIterator;

    public void reload() {
        this.providers.clear();
        this.lookupIterator = new LazyIterator(this.service, this.loader);
    }

    private ServiceLoader(Class<S> clazz, ClassLoader classLoader) {
        this.service = clazz;
        this.loader = classLoader;
        this.reload();
    }

    private static void fail(Class clazz, String string, Throwable throwable) throws ServiceConfigurationError {
        throw new ServiceConfigurationError(clazz.getName() + ": " + string, throwable);
    }

    private static void fail(Class clazz, String string) throws ServiceConfigurationError {
        throw new ServiceConfigurationError(clazz.getName() + ": " + string);
    }

    private static void fail(Class clazz, URL uRL, int n, String string) throws ServiceConfigurationError {
        ServiceLoader.fail(clazz, uRL + ":" + n + ": " + string);
    }

    private int parseLine(Class clazz, URL uRL, BufferedReader bufferedReader, int n, List<String> list) throws IOException, ServiceConfigurationError {
        int n2;
        String string = bufferedReader.readLine();
        if (string == null) {
            return -1;
        }
        int n3 = string.indexOf(35);
        if (n3 >= 0) {
            string = string.substring(0, n3);
        }
        if ((n2 = (string = string.trim()).length()) != 0) {
            int n4;
            if (string.indexOf(32) >= 0 || string.indexOf(9) >= 0) {
                ServiceLoader.fail(clazz, uRL, n, "Illegal configuration-file syntax");
            }
            if (!Character.isJavaIdentifierStart(n4 = string.codePointAt(0))) {
                ServiceLoader.fail(clazz, uRL, n, "Illegal provider-class name: " + string);
            }
            for (int i = Character.charCount(n4); i < n2; i += Character.charCount(n4)) {
                n4 = string.codePointAt(i);
                if (Character.isJavaIdentifierPart(n4) || n4 == 46) continue;
                ServiceLoader.fail(clazz, uRL, n, "Illegal provider-class name: " + string);
            }
            if (!this.providers.containsKey(string) && !list.contains(string)) {
                list.add(string);
            }
        }
        return n + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Iterator<String> parse(Class clazz, URL uRL) throws ServiceConfigurationError {
        ArrayList<String> arrayList;
        block15: {
            InputStream inputStream = null;
            BufferedReader bufferedReader = null;
            arrayList = new ArrayList<String>();
            inputStream = uRL.openStream();
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "utf-8"));
            int n = 1;
            while ((n = this.parseLine(clazz, uRL, bufferedReader, n, arrayList)) >= 0) {
            }
            Object var8_8 = null;
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
                break block15;
            }
            catch (IOException iOException) {
                ServiceLoader.fail(clazz, "Error closing configuration file", iOException);
            }
            break block15;
            {
                catch (IOException iOException) {
                    ServiceLoader.fail(clazz, "Error reading configuration file", iOException);
                    Object var8_9 = null;
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        break block15;
                    }
                    catch (IOException iOException2) {
                        ServiceLoader.fail(clazz, "Error closing configuration file", iOException2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {
                    ServiceLoader.fail(clazz, "Error closing configuration file", iOException);
                }
                throw throwable;
            }
        }
        return arrayList.iterator();
    }

    @Override
    public Iterator<S> iterator() {
        return new Iterator<S>(){
            Iterator<Map.Entry<String, S>> knownProviders;
            {
                this.knownProviders = ServiceLoader.this.providers.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.knownProviders.hasNext()) {
                    return true;
                }
                return ServiceLoader.this.lookupIterator.hasNext();
            }

            @Override
            public S next() {
                if (this.knownProviders.hasNext()) {
                    return this.knownProviders.next().getValue();
                }
                return ServiceLoader.this.lookupIterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <S> ServiceLoader<S> load(Class<S> clazz, ClassLoader classLoader) {
        return new ServiceLoader<S>(clazz, classLoader);
    }

    public static <S> ServiceLoader<S> load(Class<S> clazz) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return ServiceLoader.load(clazz, classLoader);
    }

    public static <S> ServiceLoader<S> loadInstalled(Class<S> clazz) {
        ClassLoader classLoader = null;
        for (ClassLoader classLoader2 = ClassLoader.getSystemClassLoader(); classLoader2 != null; classLoader2 = classLoader2.getParent()) {
            classLoader = classLoader2;
        }
        return ServiceLoader.load(clazz, classLoader);
    }

    public String toString() {
        return "java.util.ServiceLoader[" + this.service.getName() + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LazyIterator
    implements Iterator<S> {
        Class<S> service;
        ClassLoader loader;
        Enumeration<URL> configs = null;
        Iterator<String> pending = null;
        String nextName = null;

        private LazyIterator(Class<S> clazz, ClassLoader classLoader) {
            this.service = clazz;
            this.loader = classLoader;
        }

        @Override
        public boolean hasNext() {
            if (this.nextName != null) {
                return true;
            }
            if (this.configs == null) {
                try {
                    String string = ServiceLoader.PREFIX + this.service.getName();
                    this.configs = this.loader == null ? ClassLoader.getSystemResources(string) : this.loader.getResources(string);
                }
                catch (IOException iOException) {
                    ServiceLoader.fail(this.service, "Error locating configuration files", iOException);
                }
            }
            while (this.pending == null || !this.pending.hasNext()) {
                if (!this.configs.hasMoreElements()) {
                    return false;
                }
                this.pending = ServiceLoader.this.parse(this.service, this.configs.nextElement());
            }
            this.nextName = this.pending.next();
            return true;
        }

        @Override
        public S next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            String string = this.nextName;
            this.nextName = null;
            Class<?> clazz = null;
            try {
                clazz = Class.forName(string, false, this.loader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                ServiceLoader.fail(this.service, "Provider " + string + " not found");
            }
            if (!this.service.isAssignableFrom(clazz)) {
                ServiceLoader.fail(this.service, "Provider " + string + " not a subtype");
            }
            try {
                Object s = this.service.cast(clazz.newInstance());
                ServiceLoader.this.providers.put(string, s);
                return s;
            }
            catch (Throwable throwable) {
                ServiceLoader.fail(this.service, "Provider " + string + " could not be instantiated", throwable);
                throw new Error();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

