/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.AccessController;
import java.security.Identity;
import java.security.IdentityScope;
import java.security.InvalidParameterException;
import java.security.KeyException;
import java.security.KeyManagementException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.PublicKey;

@Deprecated
public abstract class Signer
extends Identity {
    private static final long serialVersionUID = -1763464102261361480L;
    private PrivateKey privateKey;

    protected Signer() {
    }

    public Signer(String string) {
        super(string);
    }

    public Signer(String string, IdentityScope identityScope) throws KeyManagementException {
        super(string, identityScope);
    }

    public PrivateKey getPrivateKey() {
        Signer.check("getSignerPrivateKey");
        return this.privateKey;
    }

    public final void setKeyPair(KeyPair keyPair) throws InvalidParameterException, KeyException {
        Signer.check("setSignerKeyPair");
        final PublicKey publicKey = keyPair.getPublic();
        PrivateKey privateKey = keyPair.getPrivate();
        if (publicKey == null || privateKey == null) {
            throw new InvalidParameterException();
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws KeyManagementException {
                    Signer.this.setPublicKey(publicKey);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (KeyManagementException)privilegedActionException.getException();
        }
        this.privateKey = privateKey;
    }

    String printKeys() {
        String string = "";
        PublicKey publicKey = this.getPublicKey();
        string = publicKey != null && this.privateKey != null ? "\tpublic and private keys initialized" : "\tno keys";
        return string;
    }

    public String toString() {
        return "[Signer]" + super.toString();
    }

    private static void check(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSecurityAccess(string);
        }
    }
}

