/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.DomainCombiner;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import sun.reflect.CallerSensitive;
import sun.reflect.Reflection;
import sun.security.util.Debug;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AccessController {
    private AccessController() {
    }

    @CallerSensitive
    public static native <T> T doPrivileged(PrivilegedAction<T> var0);

    @CallerSensitive
    public static <T> T doPrivilegedWithCombiner(PrivilegedAction<T> privilegedAction) {
        AccessControlContext accessControlContext = AccessController.getStackAccessControlContext();
        if (accessControlContext == null) {
            return AccessController.doPrivileged(privilegedAction);
        }
        DomainCombiner domainCombiner = accessControlContext.getAssignedCombiner();
        return AccessController.doPrivileged(privilegedAction, AccessController.preserveCombiner(domainCombiner, Reflection.getCallerClass()));
    }

    @CallerSensitive
    public static native <T> T doPrivileged(PrivilegedAction<T> var0, AccessControlContext var1);

    @CallerSensitive
    public static native <T> T doPrivileged(PrivilegedExceptionAction<T> var0) throws PrivilegedActionException;

    @CallerSensitive
    public static <T> T doPrivilegedWithCombiner(PrivilegedExceptionAction<T> privilegedExceptionAction) throws PrivilegedActionException {
        AccessControlContext accessControlContext = AccessController.getStackAccessControlContext();
        if (accessControlContext == null) {
            return AccessController.doPrivileged(privilegedExceptionAction);
        }
        DomainCombiner domainCombiner = accessControlContext.getAssignedCombiner();
        return AccessController.doPrivileged(privilegedExceptionAction, AccessController.preserveCombiner(domainCombiner, Reflection.getCallerClass()));
    }

    private static AccessControlContext preserveCombiner(DomainCombiner domainCombiner, final Class<?> clazz) {
        ProtectionDomain protectionDomain = AccessController.doPrivileged(new PrivilegedAction<ProtectionDomain>(){

            @Override
            public ProtectionDomain run() {
                return clazz.getProtectionDomain();
            }
        });
        ProtectionDomain[] protectionDomainArray = new ProtectionDomain[]{protectionDomain};
        if (domainCombiner == null) {
            return new AccessControlContext(protectionDomainArray);
        }
        return new AccessControlContext(domainCombiner.combine(protectionDomainArray, null), domainCombiner);
    }

    @CallerSensitive
    public static native <T> T doPrivileged(PrivilegedExceptionAction<T> var0, AccessControlContext var1) throws PrivilegedActionException;

    private static native AccessControlContext getStackAccessControlContext();

    static native AccessControlContext getInheritedAccessControlContext();

    public static AccessControlContext getContext() {
        AccessControlContext accessControlContext = AccessController.getStackAccessControlContext();
        if (accessControlContext == null) {
            return new AccessControlContext(null, true);
        }
        return accessControlContext.optimize();
    }

    public static void checkPermission(Permission permission) throws AccessControlException {
        if (permission == null) {
            throw new NullPointerException("permission can't be null");
        }
        AccessControlContext accessControlContext = AccessController.getStackAccessControlContext();
        if (accessControlContext == null) {
            Debug debug = AccessControlContext.getDebug();
            boolean bl = false;
            if (debug != null) {
                bl = !Debug.isOn("codebase=");
                bl &= !Debug.isOn("permission=") || Debug.isOn("permission=" + permission.getClass().getCanonicalName());
            }
            if (bl && Debug.isOn("stack")) {
                Thread.currentThread();
                Thread.dumpStack();
            }
            if (bl && Debug.isOn("domain")) {
                debug.println("domain (context is null)");
            }
            if (bl) {
                debug.println("access allowed " + permission);
            }
            return;
        }
        AccessControlContext accessControlContext2 = accessControlContext.optimize();
        accessControlContext2.checkPermission(permission);
    }
}

