/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Console;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.channels.Channel;
import java.nio.channels.spi.SelectorProvider;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.Properties;
import java.util.PropertyPermission;
import sun.misc.JavaLangAccess;
import sun.misc.SharedSecrets;
import sun.misc.VM;
import sun.misc.Version;
import sun.net.InetAddressCachePolicy;
import sun.nio.ch.Interruptible;
import sun.reflect.CallerSensitive;
import sun.reflect.ConstantPool;
import sun.reflect.Reflection;
import sun.reflect.annotation.AnnotationType;
import sun.security.util.SecurityConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class System {
    public static final InputStream in;
    public static final PrintStream out;
    public static final PrintStream err;
    private static volatile SecurityManager security;
    private static volatile Console cons;
    private static Properties props;

    private static native void registerNatives();

    private System() {
    }

    public static void setIn(InputStream inputStream) {
        System.checkIO();
        System.setIn0(inputStream);
    }

    public static void setOut(PrintStream printStream) {
        System.checkIO();
        System.setOut0(printStream);
    }

    public static void setErr(PrintStream printStream) {
        System.checkIO();
        System.setErr0(printStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Console console() {
        if (cons != null) return cons;
        Class<System> clazz = System.class;
        synchronized (System.class) {
            cons = SharedSecrets.getJavaIOAccess().console();
            // ** MonitorExit[var0] (shouldn't be in output)
            return cons;
        }
    }

    public static Channel inheritedChannel() throws IOException {
        return SelectorProvider.provider().inheritedChannel();
    }

    private static void checkIO() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("setIO"));
        }
    }

    private static native void setIn0(InputStream var0);

    private static native void setOut0(PrintStream var0);

    private static native void setErr0(PrintStream var0);

    public static void setSecurityManager(SecurityManager securityManager) {
        try {
            securityManager.checkPackageAccess("java.lang");
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.setSecurityManager0(securityManager);
    }

    private static synchronized void setSecurityManager0(final SecurityManager securityManager) {
        SecurityManager securityManager2 = System.getSecurityManager();
        if (securityManager2 != null) {
            securityManager2.checkPermission(new RuntimePermission("setSecurityManager"));
        }
        if (securityManager != null && securityManager.getClass().getClassLoader() != null) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    securityManager.getClass().getProtectionDomain().implies(SecurityConstants.ALL_PERMISSION);
                    return null;
                }
            });
        }
        security = securityManager;
        InetAddressCachePolicy.setIfNotSet(-1);
    }

    public static SecurityManager getSecurityManager() {
        return security;
    }

    public static native long currentTimeMillis();

    public static native long nanoTime();

    public static native void arraycopy(Object var0, int var1, Object var2, int var3, int var4);

    public static native int identityHashCode(Object var0);

    private static native Properties initProperties(Properties var0);

    public static Properties getProperties() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPropertiesAccess();
        }
        return props;
    }

    public static void setProperties(Properties properties) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPropertiesAccess();
        }
        if (properties == null) {
            properties = new Properties();
            System.initProperties(properties);
        }
        props = properties;
    }

    public static String getProperty(String string) {
        System.checkKey(string);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPropertyAccess(string);
        }
        return props.getProperty(string);
    }

    public static String getProperty(String string, String string2) {
        System.checkKey(string);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPropertyAccess(string);
        }
        return props.getProperty(string, string2);
    }

    public static String setProperty(String string, String string2) {
        System.checkKey(string);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new PropertyPermission(string, "write"));
        }
        return (String)props.setProperty(string, string2);
    }

    public static String clearProperty(String string) {
        System.checkKey(string);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new PropertyPermission(string, "write"));
        }
        return (String)props.remove(string);
    }

    private static void checkKey(String string) {
        if (string == null) {
            throw new NullPointerException("key can't be null");
        }
        if (string.equals("")) {
            throw new IllegalArgumentException("key can't be empty");
        }
    }

    public static String getenv(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("getenv." + string));
        }
        return ProcessEnvironment.getenv(string);
    }

    public static Map<String, String> getenv() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("getenv.*"));
        }
        return ProcessEnvironment.getenv();
    }

    public static void exit(int n) {
        Runtime.getRuntime().exit(n);
    }

    public static void gc() {
        Runtime.getRuntime().gc();
    }

    public static void runFinalization() {
        Runtime.getRuntime().runFinalization();
    }

    @Deprecated
    public static void runFinalizersOnExit(boolean bl) {
        Runtime.getRuntime();
        Runtime.runFinalizersOnExit(bl);
    }

    @CallerSensitive
    public static void load(String string) {
        Runtime.getRuntime().load0(Reflection.getCallerClass(), string);
    }

    @CallerSensitive
    public static void loadLibrary(String string) {
        Runtime.getRuntime().loadLibrary0(Reflection.getCallerClass(), string);
    }

    public static native String mapLibraryName(String var0);

    private static InputStream nullInputStream() throws NullPointerException {
        if (System.currentTimeMillis() > 0L) {
            return null;
        }
        throw new NullPointerException();
    }

    private static PrintStream nullPrintStream() throws NullPointerException {
        if (System.currentTimeMillis() > 0L) {
            return null;
        }
        throw new NullPointerException();
    }

    private static void initializeSystemClass() {
        props = new Properties();
        System.initProperties(props);
        Version.init();
        FileInputStream fileInputStream = new FileInputStream(FileDescriptor.in);
        FileOutputStream fileOutputStream = new FileOutputStream(FileDescriptor.out);
        FileOutputStream fileOutputStream2 = new FileOutputStream(FileDescriptor.err);
        System.setIn0(new BufferedInputStream(fileInputStream));
        System.setOut0(new PrintStream(new BufferedOutputStream(fileOutputStream, 128), true));
        System.setErr0(new PrintStream(new BufferedOutputStream(fileOutputStream2, 128), true));
        System.loadLibrary("zip");
        Terminator.setup();
        Shutdown.add(SharedSecrets.getJavaIOAccess().consoleRestoreHook());
        Shutdown.add(ApplicationShutdownHooks.hook());
        Shutdown.add(SharedSecrets.getJavaIODeleteOnExitAccess());
        VM.initializeOSEnvironment();
        VM.maxDirectMemory();
        VM.allowArraySyntax();
        VM.booted();
        Thread thread = Thread.currentThread();
        thread.getThreadGroup().add(thread);
        SharedSecrets.setJavaLangAccess(new JavaLangAccess(){

            @Override
            public ConstantPool getConstantPool(Class clazz) {
                return clazz.getConstantPool();
            }

            @Override
            public boolean casAnnotationType(Class<?> clazz, AnnotationType annotationType, AnnotationType annotationType2) {
                return clazz.casAnnotationType(annotationType, annotationType2);
            }

            @Override
            public AnnotationType getAnnotationType(Class clazz) {
                return clazz.getAnnotationType();
            }

            @Override
            public byte[] getRawClassAnnotations(Class<?> clazz) {
                return clazz.getRawAnnotations();
            }

            @Override
            public <E extends Enum<E>> E[] getEnumConstantsShared(Class<E> clazz) {
                return (Enum[])clazz.getEnumConstantsShared();
            }

            @Override
            public void blockedOn(Thread thread, Interruptible interruptible) {
                thread.blockedOn(interruptible);
            }

            @Override
            public Thread newThreadWithAcc(Runnable runnable, AccessControlContext accessControlContext) {
                return new Thread(runnable, accessControlContext);
            }
        });
    }

    static {
        System.registerNatives();
        in = System.nullInputStream();
        out = System.nullPrintStream();
        err = System.nullPrintStream();
        security = null;
        cons = null;
    }
}

