/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AudioFloatConverter;
import com.sun.media.sound.RIFFReader;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.sound.sampled.spi.AudioFileReader;

public final class WaveExtensibleFileReader
extends AudioFileReader {
    private static final String[] channelnames = new String[]{"FL", "FR", "FC", "LF", "BL", "BR", "FLC", "FLR", "BC", "SL", "SR", "TC", "TFL", "TFC", "TFR", "TBL", "TBC", "TBR"};
    private static final String[] allchannelnames = new String[]{"w1", "w2", "w3", "w4", "w5", "w6", "w7", "w8", "w9", "w10", "w11", "w12", "w13", "w14", "w15", "w16", "w17", "w18", "w19", "w20", "w21", "w22", "w23", "w24", "w25", "w26", "w27", "w28", "w29", "w30", "w31", "w32", "w33", "w34", "w35", "w36", "w37", "w38", "w39", "w40", "w41", "w42", "w43", "w44", "w45", "w46", "w47", "w48", "w49", "w50", "w51", "w52", "w53", "w54", "w55", "w56", "w57", "w58", "w59", "w60", "w61", "w62", "w63", "w64"};
    private static final GUID SUBTYPE_PCM = new GUID(1L, 0, 16, 128, 0, 0, 170, 0, 56, 155, 113);
    private static final GUID SUBTYPE_IEEE_FLOAT = new GUID(3L, 0, 16, 128, 0, 0, 170, 0, 56, 155, 113);

    private String decodeChannelMask(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        long l2 = 1L;
        for (int i = 0; i < allchannelnames.length; ++i) {
            if ((l & l2) != 0L) {
                if (i < channelnames.length) {
                    stringBuffer.append(channelnames[i] + " ");
                } else {
                    stringBuffer.append(allchannelnames[i] + " ");
                }
            }
            l2 *= 2L;
        }
        if (stringBuffer.length() == 0) {
            return null;
        }
        return stringBuffer.substring(0, stringBuffer.length() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AudioFileFormat getAudioFileFormat(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        AudioFileFormat audioFileFormat;
        inputStream.mark(200);
        try {
            audioFileFormat = this.internal_getAudioFileFormat(inputStream);
        }
        finally {
            inputStream.reset();
        }
        return audioFileFormat;
    }

    private AudioFileFormat internal_getAudioFileFormat(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        Object object;
        RIFFReader rIFFReader = new RIFFReader(inputStream);
        if (!rIFFReader.getFormat().equals("RIFF")) {
            throw new UnsupportedAudioFileException();
        }
        if (!rIFFReader.getType().equals("WAVE")) {
            throw new UnsupportedAudioFileException();
        }
        boolean bl = false;
        boolean bl2 = false;
        int n = 1;
        long l = 1L;
        int n2 = 1;
        int n3 = 1;
        int n4 = 1;
        long l2 = 0L;
        GUID gUID = null;
        while (rIFFReader.hasNextChunk()) {
            object = rIFFReader.nextChunk();
            if (((RIFFReader)object).getFormat().equals("fmt ")) {
                bl = true;
                int n5 = ((RIFFReader)object).readUnsignedShort();
                if (n5 != 65534) {
                    throw new UnsupportedAudioFileException();
                }
                n = ((RIFFReader)object).readUnsignedShort();
                l = ((RIFFReader)object).readUnsignedInt();
                ((RIFFReader)object).readUnsignedInt();
                n2 = ((RIFFReader)object).readUnsignedShort();
                n3 = ((RIFFReader)object).readUnsignedShort();
                int n6 = ((RIFFReader)object).readUnsignedShort();
                if (n6 != 22) {
                    throw new UnsupportedAudioFileException();
                }
                n4 = ((RIFFReader)object).readUnsignedShort();
                if (n4 > n3) {
                    throw new UnsupportedAudioFileException();
                }
                l2 = ((RIFFReader)object).readUnsignedInt();
                gUID = GUID.read((RIFFReader)object);
            }
            if (!((RIFFReader)object).getFormat().equals("data")) continue;
            bl2 = true;
            break;
        }
        if (!bl) {
            throw new UnsupportedAudioFileException();
        }
        if (!bl2) {
            throw new UnsupportedAudioFileException();
        }
        object = new HashMap();
        String string = this.decodeChannelMask(l2);
        if (string != null) {
            object.put("channelOrder", string);
        }
        if (l2 != 0L) {
            object.put("channelMask", l2);
        }
        object.put("validBitsPerSample", n4);
        AudioFormat audioFormat = null;
        if (gUID.equals(SUBTYPE_PCM)) {
            audioFormat = n3 == 8 ? new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, l, n3, n, n2, l, false, (Map<String, Object>)object) : new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, l, n3, n, n2, l, false, (Map<String, Object>)object);
        } else if (gUID.equals(SUBTYPE_IEEE_FLOAT)) {
            audioFormat = new AudioFormat(AudioFloatConverter.PCM_FLOAT, l, n3, n, n2, l, false, (Map<String, Object>)object);
        } else {
            throw new UnsupportedAudioFileException();
        }
        AudioFileFormat audioFileFormat = new AudioFileFormat(AudioFileFormat.Type.WAVE, audioFormat, -1);
        return audioFileFormat;
    }

    public AudioInputStream getAudioInputStream(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        AudioFileFormat audioFileFormat = this.getAudioFileFormat(inputStream);
        RIFFReader rIFFReader = new RIFFReader(inputStream);
        if (!rIFFReader.getFormat().equals("RIFF")) {
            throw new UnsupportedAudioFileException();
        }
        if (!rIFFReader.getType().equals("WAVE")) {
            throw new UnsupportedAudioFileException();
        }
        while (rIFFReader.hasNextChunk()) {
            RIFFReader rIFFReader2 = rIFFReader.nextChunk();
            if (!rIFFReader2.getFormat().equals("data")) continue;
            return new AudioInputStream(rIFFReader2, audioFileFormat.getFormat(), rIFFReader2.getSize());
        }
        throw new UnsupportedAudioFileException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AudioFileFormat getAudioFileFormat(URL uRL) throws UnsupportedAudioFileException, IOException {
        AudioFileFormat audioFileFormat;
        InputStream inputStream = uRL.openStream();
        try {
            audioFileFormat = this.getAudioFileFormat(new BufferedInputStream(inputStream));
        }
        finally {
            inputStream.close();
        }
        return audioFileFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AudioFileFormat getAudioFileFormat(File file) throws UnsupportedAudioFileException, IOException {
        AudioFileFormat audioFileFormat;
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            audioFileFormat = this.getAudioFileFormat(new BufferedInputStream(fileInputStream));
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
        return audioFileFormat;
    }

    public AudioInputStream getAudioInputStream(URL uRL) throws UnsupportedAudioFileException, IOException {
        return this.getAudioInputStream(new BufferedInputStream(uRL.openStream()));
    }

    public AudioInputStream getAudioInputStream(File file) throws UnsupportedAudioFileException, IOException {
        return this.getAudioInputStream(new BufferedInputStream(new FileInputStream(file)));
    }

    private static class GUID {
        long i1;
        int s1;
        int s2;
        int x1;
        int x2;
        int x3;
        int x4;
        int x5;
        int x6;
        int x7;
        int x8;

        private GUID() {
        }

        GUID(long l, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
            this.i1 = l;
            this.s1 = n;
            this.s2 = n2;
            this.x1 = n3;
            this.x2 = n4;
            this.x3 = n5;
            this.x4 = n6;
            this.x5 = n7;
            this.x6 = n8;
            this.x7 = n9;
            this.x8 = n10;
        }

        public static GUID read(RIFFReader rIFFReader) throws IOException {
            GUID gUID = new GUID();
            gUID.i1 = rIFFReader.readUnsignedInt();
            gUID.s1 = rIFFReader.readUnsignedShort();
            gUID.s2 = rIFFReader.readUnsignedShort();
            gUID.x1 = rIFFReader.readUnsignedByte();
            gUID.x2 = rIFFReader.readUnsignedByte();
            gUID.x3 = rIFFReader.readUnsignedByte();
            gUID.x4 = rIFFReader.readUnsignedByte();
            gUID.x5 = rIFFReader.readUnsignedByte();
            gUID.x6 = rIFFReader.readUnsignedByte();
            gUID.x7 = rIFFReader.readUnsignedByte();
            gUID.x8 = rIFFReader.readUnsignedByte();
            return gUID;
        }

        public int hashCode() {
            return (int)this.i1;
        }

        public boolean equals(Object object) {
            if (!(object instanceof GUID)) {
                return false;
            }
            GUID gUID = (GUID)object;
            if (this.i1 != gUID.i1) {
                return false;
            }
            if (this.s1 != gUID.s1) {
                return false;
            }
            if (this.s2 != gUID.s2) {
                return false;
            }
            if (this.x1 != gUID.x1) {
                return false;
            }
            if (this.x2 != gUID.x2) {
                return false;
            }
            if (this.x3 != gUID.x3) {
                return false;
            }
            if (this.x4 != gUID.x4) {
                return false;
            }
            if (this.x5 != gUID.x5) {
                return false;
            }
            if (this.x6 != gUID.x6) {
                return false;
            }
            if (this.x7 != gUID.x7) {
                return false;
            }
            return this.x8 == gUID.x8;
        }
    }
}

