/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AudioFloatInputStream;
import com.sun.media.sound.SoftAudioBuffer;
import com.sun.media.sound.SoftMixingDataLine;
import com.sun.media.sound.SoftMixingMixer;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

public final class SoftMixingSourceDataLine
extends SoftMixingDataLine
implements SourceDataLine {
    private boolean open = false;
    private AudioFormat format = new AudioFormat(44100.0f, 16, 2, true, false);
    private int framesize;
    private int bufferSize = -1;
    private float[] readbuffer;
    private boolean active = false;
    private byte[] cycling_buffer;
    private int cycling_read_pos = 0;
    private int cycling_write_pos = 0;
    private int cycling_avail = 0;
    private long cycling_framepos = 0L;
    private AudioFloatInputStream afis;
    private boolean _active = false;
    private AudioFormat outputformat;
    private int out_nrofchannels;
    private int in_nrofchannels;
    private float _rightgain;
    private float _leftgain;
    private float _eff1gain;
    private float _eff2gain;

    SoftMixingSourceDataLine(SoftMixingMixer softMixingMixer, DataLine.Info info) {
        super(softMixingMixer, info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public int write(byte[] byArray, int n, int n2) {
        if (!this.isOpen()) {
            return 0;
        }
        if (n2 % this.framesize != 0) {
            throw new IllegalArgumentException("Number of bytes does not represent an integral number of sample frames.");
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        if ((long)n + (long)n2 > (long)byArray.length) {
            throw new ArrayIndexOutOfBoundsException(byArray.length);
        }
        byte[] byArray2 = this.cycling_buffer;
        int n3 = this.cycling_buffer.length;
        int n4 = 0;
        while (n4 != n2) {
            int n5;
            byte[] byArray3 = this.cycling_buffer;
            // MONITORENTER : this.cycling_buffer
            int n6 = this.cycling_write_pos;
            for (n5 = this.cycling_avail; n4 != n2 && n5 != n3; ++n4, ++n5) {
                byArray2[n6++] = byArray[n++];
                if (n6 != n3) continue;
                n6 = 0;
            }
            this.cycling_avail = n5;
            this.cycling_write_pos = n6;
            if (n4 == n2) {
                // MONITOREXIT : byArray3
                return n4;
            }
            // MONITOREXIT : byArray3
            if (n5 != n3) continue;
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                return n4;
            }
            if (!this.isRunning()) return n4;
        }
        return n4;
    }

    protected void processControlLogic() {
        this._active = this.active;
        this._rightgain = this.rightgain;
        this._leftgain = this.leftgain;
        this._eff1gain = this.eff1gain;
        this._eff2gain = this.eff2gain;
    }

    protected void processAudioLogic(SoftAudioBuffer[] softAudioBufferArray) {
        if (this._active) {
            int n;
            float[] fArray = softAudioBufferArray[0].array();
            float[] fArray2 = softAudioBufferArray[1].array();
            int n2 = softAudioBufferArray[0].getSize();
            int n3 = n2 * this.in_nrofchannels;
            if (this.readbuffer == null || this.readbuffer.length < n3) {
                this.readbuffer = new float[n3];
            }
            int n4 = 0;
            try {
                n4 = this.afis.read(this.readbuffer);
                if (n4 != this.in_nrofchannels) {
                    Arrays.fill(this.readbuffer, n4, n3, 0.0f);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            int n5 = this.in_nrofchannels;
            int n6 = 0;
            int n7 = 0;
            while (n6 < n2) {
                int n8 = n6++;
                fArray[n8] = fArray[n8] + this.readbuffer[n7] * this._leftgain;
                n7 += n5;
            }
            if (this.out_nrofchannels != 1) {
                if (this.in_nrofchannels == 1) {
                    n6 = 0;
                    n7 = 0;
                    while (n6 < n2) {
                        int n9 = n6++;
                        fArray2[n9] = fArray2[n9] + this.readbuffer[n7] * this._rightgain;
                        n7 += n5;
                    }
                } else {
                    n6 = 0;
                    n7 = 1;
                    while (n6 < n2) {
                        int n10 = n6++;
                        fArray2[n10] = fArray2[n10] + this.readbuffer[n7] * this._rightgain;
                        n7 += n5;
                    }
                }
            }
            if ((double)this._eff1gain > 1.0E-4) {
                float[] fArray3 = softAudioBufferArray[2].array();
                n7 = 0;
                n = 0;
                while (n7 < n2) {
                    int n11 = n7++;
                    fArray3[n11] = fArray3[n11] + this.readbuffer[n] * this._eff1gain;
                    n += n5;
                }
                if (this.in_nrofchannels == 2) {
                    n7 = 0;
                    n = 1;
                    while (n7 < n2) {
                        int n12 = n7++;
                        fArray3[n12] = fArray3[n12] + this.readbuffer[n] * this._eff1gain;
                        n += n5;
                    }
                }
            }
            if ((double)this._eff2gain > 1.0E-4) {
                float[] fArray4 = softAudioBufferArray[3].array();
                n7 = 0;
                n = 0;
                while (n7 < n2) {
                    int n13 = n7++;
                    fArray4[n13] = fArray4[n13] + this.readbuffer[n] * this._eff2gain;
                    n += n5;
                }
                if (this.in_nrofchannels == 2) {
                    n7 = 0;
                    n = 1;
                    while (n7 < n2) {
                        int n14 = n7++;
                        fArray4[n14] = fArray4[n14] + this.readbuffer[n] * this._eff2gain;
                        n += n5;
                    }
                }
            }
        }
    }

    public void open() throws LineUnavailableException {
        this.open(this.format);
    }

    public void open(AudioFormat audioFormat) throws LineUnavailableException {
        if (this.bufferSize == -1) {
            this.bufferSize = (int)(audioFormat.getFrameRate() / 2.0f) * audioFormat.getFrameSize();
        }
        this.open(audioFormat, this.bufferSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(AudioFormat audioFormat, int n) throws LineUnavailableException {
        LineEvent lineEvent = null;
        if (n < audioFormat.getFrameSize() * 32) {
            n = audioFormat.getFrameSize() * 32;
        }
        Object object = this.control_mutex;
        synchronized (object) {
            if (!this.isOpen()) {
                if (!this.mixer.isOpen()) {
                    this.mixer.open();
                    this.mixer.implicitOpen = true;
                }
                lineEvent = new LineEvent(this, LineEvent.Type.OPEN, 0L);
                this.bufferSize = n - n % audioFormat.getFrameSize();
                this.format = audioFormat;
                this.framesize = audioFormat.getFrameSize();
                this.outputformat = this.mixer.getFormat();
                this.out_nrofchannels = this.outputformat.getChannels();
                this.in_nrofchannels = audioFormat.getChannels();
                this.open = true;
                this.mixer.getMainMixer().openLine(this);
                this.cycling_buffer = new byte[this.framesize * n];
                this.cycling_read_pos = 0;
                this.cycling_write_pos = 0;
                this.cycling_avail = 0;
                this.cycling_framepos = 0L;
                InputStream inputStream = new InputStream(){

                    public int read() throws IOException {
                        byte[] byArray = new byte[1];
                        int n = this.read(byArray);
                        if (n < 0) {
                            return n;
                        }
                        return byArray[0] & 0xFF;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public int available() throws IOException {
                        byte[] byArray = SoftMixingSourceDataLine.this.cycling_buffer;
                        synchronized (byArray) {
                            return SoftMixingSourceDataLine.this.cycling_avail;
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public int read(byte[] byArray, int n, int n2) throws IOException {
                        byte[] byArray2 = SoftMixingSourceDataLine.this.cycling_buffer;
                        synchronized (byArray2) {
                            if (n2 > SoftMixingSourceDataLine.this.cycling_avail) {
                                n2 = SoftMixingSourceDataLine.this.cycling_avail;
                            }
                            int n3 = SoftMixingSourceDataLine.this.cycling_read_pos;
                            byte[] byArray3 = SoftMixingSourceDataLine.this.cycling_buffer;
                            int n4 = byArray3.length;
                            for (int i = 0; i < n2; ++i) {
                                byArray[n++] = byArray3[n3];
                                if (++n3 != n4) continue;
                                n3 = 0;
                            }
                            SoftMixingSourceDataLine.this.cycling_read_pos = n3;
                            SoftMixingSourceDataLine.this.cycling_avail -= n2;
                            SoftMixingSourceDataLine.this.cycling_framepos += n2 / SoftMixingSourceDataLine.this.framesize;
                        }
                        return n2;
                    }
                };
                this.afis = AudioFloatInputStream.getInputStream(new AudioInputStream(inputStream, audioFormat, -1L));
                this.afis = new NonBlockingFloatInputStream(this.afis);
                if ((double)Math.abs(audioFormat.getSampleRate() - this.outputformat.getSampleRate()) > 1.0E-6) {
                    this.afis = new SoftMixingDataLine.AudioFloatInputStreamResampler(this.afis, this.outputformat);
                }
            } else if (!audioFormat.matches(this.getFormat())) {
                throw new IllegalStateException("Line is already open with format " + this.getFormat() + " and bufferSize " + this.getBufferSize());
            }
        }
        if (lineEvent != null) {
            this.sendEvent(lineEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int available() {
        byte[] byArray = this.cycling_buffer;
        synchronized (this.cycling_buffer) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.cycling_buffer.length - this.cycling_avail;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void drain() {
        while (true) {
            byte[] byArray = this.cycling_buffer;
            // MONITORENTER : this.cycling_buffer
            int n = this.cycling_avail;
            // MONITOREXIT : byArray
            if (n != 0) {
                return;
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        byte[] byArray = this.cycling_buffer;
        synchronized (this.cycling_buffer) {
            this.cycling_read_pos = 0;
            this.cycling_write_pos = 0;
            this.cycling_avail = 0;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBufferSize() {
        Object object = this.control_mutex;
        synchronized (object) {
            return this.bufferSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AudioFormat getFormat() {
        Object object = this.control_mutex;
        synchronized (object) {
            return this.format;
        }
    }

    public int getFramePosition() {
        return (int)this.getLongFramePosition();
    }

    public float getLevel() {
        return -1.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLongFramePosition() {
        byte[] byArray = this.cycling_buffer;
        synchronized (this.cycling_buffer) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.cycling_framepos;
        }
    }

    public long getMicrosecondPosition() {
        return (long)((double)this.getLongFramePosition() * (1000000.0 / (double)this.getFormat().getSampleRate()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActive() {
        Object object = this.control_mutex;
        synchronized (object) {
            return this.active;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        Object object = this.control_mutex;
        synchronized (object) {
            return this.active;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        LineEvent lineEvent = null;
        Object object = this.control_mutex;
        synchronized (object) {
            if (this.isOpen()) {
                if (this.active) {
                    return;
                }
                this.active = true;
                lineEvent = new LineEvent(this, LineEvent.Type.START, this.getLongFramePosition());
            }
        }
        if (lineEvent != null) {
            this.sendEvent(lineEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        LineEvent lineEvent = null;
        Object object = this.control_mutex;
        synchronized (object) {
            if (this.isOpen()) {
                if (!this.active) {
                    return;
                }
                this.active = false;
                lineEvent = new LineEvent(this, LineEvent.Type.STOP, this.getLongFramePosition());
            }
        }
        if (lineEvent != null) {
            this.sendEvent(lineEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        LineEvent lineEvent = null;
        Object object = this.control_mutex;
        synchronized (object) {
            if (!this.isOpen()) {
                return;
            }
            this.stop();
            lineEvent = new LineEvent(this, LineEvent.Type.CLOSE, this.getLongFramePosition());
            this.open = false;
            this.mixer.getMainMixer().closeLine(this);
        }
        if (lineEvent != null) {
            this.sendEvent(lineEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOpen() {
        Object object = this.control_mutex;
        synchronized (object) {
            return this.open;
        }
    }

    private static class NonBlockingFloatInputStream
    extends AudioFloatInputStream {
        AudioFloatInputStream ais;

        NonBlockingFloatInputStream(AudioFloatInputStream audioFloatInputStream) {
            this.ais = audioFloatInputStream;
        }

        public int available() throws IOException {
            return this.ais.available();
        }

        public void close() throws IOException {
            this.ais.close();
        }

        public AudioFormat getFormat() {
            return this.ais.getFormat();
        }

        public long getFrameLength() {
            return this.ais.getFrameLength();
        }

        public void mark(int n) {
            this.ais.mark(n);
        }

        public boolean markSupported() {
            return this.ais.markSupported();
        }

        public int read(float[] fArray, int n, int n2) throws IOException {
            int n3 = this.available();
            if (n2 > n3) {
                int n4 = this.ais.read(fArray, n, n3);
                Arrays.fill(fArray, n + n4, n + n2, 0.0f);
                return n2;
            }
            return this.ais.read(fArray, n, n2);
        }

        public void reset() throws IOException {
            this.ais.reset();
        }

        public long skip(long l) throws IOException {
            return this.ais.skip(l);
        }
    }
}

