/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.ModelByteBuffer;
import com.sun.media.sound.ModelByteBufferWavetable;
import com.sun.media.sound.ModelConnectionBlock;
import com.sun.media.sound.ModelDestination;
import com.sun.media.sound.ModelIdentifier;
import com.sun.media.sound.ModelInstrument;
import com.sun.media.sound.ModelPatch;
import com.sun.media.sound.ModelPerformer;
import com.sun.media.sound.ModelSource;
import com.sun.media.sound.ModelStandardTransform;
import com.sun.media.sound.ModelTransform;
import com.sun.media.sound.SF2GlobalRegion;
import com.sun.media.sound.SF2InstrumentRegion;
import com.sun.media.sound.SF2Layer;
import com.sun.media.sound.SF2LayerRegion;
import com.sun.media.sound.SF2Modulator;
import com.sun.media.sound.SF2Region;
import com.sun.media.sound.SF2Sample;
import com.sun.media.sound.SF2Soundbank;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.sound.midi.Patch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SF2Instrument
extends ModelInstrument {
    String name = "";
    int preset = 0;
    int bank = 0;
    long library = 0L;
    long genre = 0L;
    long morphology = 0L;
    SF2GlobalRegion globalregion = null;
    List<SF2InstrumentRegion> regions = new ArrayList<SF2InstrumentRegion>();

    public SF2Instrument() {
        super(null, null, null, null);
    }

    public SF2Instrument(SF2Soundbank sF2Soundbank) {
        super(sF2Soundbank, null, null, null);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    @Override
    public Patch getPatch() {
        if (this.bank == 128) {
            return new ModelPatch(0, this.preset, true);
        }
        return new ModelPatch(this.bank << 7, this.preset, false);
    }

    public void setPatch(Patch patch) {
        if (patch instanceof ModelPatch && ((ModelPatch)patch).isPercussion()) {
            this.bank = 128;
            this.preset = patch.getProgram();
        } else {
            this.bank = patch.getBank() >> 7;
            this.preset = patch.getProgram();
        }
    }

    @Override
    public Object getData() {
        return null;
    }

    public long getGenre() {
        return this.genre;
    }

    public void setGenre(long l) {
        this.genre = l;
    }

    public long getLibrary() {
        return this.library;
    }

    public void setLibrary(long l) {
        this.library = l;
    }

    public long getMorphology() {
        return this.morphology;
    }

    public void setMorphology(long l) {
        this.morphology = l;
    }

    public List<SF2InstrumentRegion> getRegions() {
        return this.regions;
    }

    public SF2GlobalRegion getGlobalRegion() {
        return this.globalregion;
    }

    public void setGlobalZone(SF2GlobalRegion sF2GlobalRegion) {
        this.globalregion = sF2GlobalRegion;
    }

    public String toString() {
        if (this.bank == 128) {
            return "Drumkit: " + this.name + " preset #" + this.preset;
        }
        return "Instrument: " + this.name + " bank #" + this.bank + " preset #" + this.preset;
    }

    @Override
    public ModelPerformer[] getPerformers() {
        int n = 0;
        for (SF2InstrumentRegion sF2InstrumentRegion : this.regions) {
            n += sF2InstrumentRegion.getLayer().getRegions().size();
        }
        ModelPerformer[] modelPerformerArray = new ModelPerformer[n];
        int n2 = 0;
        SF2GlobalRegion sF2GlobalRegion = this.globalregion;
        for (SF2InstrumentRegion sF2InstrumentRegion : this.regions) {
            HashMap<Integer, Short> hashMap = new HashMap<Integer, Short>();
            hashMap.putAll(sF2InstrumentRegion.getGenerators());
            if (sF2GlobalRegion != null) {
                hashMap.putAll(sF2GlobalRegion.getGenerators());
            }
            SF2Layer sF2Layer = sF2InstrumentRegion.getLayer();
            SF2GlobalRegion sF2GlobalRegion2 = sF2Layer.getGlobalRegion();
            for (SF2LayerRegion sF2LayerRegion : sF2Layer.getRegions()) {
                Iterator<SF2Modulator> iterator;
                ModelIdentifier modelIdentifier;
                float f;
                short s;
                short s2;
                byte[] byArray;
                ModelPerformer modelPerformer = new ModelPerformer();
                if (sF2LayerRegion.getSample() != null) {
                    modelPerformer.setName(sF2LayerRegion.getSample().getName());
                } else {
                    modelPerformer.setName(sF2Layer.getName());
                }
                modelPerformerArray[n2++] = modelPerformer;
                byte by = 0;
                byte by2 = 127;
                byte by3 = 0;
                byte by4 = 127;
                if (sF2LayerRegion.contains(57)) {
                    modelPerformer.setExclusiveClass(sF2LayerRegion.getInteger(57));
                }
                if (sF2LayerRegion.contains(43)) {
                    byArray = sF2LayerRegion.getBytes(43);
                    if (byArray[0] >= 0 && byArray[0] > by) {
                        by = byArray[0];
                    }
                    if (byArray[1] >= 0 && byArray[1] < by2) {
                        by2 = byArray[1];
                    }
                }
                if (sF2LayerRegion.contains(44)) {
                    byArray = sF2LayerRegion.getBytes(44);
                    if (byArray[0] >= 0 && byArray[0] > by3) {
                        by3 = byArray[0];
                    }
                    if (byArray[1] >= 0 && byArray[1] < by4) {
                        by4 = byArray[1];
                    }
                }
                if (sF2InstrumentRegion.contains(43)) {
                    byArray = sF2InstrumentRegion.getBytes(43);
                    if (byArray[0] > by) {
                        by = byArray[0];
                    }
                    if (byArray[1] < by2) {
                        by2 = byArray[1];
                    }
                }
                if (sF2InstrumentRegion.contains(44)) {
                    byArray = sF2InstrumentRegion.getBytes(44);
                    if (byArray[0] > by3) {
                        by3 = byArray[0];
                    }
                    if (byArray[1] < by4) {
                        by4 = byArray[1];
                    }
                }
                modelPerformer.setKeyFrom(by);
                modelPerformer.setKeyTo(by2);
                modelPerformer.setVelFrom(by3);
                modelPerformer.setVelTo(by4);
                int n3 = sF2LayerRegion.getShort(0);
                int n4 = sF2LayerRegion.getShort(1);
                int n5 = sF2LayerRegion.getShort(2);
                int n6 = sF2LayerRegion.getShort(3);
                n4 += sF2LayerRegion.getShort(12) * 32768;
                n5 += sF2LayerRegion.getShort(45) * 32768;
                n6 += sF2LayerRegion.getShort(50) * 32768;
                n5 -= (n3 += sF2LayerRegion.getShort(4) * 32768);
                n6 -= n3;
                SF2Sample sF2Sample = sF2LayerRegion.getSample();
                int n7 = sF2Sample.originalPitch;
                if (sF2LayerRegion.getShort(58) != -1) {
                    n7 = sF2LayerRegion.getShort(58);
                }
                float f2 = -n7 * 100 + sF2Sample.pitchCorrection;
                ModelByteBuffer modelByteBuffer = sF2Sample.getDataBuffer();
                ModelByteBuffer modelByteBuffer2 = sF2Sample.getData24Buffer();
                if (n3 != 0 || n4 != 0) {
                    modelByteBuffer = modelByteBuffer.subbuffer(n3 * 2, modelByteBuffer.capacity() + (long)(n4 * 2));
                    if (modelByteBuffer2 != null) {
                        modelByteBuffer2 = modelByteBuffer2.subbuffer(n3, modelByteBuffer2.capacity() + (long)n4);
                    }
                }
                ModelByteBufferWavetable modelByteBufferWavetable = new ModelByteBufferWavetable(modelByteBuffer, sF2Sample.getFormat(), f2);
                if (modelByteBuffer2 != null) {
                    modelByteBufferWavetable.set8BitExtensionBuffer(modelByteBuffer2);
                }
                HashMap<Integer, Short> hashMap2 = new HashMap<Integer, Short>();
                if (sF2GlobalRegion2 != null) {
                    hashMap2.putAll(sF2GlobalRegion2.getGenerators());
                }
                hashMap2.putAll(sF2LayerRegion.getGenerators());
                for (Map.Entry entry : hashMap.entrySet()) {
                    s2 = !hashMap2.containsKey(entry.getKey()) ? sF2LayerRegion.getShort((Integer)entry.getKey()) : ((Short)hashMap2.get(entry.getKey())).shortValue();
                    s2 = (short)(s2 + (Short)entry.getValue());
                    hashMap2.put((Integer)entry.getKey(), s2);
                }
                short s3 = this.getGeneratorValue(hashMap2, 54);
                if ((s3 == 1 || s3 == 3) && sF2Sample.startLoop >= 0L && sF2Sample.endLoop > 0L) {
                    modelByteBufferWavetable.setLoopStart((int)(sF2Sample.startLoop + (long)n5));
                    modelByteBufferWavetable.setLoopLength((int)(sF2Sample.endLoop - sF2Sample.startLoop + (long)n6 - (long)n5));
                    if (s3 == 1) {
                        modelByteBufferWavetable.setLoopType(1);
                    }
                    if (s3 == 3) {
                        modelByteBufferWavetable.setLoopType(2);
                    }
                }
                modelPerformer.getOscillators().add(modelByteBufferWavetable);
                short s4 = this.getGeneratorValue(hashMap2, 33);
                s2 = this.getGeneratorValue(hashMap2, 34);
                short s5 = this.getGeneratorValue(hashMap2, 35);
                short s6 = this.getGeneratorValue(hashMap2, 36);
                short s7 = this.getGeneratorValue(hashMap2, 37);
                short s8 = this.getGeneratorValue(hashMap2, 38);
                if (s5 != -12000) {
                    s = this.getGeneratorValue(hashMap2, 39);
                    s5 = (short)(s5 + 60 * s);
                    f = -s * 128;
                    modelIdentifier = ModelSource.SOURCE_NOTEON_KEYNUMBER;
                    iterator = ModelDestination.DESTINATION_EG1_HOLD;
                    modelPerformer.getConnectionBlocks().add(new ModelConnectionBlock(new ModelSource(modelIdentifier), f, new ModelDestination((ModelIdentifier)((Object)iterator))));
                }
                if (s6 != -12000) {
                    s = this.getGeneratorValue(hashMap2, 40);
                    s6 = (short)(s6 + 60 * s);
                    f = -s * 128;
                    modelIdentifier = ModelSource.SOURCE_NOTEON_KEYNUMBER;
                    iterator = ModelDestination.DESTINATION_EG1_DECAY;
                    modelPerformer.getConnectionBlocks().add(new ModelConnectionBlock(new ModelSource(modelIdentifier), f, new ModelDestination((ModelIdentifier)((Object)iterator))));
                }
                this.addTimecentValue(modelPerformer, ModelDestination.DESTINATION_EG1_DELAY, s4);
                this.addTimecentValue(modelPerformer, ModelDestination.DESTINATION_EG1_ATTACK, s2);
                this.addTimecentValue(modelPerformer, ModelDestination.DESTINATION_EG1_HOLD, s5);
                this.addTimecentValue(modelPerformer, ModelDestination.DESTINATION_EG1_DECAY, s6);
                s7 = (short)(1000 - s7);
                if (s7 < 0) {
                    s7 = 0;
                }
                if (s7 > 1000) {
                    s7 = 1000;
                }
                this.addValue(modelPerformer, ModelDestination.DESTINATION_EG1_SUSTAIN, s7);
                this.addTimecentValue(modelPerformer, ModelDestination.DESTINATION_EG1_RELEASE, s8);
                if (this.getGeneratorValue(hashMap2, 11) != 0 || this.getGeneratorValue(hashMap2, 7) != 0) {
                    ModelIdentifier modelIdentifier2;
                    ModelIdentifier modelIdentifier3;
                    float f3;
                    short s9;
                    s = this.getGeneratorValue(hashMap2, 25);
                    short s10 = this.getGeneratorValue(hashMap2, 26);
                    short s11 = this.getGeneratorValue(hashMap2, 27);
                    short s12 = this.getGeneratorValue(hashMap2, 28);
                    int n8 = this.getGeneratorValue(hashMap2, 29);
                    short s13 = this.getGeneratorValue(hashMap2, 30);
                    if (s11 != -12000) {
                        s9 = this.getGeneratorValue(hashMap2, 31);
                        s11 = (short)(s11 + 60 * s9);
                        f3 = -s9 * 128;
                        modelIdentifier3 = ModelSource.SOURCE_NOTEON_KEYNUMBER;
                        modelIdentifier2 = ModelDestination.DESTINATION_EG2_HOLD;
                        modelPerformer.getConnectionBlocks().add(new ModelConnectionBlock(new ModelSource(modelIdentifier3), f3, new ModelDestination(modelIdentifier2)));
                    }
                    if (s12 != -12000) {
                        s9 = this.getGeneratorValue(hashMap2, 32);
                        s12 = (short)(s12 + 60 * s9);
                        f3 = -s9 * 128;
                        modelIdentifier3 = ModelSource.SOURCE_NOTEON_KEYNUMBER;
                        modelIdentifier2 = ModelDestination.DESTINATION_EG2_DECAY;
                        modelPerformer.getConnectionBlocks().add(new ModelConnectionBlock(new ModelSource(modelIdentifier3), f3, new ModelDestination(modelIdentifier2)));
                    }
                    this.addTimecentValue(modelPerformer, ModelDestination.DESTINATION_EG2_DELAY, s);
                    this.addTimecentValue(modelPerformer, ModelDestination.DESTINATION_EG2_ATTACK, s10);
                    this.addTimecentValue(modelPerformer, ModelDestination.DESTINATION_EG2_HOLD, s11);
                    this.addTimecentValue(modelPerformer, ModelDestination.DESTINATION_EG2_DECAY, s12);
                    if (n8 < 0) {
                        n8 = 0;
                    }
                    if (n8 > 1000) {
                        n8 = 1000;
                    }
                    this.addValue(modelPerformer, ModelDestination.DESTINATION_EG2_SUSTAIN, 1000 - n8);
                    this.addTimecentValue(modelPerformer, ModelDestination.DESTINATION_EG2_RELEASE, s13);
                    if (this.getGeneratorValue(hashMap2, 11) != 0) {
                        double d = this.getGeneratorValue(hashMap2, 11);
                        modelIdentifier3 = ModelSource.SOURCE_EG2;
                        modelIdentifier2 = ModelDestination.DESTINATION_FILTER_FREQ;
                        modelPerformer.getConnectionBlocks().add(new ModelConnectionBlock(new ModelSource(modelIdentifier3), d, new ModelDestination(modelIdentifier2)));
                    }
                    if (this.getGeneratorValue(hashMap2, 7) != 0) {
                        double d = this.getGeneratorValue(hashMap2, 7);
                        modelIdentifier3 = ModelSource.SOURCE_EG2;
                        modelIdentifier2 = ModelDestination.DESTINATION_PITCH;
                        modelPerformer.getConnectionBlocks().add(new ModelConnectionBlock(new ModelSource(modelIdentifier3), d, new ModelDestination(modelIdentifier2)));
                    }
                }
                if (this.getGeneratorValue(hashMap2, 10) != 0 || this.getGeneratorValue(hashMap2, 5) != 0 || this.getGeneratorValue(hashMap2, 13) != 0) {
                    s = this.getGeneratorValue(hashMap2, 22);
                    short s14 = this.getGeneratorValue(hashMap2, 21);
                    this.addTimecentValue(modelPerformer, ModelDestination.DESTINATION_LFO1_DELAY, s14);
                    this.addValue(modelPerformer, ModelDestination.DESTINATION_LFO1_FREQ, s);
                }
                s = this.getGeneratorValue(hashMap2, 24);
                short s15 = this.getGeneratorValue(hashMap2, 23);
                this.addTimecentValue(modelPerformer, ModelDestination.DESTINATION_LFO2_DELAY, s15);
                this.addValue(modelPerformer, ModelDestination.DESTINATION_LFO2_FREQ, s);
                if (this.getGeneratorValue(hashMap2, 6) != 0) {
                    double d = this.getGeneratorValue(hashMap2, 6);
                    ModelIdentifier modelIdentifier4 = ModelSource.SOURCE_LFO2;
                    ModelIdentifier modelIdentifier5 = ModelDestination.DESTINATION_PITCH;
                    modelPerformer.getConnectionBlocks().add(new ModelConnectionBlock(new ModelSource(modelIdentifier4, false, true), d, new ModelDestination(modelIdentifier5)));
                }
                if (this.getGeneratorValue(hashMap2, 10) != 0) {
                    double d = this.getGeneratorValue(hashMap2, 10);
                    ModelIdentifier modelIdentifier6 = ModelSource.SOURCE_LFO1;
                    ModelIdentifier modelIdentifier7 = ModelDestination.DESTINATION_FILTER_FREQ;
                    modelPerformer.getConnectionBlocks().add(new ModelConnectionBlock(new ModelSource(modelIdentifier6, false, true), d, new ModelDestination(modelIdentifier7)));
                }
                if (this.getGeneratorValue(hashMap2, 5) != 0) {
                    double d = this.getGeneratorValue(hashMap2, 5);
                    ModelIdentifier modelIdentifier8 = ModelSource.SOURCE_LFO1;
                    ModelIdentifier modelIdentifier9 = ModelDestination.DESTINATION_PITCH;
                    modelPerformer.getConnectionBlocks().add(new ModelConnectionBlock(new ModelSource(modelIdentifier8, false, true), d, new ModelDestination(modelIdentifier9)));
                }
                if (this.getGeneratorValue(hashMap2, 13) != 0) {
                    double d = this.getGeneratorValue(hashMap2, 13);
                    ModelIdentifier modelIdentifier10 = ModelSource.SOURCE_LFO1;
                    ModelIdentifier modelIdentifier11 = ModelDestination.DESTINATION_GAIN;
                    modelPerformer.getConnectionBlocks().add(new ModelConnectionBlock(new ModelSource(modelIdentifier10, false, true), d, new ModelDestination(modelIdentifier11)));
                }
                if (sF2LayerRegion.getShort(46) != -1) {
                    double d = (double)sF2LayerRegion.getShort(46) / 128.0;
                    this.addValue(modelPerformer, ModelDestination.DESTINATION_KEYNUMBER, d);
                }
                if (sF2LayerRegion.getShort(47) != -1) {
                    double d = (double)sF2LayerRegion.getShort(47) / 128.0;
                    this.addValue(modelPerformer, ModelDestination.DESTINATION_VELOCITY, d);
                }
                if (this.getGeneratorValue(hashMap2, 8) < 13500) {
                    short s16 = this.getGeneratorValue(hashMap2, 8);
                    short s17 = this.getGeneratorValue(hashMap2, 9);
                    this.addValue(modelPerformer, ModelDestination.DESTINATION_FILTER_FREQ, s16);
                    this.addValue(modelPerformer, ModelDestination.DESTINATION_FILTER_Q, s17);
                }
                int n9 = 100 * this.getGeneratorValue(hashMap2, 51);
                if ((n9 += this.getGeneratorValue(hashMap2, 52)) != 0) {
                    this.addValue(modelPerformer, ModelDestination.DESTINATION_PITCH, (short)n9);
                }
                if (this.getGeneratorValue(hashMap2, 17) != 0) {
                    short s18 = this.getGeneratorValue(hashMap2, 17);
                    this.addValue(modelPerformer, ModelDestination.DESTINATION_PAN, s18);
                }
                if (this.getGeneratorValue(hashMap2, 48) != 0) {
                    short s19 = this.getGeneratorValue(hashMap2, 48);
                    this.addValue(modelPerformer, ModelDestination.DESTINATION_GAIN, -0.376287f * (float)s19);
                }
                if (this.getGeneratorValue(hashMap2, 15) != 0) {
                    short s20 = this.getGeneratorValue(hashMap2, 15);
                    this.addValue(modelPerformer, ModelDestination.DESTINATION_CHORUS, s20);
                }
                if (this.getGeneratorValue(hashMap2, 16) != 0) {
                    short s21 = this.getGeneratorValue(hashMap2, 16);
                    this.addValue(modelPerformer, ModelDestination.DESTINATION_REVERB, s21);
                }
                if (this.getGeneratorValue(hashMap2, 56) != 100) {
                    ModelIdentifier modelIdentifier12;
                    short s22 = this.getGeneratorValue(hashMap2, 56);
                    if (s22 == 0) {
                        modelIdentifier12 = ModelDestination.DESTINATION_PITCH;
                        modelPerformer.getConnectionBlocks().add(new ModelConnectionBlock(null, n7 * 100, new ModelDestination(modelIdentifier12)));
                    } else {
                        modelIdentifier12 = ModelDestination.DESTINATION_PITCH;
                        modelPerformer.getConnectionBlocks().add(new ModelConnectionBlock(null, n7 * (100 - s22), new ModelDestination(modelIdentifier12)));
                    }
                    modelIdentifier12 = ModelSource.SOURCE_NOTEON_KEYNUMBER;
                    ModelIdentifier modelIdentifier13 = ModelDestination.DESTINATION_PITCH;
                    modelPerformer.getConnectionBlocks().add(new ModelConnectionBlock(new ModelSource(modelIdentifier12), 128 * s22, new ModelDestination(modelIdentifier13)));
                }
                modelPerformer.getConnectionBlocks().add(new ModelConnectionBlock(new ModelSource(ModelSource.SOURCE_NOTEON_VELOCITY, new ModelTransform(){

                    public double transform(double d) {
                        if (d < 0.5) {
                            return 1.0 - d * 2.0;
                        }
                        return 0.0;
                    }
                }), -2400.0, new ModelDestination(ModelDestination.DESTINATION_FILTER_FREQ)));
                modelPerformer.getConnectionBlocks().add(new ModelConnectionBlock(new ModelSource(ModelSource.SOURCE_LFO2, false, true, 0), new ModelSource(new ModelIdentifier("midi_cc", "1", 0), false, false, 0), 50.0, new ModelDestination(ModelDestination.DESTINATION_PITCH)));
                if (sF2Layer.getGlobalRegion() != null) {
                    for (SF2Modulator sF2Modulator : sF2Layer.getGlobalRegion().getModulators()) {
                        this.convertModulator(modelPerformer, sF2Modulator);
                    }
                }
                for (SF2Modulator sF2Modulator : sF2LayerRegion.getModulators()) {
                    this.convertModulator(modelPerformer, sF2Modulator);
                }
                if (sF2GlobalRegion != null) {
                    for (SF2Modulator sF2Modulator : sF2GlobalRegion.getModulators()) {
                        this.convertModulator(modelPerformer, sF2Modulator);
                    }
                }
                for (SF2Modulator sF2Modulator : sF2InstrumentRegion.getModulators()) {
                    this.convertModulator(modelPerformer, sF2Modulator);
                }
            }
        }
        return modelPerformerArray;
    }

    private void convertModulator(ModelPerformer modelPerformer, SF2Modulator sF2Modulator) {
        ModelSource modelSource = SF2Instrument.convertSource(sF2Modulator.getSourceOperator());
        ModelSource modelSource2 = SF2Instrument.convertSource(sF2Modulator.getAmountSourceOperator());
        if (modelSource == null && sF2Modulator.getSourceOperator() != 0) {
            return;
        }
        if (modelSource2 == null && sF2Modulator.getAmountSourceOperator() != 0) {
            return;
        }
        double d = sF2Modulator.getAmount();
        double[] dArray = new double[1];
        ModelSource[] modelSourceArray = new ModelSource[1];
        dArray[0] = 1.0;
        ModelDestination modelDestination = SF2Instrument.convertDestination(sF2Modulator.getDestinationOperator(), dArray, modelSourceArray);
        d *= dArray[0];
        if (modelDestination == null) {
            return;
        }
        if (sF2Modulator.getTransportOperator() == 2) {
            ((ModelStandardTransform)modelDestination.getTransform()).setTransform(4);
        }
        ModelConnectionBlock modelConnectionBlock = new ModelConnectionBlock(modelSource, modelSource2, d, modelDestination);
        if (modelSourceArray[0] != null) {
            modelConnectionBlock.addSource(modelSourceArray[0]);
        }
        modelPerformer.getConnectionBlocks().add(modelConnectionBlock);
    }

    private static ModelSource convertSource(int n) {
        if (n == 0) {
            return null;
        }
        ModelIdentifier modelIdentifier = null;
        int n2 = n & 0x7F;
        if ((n & 0x80) != 0) {
            modelIdentifier = new ModelIdentifier("midi_cc", Integer.toString(n2));
        } else {
            if (n2 == 2) {
                modelIdentifier = ModelSource.SOURCE_NOTEON_VELOCITY;
            }
            if (n2 == 3) {
                modelIdentifier = ModelSource.SOURCE_NOTEON_KEYNUMBER;
            }
            if (n2 == 10) {
                modelIdentifier = ModelSource.SOURCE_MIDI_POLY_PRESSURE;
            }
            if (n2 == 13) {
                modelIdentifier = ModelSource.SOURCE_MIDI_CHANNEL_PRESSURE;
            }
            if (n2 == 14) {
                modelIdentifier = ModelSource.SOURCE_MIDI_PITCH;
            }
            if (n2 == 16) {
                modelIdentifier = new ModelIdentifier("midi_rpn", "0");
            }
        }
        if (modelIdentifier == null) {
            return null;
        }
        ModelSource modelSource = new ModelSource(modelIdentifier);
        ModelStandardTransform modelStandardTransform = (ModelStandardTransform)modelSource.getTransform();
        if ((0x100 & n) != 0) {
            modelStandardTransform.setDirection(true);
        } else {
            modelStandardTransform.setDirection(false);
        }
        if ((0x200 & n) != 0) {
            modelStandardTransform.setPolarity(true);
        } else {
            modelStandardTransform.setPolarity(false);
        }
        if ((0x400 & n) != 0) {
            modelStandardTransform.setTransform(1);
        }
        if ((0x800 & n) != 0) {
            modelStandardTransform.setTransform(2);
        }
        if ((0xC00 & n) != 0) {
            modelStandardTransform.setTransform(3);
        }
        return modelSource;
    }

    static ModelDestination convertDestination(int n, double[] dArray, ModelSource[] modelSourceArray) {
        ModelIdentifier modelIdentifier = null;
        switch (n) {
            case 8: {
                modelIdentifier = ModelDestination.DESTINATION_FILTER_FREQ;
                break;
            }
            case 9: {
                modelIdentifier = ModelDestination.DESTINATION_FILTER_Q;
                break;
            }
            case 15: {
                modelIdentifier = ModelDestination.DESTINATION_CHORUS;
                break;
            }
            case 16: {
                modelIdentifier = ModelDestination.DESTINATION_REVERB;
                break;
            }
            case 17: {
                modelIdentifier = ModelDestination.DESTINATION_PAN;
                break;
            }
            case 21: {
                modelIdentifier = ModelDestination.DESTINATION_LFO1_DELAY;
                break;
            }
            case 22: {
                modelIdentifier = ModelDestination.DESTINATION_LFO1_FREQ;
                break;
            }
            case 23: {
                modelIdentifier = ModelDestination.DESTINATION_LFO2_DELAY;
                break;
            }
            case 24: {
                modelIdentifier = ModelDestination.DESTINATION_LFO2_FREQ;
                break;
            }
            case 25: {
                modelIdentifier = ModelDestination.DESTINATION_EG2_DELAY;
                break;
            }
            case 26: {
                modelIdentifier = ModelDestination.DESTINATION_EG2_ATTACK;
                break;
            }
            case 27: {
                modelIdentifier = ModelDestination.DESTINATION_EG2_HOLD;
                break;
            }
            case 28: {
                modelIdentifier = ModelDestination.DESTINATION_EG2_DECAY;
                break;
            }
            case 29: {
                modelIdentifier = ModelDestination.DESTINATION_EG2_SUSTAIN;
                dArray[0] = -1.0;
                break;
            }
            case 30: {
                modelIdentifier = ModelDestination.DESTINATION_EG2_RELEASE;
                break;
            }
            case 33: {
                modelIdentifier = ModelDestination.DESTINATION_EG1_DELAY;
                break;
            }
            case 34: {
                modelIdentifier = ModelDestination.DESTINATION_EG1_ATTACK;
                break;
            }
            case 35: {
                modelIdentifier = ModelDestination.DESTINATION_EG1_HOLD;
                break;
            }
            case 36: {
                modelIdentifier = ModelDestination.DESTINATION_EG1_DECAY;
                break;
            }
            case 37: {
                modelIdentifier = ModelDestination.DESTINATION_EG1_SUSTAIN;
                dArray[0] = -1.0;
                break;
            }
            case 38: {
                modelIdentifier = ModelDestination.DESTINATION_EG1_RELEASE;
                break;
            }
            case 46: {
                modelIdentifier = ModelDestination.DESTINATION_KEYNUMBER;
                break;
            }
            case 47: {
                modelIdentifier = ModelDestination.DESTINATION_VELOCITY;
                break;
            }
            case 51: {
                dArray[0] = 100.0;
                modelIdentifier = ModelDestination.DESTINATION_PITCH;
                break;
            }
            case 52: {
                modelIdentifier = ModelDestination.DESTINATION_PITCH;
                break;
            }
            case 48: {
                modelIdentifier = ModelDestination.DESTINATION_GAIN;
                dArray[0] = -0.376287f;
                break;
            }
            case 6: {
                modelIdentifier = ModelDestination.DESTINATION_PITCH;
                modelSourceArray[0] = new ModelSource(ModelSource.SOURCE_LFO2, false, true);
                break;
            }
            case 5: {
                modelIdentifier = ModelDestination.DESTINATION_PITCH;
                modelSourceArray[0] = new ModelSource(ModelSource.SOURCE_LFO1, false, true);
                break;
            }
            case 10: {
                modelIdentifier = ModelDestination.DESTINATION_FILTER_FREQ;
                modelSourceArray[0] = new ModelSource(ModelSource.SOURCE_LFO1, false, true);
                break;
            }
            case 13: {
                modelIdentifier = ModelDestination.DESTINATION_GAIN;
                dArray[0] = -0.376287f;
                modelSourceArray[0] = new ModelSource(ModelSource.SOURCE_LFO1, false, true);
                break;
            }
            case 7: {
                modelIdentifier = ModelDestination.DESTINATION_PITCH;
                modelSourceArray[0] = new ModelSource(ModelSource.SOURCE_EG2, false, true);
                break;
            }
            case 11: {
                modelIdentifier = ModelDestination.DESTINATION_FILTER_FREQ;
                modelSourceArray[0] = new ModelSource(ModelSource.SOURCE_EG2, false, true);
                break;
            }
        }
        if (modelIdentifier != null) {
            return new ModelDestination(modelIdentifier);
        }
        return null;
    }

    private void addTimecentValue(ModelPerformer modelPerformer, ModelIdentifier modelIdentifier, short s) {
        double d = s == -12000 ? Double.NEGATIVE_INFINITY : (double)s;
        modelPerformer.getConnectionBlocks().add(new ModelConnectionBlock(d, new ModelDestination(modelIdentifier)));
    }

    private void addValue(ModelPerformer modelPerformer, ModelIdentifier modelIdentifier, short s) {
        double d = s;
        modelPerformer.getConnectionBlocks().add(new ModelConnectionBlock(d, new ModelDestination(modelIdentifier)));
    }

    private void addValue(ModelPerformer modelPerformer, ModelIdentifier modelIdentifier, double d) {
        double d2 = d;
        modelPerformer.getConnectionBlocks().add(new ModelConnectionBlock(d2, new ModelDestination(modelIdentifier)));
    }

    private short getGeneratorValue(Map<Integer, Short> map, int n) {
        if (map.containsKey(n)) {
            return map.get(n);
        }
        return SF2Region.getDefaultValue(n);
    }
}

