/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AbstractLine;
import com.sun.media.sound.AbstractMixer;
import com.sun.media.sound.PortMixerProvider;
import java.util.Vector;
import javax.sound.sampled.BooleanControl;
import javax.sound.sampled.CompoundControl;
import javax.sound.sampled.Control;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Port;

final class PortMixer
extends AbstractMixer {
    private static final int SRC_UNKNOWN = 1;
    private static final int SRC_MICROPHONE = 2;
    private static final int SRC_LINE_IN = 3;
    private static final int SRC_COMPACT_DISC = 4;
    private static final int SRC_MASK = 255;
    private static final int DST_UNKNOWN = 256;
    private static final int DST_SPEAKER = 512;
    private static final int DST_HEADPHONE = 768;
    private static final int DST_LINE_OUT = 1024;
    private static final int DST_MASK = 65280;
    private Port.Info[] portInfos;
    private PortMixerPort[] ports;
    private long id = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PortMixer(PortMixerProvider.PortMixerInfo portMixerInfo) {
        super(portMixerInfo, null, null, null);
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        try {
            try {
                this.id = PortMixer.nOpen(this.getMixerIndex());
                if (this.id != 0L && (n2 = PortMixer.nGetPortCount(this.id)) < 0) {
                    n2 = 0;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.portInfos = new Port.Info[n2];
            for (n = 0; n < n2; ++n) {
                int n5 = PortMixer.nGetPortType(this.id, n);
                n3 += (n5 & 0xFF) != 0 ? 1 : 0;
                n4 += (n5 & 0xFF00) != 0 ? 1 : 0;
                this.portInfos[n] = this.getPortInfo(n, n5);
            }
        }
        finally {
            if (this.id != 0L) {
                PortMixer.nClose(this.id);
            }
            this.id = 0L;
        }
        this.sourceLineInfo = new Port.Info[n3];
        this.targetLineInfo = new Port.Info[n4];
        n3 = 0;
        n4 = 0;
        for (n = 0; n < n2; ++n) {
            if (this.portInfos[n].isSource()) {
                this.sourceLineInfo[n3++] = this.portInfos[n];
                continue;
            }
            this.targetLineInfo[n4++] = this.portInfos[n];
        }
    }

    public Line getLine(Line.Info info) throws LineUnavailableException {
        Line.Info info2 = this.getLineInfo(info);
        if (info2 != null && info2 instanceof Port.Info) {
            for (int i = 0; i < this.portInfos.length; ++i) {
                if (!info2.equals(this.portInfos[i])) continue;
                return this.getPort(i);
            }
        }
        throw new IllegalArgumentException("Line unsupported: " + info);
    }

    public int getMaxLines(Line.Info info) {
        Line.Info info2 = this.getLineInfo(info);
        if (info2 == null) {
            return 0;
        }
        if (info2 instanceof Port.Info) {
            return 1;
        }
        return 0;
    }

    protected void implOpen() throws LineUnavailableException {
        this.id = PortMixer.nOpen(this.getMixerIndex());
    }

    protected void implClose() {
        long l = this.id;
        this.id = 0L;
        PortMixer.nClose(l);
        if (this.ports != null) {
            for (int i = 0; i < this.ports.length; ++i) {
                if (this.ports[i] == null) continue;
                this.ports[i].disposeControls();
            }
        }
    }

    protected void implStart() {
    }

    protected void implStop() {
    }

    private Port.Info getPortInfo(int n, int n2) {
        switch (n2) {
            case 1: {
                return new PortInfo(PortMixer.nGetPortName(this.getID(), n), true);
            }
            case 2: {
                return Port.Info.MICROPHONE;
            }
            case 3: {
                return Port.Info.LINE_IN;
            }
            case 4: {
                return Port.Info.COMPACT_DISC;
            }
            case 256: {
                return new PortInfo(PortMixer.nGetPortName(this.getID(), n), false);
            }
            case 512: {
                return Port.Info.SPEAKER;
            }
            case 768: {
                return Port.Info.HEADPHONE;
            }
            case 1024: {
                return Port.Info.LINE_OUT;
            }
        }
        return null;
    }

    int getMixerIndex() {
        return ((PortMixerProvider.PortMixerInfo)this.getMixerInfo()).getIndex();
    }

    Port getPort(int n) {
        if (this.ports == null) {
            this.ports = new PortMixerPort[this.portInfos.length];
        }
        if (this.ports[n] == null) {
            this.ports[n] = new PortMixerPort(this.portInfos[n], this, n);
            return this.ports[n];
        }
        return this.ports[n];
    }

    long getID() {
        return this.id;
    }

    private static native long nOpen(int var0) throws LineUnavailableException;

    private static native void nClose(long var0);

    private static native int nGetPortCount(long var0);

    private static native int nGetPortType(long var0, int var2);

    private static native String nGetPortName(long var0, int var2);

    private static native void nGetControls(long var0, int var2, Vector var3);

    private static native void nControlSetIntValue(long var0, int var2);

    private static native int nControlGetIntValue(long var0);

    private static native void nControlSetFloatValue(long var0, float var2);

    private static native float nControlGetFloatValue(long var0);

    private static final class PortInfo
    extends Port.Info {
        private PortInfo(String string, boolean bl) {
            super(Port.class, string, bl);
        }
    }

    private static final class FloatCtrl
    extends FloatControl {
        private final long controlID;
        private boolean closed = false;
        private static final FloatControl.Type[] FLOAT_CONTROL_TYPES = new FloatControl.Type[]{null, FloatControl.Type.BALANCE, FloatControl.Type.MASTER_GAIN, FloatControl.Type.PAN, FloatControl.Type.VOLUME};

        private FloatCtrl(long l, String string, float f, float f2, float f3, String string2) {
            this(l, new FCT(string), f, f2, f3, string2);
        }

        private FloatCtrl(long l, int n, float f, float f2, float f3, String string) {
            this(l, FLOAT_CONTROL_TYPES[n], f, f2, f3, string);
        }

        private FloatCtrl(long l, FloatControl.Type type, float f, float f2, float f3, String string) {
            super(type, f, f2, f3, 1000, f, string);
            this.controlID = l;
        }

        public void setValue(float f) {
            if (!this.closed) {
                PortMixer.nControlSetFloatValue(this.controlID, f);
            }
        }

        public float getValue() {
            if (!this.closed) {
                return PortMixer.nControlGetFloatValue(this.controlID);
            }
            return this.getMinimum();
        }

        private static final class FCT
        extends FloatControl.Type {
            private FCT(String string) {
                super(string);
            }
        }
    }

    private static final class CompCtrl
    extends CompoundControl {
        private CompCtrl(String string, Control[] controlArray) {
            super(new CCT(string), controlArray);
        }

        private static final class CCT
        extends CompoundControl.Type {
            private CCT(String string) {
                super(string);
            }
        }
    }

    private static final class BoolCtrl
    extends BooleanControl {
        private final long controlID;
        private boolean closed = false;

        private static BooleanControl.Type createType(String string) {
            if (string.equals("Mute")) {
                return BooleanControl.Type.MUTE;
            }
            if (string.equals("Select")) {
                // empty if block
            }
            return new BCT(string);
        }

        private BoolCtrl(long l, String string) {
            this(l, BoolCtrl.createType(string));
        }

        private BoolCtrl(long l, BooleanControl.Type type) {
            super(type, false);
            this.controlID = l;
        }

        public void setValue(boolean bl) {
            if (!this.closed) {
                PortMixer.nControlSetIntValue(this.controlID, bl ? 1 : 0);
            }
        }

        public boolean getValue() {
            if (!this.closed) {
                return PortMixer.nControlGetIntValue(this.controlID) != 0;
            }
            return false;
        }

        private static final class BCT
        extends BooleanControl.Type {
            private BCT(String string) {
                super(string);
            }
        }
    }

    private static final class PortMixerPort
    extends AbstractLine
    implements Port {
        private final int portIndex;
        private long id;

        private PortMixerPort(Port.Info info, PortMixer portMixer, int n) {
            super(info, portMixer, null);
            this.portIndex = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void implOpen() throws LineUnavailableException {
            long l = ((PortMixer)this.mixer).getID();
            if (this.id == 0L || l != this.id || this.controls.length == 0) {
                Vector vector;
                this.id = l;
                Vector vector2 = vector = new Vector();
                synchronized (vector2) {
                    PortMixer.nGetControls(this.id, this.portIndex, vector);
                    this.controls = new Control[vector.size()];
                    for (int i = 0; i < this.controls.length; ++i) {
                        this.controls[i] = (Control)vector.elementAt(i);
                    }
                }
            } else {
                this.enableControls(this.controls, true);
            }
        }

        private void enableControls(Control[] controlArray, boolean bl) {
            for (int i = 0; i < controlArray.length; ++i) {
                if (controlArray[i] instanceof BoolCtrl) {
                    ((BoolCtrl)controlArray[i]).closed = !bl;
                    continue;
                }
                if (controlArray[i] instanceof FloatCtrl) {
                    ((FloatCtrl)controlArray[i]).closed = !bl;
                    continue;
                }
                if (!(controlArray[i] instanceof CompoundControl)) continue;
                this.enableControls(((CompoundControl)controlArray[i]).getMemberControls(), bl);
            }
        }

        private void disposeControls() {
            this.enableControls(this.controls, false);
            this.controls = new Control[0];
        }

        void implClose() {
            this.enableControls(this.controls, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void open() throws LineUnavailableException {
            AbstractMixer abstractMixer = this.mixer;
            synchronized (abstractMixer) {
                if (!this.isOpen()) {
                    this.mixer.open(this);
                    try {
                        this.implOpen();
                        this.setOpen(true);
                    }
                    catch (LineUnavailableException lineUnavailableException) {
                        this.mixer.close(this);
                        throw lineUnavailableException;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            AbstractMixer abstractMixer = this.mixer;
            synchronized (abstractMixer) {
                if (this.isOpen()) {
                    this.setOpen(false);
                    this.implClose();
                    this.mixer.close(this);
                }
            }
        }
    }
}

