/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss.wrapper;

import java.io.IOException;
import java.security.Provider;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import sun.security.jgss.GSSExceptionImpl;
import sun.security.jgss.GSSUtil;
import sun.security.jgss.spi.GSSNameSpi;
import sun.security.jgss.wrapper.GSSLibStub;
import sun.security.jgss.wrapper.SunNativeProvider;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.ObjectIdentifier;

public class GSSNameElement
implements GSSNameSpi {
    long pName = 0L;
    private String printableName;
    private Oid printableType;
    private GSSLibStub cStub;
    static final GSSNameElement DEF_ACCEPTOR = new GSSNameElement();

    private static Oid getNativeNameType(Oid oid, GSSLibStub gSSLibStub) {
        if (GSSUtil.NT_GSS_KRB5_PRINCIPAL.equals(oid) || GSSName.NT_HOSTBASED_SERVICE.equals(oid)) {
            Oid[] oidArray = null;
            try {
                oidArray = gSSLibStub.inquireNamesForMech();
            }
            catch (GSSException gSSException) {
                if (gSSException.getMajor() == 2 && GSSUtil.isSpNegoMech(gSSLibStub.getMech())) {
                    try {
                        gSSLibStub = GSSLibStub.getInstance(GSSUtil.GSS_KRB5_MECH_OID);
                        oidArray = gSSLibStub.inquireNamesForMech();
                    }
                    catch (GSSException gSSException2) {
                        SunNativeProvider.debug("Name type list unavailable: " + gSSException2.getMajorString());
                    }
                }
                SunNativeProvider.debug("Name type list unavailable: " + gSSException.getMajorString());
            }
            if (oidArray != null) {
                for (int i = 0; i < oidArray.length; ++i) {
                    if (!oidArray[i].equals(oid)) continue;
                    return oid;
                }
                if (GSSUtil.NT_GSS_KRB5_PRINCIPAL.equals(oid)) {
                    SunNativeProvider.debug("Override " + oid + " with mechanism default(null)");
                    return null;
                }
                SunNativeProvider.debug("Override " + oid + " with " + GSSUtil.NT_HOSTBASED_SERVICE2);
                return GSSUtil.NT_HOSTBASED_SERVICE2;
            }
        }
        return oid;
    }

    private GSSNameElement() {
        this.printableName = "<DEFAULT ACCEPTOR>";
    }

    GSSNameElement(long l, GSSLibStub gSSLibStub) throws GSSException {
        assert (gSSLibStub != null);
        if (l == 0L) {
            throw new GSSException(3);
        }
        this.pName = l;
        this.cStub = gSSLibStub;
        this.setPrintables();
    }

    GSSNameElement(byte[] byArray, Oid oid, GSSLibStub gSSLibStub) throws GSSException {
        assert (gSSLibStub != null);
        if (byArray == null) {
            throw new GSSException(3);
        }
        this.cStub = gSSLibStub;
        byte[] byArray2 = byArray;
        if (oid != null && GSSName.NT_EXPORT_NAME.equals(oid = GSSNameElement.getNativeNameType(oid, gSSLibStub))) {
            byte[] byArray3 = null;
            DerOutputStream derOutputStream = new DerOutputStream();
            Oid oid2 = this.cStub.getMech();
            try {
                derOutputStream.putOID(new ObjectIdentifier(oid2.toString()));
            }
            catch (IOException iOException) {
                throw new GSSExceptionImpl(11, iOException);
            }
            byArray3 = derOutputStream.toByteArray();
            byArray2 = new byte[4 + byArray3.length + 4 + byArray.length];
            int n = 0;
            byArray2[n++] = 4;
            byArray2[n++] = 1;
            byArray2[n++] = (byte)(byArray3.length >>> 8);
            byArray2[n++] = (byte)byArray3.length;
            System.arraycopy(byArray3, 0, byArray2, n, byArray3.length);
            n += byArray3.length;
            byArray2[n++] = (byte)(byArray.length >>> 24);
            byArray2[n++] = (byte)(byArray.length >>> 16);
            byArray2[n++] = (byte)(byArray.length >>> 8);
            byArray2[n++] = (byte)byArray.length;
            System.arraycopy(byArray, 0, byArray2, n, byArray.length);
        }
        this.pName = this.cStub.importName(byArray2, oid);
        this.setPrintables();
        SunNativeProvider.debug("Imported " + this.printableName + " w/ type " + this.printableType);
    }

    private void setPrintables() throws GSSException {
        Object[] objectArray = null;
        objectArray = this.cStub.displayName(this.pName);
        assert (objectArray != null && objectArray.length == 2);
        this.printableName = (String)objectArray[0];
        assert (this.printableName != null);
        this.printableType = (Oid)objectArray[1];
        if (this.printableType == null) {
            this.printableType = GSSName.NT_USER_NAME;
        }
    }

    public String getKrbName() throws GSSException {
        long l = 0L;
        GSSLibStub gSSLibStub = this.cStub;
        if (!GSSUtil.isKerberosMech(this.cStub.getMech())) {
            gSSLibStub = GSSLibStub.getInstance(GSSUtil.GSS_KRB5_MECH_OID);
        }
        l = gSSLibStub.canonicalizeName(this.pName);
        Object[] objectArray = gSSLibStub.displayName(l);
        gSSLibStub.releaseName(l);
        SunNativeProvider.debug("Got kerberized name: " + objectArray[0]);
        return (String)objectArray[0];
    }

    public Provider getProvider() {
        return SunNativeProvider.INSTANCE;
    }

    public boolean equals(GSSNameSpi gSSNameSpi) throws GSSException {
        if (!(gSSNameSpi instanceof GSSNameElement)) {
            return false;
        }
        return this.cStub.compareName(this.pName, ((GSSNameElement)gSSNameSpi).pName);
    }

    public boolean equals(Object object) {
        if (!(object instanceof GSSNameElement)) {
            return false;
        }
        try {
            return this.equals((GSSNameElement)object);
        }
        catch (GSSException gSSException) {
            return false;
        }
    }

    public int hashCode() {
        return new Long(this.pName).hashCode();
    }

    public byte[] export() throws GSSException {
        int n;
        Object object;
        byte[] byArray = this.cStub.exportName(this.pName);
        int n2 = 0;
        if (byArray[n2++] != 4 || byArray[n2++] != 1) {
            throw new GSSException(3);
        }
        int n3 = (0xFF & byArray[n2++]) << 8 | 0xFF & byArray[n2++];
        ObjectIdentifier objectIdentifier = null;
        try {
            object = new DerInputStream(byArray, n2, n3);
            objectIdentifier = new ObjectIdentifier((DerInputStream)object);
        }
        catch (IOException iOException) {
            throw new GSSExceptionImpl(3, iOException);
        }
        object = new Oid(objectIdentifier.toString());
        assert (((Oid)object).equals(this.getMechanism()));
        n2 += n3;
        if ((n = (0xFF & byArray[n2++]) << 24 | (0xFF & byArray[n2++]) << 16 | (0xFF & byArray[n2++]) << 8 | 0xFF & byArray[n2++]) < 0) {
            throw new GSSException(3);
        }
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, n2, byArray2, 0, n);
        return byArray2;
    }

    public Oid getMechanism() {
        return this.cStub.getMech();
    }

    public String toString() {
        return this.printableName;
    }

    public Oid getStringNameType() {
        return this.printableType;
    }

    public boolean isAnonymousName() {
        return GSSName.NT_ANONYMOUS.equals(this.printableType);
    }

    public void dispose() {
        if (this.pName != 0L) {
            this.cStub.releaseName(this.pName);
            this.pName = 0L;
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
    }
}

