/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.http;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import sun.misc.BASE64Decoder;
import sun.net.www.HeaderParser;
import sun.net.www.protocol.http.AuthScheme;
import sun.net.www.protocol.http.AuthenticationInfo;
import sun.net.www.protocol.http.B64Encoder;
import sun.net.www.protocol.http.HttpURLConnection;
import sun.security.action.GetPropertyAction;
import sun.security.provider.MD4;

class NTLMAuthentication
extends AuthenticationInfo {
    private byte[] type1;
    private byte[] type3;
    private SecretKeyFactory fac;
    private Cipher cipher;
    private MessageDigest md4;
    private String hostname;
    private static String defaultDomain = AccessController.doPrivileged(new GetPropertyAction("http.auth.ntlm.domain", "domain"));
    PasswordAuthentication pw;
    String username;
    String ntdomain;
    String password;

    static boolean supportsTransparentAuth() {
        return false;
    }

    private void init0() {
        block5: {
            this.type1 = new byte[256];
            this.type3 = new byte[256];
            System.arraycopy(new byte[]{78, 84, 76, 77, 83, 83, 80, 0, 1}, 0, this.type1, 0, 9);
            this.type1[12] = 3;
            this.type1[13] = -78;
            this.type1[28] = 32;
            System.arraycopy(new byte[]{78, 84, 76, 77, 83, 83, 80, 0, 3}, 0, this.type3, 0, 9);
            this.type3[12] = 24;
            this.type3[14] = 24;
            this.type3[20] = 24;
            this.type3[22] = 24;
            this.type3[32] = 64;
            this.type3[60] = 1;
            this.type3[61] = -126;
            try {
                this.hostname = AccessController.doPrivileged(new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        String string;
                        try {
                            string = InetAddress.getLocalHost().getHostName().toUpperCase();
                        }
                        catch (UnknownHostException unknownHostException) {
                            string = "localhost";
                        }
                        return string;
                    }
                });
                int n = this.hostname.indexOf(46);
                if (n != -1) {
                    this.hostname = this.hostname.substring(0, n);
                }
                this.fac = SecretKeyFactory.getInstance("DES");
                this.cipher = Cipher.getInstance("DES/ECB/NoPadding");
                this.md4 = MD4.getInstance();
            }
            catch (NoSuchPaddingException noSuchPaddingException) {
                assert (false);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                if ($assertionsDisabled) break block5;
                throw new AssertionError();
            }
        }
    }

    public NTLMAuthentication(boolean bl, URL uRL, PasswordAuthentication passwordAuthentication) {
        super(bl ? (char)'p' : 's', AuthScheme.NTLM, uRL, "");
        this.init(passwordAuthentication);
    }

    private void init(PasswordAuthentication passwordAuthentication) {
        this.pw = passwordAuthentication;
        String string = passwordAuthentication.getUserName();
        int n = string.indexOf(92);
        if (n == -1) {
            this.username = string;
            this.ntdomain = defaultDomain;
        } else {
            this.ntdomain = string.substring(0, n).toUpperCase();
            this.username = string.substring(n + 1);
        }
        this.password = new String(passwordAuthentication.getPassword());
        this.init0();
    }

    public NTLMAuthentication(boolean bl, String string, int n, PasswordAuthentication passwordAuthentication) {
        super(bl ? (char)'p' : 's', AuthScheme.NTLM, string, n, "");
        this.init(passwordAuthentication);
    }

    boolean supportsPreemptiveAuthorization() {
        return false;
    }

    String getHeaderName() {
        if (this.type == 's') {
            return "Authorization";
        }
        return "Proxy-authorization";
    }

    String getHeaderValue(URL uRL, String string) {
        throw new RuntimeException("getHeaderValue not supported");
    }

    boolean isAuthorizationStale(String string) {
        return false;
    }

    synchronized boolean setHeaders(HttpURLConnection httpURLConnection, HeaderParser headerParser, String string) {
        try {
            String string2;
            if (string.length() < 6) {
                string2 = this.buildType1Msg();
            } else {
                String string3 = string.substring(5);
                string2 = this.buildType3Msg(string3);
            }
            httpURLConnection.setAuthenticationProperty(this.getHeaderName(), string2);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
        catch (GeneralSecurityException generalSecurityException) {
            return false;
        }
    }

    public void checkResponse(String string, String string2, URL uRL) throws IOException {
    }

    private void copybytes(byte[] byArray, int n, String string, String string2) {
        block2: {
            try {
                byte[] byArray2 = string.getBytes(string2);
                System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    private String buildType1Msg() {
        int n = this.ntdomain.length();
        this.type1[16] = (byte)(n % 256);
        this.type1[17] = (byte)(n / 256);
        this.type1[18] = this.type1[16];
        this.type1[19] = this.type1[17];
        int n2 = this.hostname.length();
        this.type1[24] = (byte)(n2 % 256);
        this.type1[25] = (byte)(n2 / 256);
        this.type1[26] = this.type1[24];
        this.type1[27] = this.type1[25];
        this.copybytes(this.type1, 32, this.hostname, "ISO8859_1");
        this.copybytes(this.type1, n2 + 32, this.ntdomain, "ISO8859_1");
        this.type1[20] = (byte)((n2 + 32) % 256);
        this.type1[21] = (byte)((n2 + 32) / 256);
        byte[] byArray = new byte[32 + n2 + n];
        System.arraycopy(this.type1, 0, byArray, 0, 32 + n2 + n);
        String string = "NTLM " + new B64Encoder().encode(byArray);
        return string;
    }

    private byte[] makeDesKey(byte[] byArray, int n) {
        int[] nArray = new int[byArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = byArray[i] < 0 ? byArray[i] + 256 : byArray[i];
        }
        byte[] byArray2 = new byte[]{(byte)nArray[n + 0], (byte)(nArray[n + 0] << 7 & 0xFF | nArray[n + 1] >> 1), (byte)(nArray[n + 1] << 6 & 0xFF | nArray[n + 2] >> 2), (byte)(nArray[n + 2] << 5 & 0xFF | nArray[n + 3] >> 3), (byte)(nArray[n + 3] << 4 & 0xFF | nArray[n + 4] >> 4), (byte)(nArray[n + 4] << 3 & 0xFF | nArray[n + 5] >> 5), (byte)(nArray[n + 5] << 2 & 0xFF | nArray[n + 6] >> 6), (byte)(nArray[n + 6] << 1 & 0xFF)};
        return byArray2;
    }

    private byte[] calcLMHash() throws GeneralSecurityException {
        byte[] byArray = new byte[]{75, 71, 83, 33, 64, 35, 36, 37};
        byte[] byArray2 = this.password.toUpperCase().getBytes();
        byte[] byArray3 = new byte[14];
        int n = this.password.length();
        if (n > 14) {
            n = 14;
        }
        System.arraycopy(byArray2, 0, byArray3, 0, n);
        DESKeySpec dESKeySpec = new DESKeySpec(this.makeDesKey(byArray3, 0));
        DESKeySpec dESKeySpec2 = new DESKeySpec(this.makeDesKey(byArray3, 7));
        SecretKey secretKey = this.fac.generateSecret(dESKeySpec);
        SecretKey secretKey2 = this.fac.generateSecret(dESKeySpec2);
        this.cipher.init(1, secretKey);
        byte[] byArray4 = this.cipher.doFinal(byArray, 0, 8);
        this.cipher.init(1, secretKey2);
        byte[] byArray5 = this.cipher.doFinal(byArray, 0, 8);
        byte[] byArray6 = new byte[21];
        System.arraycopy(byArray4, 0, byArray6, 0, 8);
        System.arraycopy(byArray5, 0, byArray6, 8, 8);
        return byArray6;
    }

    private byte[] calcNTHash() throws GeneralSecurityException {
        byte[] byArray;
        block2: {
            byArray = null;
            try {
                byArray = this.password.getBytes("UnicodeLittleUnmarked");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        byte[] byArray2 = this.md4.digest(byArray);
        byte[] byArray3 = new byte[21];
        System.arraycopy(byArray2, 0, byArray3, 0, 16);
        return byArray3;
    }

    private byte[] calcResponse(byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        assert (byArray.length == 21);
        DESKeySpec dESKeySpec = new DESKeySpec(this.makeDesKey(byArray, 0));
        DESKeySpec dESKeySpec2 = new DESKeySpec(this.makeDesKey(byArray, 7));
        DESKeySpec dESKeySpec3 = new DESKeySpec(this.makeDesKey(byArray, 14));
        SecretKey secretKey = this.fac.generateSecret(dESKeySpec);
        SecretKey secretKey2 = this.fac.generateSecret(dESKeySpec2);
        SecretKey secretKey3 = this.fac.generateSecret(dESKeySpec3);
        this.cipher.init(1, secretKey);
        byte[] byArray3 = this.cipher.doFinal(byArray2, 0, 8);
        this.cipher.init(1, secretKey2);
        byte[] byArray4 = this.cipher.doFinal(byArray2, 0, 8);
        this.cipher.init(1, secretKey3);
        byte[] byArray5 = this.cipher.doFinal(byArray2, 0, 8);
        byte[] byArray6 = new byte[24];
        System.arraycopy(byArray3, 0, byArray6, 0, 8);
        System.arraycopy(byArray4, 0, byArray6, 8, 8);
        System.arraycopy(byArray5, 0, byArray6, 16, 8);
        return byArray6;
    }

    private String buildType3Msg(String string) throws GeneralSecurityException, IOException {
        byte[] byArray = new BASE64Decoder().decodeBuffer(string);
        byte[] byArray2 = new byte[8];
        System.arraycopy(byArray, 24, byArray2, 0, 8);
        int n = this.username.length() * 2;
        this.type3[36] = this.type3[38] = (byte)(n % 256);
        this.type3[37] = this.type3[39] = (byte)(n / 256);
        int n2 = this.ntdomain.length() * 2;
        this.type3[28] = this.type3[30] = (byte)(n2 % 256);
        this.type3[29] = this.type3[31] = (byte)(n2 / 256);
        int n3 = this.hostname.length() * 2;
        this.type3[44] = this.type3[46] = (byte)(n3 % 256);
        this.type3[45] = this.type3[47] = (byte)(n3 / 256);
        int n4 = 64;
        this.copybytes(this.type3, n4, this.ntdomain, "UnicodeLittleUnmarked");
        this.type3[32] = (byte)(n4 % 256);
        this.type3[33] = (byte)(n4 / 256);
        this.copybytes(this.type3, n4 += n2, this.username, "UnicodeLittleUnmarked");
        this.type3[40] = (byte)(n4 % 256);
        this.type3[41] = (byte)(n4 / 256);
        this.copybytes(this.type3, n4 += n, this.hostname, "UnicodeLittleUnmarked");
        this.type3[48] = (byte)(n4 % 256);
        this.type3[49] = (byte)(n4 / 256);
        byte[] byArray3 = this.calcLMHash();
        byte[] byArray4 = this.calcResponse(byArray3, byArray2);
        byte[] byArray5 = this.calcNTHash();
        byte[] byArray6 = this.calcResponse(byArray5, byArray2);
        System.arraycopy(byArray4, 0, this.type3, n4 += n3, 24);
        this.type3[16] = (byte)(n4 % 256);
        this.type3[17] = (byte)(n4 / 256);
        System.arraycopy(byArray6, 0, this.type3, n4 += 24, 24);
        this.type3[24] = (byte)(n4 % 256);
        this.type3[25] = (byte)(n4 / 256);
        this.type3[56] = (byte)((n4 += 24) % 256);
        this.type3[57] = (byte)(n4 / 256);
        byte[] byArray7 = new byte[n4];
        System.arraycopy(this.type3, 0, byArray7, 0, n4);
        String string2 = "NTLM " + new B64Encoder().encode(byArray7);
        return string2;
    }
}

