/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.http;

import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.net.Authenticator;
import java.net.CacheRequest;
import java.net.CacheResponse;
import java.net.CookieHandler;
import java.net.HttpRetryException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.ResponseCache;
import java.net.SecureCacheResponse;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import sun.net.ApplicationProxy;
import sun.net.ProgressMonitor;
import sun.net.ProgressSource;
import sun.net.www.HeaderParser;
import sun.net.www.MessageHeader;
import sun.net.www.MeteredStream;
import sun.net.www.ParseUtil;
import sun.net.www.http.ChunkedInputStream;
import sun.net.www.http.ChunkedOutputStream;
import sun.net.www.http.HttpCapture;
import sun.net.www.http.HttpClient;
import sun.net.www.http.PosterOutputStream;
import sun.net.www.protocol.http.AuthScheme;
import sun.net.www.protocol.http.AuthenticationHeader;
import sun.net.www.protocol.http.AuthenticationInfo;
import sun.net.www.protocol.http.BasicAuthentication;
import sun.net.www.protocol.http.DigestAuthentication;
import sun.net.www.protocol.http.EmptyInputStream;
import sun.net.www.protocol.http.Handler;
import sun.net.www.protocol.http.HttpAuthenticator;
import sun.net.www.protocol.http.HttpCallerInfo;
import sun.net.www.protocol.http.NTLMAuthenticationProxy;
import sun.net.www.protocol.http.NegotiateAuthentication;
import sun.security.action.GetBooleanAction;
import sun.security.action.GetIntegerAction;
import sun.security.action.GetPropertyAction;

public class HttpURLConnection
extends java.net.HttpURLConnection {
    static final String version;
    public static final String userAgent;
    static final int defaultmaxRedirects = 20;
    static final int maxRedirects;
    static final boolean validateProxy;
    static final boolean validateServer;
    private StreamingOutputStream strOutputStream;
    private static final String RETRY_MSG1 = "cannot retry due to proxy authentication, in streaming mode";
    private static final String RETRY_MSG2 = "cannot retry due to server authentication, in streaming mode";
    private static final String RETRY_MSG3 = "cannot retry due to redirection, in streaming mode";
    private static boolean enableESBuffer;
    private static int timeout4ESBuffer;
    private static int bufSize4ES;
    private static final boolean allowRestrictedHeaders;
    private static final Set<String> restrictedHeaderSet;
    private static final String[] restrictedHeaders;
    static final String httpVersion = "HTTP/1.1";
    static final String acceptString = "text/html, image/gif, image/jpeg, *; q=.2, */*; q=.2";
    private static final String[] EXCLUDE_HEADERS;
    private static final String[] EXCLUDE_HEADERS2;
    protected HttpClient http;
    protected Handler handler;
    protected Proxy instProxy;
    private CookieHandler cookieHandler;
    private ResponseCache cacheHandler;
    protected CacheResponse cachedResponse;
    private MessageHeader cachedHeaders;
    private InputStream cachedInputStream;
    protected PrintStream ps = null;
    private InputStream errorStream = null;
    private boolean setUserCookies = true;
    private String userCookies = null;
    private String userCookies2 = null;
    private static HttpAuthenticator defaultAuth;
    private MessageHeader requests;
    String domain;
    DigestAuthentication.Parameters digestparams;
    AuthenticationInfo currentProxyCredentials = null;
    AuthenticationInfo currentServerCredentials = null;
    boolean needToCheck = true;
    private boolean doingNTLM2ndStage = false;
    private boolean doingNTLMp2ndStage = false;
    private boolean tryTransparentNTLMServer = true;
    private boolean tryTransparentNTLMProxy = true;
    private boolean useProxyResponseCode = false;
    Object authObj;
    boolean isUserServerAuth;
    boolean isUserProxyAuth;
    protected ProgressSource pi;
    private MessageHeader responses;
    private InputStream inputStream = null;
    private PosterOutputStream poster = null;
    private boolean setRequests = false;
    private boolean failedOnce = false;
    private Exception rememberedException = null;
    private HttpClient reuseClient = null;
    private int connectTimeout = -1;
    private int readTimeout = -1;
    byte[] cdata = new byte[128];

    private static PasswordAuthentication privilegedRequestPasswordAuthentication(final String string, final InetAddress inetAddress, final int n, final String string2, final String string3, final String string4, final URL uRL, final Authenticator.RequestorType requestorType) {
        return AccessController.doPrivileged(new PrivilegedAction<PasswordAuthentication>(){

            @Override
            public PasswordAuthentication run() {
                if (HttpCapture.isLoggable("FINEST")) {
                    HttpCapture.finest("Requesting Authentication: host =" + string + " url = " + uRL);
                }
                PasswordAuthentication passwordAuthentication = Authenticator.requestPasswordAuthentication(string, inetAddress, n, string2, string3, string4, uRL, requestorType);
                if (HttpCapture.isLoggable("FINEST")) {
                    HttpCapture.finest("Authentication returned: " + (passwordAuthentication != null ? passwordAuthentication.toString() : "null"));
                }
                return passwordAuthentication;
            }
        });
    }

    private boolean isRestrictedHeader(String string, String string2) {
        if (allowRestrictedHeaders) {
            return false;
        }
        if (restrictedHeaderSet.contains(string = string.toLowerCase())) {
            return !string.equals("connection") || !string2.equalsIgnoreCase("close");
        }
        return string.startsWith("sec-");
    }

    private boolean isExternalMessageHeaderAllowed(String string, String string2) {
        this.checkMessageHeader(string, string2);
        return !this.isRestrictedHeader(string, string2);
    }

    private void checkMessageHeader(String string, String string2) {
        int n = 10;
        int n2 = string.indexOf(n);
        if (n2 != -1) {
            throw new IllegalArgumentException("Illegal character(s) in message header field: " + string);
        }
        if (string2 == null) {
            return;
        }
        n2 = string2.indexOf(n);
        while (n2 != -1) {
            char c;
            if (++n2 < string2.length() && ((c = string2.charAt(n2)) == ' ' || c == '\t')) {
                n2 = string2.indexOf(n, n2);
                continue;
            }
            throw new IllegalArgumentException("Illegal character(s) in message header value: " + string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeRequests() throws IOException {
        if (this.http.usingProxy) {
            this.setPreemptiveProxyAuthentication(this.requests);
        }
        if (!this.setRequests) {
            Cloneable cloneable;
            if (!this.failedOnce) {
                this.requests.prepend(this.method + " " + this.http.getURLFile() + " " + httpVersion, null);
            }
            if (!this.getUseCaches()) {
                this.requests.setIfNotSet("Cache-Control", "no-cache");
                this.requests.setIfNotSet("Pragma", "no-cache");
            }
            this.requests.setIfNotSet("User-Agent", userAgent);
            int n = this.url.getPort();
            String string = this.url.getHost();
            if (n != -1 && n != this.url.getDefaultPort()) {
                string = string + ":" + String.valueOf(n);
            }
            this.requests.setIfNotSet("Host", string);
            this.requests.setIfNotSet("Accept", acceptString);
            if (!this.failedOnce && this.http.getHttpKeepAliveSet()) {
                if (this.http.usingProxy) {
                    this.requests.setIfNotSet("Proxy-Connection", "keep-alive");
                } else {
                    this.requests.setIfNotSet("Connection", "keep-alive");
                }
            } else {
                this.requests.setIfNotSet("Connection", "close");
            }
            long l = this.getIfModifiedSince();
            if (l != 0L) {
                cloneable = new Date(l);
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
                simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
                this.requests.setIfNotSet("If-Modified-Since", simpleDateFormat.format((Date)cloneable));
            }
            if ((cloneable = AuthenticationInfo.getServerAuth(this.url)) != null && ((AuthenticationInfo)cloneable).supportsPreemptiveAuthorization()) {
                this.requests.setIfNotSet(((AuthenticationInfo)cloneable).getHeaderName(), ((AuthenticationInfo)cloneable).getHeaderValue(this.url, this.method));
                this.currentServerCredentials = cloneable;
            }
            if (!this.method.equals("PUT") && (this.poster != null || this.streaming())) {
                this.requests.setIfNotSet("Content-type", "application/x-www-form-urlencoded");
            }
            boolean bl = false;
            if (this.streaming()) {
                if (this.chunkLength != -1) {
                    this.requests.set("Transfer-Encoding", "chunked");
                    bl = true;
                } else {
                    this.requests.set("Content-Length", String.valueOf(this.fixedContentLength));
                }
            } else if (this.poster != null) {
                PosterOutputStream posterOutputStream = this.poster;
                synchronized (posterOutputStream) {
                    this.poster.close();
                    this.requests.set("Content-Length", String.valueOf(this.poster.size()));
                }
            }
            if (!bl && this.requests.findValue("Transfer-Encoding") != null) {
                this.requests.remove("Transfer-Encoding");
                if (HttpCapture.isLoggable("WARNING")) {
                    HttpCapture.warning("use streaming mode for chunked encoding");
                }
            }
            this.setCookieHeader();
            this.setRequests = true;
        }
        if (HttpCapture.isLoggable("FINE")) {
            HttpCapture.fine(this.requests.toString());
        }
        this.http.writeRequests(this.requests, this.poster, this.streaming());
        if (this.ps.checkError()) {
            String string = this.http.getProxyHostUsed();
            int n = this.http.getProxyPortUsed();
            this.disconnectInternal();
            if (this.failedOnce) {
                throw new IOException("Error writing to server");
            }
            this.failedOnce = true;
            if (string != null) {
                this.setProxiedClient(this.url, string, n);
            } else {
                this.setNewClient(this.url);
            }
            this.ps = (PrintStream)this.http.getOutputStream();
            this.connected = true;
            this.responses = new MessageHeader();
            this.setRequests = false;
            this.writeRequests();
        }
    }

    protected void setNewClient(URL uRL) throws IOException {
        this.setNewClient(uRL, false);
    }

    protected void setNewClient(URL uRL, boolean bl) throws IOException {
        this.http = HttpClient.New(uRL, null, -1, bl, this.connectTimeout);
        this.http.setReadTimeout(this.readTimeout);
    }

    protected void setProxiedClient(URL uRL, String string, int n) throws IOException {
        this.setProxiedClient(uRL, string, n, false);
    }

    protected void setProxiedClient(URL uRL, String string, int n, boolean bl) throws IOException {
        this.proxiedConnect(uRL, string, n, bl);
    }

    protected void proxiedConnect(URL uRL, String string, int n, boolean bl) throws IOException {
        this.http = HttpClient.New(uRL, string, n, bl, this.connectTimeout);
        this.http.setReadTimeout(this.readTimeout);
    }

    protected HttpURLConnection(URL uRL, Handler handler) throws IOException {
        this(uRL, null, handler);
    }

    public HttpURLConnection(URL uRL, String string, int n) {
        this(uRL, new Proxy(Proxy.Type.HTTP, InetSocketAddress.createUnresolved(string, n)));
    }

    public HttpURLConnection(URL uRL, Proxy proxy) {
        this(uRL, proxy, new Handler());
    }

    protected HttpURLConnection(URL uRL, Proxy proxy, Handler handler) {
        super(uRL);
        this.requests = new MessageHeader();
        this.responses = new MessageHeader();
        this.handler = handler;
        this.instProxy = proxy;
        if (this.instProxy instanceof ApplicationProxy) {
            try {
                this.cookieHandler = CookieHandler.getDefault();
            }
            catch (SecurityException securityException) {}
        } else {
            this.cookieHandler = AccessController.doPrivileged(new PrivilegedAction<CookieHandler>(){

                @Override
                public CookieHandler run() {
                    return CookieHandler.getDefault();
                }
            });
        }
        this.cacheHandler = AccessController.doPrivileged(new PrivilegedAction<ResponseCache>(){

            @Override
            public ResponseCache run() {
                return ResponseCache.getDefault();
            }
        });
    }

    public static void setDefaultAuthenticator(HttpAuthenticator httpAuthenticator) {
        defaultAuth = httpAuthenticator;
    }

    public static InputStream openConnectionCheckRedirects(URLConnection uRLConnection) throws IOException {
        InputStream inputStream;
        boolean bl;
        int n = 0;
        do {
            HttpURLConnection httpURLConnection;
            int n2;
            if (uRLConnection instanceof HttpURLConnection) {
                ((HttpURLConnection)uRLConnection).setInstanceFollowRedirects(false);
            }
            inputStream = uRLConnection.getInputStream();
            bl = false;
            if (!(uRLConnection instanceof HttpURLConnection) || (n2 = (httpURLConnection = (HttpURLConnection)uRLConnection).getResponseCode()) < 300 || n2 > 307 || n2 == 306 || n2 == 304) continue;
            URL uRL = httpURLConnection.getURL();
            String string = httpURLConnection.getHeaderField("Location");
            URL uRL2 = null;
            if (string != null) {
                uRL2 = new URL(uRL, string);
            }
            httpURLConnection.disconnect();
            if (uRL2 == null || !uRL.getProtocol().equals(uRL2.getProtocol()) || uRL.getPort() != uRL2.getPort() || !HttpURLConnection.hostsEqual(uRL, uRL2) || n >= 5) {
                throw new SecurityException("illegal URL redirect");
            }
            bl = true;
            uRLConnection = uRL2.openConnection();
            ++n;
        } while (bl);
        return inputStream;
    }

    private static boolean hostsEqual(URL uRL, URL uRL2) {
        final String string = uRL.getHost();
        final String string2 = uRL2.getHost();
        if (string == null) {
            return string2 == null;
        }
        if (string2 == null) {
            return false;
        }
        if (string.equalsIgnoreCase(string2)) {
            return true;
        }
        final boolean[] blArray = new boolean[]{false};
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                try {
                    InetAddress inetAddress = InetAddress.getByName(string);
                    InetAddress inetAddress2 = InetAddress.getByName(string2);
                    blArray[0] = inetAddress.equals(inetAddress2);
                }
                catch (UnknownHostException unknownHostException) {
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                return null;
            }
        });
        return blArray[0];
    }

    public void connect() throws IOException {
        this.plainConnect();
    }

    private boolean checkReuseConnection() {
        if (this.connected) {
            return true;
        }
        if (this.reuseClient != null) {
            this.http = this.reuseClient;
            this.http.setReadTimeout(this.getReadTimeout());
            this.http.reuse = false;
            this.reuseClient = null;
            this.connected = true;
            return true;
        }
        return false;
    }

    protected void plainConnect() throws IOException {
        Object object;
        if (this.connected) {
            return;
        }
        if (this.cacheHandler != null && this.getUseCaches()) {
            try {
                object = ParseUtil.toURI(this.url);
                if (object != null) {
                    this.cachedResponse = this.cacheHandler.get((URI)object, this.getRequestMethod(), this.requests.getHeaders(EXCLUDE_HEADERS));
                    if ("https".equalsIgnoreCase(((URI)object).getScheme()) && !(this.cachedResponse instanceof SecureCacheResponse)) {
                        this.cachedResponse = null;
                    }
                    if (HttpCapture.isLoggable("FINEST")) {
                        HttpCapture.finest("Cache Request for " + object + " / " + this.getRequestMethod());
                        HttpCapture.finest("From cache: " + (this.cachedResponse != null ? this.cachedResponse.toString() : "null"));
                    }
                    if (this.cachedResponse != null) {
                        this.cachedHeaders = this.mapToMessageHeader(this.cachedResponse.getHeaders());
                        this.cachedInputStream = this.cachedResponse.getBody();
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.cachedHeaders != null && this.cachedInputStream != null) {
                this.connected = true;
                return;
            }
            this.cachedResponse = null;
        }
        if (this.instProxy == null) {
            object = AccessController.doPrivileged(new PrivilegedAction<ProxySelector>(){

                @Override
                public ProxySelector run() {
                    return ProxySelector.getDefault();
                }
            });
            if (object != null) {
                URI uRI = ParseUtil.toURI(this.url);
                if (HttpCapture.isLoggable("FINEST")) {
                    HttpCapture.finest("ProxySelector Request for " + uRI);
                }
                Iterator<Proxy> iterator = ((ProxySelector)object).select(uRI).iterator();
                while (iterator.hasNext()) {
                    Proxy proxy = iterator.next();
                    try {
                        if (!this.failedOnce) {
                            this.http = this.getNewHttpClient(this.url, proxy, this.connectTimeout);
                            this.http.setReadTimeout(this.readTimeout);
                        } else {
                            this.http = this.getNewHttpClient(this.url, proxy, this.connectTimeout, false);
                            this.http.setReadTimeout(this.readTimeout);
                        }
                        if (HttpCapture.isLoggable("FINEST") && proxy != null) {
                            HttpCapture.finest("Proxy used: " + proxy.toString());
                        }
                        break;
                    }
                    catch (IOException iOException) {
                        if (proxy != Proxy.NO_PROXY) {
                            ((ProxySelector)object).connectFailed(uRI, proxy.address(), iOException);
                            if (iterator.hasNext()) continue;
                            this.http = this.getNewHttpClient(this.url, null, this.connectTimeout, false);
                            this.http.setReadTimeout(this.readTimeout);
                            break;
                        }
                        throw iOException;
                    }
                }
            } else if (!this.failedOnce) {
                this.http = this.getNewHttpClient(this.url, null, this.connectTimeout);
                this.http.setReadTimeout(this.readTimeout);
            } else {
                this.http = this.getNewHttpClient(this.url, null, this.connectTimeout, false);
                this.http.setReadTimeout(this.readTimeout);
            }
        } else if (!this.failedOnce) {
            this.http = this.getNewHttpClient(this.url, this.instProxy, this.connectTimeout);
            this.http.setReadTimeout(this.readTimeout);
        } else {
            this.http = this.getNewHttpClient(this.url, this.instProxy, this.connectTimeout, false);
            this.http.setReadTimeout(this.readTimeout);
        }
        this.ps = (PrintStream)this.http.getOutputStream();
        this.connected = true;
    }

    protected HttpClient getNewHttpClient(URL uRL, Proxy proxy, int n) throws IOException {
        return HttpClient.New(uRL, proxy, n);
    }

    protected HttpClient getNewHttpClient(URL uRL, Proxy proxy, int n, boolean bl) throws IOException {
        return HttpClient.New(uRL, proxy, n, bl);
    }

    private void expect100Continue() throws IOException {
        int n = this.http.getReadTimeout();
        boolean bl = false;
        boolean bl2 = false;
        if (n <= 0) {
            this.http.setReadTimeout(5000);
            bl = true;
        }
        try {
            this.http.parseHTTP(this.responses, this.pi, this);
        }
        catch (SocketTimeoutException socketTimeoutException) {
            if (!bl) {
                throw socketTimeoutException;
            }
            bl2 = true;
            this.http.setIgnoreContinue(true);
        }
        if (!bl2) {
            String string = this.responses.getValue(0);
            if (string != null && string.startsWith("HTTP/")) {
                String[] stringArray = string.split("\\s+");
                this.responseCode = -1;
                try {
                    if (stringArray.length > 1) {
                        this.responseCode = Integer.parseInt(stringArray[1]);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (this.responseCode != 100) {
                throw new ProtocolException("Server rejected operation");
            }
        }
        if (n > 0) {
            this.http.setReadTimeout(n);
        }
        this.responseCode = -1;
        this.responses.reset();
    }

    public synchronized OutputStream getOutputStream() throws IOException {
        try {
            if (!this.doOutput) {
                throw new ProtocolException("cannot write to a URLConnection if doOutput=false - call setDoOutput(true)");
            }
            if (this.method.equals("GET")) {
                this.method = "POST";
            }
            if (!"POST".equals(this.method) && !"PUT".equals(this.method) && "http".equals(this.url.getProtocol())) {
                throw new ProtocolException("HTTP method " + this.method + " doesn't support output");
            }
            if (this.inputStream != null) {
                throw new ProtocolException("Cannot write output after reading input.");
            }
            if (!this.checkReuseConnection()) {
                this.connect();
            }
            boolean bl = false;
            String string = this.requests.findValue("Expect");
            if ("100-Continue".equalsIgnoreCase(string)) {
                this.http.setIgnoreContinue(false);
                bl = true;
            }
            if (this.streaming() && this.strOutputStream == null) {
                this.writeRequests();
            }
            if (bl) {
                this.expect100Continue();
            }
            this.ps = (PrintStream)this.http.getOutputStream();
            if (this.streaming()) {
                if (this.strOutputStream == null) {
                    if (this.fixedContentLength != -1) {
                        this.strOutputStream = new StreamingOutputStream(this.ps, this.fixedContentLength);
                    } else if (this.chunkLength != -1) {
                        this.strOutputStream = new StreamingOutputStream(new ChunkedOutputStream(this.ps, this.chunkLength), -1);
                    }
                }
                return this.strOutputStream;
            }
            if (this.poster == null) {
                this.poster = new PosterOutputStream();
            }
            return this.poster;
        }
        catch (RuntimeException runtimeException) {
            this.disconnectInternal();
            throw runtimeException;
        }
        catch (ProtocolException protocolException) {
            int n = this.responseCode;
            this.disconnectInternal();
            this.responseCode = n;
            throw protocolException;
        }
        catch (IOException iOException) {
            this.disconnectInternal();
            throw iOException;
        }
    }

    private boolean streaming() {
        return this.fixedContentLength != -1 || this.chunkLength != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCookieHeader() throws IOException {
        if (this.cookieHandler != null) {
            Object object = this;
            synchronized (object) {
                if (this.setUserCookies) {
                    int n = this.requests.getKey("Cookie");
                    if (n != -1) {
                        this.userCookies = this.requests.getValue(n);
                    }
                    if ((n = this.requests.getKey("Cookie2")) != -1) {
                        this.userCookies2 = this.requests.getValue(n);
                    }
                    this.setUserCookies = false;
                }
            }
            this.requests.remove("Cookie");
            this.requests.remove("Cookie2");
            object = ParseUtil.toURI(this.url);
            if (object != null) {
                Map<String, List<String>> map;
                if (HttpCapture.isLoggable("FINEST")) {
                    HttpCapture.finest("CookieHandler request for " + object);
                }
                if (!(map = this.cookieHandler.get((URI)object, this.requests.getHeaders(EXCLUDE_HEADERS))).isEmpty()) {
                    if (HttpCapture.isLoggable("FINEST")) {
                        HttpCapture.finest("Cookies retrieved: " + map.toString());
                    }
                    for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                        List<String> list;
                        String string = entry.getKey();
                        if (!"Cookie".equalsIgnoreCase(string) && !"Cookie2".equalsIgnoreCase(string) || (list = entry.getValue()) == null || list.isEmpty()) continue;
                        StringBuilder stringBuilder = new StringBuilder();
                        for (String string2 : list) {
                            stringBuilder.append(string2).append("; ");
                        }
                        try {
                            this.requests.add(string, stringBuilder.substring(0, stringBuilder.length() - 2));
                        }
                        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
                    }
                }
            }
            if (this.userCookies != null) {
                int n = this.requests.getKey("Cookie");
                if (n != -1) {
                    this.requests.set("Cookie", this.requests.getValue(n) + ";" + this.userCookies);
                } else {
                    this.requests.set("Cookie", this.userCookies);
                }
            }
            if (this.userCookies2 != null) {
                int n = this.requests.getKey("Cookie2");
                if (n != -1) {
                    this.requests.set("Cookie2", this.requests.getValue(n) + ";" + this.userCookies2);
                } else {
                    this.requests.set("Cookie2", this.userCookies2);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized InputStream getInputStream() throws IOException {
        if (!this.doInput) {
            throw new ProtocolException("Cannot read from URLConnection if doInput=false (call setDoInput(true))");
        }
        if (this.rememberedException != null) {
            if (!(this.rememberedException instanceof RuntimeException)) throw this.getChainedException((IOException)this.rememberedException);
            throw new RuntimeException(this.rememberedException);
        }
        if (this.inputStream != null) {
            return this.inputStream;
        }
        if (this.streaming()) {
            if (this.strOutputStream == null) {
                this.getOutputStream();
            }
            this.strOutputStream.close();
            if (!this.strOutputStream.writtenOK()) {
                throw new IOException("Incomplete output stream");
            }
        }
        int n = 0;
        int n2 = 0;
        int n3 = -1;
        Object object = null;
        AuthenticationInfo authenticationInfo = null;
        AuthenticationHeader authenticationHeader = null;
        this.isUserServerAuth = this.requests.getKey("Authorization") != -1;
        this.isUserProxyAuth = this.requests.getKey("Proxy-Authorization") != -1;
        try {
            Object object2;
            block63: {
                InputStream inputStream;
                block61: {
                    block62: {
                        try {
                            do {
                                Object object3;
                                Object object4;
                                if (!this.checkReuseConnection()) {
                                    this.connect();
                                }
                                if (this.cachedInputStream != null) {
                                    inputStream = this.cachedInputStream;
                                    Object var16_23 = null;
                                    if (n2 != 407 || authenticationInfo == null) break block61;
                                    break block62;
                                }
                                boolean bl = ProgressMonitor.getDefault().shouldMeterInput(this.url, this.method);
                                if (bl) {
                                    this.pi = new ProgressSource(this.url, this.method);
                                    this.pi.beginTracking();
                                }
                                this.ps = (PrintStream)this.http.getOutputStream();
                                if (!this.streaming()) {
                                    this.writeRequests();
                                }
                                this.http.parseHTTP(this.responses, this.pi, this);
                                if (HttpCapture.isLoggable("FINE")) {
                                    HttpCapture.fine(this.responses.toString());
                                }
                                this.inputStream = this.http.getInputStream();
                                n2 = this.getResponseCode();
                                if (n2 == 407) {
                                    if (this.streaming()) {
                                        this.disconnectInternal();
                                        throw new HttpRetryException(RETRY_MSG1, 407);
                                    }
                                    object2 = new AuthenticationHeader("Proxy-Authenticate", this.responses, new HttpCallerInfo(this.url, this.http.getProxyHostUsed(), this.http.getProxyPortUsed()));
                                    if (!this.doingNTLMp2ndStage) {
                                        if ((authenticationInfo = this.resetProxyAuthentication(authenticationInfo, (AuthenticationHeader)object2)) != null) {
                                            ++n;
                                            this.disconnectInternal();
                                            continue;
                                        }
                                    } else {
                                        object4 = this.responses.findValue("Proxy-Authenticate");
                                        this.reset();
                                        if (!authenticationInfo.setHeaders(this, ((AuthenticationHeader)object2).headerParser(), (String)object4)) {
                                            this.disconnectInternal();
                                            throw new IOException("Authentication failure");
                                        }
                                        if (object != null && authenticationHeader != null && !((AuthenticationInfo)object).setHeaders(this, authenticationHeader.headerParser(), (String)object4)) {
                                            this.disconnectInternal();
                                            throw new IOException("Authentication failure");
                                        }
                                        this.authObj = null;
                                        this.doingNTLMp2ndStage = false;
                                        continue;
                                    }
                                }
                                if (authenticationInfo != null) {
                                    authenticationInfo.addToCache();
                                }
                                if (n2 == 401) {
                                    if (this.streaming()) {
                                        this.disconnectInternal();
                                        throw new HttpRetryException(RETRY_MSG2, 401);
                                    }
                                    authenticationHeader = new AuthenticationHeader("WWW-Authenticate", this.responses, new HttpCallerInfo(this.url));
                                    object2 = authenticationHeader.raw();
                                    if (!this.doingNTLM2ndStage) {
                                        if (object != null && ((AuthenticationInfo)object).getAuthScheme() != AuthScheme.NTLM) {
                                            if (((AuthenticationInfo)object).isAuthorizationStale((String)object2)) {
                                                this.disconnectInternal();
                                                ++n;
                                                this.requests.set(((AuthenticationInfo)object).getHeaderName(), ((AuthenticationInfo)object).getHeaderValue(this.url, this.method));
                                                this.currentServerCredentials = object;
                                                this.setCookieHeader();
                                                continue;
                                            }
                                            ((AuthenticationInfo)object).removeFromCache();
                                        }
                                        object = this.getServerAuthentication(authenticationHeader);
                                        this.currentServerCredentials = object;
                                        if (object != null) {
                                            this.disconnectInternal();
                                            ++n;
                                            this.setCookieHeader();
                                            continue;
                                        }
                                    } else {
                                        this.reset();
                                        if (!((AuthenticationInfo)object).setHeaders(this, null, (String)object2)) {
                                            this.disconnectInternal();
                                            throw new IOException("Authentication failure");
                                        }
                                        this.doingNTLM2ndStage = false;
                                        this.authObj = null;
                                        this.setCookieHeader();
                                        continue;
                                    }
                                }
                                if (object != null) {
                                    if (!(object instanceof DigestAuthentication) || this.domain == null) {
                                        if (object instanceof BasicAuthentication) {
                                            object4 = ((AuthenticationInfo)object).path;
                                            object2 = AuthenticationInfo.reducePath(this.url.getPath());
                                            if (!((String)object4).startsWith((String)object2) || ((String)object2).length() >= ((String)object4).length()) {
                                                object2 = BasicAuthentication.getRootPath((String)object4, (String)object2);
                                            }
                                            object3 = (BasicAuthentication)((AuthenticationInfo)object).clone();
                                            ((AuthenticationInfo)object).removeFromCache();
                                            ((BasicAuthentication)object3).path = object2;
                                            object = object3;
                                        }
                                        ((AuthenticationInfo)object).addToCache();
                                    } else {
                                        object2 = (DigestAuthentication)object;
                                        object4 = new StringTokenizer(this.domain, " ");
                                        object3 = ((DigestAuthentication)object2).realm;
                                        PasswordAuthentication passwordAuthentication = ((DigestAuthentication)object2).pw;
                                        this.digestparams = ((DigestAuthentication)object2).params;
                                        while (((StringTokenizer)object4).hasMoreTokens()) {
                                            String string = ((StringTokenizer)object4).nextToken();
                                            try {
                                                URL uRL = new URL(this.url, string);
                                                DigestAuthentication digestAuthentication = new DigestAuthentication(false, uRL, (String)object3, "Digest", passwordAuthentication, this.digestparams);
                                                digestAuthentication.addToCache();
                                            }
                                            catch (Exception exception) {}
                                        }
                                    }
                                }
                                this.doingNTLMp2ndStage = false;
                                this.doingNTLM2ndStage = false;
                                if (!this.isUserServerAuth) {
                                    this.requests.remove("Authorization");
                                }
                                if (!this.isUserProxyAuth) {
                                    this.requests.remove("Proxy-Authorization");
                                }
                                if (n2 == 200) {
                                    this.checkResponseCredentials(false);
                                } else {
                                    this.needToCheck = false;
                                }
                                this.needToCheck = true;
                                if (this.followRedirect()) {
                                    ++n;
                                    this.setCookieHeader();
                                    continue;
                                }
                                try {
                                    n3 = Integer.parseInt(this.responses.findValue("content-length"));
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                if (this.method.equals("HEAD") || n3 == 0 || n2 == 304 || n2 == 204) {
                                    if (this.pi != null) {
                                        this.pi.finishTracking();
                                        this.pi = null;
                                    }
                                    this.http.finished();
                                    this.http = null;
                                    this.inputStream = new EmptyInputStream();
                                    this.connected = false;
                                }
                                if ((n2 == 200 || n2 == 203 || n2 == 206 || n2 == 300 || n2 == 301 || n2 == 410) && this.cacheHandler != null && this.getUseCaches() && (object2 = ParseUtil.toURI(this.url)) != null) {
                                    object4 = this;
                                    if ("https".equalsIgnoreCase(((URI)object2).getScheme())) {
                                        try {
                                            object4 = (URLConnection)this.getClass().getField("httpsURLConnection").get(this);
                                        }
                                        catch (IllegalAccessException illegalAccessException) {
                                        }
                                        catch (NoSuchFieldException noSuchFieldException) {
                                            // empty catch block
                                        }
                                    }
                                    if ((object3 = this.cacheHandler.put((URI)object2, (URLConnection)object4)) != null && this.http != null) {
                                        this.http.setCacheRequest((CacheRequest)object3);
                                        this.inputStream = new HttpInputStream(this.inputStream, (CacheRequest)object3);
                                    }
                                }
                                if (!(this.inputStream instanceof HttpInputStream)) {
                                    this.inputStream = new HttpInputStream(this.inputStream);
                                }
                                if (n2 >= 400) {
                                    if (n2 == 404) throw new FileNotFoundException(this.url.toString());
                                    if (n2 != 410) throw new IOException("Server returned HTTP response code: " + n2 + " for URL: " + this.url.toString());
                                    throw new FileNotFoundException(this.url.toString());
                                }
                                this.poster = null;
                                this.strOutputStream = null;
                                object2 = this.inputStream;
                                break block63;
                            } while (n < maxRedirects);
                            throw new ProtocolException("Server redirected too many  times (" + n + ")");
                        }
                        catch (RuntimeException runtimeException) {
                            this.disconnectInternal();
                            this.rememberedException = runtimeException;
                            throw runtimeException;
                        }
                        catch (IOException iOException) {
                            this.rememberedException = iOException;
                            String string = this.responses.findValue("Transfer-Encoding");
                            if (this.http == null) throw iOException;
                            if (!this.http.isKeepingAlive()) throw iOException;
                            if (!enableESBuffer) throw iOException;
                            if (n3 <= 0) {
                                if (string == null) throw iOException;
                                if (!string.equalsIgnoreCase("chunked")) throw iOException;
                            }
                            this.errorStream = ErrorStream.getErrorStream(this.inputStream, n3, this.http);
                            throw iOException;
                        }
                    }
                    authenticationInfo.endAuthRequest();
                    return inputStream;
                }
                if (n2 != 401) return inputStream;
                if (object == null) return inputStream;
                ((AuthenticationInfo)object).endAuthRequest();
                return inputStream;
            }
            Object var16_24 = null;
            if (n2 == 407 && authenticationInfo != null) {
                authenticationInfo.endAuthRequest();
                return object2;
            }
            if (n2 != 401) return object2;
            if (object == null) return object2;
            ((AuthenticationInfo)object).endAuthRequest();
            return object2;
        }
        catch (Throwable throwable) {
            Object var16_25 = null;
            if (n2 == 407 && authenticationInfo != null) {
                authenticationInfo.endAuthRequest();
                throw throwable;
            }
            if (n2 != 401) throw throwable;
            if (object == null) throw throwable;
            ((AuthenticationInfo)object).endAuthRequest();
            throw throwable;
        }
    }

    private IOException getChainedException(IOException iOException) {
        try {
            final IOException iOException2 = iOException;
            final Class[] classArray = new Class[]{String.class};
            final String[] stringArray = new String[]{iOException2.getMessage()};
            IOException iOException3 = AccessController.doPrivileged(new PrivilegedExceptionAction<IOException>(){

                @Override
                public IOException run() throws Exception {
                    Constructor<?> constructor = iOException2.getClass().getConstructor(classArray);
                    return (IOException)constructor.newInstance(stringArray);
                }
            });
            iOException3.initCause(iOException2);
            return iOException3;
        }
        catch (Exception exception) {
            return iOException;
        }
    }

    public InputStream getErrorStream() {
        if (this.connected && this.responseCode >= 400) {
            if (this.errorStream != null) {
                return this.errorStream;
            }
            if (this.inputStream != null) {
                return this.inputStream;
            }
        }
        return null;
    }

    private AuthenticationInfo resetProxyAuthentication(AuthenticationInfo authenticationInfo, AuthenticationHeader authenticationHeader) {
        if (authenticationInfo != null && authenticationInfo.getAuthScheme() != AuthScheme.NTLM) {
            String string = authenticationHeader.raw();
            if (authenticationInfo.isAuthorizationStale(string)) {
                this.requests.set(authenticationInfo.getHeaderName(), authenticationInfo.getHeaderValue(this.url, this.method));
                this.currentProxyCredentials = authenticationInfo;
                return authenticationInfo;
            }
            authenticationInfo.removeFromCache();
        }
        this.currentProxyCredentials = authenticationInfo = this.getHttpProxyAuthentication(authenticationHeader);
        return authenticationInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void doTunneling() throws IOException {
        int n = 0;
        String string = "";
        int n2 = 0;
        AuthenticationInfo authenticationInfo = null;
        String string2 = null;
        int n3 = -1;
        MessageHeader messageHeader = this.requests;
        this.requests = new MessageHeader();
        try {
            do {
                if (!this.checkReuseConnection()) {
                    this.proxiedConnect(this.url, string2, n3, false);
                }
                this.sendCONNECTRequest();
                this.responses.reset();
                this.http.parseHTTP(this.responses, null, this);
                if (HttpCapture.isLoggable("FINE")) {
                    HttpCapture.fine(this.responses.toString());
                }
                string = this.responses.getValue(0);
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                stringTokenizer.nextToken();
                n2 = Integer.parseInt(stringTokenizer.nextToken().trim());
                if (n2 == 407) {
                    AuthenticationHeader authenticationHeader = new AuthenticationHeader("Proxy-Authenticate", this.responses, new HttpCallerInfo(this.url, this.http.getProxyHostUsed(), this.http.getProxyPortUsed()));
                    if (!this.doingNTLMp2ndStage) {
                        if ((authenticationInfo = this.resetProxyAuthentication(authenticationInfo, authenticationHeader)) != null) {
                            string2 = this.http.getProxyHostUsed();
                            n3 = this.http.getProxyPortUsed();
                            this.disconnectInternal();
                            ++n;
                            continue;
                        }
                    } else {
                        String string3 = this.responses.findValue("Proxy-Authenticate");
                        this.reset();
                        if (!authenticationInfo.setHeaders(this, authenticationHeader.headerParser(), string3)) {
                            this.disconnectInternal();
                            throw new IOException("Authentication failure");
                        }
                        this.authObj = null;
                        this.doingNTLMp2ndStage = false;
                        continue;
                    }
                }
                if (authenticationInfo != null) {
                    authenticationInfo.addToCache();
                }
                if (n2 == 200) break;
                this.disconnectInternal();
                break;
            } while (n < maxRedirects);
            if (n >= maxRedirects || n2 != 200) {
                throw new IOException("Unable to tunnel through proxy. Proxy returns \"" + string + "\"");
            }
            Object var12_11 = null;
            if (n2 == 407 && authenticationInfo != null) {
                authenticationInfo.endAuthRequest();
            }
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            if (n2 == 407 && authenticationInfo != null) {
                authenticationInfo.endAuthRequest();
            }
            throw throwable;
        }
        this.requests = messageHeader;
        this.responses.reset();
    }

    private void sendCONNECTRequest() throws IOException {
        int n = this.url.getPort();
        if (this.setRequests) {
            this.requests.set(0, null, null);
        }
        this.requests.prepend("CONNECT " + this.url.getHost() + ":" + (n != -1 ? n : this.url.getDefaultPort()) + " " + httpVersion, null);
        this.requests.setIfNotSet("User-Agent", userAgent);
        String string = this.url.getHost();
        if (n != -1 && n != this.url.getDefaultPort()) {
            string = string + ":" + String.valueOf(n);
        }
        this.requests.setIfNotSet("Host", string);
        this.requests.setIfNotSet("Accept", acceptString);
        this.setPreemptiveProxyAuthentication(this.requests);
        if (HttpCapture.isLoggable("FINE")) {
            HttpCapture.fine(this.requests.toString());
        }
        this.http.writeRequests(this.requests, null);
        this.requests.set(0, null, null);
    }

    private void setPreemptiveProxyAuthentication(MessageHeader messageHeader) {
        AuthenticationInfo authenticationInfo = AuthenticationInfo.getProxyAuth(this.http.getProxyHostUsed(), this.http.getProxyPortUsed());
        if (authenticationInfo != null && authenticationInfo.supportsPreemptiveAuthorization()) {
            messageHeader.set(authenticationInfo.getHeaderName(), authenticationInfo.getHeaderValue(this.url, this.method));
            this.currentProxyCredentials = authenticationInfo;
        }
    }

    private AuthenticationInfo getHttpProxyAuthentication(AuthenticationHeader authenticationHeader) {
        Object object = null;
        String string = authenticationHeader.raw();
        String string2 = this.http.getProxyHostUsed();
        int n = this.http.getProxyPortUsed();
        if (string2 != null && authenticationHeader.isPresent()) {
            Object object2;
            Serializable serializable;
            HeaderParser headerParser = authenticationHeader.headerParser();
            String string3 = headerParser.findValue("realm");
            String string4 = authenticationHeader.scheme();
            AuthScheme authScheme = AuthScheme.UNKNOWN;
            if ("basic".equalsIgnoreCase(string4)) {
                authScheme = AuthScheme.BASIC;
            } else if ("digest".equalsIgnoreCase(string4)) {
                authScheme = AuthScheme.DIGEST;
            } else if ("ntlm".equalsIgnoreCase(string4)) {
                authScheme = AuthScheme.NTLM;
                this.doingNTLMp2ndStage = true;
            } else if ("Kerberos".equalsIgnoreCase(string4)) {
                authScheme = AuthScheme.KERBEROS;
                this.doingNTLMp2ndStage = true;
            } else if ("Negotiate".equalsIgnoreCase(string4)) {
                authScheme = AuthScheme.NEGOTIATE;
                this.doingNTLMp2ndStage = true;
            }
            if (string3 == null) {
                string3 = "";
            }
            if ((object = AuthenticationInfo.getProxyAuth(string2, n, string3, authScheme)) == null) {
                switch (authScheme) {
                    case BASIC: {
                        serializable = null;
                        try {
                            object2 = string2;
                            serializable = AccessController.doPrivileged(new PrivilegedExceptionAction<InetAddress>((String)object2){
                                final /* synthetic */ String val$finalHost;
                                {
                                    this.val$finalHost = string;
                                }

                                @Override
                                public InetAddress run() throws UnknownHostException {
                                    return InetAddress.getByName(this.val$finalHost);
                                }
                            });
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            // empty catch block
                        }
                        object2 = HttpURLConnection.privilegedRequestPasswordAuthentication(string2, (InetAddress)serializable, n, "http", string3, string4, this.url, Authenticator.RequestorType.PROXY);
                        if (object2 == null) break;
                        object = new BasicAuthentication(true, string2, n, string3, (PasswordAuthentication)object2);
                        break;
                    }
                    case DIGEST: {
                        object2 = HttpURLConnection.privilegedRequestPasswordAuthentication(string2, null, n, this.url.getProtocol(), string3, string4, this.url, Authenticator.RequestorType.PROXY);
                        if (object2 == null) break;
                        DigestAuthentication.Parameters parameters = new DigestAuthentication.Parameters();
                        object = new DigestAuthentication(true, string2, n, string3, string4, (PasswordAuthentication)object2, parameters);
                        break;
                    }
                    case NTLM: {
                        if (!NTLMAuthenticationProxy.supported) break;
                        if (this.tryTransparentNTLMProxy) {
                            this.tryTransparentNTLMProxy = NTLMAuthenticationProxy.supportsTransparentAuth;
                            if (this.tryTransparentNTLMProxy && this.useProxyResponseCode) {
                                this.tryTransparentNTLMProxy = false;
                            }
                        }
                        object2 = null;
                        if (this.tryTransparentNTLMProxy) {
                            HttpCapture.finest("Trying Transparent NTLM authentication");
                        } else {
                            object2 = HttpURLConnection.privilegedRequestPasswordAuthentication(string2, null, n, this.url.getProtocol(), "", string4, this.url, Authenticator.RequestorType.PROXY);
                        }
                        if (this.tryTransparentNTLMProxy || !this.tryTransparentNTLMProxy && object2 != null) {
                            object = NTLMAuthenticationProxy.proxy.create(true, string2, n, (PasswordAuthentication)object2);
                        }
                        this.tryTransparentNTLMProxy = false;
                        break;
                    }
                    case NEGOTIATE: {
                        object = new NegotiateAuthentication(new HttpCallerInfo(authenticationHeader.getHttpCallerInfo(), "Negotiate"));
                        break;
                    }
                    case KERBEROS: {
                        object = new NegotiateAuthentication(new HttpCallerInfo(authenticationHeader.getHttpCallerInfo(), "Kerberos"));
                        break;
                    }
                    case UNKNOWN: {
                        HttpCapture.finest("Unknown/Unsupported authentication scheme: " + string4);
                    }
                    default: {
                        throw new AssertionError((Object)"should not reach here");
                    }
                }
            }
            if (object == null && defaultAuth != null && defaultAuth.schemeSupported(string4)) {
                try {
                    serializable = new URL("http", string2, n, "/");
                    object2 = defaultAuth.authString((URL)serializable, string4, string3);
                    if (object2 != null) {
                        object = new BasicAuthentication(true, string2, n, string3, (String)object2);
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if (object != null && !((AuthenticationInfo)object).setHeaders(this, headerParser, string)) {
                object = null;
            }
        }
        if (HttpCapture.isLoggable("FINER")) {
            HttpCapture.finer("Proxy Authentication for " + authenticationHeader.toString() + " returned " + (object != null ? object.toString() : "null"));
        }
        return object;
    }

    private AuthenticationInfo getServerAuthentication(AuthenticationHeader authenticationHeader) {
        Object object = null;
        String string = authenticationHeader.raw();
        if (authenticationHeader.isPresent()) {
            Object object2;
            int n;
            HeaderParser headerParser = authenticationHeader.headerParser();
            String string2 = headerParser.findValue("realm");
            String string3 = authenticationHeader.scheme();
            AuthScheme authScheme = AuthScheme.UNKNOWN;
            if ("basic".equalsIgnoreCase(string3)) {
                authScheme = AuthScheme.BASIC;
            } else if ("digest".equalsIgnoreCase(string3)) {
                authScheme = AuthScheme.DIGEST;
            } else if ("ntlm".equalsIgnoreCase(string3)) {
                authScheme = AuthScheme.NTLM;
                this.doingNTLM2ndStage = true;
            } else if ("Kerberos".equalsIgnoreCase(string3)) {
                authScheme = AuthScheme.KERBEROS;
                this.doingNTLM2ndStage = true;
            } else if ("Negotiate".equalsIgnoreCase(string3)) {
                authScheme = AuthScheme.NEGOTIATE;
                this.doingNTLM2ndStage = true;
            }
            this.domain = headerParser.findValue("domain");
            if (string2 == null) {
                string2 = "";
            }
            object = AuthenticationInfo.getServerAuth(this.url, string2, authScheme);
            InetAddress inetAddress = null;
            if (object == null) {
                try {
                    inetAddress = InetAddress.getByName(this.url.getHost());
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
            }
            if ((n = this.url.getPort()) == -1) {
                n = this.url.getDefaultPort();
            }
            if (object == null) {
                switch (authScheme) {
                    case KERBEROS: {
                        object = new NegotiateAuthentication(new HttpCallerInfo(authenticationHeader.getHttpCallerInfo(), "Kerberos"));
                        break;
                    }
                    case NEGOTIATE: {
                        object = new NegotiateAuthentication(new HttpCallerInfo(authenticationHeader.getHttpCallerInfo(), "Negotiate"));
                        break;
                    }
                    case BASIC: {
                        object2 = HttpURLConnection.privilegedRequestPasswordAuthentication(this.url.getHost(), inetAddress, n, this.url.getProtocol(), string2, string3, this.url, Authenticator.RequestorType.SERVER);
                        if (object2 == null) break;
                        object = new BasicAuthentication(false, this.url, string2, (PasswordAuthentication)object2);
                        break;
                    }
                    case DIGEST: {
                        object2 = HttpURLConnection.privilegedRequestPasswordAuthentication(this.url.getHost(), inetAddress, n, this.url.getProtocol(), string2, string3, this.url, Authenticator.RequestorType.SERVER);
                        if (object2 == null) break;
                        this.digestparams = new DigestAuthentication.Parameters();
                        object = new DigestAuthentication(false, this.url, string2, string3, (PasswordAuthentication)object2, this.digestparams);
                        break;
                    }
                    case NTLM: {
                        URL uRL;
                        if (!NTLMAuthenticationProxy.supported) break;
                        try {
                            uRL = new URL(this.url, "/");
                        }
                        catch (Exception exception) {
                            uRL = this.url;
                        }
                        if (this.tryTransparentNTLMServer) {
                            this.tryTransparentNTLMServer = NTLMAuthenticationProxy.supportsTransparentAuth;
                        }
                        object2 = null;
                        if (this.tryTransparentNTLMServer) {
                            HttpCapture.finest("Trying Transparent NTLM authentication");
                        } else {
                            object2 = HttpURLConnection.privilegedRequestPasswordAuthentication(this.url.getHost(), inetAddress, n, this.url.getProtocol(), "", string3, this.url, Authenticator.RequestorType.SERVER);
                        }
                        if (this.tryTransparentNTLMServer || !this.tryTransparentNTLMServer && object2 != null) {
                            object = NTLMAuthenticationProxy.proxy.create(false, uRL, (PasswordAuthentication)object2);
                        }
                        this.tryTransparentNTLMServer = false;
                        break;
                    }
                    case UNKNOWN: {
                        HttpCapture.finest("Unknown/Unsupported authentication scheme: " + string3);
                    }
                    default: {
                        throw new AssertionError((Object)"should not reach here");
                    }
                }
            }
            if (object == null && defaultAuth != null && defaultAuth.schemeSupported(string3) && (object2 = defaultAuth.authString(this.url, string3, string2)) != null) {
                object = new BasicAuthentication(false, this.url, string2, (String)object2);
            }
            if (object != null && !((AuthenticationInfo)object).setHeaders(this, headerParser, string)) {
                object = null;
            }
        }
        if (HttpCapture.isLoggable("FINER")) {
            HttpCapture.finer("Server Authentication for " + authenticationHeader.toString() + " returned " + (object != null ? object.toString() : "null"));
        }
        return object;
    }

    private void checkResponseCredentials(boolean bl) throws IOException {
        try {
            String string;
            if (!this.needToCheck) {
                return;
            }
            if (validateProxy && this.currentProxyCredentials != null) {
                string = this.responses.findValue("Proxy-Authentication-Info");
                if (bl || string != null) {
                    this.currentProxyCredentials.checkResponse(string, this.method, this.url);
                    this.currentProxyCredentials = null;
                }
            }
            if (validateServer && this.currentServerCredentials != null) {
                string = this.responses.findValue("Authentication-Info");
                if (bl || string != null) {
                    this.currentServerCredentials.checkResponse(string, this.method, this.url);
                    this.currentServerCredentials = null;
                }
            }
            if (this.currentServerCredentials == null && this.currentProxyCredentials == null) {
                this.needToCheck = false;
            }
        }
        catch (IOException iOException) {
            this.disconnectInternal();
            this.connected = false;
            throw iOException;
        }
    }

    private boolean followRedirect() throws IOException {
        URL uRL;
        if (!this.getInstanceFollowRedirects()) {
            return false;
        }
        int n = this.getResponseCode();
        if (n < 300 || n > 307 || n == 306 || n == 304) {
            return false;
        }
        String string = this.getHeaderField("Location");
        if (string == null) {
            return false;
        }
        try {
            uRL = new URL(string);
            if (!this.url.getProtocol().equalsIgnoreCase(uRL.getProtocol())) {
                return false;
            }
        }
        catch (MalformedURLException malformedURLException) {
            uRL = new URL(this.url, string);
        }
        this.disconnectInternal();
        if (this.streaming()) {
            throw new HttpRetryException(RETRY_MSG3, n, string);
        }
        if (HttpCapture.isLoggable("FINE")) {
            HttpCapture.fine("Redirected from " + this.url + " to " + uRL);
        }
        this.responses = new MessageHeader();
        if (n == 305) {
            String string2 = uRL.getHost();
            int n2 = uRL.getPort();
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkConnect(string2, n2);
            }
            this.setProxiedClient(this.url, string2, n2);
            this.requests.set(0, this.method + " " + this.http.getURLFile() + " " + httpVersion, null);
            this.connected = true;
            this.useProxyResponseCode = true;
        } else {
            this.url = uRL;
            if (this.method.equals("POST") && !Boolean.getBoolean("http.strictPostRedirect") && n != 307) {
                this.requests = new MessageHeader();
                this.setRequests = false;
                this.setRequestMethod("GET");
                this.poster = null;
                if (!this.checkReuseConnection()) {
                    this.connect();
                }
            } else {
                if (!this.checkReuseConnection()) {
                    this.connect();
                }
                if (this.http != null) {
                    this.requests.set(0, this.method + " " + this.http.getURLFile() + " " + httpVersion, null);
                    int n3 = this.url.getPort();
                    String string3 = this.url.getHost();
                    if (n3 != -1 && n3 != this.url.getDefaultPort()) {
                        string3 = string3 + ":" + String.valueOf(n3);
                    }
                    this.requests.set("Host", string3);
                }
            }
        }
        return true;
    }

    private void reset() throws IOException {
        this.http.reuse = true;
        this.reuseClient = this.http;
        InputStream inputStream = this.http.getInputStream();
        if (!this.method.equals("HEAD")) {
            block12: {
                try {
                    if (inputStream instanceof ChunkedInputStream || inputStream instanceof MeteredStream) {
                        while (inputStream.read(this.cdata) > 0) {
                        }
                        break block12;
                    }
                    long l = 0L;
                    int n = 0;
                    String string = this.responses.findValue("Content-Length");
                    if (string != null) {
                        try {
                            l = Long.parseLong(string);
                        }
                        catch (NumberFormatException numberFormatException) {
                            l = 0L;
                        }
                    }
                    for (long i = 0L; i < l && (n = inputStream.read(this.cdata)) != -1; i += (long)n) {
                    }
                }
                catch (IOException iOException) {
                    this.http.reuse = false;
                    this.reuseClient = null;
                    this.disconnectInternal();
                    return;
                }
            }
            try {
                if (inputStream instanceof MeteredStream) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.responseCode = -1;
        this.responses = new MessageHeader();
        this.connected = false;
    }

    private void disconnectInternal() {
        this.responseCode = -1;
        if (this.pi != null) {
            this.pi.finishTracking();
            this.pi = null;
        }
        if (this.http != null) {
            this.http.closeServer();
            this.http = null;
            this.connected = false;
        }
    }

    public void disconnect() {
        this.responseCode = -1;
        if (this.pi != null) {
            this.pi.finishTracking();
            this.pi = null;
        }
        if (this.http != null) {
            if (this.inputStream != null) {
                HttpClient httpClient = this.http;
                boolean bl = httpClient.isKeepingAlive();
                try {
                    this.inputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (bl) {
                    httpClient.closeIdleConnection();
                }
            } else {
                this.http.setDoNotRetry(true);
                this.http.closeServer();
            }
            this.http = null;
            this.connected = false;
        }
        this.cachedInputStream = null;
        if (this.cachedHeaders != null) {
            this.cachedHeaders.reset();
        }
    }

    public boolean usingProxy() {
        if (this.http != null) {
            return this.http.getProxyHostUsed() != null;
        }
        return false;
    }

    public String getHeaderField(String string) {
        try {
            this.getInputStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.cachedHeaders != null) {
            return this.cachedHeaders.findValue(string);
        }
        return this.responses.findValue(string);
    }

    public Map getHeaderFields() {
        try {
            this.getInputStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.cachedHeaders != null) {
            return this.cachedHeaders.getHeaders();
        }
        return this.responses.getHeaders();
    }

    public String getHeaderField(int n) {
        try {
            this.getInputStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.cachedHeaders != null) {
            return this.cachedHeaders.getValue(n);
        }
        return this.responses.getValue(n);
    }

    public String getHeaderFieldKey(int n) {
        try {
            this.getInputStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.cachedHeaders != null) {
            return this.cachedHeaders.getKey(n);
        }
        return this.responses.getKey(n);
    }

    public void setRequestProperty(String string, String string2) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        if (string == null) {
            throw new NullPointerException("key is null");
        }
        if (this.isExternalMessageHeaderAllowed(string, string2)) {
            this.requests.set(string, string2);
        }
    }

    public void addRequestProperty(String string, String string2) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        if (string == null) {
            throw new NullPointerException("key is null");
        }
        if (this.isExternalMessageHeaderAllowed(string, string2)) {
            this.requests.add(string, string2);
        }
    }

    void setAuthenticationProperty(String string, String string2) {
        this.checkMessageHeader(string, string2);
        this.requests.set(string, string2);
    }

    public String getRequestProperty(String string) {
        if (string == null) {
            return null;
        }
        for (int i = 0; i < EXCLUDE_HEADERS.length; ++i) {
            if (!string.equalsIgnoreCase(EXCLUDE_HEADERS[i])) continue;
            return null;
        }
        if (!this.setUserCookies) {
            if (string.equalsIgnoreCase("Cookie")) {
                return this.userCookies;
            }
            if (string.equalsIgnoreCase("Cookie2")) {
                return this.userCookies2;
            }
        }
        return this.requests.findValue(string);
    }

    public synchronized Map getRequestProperties() {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        if (this.setUserCookies) {
            return this.requests.getHeaders(EXCLUDE_HEADERS);
        }
        HashMap<String, String> hashMap = null;
        if (this.userCookies != null || this.userCookies2 != null) {
            hashMap = new HashMap<String, String>();
            if (this.userCookies != null) {
                hashMap.put("Cookie", this.userCookies);
            }
            if (this.userCookies2 != null) {
                hashMap.put("Cookie2", this.userCookies2);
            }
        }
        return this.requests.filterAndAddHeaders(EXCLUDE_HEADERS2, hashMap);
    }

    public void setConnectTimeout(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("timeouts can't be negative");
        }
        this.connectTimeout = n;
    }

    public int getConnectTimeout() {
        return this.connectTimeout < 0 ? 0 : this.connectTimeout;
    }

    public void setReadTimeout(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("timeouts can't be negative");
        }
        this.readTimeout = n;
    }

    public int getReadTimeout() {
        return this.readTimeout < 0 ? 0 : this.readTimeout;
    }

    String getMethod() {
        return this.method;
    }

    private MessageHeader mapToMessageHeader(Map map) {
        MessageHeader messageHeader = new MessageHeader();
        if (map == null || map.isEmpty()) {
            return messageHeader;
        }
        Set set = map.entrySet();
        for (Map.Entry entry : set) {
            String string = (String)entry.getKey();
            List list = (List)entry.getValue();
            for (String string2 : list) {
                if (string == null) {
                    messageHeader.prepend(string, string2);
                    continue;
                }
                messageHeader.add(string, string2);
            }
        }
        return messageHeader;
    }

    static {
        enableESBuffer = false;
        timeout4ESBuffer = 0;
        bufSize4ES = 0;
        restrictedHeaders = new String[]{"Access-Control-Request-Headers", "Access-Control-Request-Method", "Connection", "Content-Length", "Content-Transfer-Encoding", "Expect", "Host", "Keep-Alive", "Origin", "Trailer", "Transfer-Encoding", "Upgrade", "Via"};
        maxRedirects = AccessController.doPrivileged(new GetIntegerAction("http.maxRedirects", 20));
        version = AccessController.doPrivileged(new GetPropertyAction("java.version"));
        String string = AccessController.doPrivileged(new GetPropertyAction("http.agent"));
        string = string == null ? "Java/" + version : string + " Java/" + version;
        userAgent = string;
        validateProxy = AccessController.doPrivileged(new GetBooleanAction("http.auth.digest.validateProxy"));
        validateServer = AccessController.doPrivileged(new GetBooleanAction("http.auth.digest.validateServer"));
        enableESBuffer = AccessController.doPrivileged(new GetBooleanAction("sun.net.http.errorstream.enableBuffering"));
        timeout4ESBuffer = AccessController.doPrivileged(new GetIntegerAction("sun.net.http.errorstream.timeout", 300));
        if (timeout4ESBuffer <= 0) {
            timeout4ESBuffer = 300;
        }
        if ((bufSize4ES = AccessController.doPrivileged(new GetIntegerAction("sun.net.http.errorstream.bufferSize", 4096)).intValue()) <= 0) {
            bufSize4ES = 4096;
        }
        if (!(allowRestrictedHeaders = AccessController.doPrivileged(new GetBooleanAction("sun.net.http.allowRestrictedHeaders")).booleanValue())) {
            restrictedHeaderSet = new HashSet<String>(restrictedHeaders.length);
            for (int i = 0; i < restrictedHeaders.length; ++i) {
                restrictedHeaderSet.add(restrictedHeaders[i].toLowerCase());
            }
        } else {
            restrictedHeaderSet = null;
        }
        EXCLUDE_HEADERS = new String[]{"Proxy-Authorization", "Authorization"};
        EXCLUDE_HEADERS2 = new String[]{"Proxy-Authorization", "Authorization", "Cookie", "Cookie2"};
    }

    static class ErrorStream
    extends InputStream {
        ByteBuffer buffer;
        InputStream is;

        private ErrorStream(ByteBuffer byteBuffer) {
            this.buffer = byteBuffer;
            this.is = null;
        }

        private ErrorStream(ByteBuffer byteBuffer, InputStream inputStream) {
            this.buffer = byteBuffer;
            this.is = inputStream;
        }

        public static InputStream getErrorStream(InputStream inputStream, int n, HttpClient httpClient) {
            if (n == 0) {
                return null;
            }
            try {
                int n2 = httpClient.getReadTimeout();
                httpClient.setReadTimeout(timeout4ESBuffer / 5);
                int n3 = 0;
                boolean bl = false;
                if (n < 0) {
                    n3 = bufSize4ES;
                    bl = true;
                } else {
                    n3 = n;
                }
                if (n3 <= bufSize4ES) {
                    byte[] byArray = new byte[n3];
                    int n4 = 0;
                    int n5 = 0;
                    int n6 = 0;
                    do {
                        try {
                            n6 = inputStream.read(byArray, n4, byArray.length - n4);
                            if (n6 < 0) {
                                if (n < 0) break;
                                throw new IOException("the server closes before sending " + n + " bytes of data");
                            }
                            n4 += n6;
                        }
                        catch (SocketTimeoutException socketTimeoutException) {
                            n5 += timeout4ESBuffer / 5;
                        }
                    } while (n4 < n3 && n5 < timeout4ESBuffer);
                    httpClient.setReadTimeout(n2);
                    if (n4 == 0) {
                        return null;
                    }
                    if (n4 == n3 && !bl || bl && n6 < 0) {
                        inputStream.close();
                        return new ErrorStream(ByteBuffer.wrap(byArray, 0, n4));
                    }
                    return new ErrorStream(ByteBuffer.wrap(byArray, 0, n4), inputStream);
                }
                return null;
            }
            catch (IOException iOException) {
                return null;
            }
        }

        public int available() throws IOException {
            if (this.is == null) {
                return this.buffer.remaining();
            }
            return this.buffer.remaining() + this.is.available();
        }

        public int read() throws IOException {
            byte[] byArray = new byte[1];
            int n = this.read(byArray);
            return n == -1 ? n : byArray[0] & 0xFF;
        }

        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = this.buffer.remaining();
            if (n3 > 0) {
                int n4 = n3 < n2 ? n3 : n2;
                this.buffer.get(byArray, n, n4);
                return n4;
            }
            if (this.is == null) {
                return -1;
            }
            return this.is.read(byArray, n, n2);
        }

        public void close() throws IOException {
            this.buffer = null;
            if (this.is != null) {
                this.is.close();
            }
        }
    }

    class StreamingOutputStream
    extends FilterOutputStream {
        int expected;
        int written;
        boolean closed;
        boolean error;
        IOException errorExcp;

        StreamingOutputStream(OutputStream outputStream, int n) {
            super(outputStream);
            this.expected = n;
            this.written = 0;
            this.closed = false;
            this.error = false;
        }

        public void write(int n) throws IOException {
            this.checkError();
            ++this.written;
            if (this.expected != -1 && this.written > this.expected) {
                throw new IOException("too many bytes written");
            }
            this.out.write(n);
        }

        public void write(byte[] byArray) throws IOException {
            this.write(byArray, 0, byArray.length);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.checkError();
            this.written += n2;
            if (this.expected != -1 && this.written > this.expected) {
                this.out.close();
                throw new IOException("too many bytes written");
            }
            this.out.write(byArray, n, n2);
        }

        void checkError() throws IOException {
            if (this.closed) {
                throw new IOException("Stream is closed");
            }
            if (this.error) {
                throw this.errorExcp;
            }
            if (((PrintStream)this.out).checkError()) {
                throw new IOException("Error writing request body to server");
            }
        }

        boolean writtenOK() {
            return this.closed && !this.error;
        }

        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (this.expected != -1) {
                if (this.written != this.expected) {
                    this.error = true;
                    this.errorExcp = new IOException("insufficient data written");
                    this.out.close();
                    throw this.errorExcp;
                }
                super.flush();
            } else {
                super.close();
                OutputStream outputStream = HttpURLConnection.this.http.getOutputStream();
                outputStream.write(13);
                outputStream.write(10);
                outputStream.flush();
            }
        }
    }

    class HttpInputStream
    extends FilterInputStream {
        private CacheRequest cacheRequest;
        private OutputStream outputStream;
        private boolean marked;
        private int inCache;
        private int markCount;
        private byte[] skipBuffer;
        private static final int SKIP_BUFFER_SIZE = 8096;

        public HttpInputStream(InputStream inputStream) {
            super(inputStream);
            this.marked = false;
            this.inCache = 0;
            this.markCount = 0;
            this.cacheRequest = null;
            this.outputStream = null;
        }

        public HttpInputStream(InputStream inputStream, CacheRequest cacheRequest) {
            super(inputStream);
            this.marked = false;
            this.inCache = 0;
            this.markCount = 0;
            this.cacheRequest = cacheRequest;
            try {
                this.outputStream = cacheRequest.getBody();
            }
            catch (IOException iOException) {
                this.cacheRequest.abort();
                this.cacheRequest = null;
                this.outputStream = null;
            }
        }

        public synchronized void mark(int n) {
            super.mark(n);
            if (this.cacheRequest != null) {
                this.marked = true;
                this.markCount = 0;
            }
        }

        public synchronized void reset() throws IOException {
            super.reset();
            if (this.cacheRequest != null) {
                this.marked = false;
                this.inCache += this.markCount;
            }
        }

        public int read() throws IOException {
            try {
                byte[] byArray = new byte[1];
                int n = this.read(byArray);
                return n == -1 ? n : byArray[0] & 0xFF;
            }
            catch (IOException iOException) {
                if (this.cacheRequest != null) {
                    this.cacheRequest.abort();
                }
                throw iOException;
            }
        }

        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            try {
                int n3;
                int n4 = super.read(byArray, n, n2);
                if (this.inCache > 0) {
                    if (this.inCache >= n4) {
                        this.inCache -= n4;
                        n3 = 0;
                    } else {
                        n3 = n4 - this.inCache;
                        this.inCache = 0;
                    }
                } else {
                    n3 = n4;
                }
                if (n3 > 0 && this.outputStream != null) {
                    this.outputStream.write(byArray, n + (n4 - n3), n3);
                }
                if (this.marked) {
                    this.markCount += n4;
                }
                return n4;
            }
            catch (IOException iOException) {
                if (this.cacheRequest != null) {
                    this.cacheRequest.abort();
                }
                throw iOException;
            }
        }

        public void close() throws IOException {
            try {
                try {
                    if (this.outputStream != null) {
                        if (this.read() != -1) {
                            this.cacheRequest.abort();
                        } else {
                            this.outputStream.close();
                        }
                    }
                    super.close();
                }
                catch (IOException iOException) {
                    if (this.cacheRequest != null) {
                        this.cacheRequest.abort();
                    }
                    throw iOException;
                }
                Object var3_1 = null;
                HttpURLConnection.this.http = null;
            }
            catch (Throwable throwable) {
                Object var3_2 = null;
                HttpURLConnection.this.http = null;
                HttpURLConnection.this.checkResponseCredentials(true);
                throw throwable;
            }
            HttpURLConnection.this.checkResponseCredentials(true);
        }

        public long skip(long l) throws IOException {
            int n;
            long l2 = l;
            if (this.skipBuffer == null) {
                this.skipBuffer = new byte[8096];
            }
            byte[] byArray = this.skipBuffer;
            if (l <= 0L) {
                return 0L;
            }
            while (l2 > 0L && (n = this.read(byArray, 0, (int)Math.min(8096L, l2))) >= 0) {
                l2 -= (long)n;
            }
            return l - l2;
        }
    }
}

