/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.http;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.CacheRequest;
import java.net.CookieHandler;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Locale;
import sun.net.NetworkClient;
import sun.net.ProgressSource;
import sun.net.www.HeaderParser;
import sun.net.www.MessageHeader;
import sun.net.www.MeteredStream;
import sun.net.www.ParseUtil;
import sun.net.www.URLConnection;
import sun.net.www.http.ChunkedInputStream;
import sun.net.www.http.HttpCapture;
import sun.net.www.http.HttpCaptureInputStream;
import sun.net.www.http.HttpCaptureOutputStream;
import sun.net.www.http.KeepAliveCache;
import sun.net.www.http.KeepAliveStream;
import sun.net.www.http.PosterOutputStream;
import sun.net.www.protocol.http.HttpURLConnection;
import sun.security.action.GetPropertyAction;

public class HttpClient
extends NetworkClient {
    protected boolean cachedHttpClient = false;
    private boolean inCache;
    protected CookieHandler cookieHandler;
    MessageHeader requests;
    PosterOutputStream poster = null;
    boolean streaming;
    boolean failedOnce = false;
    private boolean ignoreContinue = true;
    private static final int HTTP_CONTINUE = 100;
    static final int httpPortNumber = 80;
    protected boolean proxyDisabled;
    public boolean usingProxy = false;
    protected String host;
    protected int port;
    protected static KeepAliveCache kac = new KeepAliveCache();
    private static boolean keepAliveProp = true;
    private static boolean retryPostProp = true;
    volatile boolean keepingAlive = false;
    int keepAliveConnections = -1;
    int keepAliveTimeout = 0;
    private CacheRequest cacheRequest = null;
    protected URL url;
    public boolean reuse = false;
    private HttpCapture capture = null;

    protected int getDefaultPort() {
        return 80;
    }

    private static int getDefaultPort(String string) {
        if ("http".equalsIgnoreCase(string)) {
            return 80;
        }
        if ("https".equalsIgnoreCase(string)) {
            return 443;
        }
        return -1;
    }

    @Deprecated
    public static synchronized void resetProperties() {
    }

    int getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public boolean getHttpKeepAliveSet() {
        return keepAliveProp;
    }

    protected HttpClient() {
    }

    private HttpClient(URL uRL) throws IOException {
        this(uRL, null, -1, false);
    }

    protected HttpClient(URL uRL, boolean bl) throws IOException {
        this(uRL, null, -1, bl);
    }

    public HttpClient(URL uRL, String string, int n) throws IOException {
        this(uRL, string, n, false);
    }

    protected HttpClient(URL uRL, Proxy proxy, int n) throws IOException {
        this.proxy = proxy == null ? Proxy.NO_PROXY : proxy;
        this.host = uRL.getHost();
        this.url = uRL;
        this.port = uRL.getPort();
        if (this.port == -1) {
            this.port = this.getDefaultPort();
        }
        this.setConnectTimeout(n);
        this.cookieHandler = (CookieHandler)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return CookieHandler.getDefault();
            }
        });
        this.capture = HttpCapture.getCapture(uRL);
        this.openServer();
    }

    protected static Proxy newHttpProxy(String string, int n, String string2) {
        if (string == null || string2 == null) {
            return Proxy.NO_PROXY;
        }
        int n2 = n < 0 ? HttpClient.getDefaultPort(string2) : n;
        InetSocketAddress inetSocketAddress = InetSocketAddress.createUnresolved(string, n2);
        return new Proxy(Proxy.Type.HTTP, inetSocketAddress);
    }

    private HttpClient(URL uRL, String string, int n, boolean bl) throws IOException {
        this(uRL, bl ? Proxy.NO_PROXY : HttpClient.newHttpProxy(string, n, "http"), -1);
    }

    public HttpClient(URL uRL, String string, int n, boolean bl, int n2) throws IOException {
        this(uRL, bl ? Proxy.NO_PROXY : HttpClient.newHttpProxy(string, n, "http"), n2);
    }

    public static HttpClient New(URL uRL) throws IOException {
        return HttpClient.New(uRL, Proxy.NO_PROXY, -1, true);
    }

    public static HttpClient New(URL uRL, boolean bl) throws IOException {
        return HttpClient.New(uRL, Proxy.NO_PROXY, -1, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpClient New(URL uRL, Proxy proxy, int n, boolean bl) throws IOException {
        Object object;
        if (proxy == null) {
            proxy = Proxy.NO_PROXY;
        }
        HttpClient httpClient = null;
        if (bl && (httpClient = (HttpClient)kac.get(uRL, null)) != null) {
            if (httpClient.proxy != null && httpClient.proxy.equals(proxy) || httpClient.proxy == null && proxy == null) {
                object = httpClient;
                synchronized (object) {
                    httpClient.cachedHttpClient = true;
                    assert (httpClient.inCache);
                    httpClient.inCache = false;
                    if (HttpCapture.isLoggable("FINEST")) {
                        HttpCapture.finest("KeepAlive stream retrieved from the cache, " + httpClient);
                    }
                }
            }
            object = httpClient;
            synchronized (object) {
                httpClient.inCache = false;
                httpClient.closeServer();
            }
            httpClient = null;
        }
        if (httpClient == null) {
            httpClient = new HttpClient(uRL, proxy, n);
        } else {
            object = System.getSecurityManager();
            if (object != null) {
                if (httpClient.proxy == Proxy.NO_PROXY || httpClient.proxy == null) {
                    ((SecurityManager)object).checkConnect(InetAddress.getByName(uRL.getHost()).getHostAddress(), uRL.getPort());
                } else {
                    ((SecurityManager)object).checkConnect(uRL.getHost(), uRL.getPort());
                }
            }
            httpClient.url = uRL;
        }
        return httpClient;
    }

    public static HttpClient New(URL uRL, Proxy proxy, int n) throws IOException {
        return HttpClient.New(uRL, proxy, n, true);
    }

    public static HttpClient New(URL uRL, String string, int n, boolean bl) throws IOException {
        return HttpClient.New(uRL, HttpClient.newHttpProxy(string, n, "http"), -1, bl);
    }

    public static HttpClient New(URL uRL, String string, int n, boolean bl, int n2) throws IOException {
        return HttpClient.New(uRL, HttpClient.newHttpProxy(string, n, "http"), n2, bl);
    }

    public void finished() {
        if (this.reuse) {
            return;
        }
        --this.keepAliveConnections;
        this.poster = null;
        if (this.keepAliveConnections > 0 && this.isKeepingAlive() && !this.serverOutput.checkError()) {
            this.putInKeepAliveCache();
        } else {
            this.closeServer();
        }
    }

    protected synchronized void putInKeepAliveCache() {
        if (this.inCache) {
            assert (false) : "Duplicate put to keep alive cache";
            return;
        }
        this.inCache = true;
        kac.put(this.url, null, this);
    }

    protected synchronized boolean isInKeepAliveCache() {
        return this.inCache;
    }

    public void closeIdleConnection() {
        HttpClient httpClient = (HttpClient)kac.get(this.url, null);
        if (httpClient != null) {
            httpClient.closeServer();
        }
    }

    public void openServer(String string, int n) throws IOException {
        this.serverSocket = this.doConnect(string, n);
        try {
            OutputStream outputStream = this.serverSocket.getOutputStream();
            if (this.capture != null) {
                outputStream = new HttpCaptureOutputStream(outputStream, this.capture);
            }
            this.serverOutput = new PrintStream(new BufferedOutputStream(outputStream), false, encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InternalError(encoding + " encoding not found");
        }
        this.serverSocket.setTcpNoDelay(true);
    }

    public boolean needsTunneling() {
        return false;
    }

    public synchronized boolean isCachedConnection() {
        return this.cachedHttpClient;
    }

    public void afterConnect() throws IOException, UnknownHostException {
    }

    private synchronized void privilegedOpenServer(final InetSocketAddress inetSocketAddress) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    HttpClient.this.openServer(inetSocketAddress.getHostName(), inetSocketAddress.getPort());
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    private void superOpenServer(String string, int n) throws IOException, UnknownHostException {
        super.openServer(string, n);
    }

    protected synchronized void openServer() throws IOException {
        SecurityManager securityManager = System.getSecurityManager();
        if (this.keepingAlive) {
            if (securityManager != null) {
                securityManager.checkConnect(this.host, this.port);
            }
            return;
        }
        if (this.url.getProtocol().equals("http") || this.url.getProtocol().equals("https")) {
            if (this.proxy != null && this.proxy.type() == Proxy.Type.HTTP) {
                URLConnection.setProxiedHost(this.host);
                if (securityManager != null) {
                    securityManager.checkConnect(this.host, this.port);
                }
                this.privilegedOpenServer((InetSocketAddress)this.proxy.address());
                this.usingProxy = true;
                return;
            }
            if (securityManager != null) {
                securityManager.checkConnect(this.host, this.port);
            }
            this.openServer(this.host, this.port);
            this.usingProxy = false;
            return;
        }
        if (this.proxy != null && this.proxy.type() == Proxy.Type.HTTP) {
            URLConnection.setProxiedHost(this.host);
            if (securityManager != null) {
                securityManager.checkConnect(this.host, this.port);
            }
            this.privilegedOpenServer((InetSocketAddress)this.proxy.address());
            this.usingProxy = true;
            return;
        }
        if (securityManager != null) {
            securityManager.checkConnect(this.host, this.port);
        }
        super.openServer(this.host, this.port);
        this.usingProxy = false;
    }

    public String getURLFile() throws IOException {
        String string = this.url.getFile();
        if (string == null || string.length() == 0) {
            string = "/";
        }
        if (this.usingProxy && !this.proxyDisabled) {
            StringBuffer stringBuffer = new StringBuffer(128);
            stringBuffer.append(this.url.getProtocol());
            stringBuffer.append(":");
            if (this.url.getAuthority() != null && this.url.getAuthority().length() > 0) {
                stringBuffer.append("//");
                stringBuffer.append(this.url.getAuthority());
            }
            if (this.url.getPath() != null) {
                stringBuffer.append(this.url.getPath());
            }
            if (this.url.getQuery() != null) {
                stringBuffer.append('?');
                stringBuffer.append(this.url.getQuery());
            }
            string = stringBuffer.toString();
        }
        if (string.indexOf(10) == -1) {
            return string;
        }
        throw new MalformedURLException("Illegal character in URL");
    }

    @Deprecated
    public void writeRequests(MessageHeader messageHeader) {
        this.requests = messageHeader;
        this.requests.print(this.serverOutput);
        this.serverOutput.flush();
    }

    public void writeRequests(MessageHeader messageHeader, PosterOutputStream posterOutputStream) throws IOException {
        this.requests = messageHeader;
        this.requests.print(this.serverOutput);
        this.poster = posterOutputStream;
        if (this.poster != null) {
            this.poster.writeTo(this.serverOutput);
        }
        this.serverOutput.flush();
    }

    public void writeRequests(MessageHeader messageHeader, PosterOutputStream posterOutputStream, boolean bl) throws IOException {
        this.streaming = bl;
        this.writeRequests(messageHeader, posterOutputStream);
    }

    public boolean parseHTTP(MessageHeader messageHeader, ProgressSource progressSource, HttpURLConnection httpURLConnection) throws IOException {
        try {
            this.serverInput = this.serverSocket.getInputStream();
            if (this.capture != null) {
                this.serverInput = new HttpCaptureInputStream(this.serverInput, this.capture);
            }
            this.serverInput = new BufferedInputStream(this.serverInput);
            return this.parseHTTPHeader(messageHeader, progressSource, httpURLConnection);
        }
        catch (SocketTimeoutException socketTimeoutException) {
            if (this.ignoreContinue) {
                this.closeServer();
            }
            throw socketTimeoutException;
        }
        catch (IOException iOException) {
            this.closeServer();
            this.cachedHttpClient = false;
            if (!this.failedOnce && this.requests != null) {
                this.failedOnce = true;
                if (!httpURLConnection.getRequestMethod().equals("POST") || retryPostProp && !this.streaming) {
                    this.openServer();
                    if (this.needsTunneling()) {
                        httpURLConnection.doTunneling();
                    }
                    this.afterConnect();
                    this.writeRequests(this.requests, this.poster);
                    return this.parseHTTP(messageHeader, progressSource, httpURLConnection);
                }
            }
            throw iOException;
        }
    }

    private boolean parseHTTPHeader(MessageHeader messageHeader, ProgressSource progressSource, HttpURLConnection httpURLConnection) throws IOException {
        int n;
        int n2;
        this.keepAliveConnections = -1;
        this.keepAliveTimeout = 0;
        boolean bl = false;
        byte[] byArray = new byte[8];
        this.serverInput.mark(10);
        for (n = 0; n < 8 && (n2 = this.serverInput.read(byArray, n, 8 - n)) >= 0; n += n2) {
        }
        String string = null;
        bl = byArray[0] == 72 && byArray[1] == 84 && byArray[2] == 84 && byArray[3] == 80 && byArray[4] == 47 && byArray[5] == 49 && byArray[6] == 46;
        this.serverInput.reset();
        if (bl) {
            Object object;
            messageHeader.parseHeader(this.serverInput);
            if (this.cookieHandler != null && (object = ParseUtil.toURI(this.url)) != null) {
                this.cookieHandler.put((URI)object, messageHeader.getHeaders());
            }
            if (this.usingProxy) {
                string = messageHeader.findValue("Proxy-Connection");
            }
            if (string == null) {
                string = messageHeader.findValue("Connection");
            }
            if (string != null && string.toLowerCase(Locale.US).equals("keep-alive")) {
                object = new HeaderParser(messageHeader.findValue("Keep-Alive"));
                if (object != null) {
                    this.keepAliveConnections = ((HeaderParser)object).findInt("max", this.usingProxy ? 50 : 5);
                    this.keepAliveTimeout = ((HeaderParser)object).findInt("timeout", this.usingProxy ? 60 : 5);
                }
            } else if (byArray[7] != 48) {
                this.keepAliveConnections = string != null ? 1 : 5;
            }
        } else {
            if (n != 8) {
                if (!this.failedOnce && this.requests != null) {
                    this.failedOnce = true;
                    if (!httpURLConnection.getRequestMethod().equals("POST") || retryPostProp && !this.streaming) {
                        this.closeServer();
                        this.cachedHttpClient = false;
                        this.openServer();
                        if (this.needsTunneling()) {
                            httpURLConnection.doTunneling();
                        }
                        this.afterConnect();
                        this.writeRequests(this.requests, this.poster);
                        return this.parseHTTP(messageHeader, progressSource, httpURLConnection);
                    }
                }
                throw new SocketException("Unexpected end of file from server");
            }
            messageHeader.set("Content-type", "unknown/unknown");
        }
        n = -1;
        try {
            string = messageHeader.getValue(0);
            int n3 = string.indexOf(32);
            while (string.charAt(n3) == ' ') {
                ++n3;
            }
            n = Integer.parseInt(string.substring(n3, n3 + 3));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n == 100 && this.ignoreContinue) {
            messageHeader.reset();
            return this.parseHTTPHeader(messageHeader, progressSource, httpURLConnection);
        }
        long l = -1L;
        String string2 = messageHeader.findValue("Transfer-Encoding");
        if (string2 != null && string2.equalsIgnoreCase("chunked")) {
            this.serverInput = new ChunkedInputStream(this.serverInput, this, messageHeader);
            if (this.keepAliveConnections <= 1) {
                this.keepAliveConnections = 1;
                this.keepingAlive = false;
            } else {
                this.keepingAlive = true;
            }
            this.failedOnce = false;
        } else {
            String string3;
            String string4 = messageHeader.findValue("content-length");
            if (string4 != null) {
                try {
                    l = Long.parseLong(string4);
                }
                catch (NumberFormatException numberFormatException) {
                    l = -1L;
                }
            }
            if ((string3 = this.requests.getKey(0)) != null && string3.startsWith("HEAD") || n == 304 || n == 204) {
                l = 0L;
            }
            if (this.keepAliveConnections > 1 && (l >= 0L || n == 304 || n == 204)) {
                this.keepingAlive = true;
                this.failedOnce = false;
            } else if (this.keepingAlive) {
                this.keepingAlive = false;
            }
        }
        if (l > 0L) {
            if (progressSource != null) {
                progressSource.setContentType(messageHeader.findValue("content-type"));
            }
            if (this.isKeepingAlive()) {
                if (HttpCapture.isLoggable("FINEST")) {
                    HttpCapture.finest("KeepAlive stream used: " + this.url);
                }
                this.serverInput = new KeepAliveStream(this.serverInput, progressSource, l, this);
                this.failedOnce = false;
            } else {
                this.serverInput = new MeteredStream(this.serverInput, progressSource, l);
            }
        } else if (l == -1L) {
            if (progressSource != null) {
                progressSource.setContentType(messageHeader.findValue("content-type"));
                this.serverInput = new MeteredStream(this.serverInput, progressSource, l);
            }
        } else if (progressSource != null) {
            progressSource.finishTracking();
        }
        return bl;
    }

    public synchronized InputStream getInputStream() {
        return this.serverInput;
    }

    public OutputStream getOutputStream() {
        return this.serverOutput;
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.url + ")";
    }

    public final boolean isKeepingAlive() {
        return this.getHttpKeepAliveSet() && this.keepingAlive;
    }

    public void setCacheRequest(CacheRequest cacheRequest) {
        this.cacheRequest = cacheRequest;
    }

    CacheRequest getCacheRequest() {
        return this.cacheRequest;
    }

    protected void finalize() throws Throwable {
    }

    public void setDoNotRetry(boolean bl) {
        this.failedOnce = bl;
    }

    public void setIgnoreContinue(boolean bl) {
        this.ignoreContinue = bl;
    }

    public void closeServer() {
        try {
            this.keepingAlive = false;
            this.serverSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getProxyHostUsed() {
        if (!this.usingProxy) {
            return null;
        }
        return ((InetSocketAddress)this.proxy.address()).getHostName();
    }

    public int getProxyPortUsed() {
        if (this.usingProxy) {
            return ((InetSocketAddress)this.proxy.address()).getPort();
        }
        return -1;
    }

    static {
        String string = AccessController.doPrivileged(new GetPropertyAction("http.keepAlive"));
        String string2 = AccessController.doPrivileged(new GetPropertyAction("sun.net.http.retryPost"));
        keepAliveProp = string != null ? Boolean.valueOf(string) : true;
        retryPostProp = string2 != null ? Boolean.valueOf(string2) : true;
    }
}

