/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.loops;

import java.awt.image.ColorModel;
import sun.java2d.loops.PixelWriter;

abstract class XorPixelWriter
extends PixelWriter {
    protected ColorModel dstCM;

    XorPixelWriter() {
    }

    public void writePixel(int n, int n2) {
        Object object = this.dstRast.getDataElements(n, n2, null);
        this.xorPixel(object);
        this.dstRast.setDataElements(n, n2, object);
    }

    protected abstract void xorPixel(Object var1);

    public static class DoubleData
    extends XorPixelWriter {
        long[] xorData;

        DoubleData(Object object, Object object2) {
            double[] dArray = (double[])object;
            double[] dArray2 = (double[])object2;
            this.xorData = new long[dArray.length];
            for (int i = 0; i < dArray.length; ++i) {
                this.xorData[i] = Double.doubleToLongBits(dArray[i]) ^ Double.doubleToLongBits(dArray2[i]);
            }
        }

        protected void xorPixel(Object object) {
            double[] dArray = (double[])object;
            for (int i = 0; i < dArray.length; ++i) {
                long l = Double.doubleToLongBits(dArray[i]) ^ this.xorData[i];
                dArray[i] = Double.longBitsToDouble(l);
            }
        }
    }

    public static class FloatData
    extends XorPixelWriter {
        int[] xorData;

        FloatData(Object object, Object object2) {
            float[] fArray = (float[])object;
            float[] fArray2 = (float[])object2;
            this.xorData = new int[fArray.length];
            for (int i = 0; i < fArray.length; ++i) {
                this.xorData[i] = Float.floatToIntBits(fArray[i]) ^ Float.floatToIntBits(fArray2[i]);
            }
        }

        protected void xorPixel(Object object) {
            float[] fArray = (float[])object;
            for (int i = 0; i < fArray.length; ++i) {
                int n = Float.floatToIntBits(fArray[i]) ^ this.xorData[i];
                fArray[i] = Float.intBitsToFloat(n);
            }
        }
    }

    public static class IntData
    extends XorPixelWriter {
        int[] xorData;

        IntData(Object object, Object object2) {
            this.xorData = (int[])object;
            this.xorPixel(object2);
            this.xorData = (int[])object2;
        }

        protected void xorPixel(Object object) {
            int[] nArray = (int[])object;
            for (int i = 0; i < nArray.length; ++i) {
                int n = i;
                nArray[n] = nArray[n] ^ this.xorData[i];
            }
        }
    }

    public static class ShortData
    extends XorPixelWriter {
        short[] xorData;

        ShortData(Object object, Object object2) {
            this.xorData = (short[])object;
            this.xorPixel(object2);
            this.xorData = (short[])object2;
        }

        protected void xorPixel(Object object) {
            short[] sArray = (short[])object;
            for (int i = 0; i < sArray.length; ++i) {
                int n = i;
                sArray[n] = (short)(sArray[n] ^ this.xorData[i]);
            }
        }
    }

    public static class ByteData
    extends XorPixelWriter {
        byte[] xorData;

        ByteData(Object object, Object object2) {
            this.xorData = (byte[])object;
            this.xorPixel(object2);
            this.xorData = (byte[])object2;
        }

        protected void xorPixel(Object object) {
            byte[] byArray = (byte[])object;
            for (int i = 0; i < byArray.length; ++i) {
                int n = i;
                byArray[n] = (byte)(byArray[n] ^ this.xorData[i]);
            }
        }
    }
}

