/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import sun.awt.X11.Native;
import sun.awt.X11.WindowPropertyGetter;
import sun.awt.X11.XAtomList;
import sun.awt.X11.XBaseWindow;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

public class XAtom {
    private static Unsafe unsafe = XlibWrapper.unsafe;
    private static XAtom[] emptyList = new XAtom[0];
    public static final long XA_PRIMARY = 1L;
    public static final long XA_SECONDARY = 2L;
    public static final long XA_ARC = 3L;
    public static final long XA_ATOM = 4L;
    public static final long XA_BITMAP = 5L;
    public static final long XA_CARDINAL = 6L;
    public static final long XA_COLORMAP = 7L;
    public static final long XA_CURSOR = 8L;
    public static final long XA_CUT_BUFFER0 = 9L;
    public static final long XA_CUT_BUFFER1 = 10L;
    public static final long XA_CUT_BUFFER2 = 11L;
    public static final long XA_CUT_BUFFER3 = 12L;
    public static final long XA_CUT_BUFFER4 = 13L;
    public static final long XA_CUT_BUFFER5 = 14L;
    public static final long XA_CUT_BUFFER6 = 15L;
    public static final long XA_CUT_BUFFER7 = 16L;
    public static final long XA_DRAWABLE = 17L;
    public static final long XA_FONT = 18L;
    public static final long XA_INTEGER = 19L;
    public static final long XA_PIXMAP = 20L;
    public static final long XA_POINT = 21L;
    public static final long XA_RECTANGLE = 22L;
    public static final long XA_RESOURCE_MANAGER = 23L;
    public static final long XA_RGB_COLOR_MAP = 24L;
    public static final long XA_RGB_BEST_MAP = 25L;
    public static final long XA_RGB_BLUE_MAP = 26L;
    public static final long XA_RGB_DEFAULT_MAP = 27L;
    public static final long XA_RGB_GRAY_MAP = 28L;
    public static final long XA_RGB_GREEN_MAP = 29L;
    public static final long XA_RGB_RED_MAP = 30L;
    public static final long XA_STRING = 31L;
    public static final long XA_VISUALID = 32L;
    public static final long XA_WINDOW = 33L;
    public static final long XA_WM_COMMAND = 34L;
    public static final long XA_WM_HINTS = 35L;
    public static final long XA_WM_CLIENT_MACHINE = 36L;
    public static final long XA_WM_ICON_NAME = 37L;
    public static final long XA_WM_ICON_SIZE = 38L;
    public static final long XA_WM_NAME = 39L;
    public static final long XA_WM_NORMAL_HINTS = 40L;
    public static final long XA_WM_SIZE_HINTS = 41L;
    public static final long XA_WM_ZOOM_HINTS = 42L;
    public static final long XA_MIN_SPACE = 43L;
    public static final long XA_NORM_SPACE = 44L;
    public static final long XA_MAX_SPACE = 45L;
    public static final long XA_END_SPACE = 46L;
    public static final long XA_SUPERSCRIPT_X = 47L;
    public static final long XA_SUPERSCRIPT_Y = 48L;
    public static final long XA_SUBSCRIPT_X = 49L;
    public static final long XA_SUBSCRIPT_Y = 50L;
    public static final long XA_UNDERLINE_POSITION = 51L;
    public static final long XA_UNDERLINE_THICKNESS = 52L;
    public static final long XA_STRIKEOUT_ASCENT = 53L;
    public static final long XA_STRIKEOUT_DESCENT = 54L;
    public static final long XA_ITALIC_ANGLE = 55L;
    public static final long XA_X_HEIGHT = 56L;
    public static final long XA_QUAD_WIDTH = 57L;
    public static final long XA_WEIGHT = 58L;
    public static final long XA_POINT_SIZE = 59L;
    public static final long XA_RESOLUTION = 60L;
    public static final long XA_COPYRIGHT = 61L;
    public static final long XA_NOTICE = 62L;
    public static final long XA_FONT_NAME = 63L;
    public static final long XA_FAMILY_NAME = 64L;
    public static final long XA_FULL_NAME = 65L;
    public static final long XA_CAP_HEIGHT = 66L;
    public static final long XA_WM_CLASS = 67L;
    public static final long XA_WM_TRANSIENT_FOR = 68L;
    public static final long XA_LAST_PREDEFINED = 68L;
    static HashMap<Long, XAtom> atomToAtom = new HashMap();
    static HashMap<String, XAtom> nameToAtom = new HashMap();
    long atom = 0L;
    String name;
    long display;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void register(XAtom xAtom) {
        if (xAtom == null) {
            return;
        }
        Class<XAtom> clazz = XAtom.class;
        synchronized (XAtom.class) {
            if (xAtom.atom != 0L) {
                atomToAtom.put(xAtom.atom, xAtom);
            }
            if (xAtom.name != null) {
                nameToAtom.put(xAtom.name, xAtom);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static XAtom lookup(long l) {
        Class<XAtom> clazz = XAtom.class;
        synchronized (XAtom.class) {
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return atomToAtom.get(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static XAtom lookup(String string) {
        Class<XAtom> clazz = XAtom.class;
        synchronized (XAtom.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return nameToAtom.get(string);
        }
    }

    static XAtom get(long l) {
        XAtom xAtom = XAtom.lookup(l);
        if (xAtom == null) {
            xAtom = new XAtom(XToolkit.getDisplay(), l);
        }
        return xAtom;
    }

    public static XAtom get(String string) {
        XAtom xAtom = XAtom.lookup(string);
        if (xAtom == null) {
            xAtom = new XAtom(string);
        }
        return xAtom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getName() {
        if (this.name == null) {
            XToolkit.awtLock();
            try {
                this.name = XlibWrapper.XGetAtomName(this.display, this.atom);
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                XToolkit.awtUnlock();
                throw throwable;
            }
            XToolkit.awtUnlock();
            this.register();
        }
        return this.name;
    }

    static String asString(long l) {
        XAtom xAtom = XAtom.lookup(l);
        if (xAtom == null) {
            return Long.toString(l);
        }
        return xAtom.toString();
    }

    void register() {
        XAtom.register(this);
    }

    public String toString() {
        if (this.name != null) {
            return this.name + ":" + this.atom;
        }
        return Long.toString(this.atom);
    }

    private XAtom(long l, String string) {
        this(l, string, true);
    }

    private XAtom(String string) {
        this(XToolkit.getDisplay(), string, true);
    }

    public XAtom(String string, boolean bl) {
        this(XToolkit.getDisplay(), string, bl);
    }

    public XAtom(long l, long l2) {
        this.atom = l2;
        this.display = l;
        this.register();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XAtom(long l, String string, boolean bl) {
        this.name = string;
        this.display = l;
        if (bl) {
            XToolkit.awtLock();
            try {
                this.atom = XlibWrapper.InternAtom(l, string, 0);
                Object var6_4 = null;
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                XToolkit.awtUnlock();
                throw throwable;
            }
            XToolkit.awtUnlock();
            {
            }
        }
        this.register();
    }

    public XAtom() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(long l, String string) {
        if (this.atom == 0L) {
            throw new IllegalStateException("Atom should be initialized");
        }
        this.checkWindow(l);
        XToolkit.awtLock();
        try {
            XlibWrapper.SetProperty(this.display, l, this.atom, string);
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            XToolkit.awtUnlock();
            throw throwable;
        }
        XToolkit.awtUnlock();
    }

    public void setPropertyUTF8(long l, String string) {
        XAtom xAtom = XAtom.get("UTF8_STRING");
        if (this.atom == 0L) {
            throw new IllegalStateException("Atom should be initialized");
        }
        this.checkWindow(l);
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        if (byArray != null) {
            this.setAtomData(l, xAtom.atom, byArray);
        }
    }

    public void setProperty8(long l, String string) {
        if (this.atom == 0L) {
            throw new IllegalStateException("Atom should be initialized");
        }
        this.checkWindow(l);
        byte[] byArray = null;
        try {
            byArray = string.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        if (byArray != null) {
            this.setAtomData(l, 31L, byArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getProperty(long l) {
        String string;
        if (this.atom == 0L) {
            throw new IllegalStateException("Atom should be initialized");
        }
        this.checkWindow(l);
        XToolkit.awtLock();
        try {
            string = XlibWrapper.GetProperty(this.display, l, this.atom);
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            XToolkit.awtUnlock();
            throw throwable;
        }
        XToolkit.awtUnlock();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long get32Property(long l, long l2) {
        WindowPropertyGetter windowPropertyGetter;
        block6: {
            block5: {
                if (this.atom == 0L) {
                    throw new IllegalStateException("Atom should be initialized");
                }
                this.checkWindow(l);
                windowPropertyGetter = new WindowPropertyGetter(l, this, 0L, 1L, false, l2);
                try {
                    int n = windowPropertyGetter.execute();
                    if (n == 0 && windowPropertyGetter.getData() != 0L) break block5;
                    long l3 = 0L;
                    Object var10_8 = null;
                    windowPropertyGetter.dispose();
                    return l3;
                }
                catch (Throwable throwable) {
                    Object var10_11 = null;
                    windowPropertyGetter.dispose();
                    throw throwable;
                }
            }
            if (windowPropertyGetter.getActualType() == l2 && windowPropertyGetter.getActualFormat() == 32) break block6;
            long l4 = 0L;
            Object var10_9 = null;
            windowPropertyGetter.dispose();
            return l4;
        }
        long l5 = Native.getCard32(windowPropertyGetter.getData());
        Object var10_10 = null;
        windowPropertyGetter.dispose();
        return l5;
    }

    public long getCard32Property(XBaseWindow xBaseWindow) {
        return this.get32Property(xBaseWindow.getWindow(), 6L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCard32Property(long l, long l2) {
        if (this.atom == 0L) {
            throw new IllegalStateException("Atom should be initialized");
        }
        this.checkWindow(l);
        XToolkit.awtLock();
        try {
            Native.putCard32(XlibWrapper.larg1, l2);
            XlibWrapper.XChangeProperty(XToolkit.getDisplay(), l, this.atom, 6L, 32, 0, XlibWrapper.larg1, 1);
            Object var6_3 = null;
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            XToolkit.awtUnlock();
            throw throwable;
        }
        XToolkit.awtUnlock();
    }

    public void setCard32Property(XBaseWindow xBaseWindow, long l) {
        this.setCard32Property(xBaseWindow.getWindow(), l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getAtomData(long l, long l2, int n) {
        WindowPropertyGetter windowPropertyGetter;
        block6: {
            block5: {
                if (this.atom == 0L) {
                    throw new IllegalStateException("Atom should be initialized");
                }
                this.checkWindow(l);
                windowPropertyGetter = new WindowPropertyGetter(l, this, 0L, (long)n, false, this);
                try {
                    int n2 = windowPropertyGetter.execute();
                    if (n2 == 0 && windowPropertyGetter.getData() != 0L) break block5;
                    boolean bl = false;
                    Object var10_9 = null;
                    windowPropertyGetter.dispose();
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var10_12 = null;
                    windowPropertyGetter.dispose();
                    throw throwable;
                }
            }
            if (windowPropertyGetter.getActualType() == this.atom && windowPropertyGetter.getActualFormat() == 32 && windowPropertyGetter.getNumberOfItems() == n) break block6;
            boolean bl = false;
            Object var10_10 = null;
            windowPropertyGetter.dispose();
            return bl;
        }
        XlibWrapper.memcpy(l2, windowPropertyGetter.getData(), n * XAtom.getAtomSize());
        boolean bl = true;
        Object var10_11 = null;
        windowPropertyGetter.dispose();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getAtomData(long l, long l2, long l3, int n) {
        WindowPropertyGetter windowPropertyGetter;
        block6: {
            block5: {
                if (this.atom == 0L) {
                    throw new IllegalStateException("Atom should be initialized");
                }
                this.checkWindow(l);
                windowPropertyGetter = new WindowPropertyGetter(l, this, 0L, (long)n, false, l2);
                try {
                    int n2 = windowPropertyGetter.execute();
                    if (n2 == 0 && windowPropertyGetter.getData() != 0L) break block5;
                    boolean bl = false;
                    Object var12_10 = null;
                    windowPropertyGetter.dispose();
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var12_13 = null;
                    windowPropertyGetter.dispose();
                    throw throwable;
                }
            }
            if (windowPropertyGetter.getActualType() == l2 && windowPropertyGetter.getActualFormat() == 32 && windowPropertyGetter.getNumberOfItems() == n) break block6;
            boolean bl = false;
            Object var12_11 = null;
            windowPropertyGetter.dispose();
            return bl;
        }
        XlibWrapper.memcpy(l3, windowPropertyGetter.getData(), n * XAtom.getAtomSize());
        boolean bl = true;
        Object var12_12 = null;
        windowPropertyGetter.dispose();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAtomData(long l, long l2, int n) {
        if (this.atom == 0L) {
            throw new IllegalStateException("Atom should be initialized");
        }
        this.checkWindow(l);
        XToolkit.awtLock();
        try {
            XlibWrapper.XChangeProperty(XToolkit.getDisplay(), l, this.atom, this.atom, 32, 0, l2, n);
            Object var7_4 = null;
        }
        catch (Throwable throwable) {
            Object var7_5 = null;
            XToolkit.awtUnlock();
            throw throwable;
        }
        XToolkit.awtUnlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAtomData(long l, long l2, long l3, int n) {
        if (this.atom == 0L) {
            throw new IllegalStateException("Atom should be initialized");
        }
        this.checkWindow(l);
        XToolkit.awtLock();
        try {
            XlibWrapper.XChangeProperty(XToolkit.getDisplay(), l, this.atom, l2, 32, 0, l3, n);
            Object var9_5 = null;
        }
        catch (Throwable throwable) {
            Object var9_6 = null;
            XToolkit.awtUnlock();
            throw throwable;
        }
        XToolkit.awtUnlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAtomData8(long l, long l2, long l3, int n) {
        if (this.atom == 0L) {
            throw new IllegalStateException("Atom should be initialized");
        }
        this.checkWindow(l);
        XToolkit.awtLock();
        try {
            XlibWrapper.XChangeProperty(XToolkit.getDisplay(), l, this.atom, l2, 8, 0, l3, n);
            Object var9_5 = null;
        }
        catch (Throwable throwable) {
            Object var9_6 = null;
            XToolkit.awtUnlock();
            throw throwable;
        }
        XToolkit.awtUnlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void DeleteProperty(long l) {
        if (this.atom == 0L) {
            throw new IllegalStateException("Atom should be initialized");
        }
        this.checkWindow(l);
        XToolkit.awtLock();
        try {
            XlibWrapper.XDeleteProperty(XToolkit.getDisplay(), l, this.atom);
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            XToolkit.awtUnlock();
            throw throwable;
        }
        XToolkit.awtUnlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void DeleteProperty(XBaseWindow xBaseWindow) {
        if (this.atom == 0L) {
            throw new IllegalStateException("Atom should be initialized");
        }
        this.checkWindow(xBaseWindow.getWindow());
        XToolkit.awtLock();
        try {
            XlibWrapper.XDeleteProperty(XToolkit.getDisplay(), xBaseWindow.getWindow(), this.atom);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            XToolkit.awtUnlock();
            throw throwable;
        }
        XToolkit.awtUnlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAtomData(long l, long l2, byte[] byArray) {
        long l3 = Native.toData(byArray);
        try {
            this.setAtomData8(l, l2, l3, byArray.length);
            Object var9_5 = null;
            unsafe.freeMemory(l3);
        }
        catch (Throwable throwable) {
            Object var9_6 = null;
            unsafe.freeMemory(l3);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getByteArrayProperty(long l, long l2) {
        byte[] byArray;
        WindowPropertyGetter windowPropertyGetter;
        block6: {
            block5: {
                if (this.atom == 0L) {
                    throw new IllegalStateException("Atom should be initialized");
                }
                this.checkWindow(l);
                windowPropertyGetter = new WindowPropertyGetter(l, this, 0L, 65535L, false, l2);
                try {
                    int n = windowPropertyGetter.execute();
                    if (n == 0 && windowPropertyGetter.getData() != 0L) break block5;
                    byte[] byArray2 = null;
                    Object var10_8 = null;
                    windowPropertyGetter.dispose();
                    return byArray2;
                }
                catch (Throwable throwable) {
                    Object var10_11 = null;
                    windowPropertyGetter.dispose();
                    throw throwable;
                }
            }
            if (windowPropertyGetter.getActualType() == l2 && windowPropertyGetter.getActualFormat() == 8) break block6;
            byte[] byArray3 = null;
            Object var10_9 = null;
            windowPropertyGetter.dispose();
            return byArray3;
        }
        byte[] byArray4 = byArray = XlibWrapper.getStringBytes(windowPropertyGetter.getData());
        Object var10_10 = null;
        windowPropertyGetter.dispose();
        return byArray4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void intern(boolean bl) {
        XToolkit.awtLock();
        try {
            this.atom = XlibWrapper.InternAtom(this.display, this.name, bl ? 1 : 0);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            XToolkit.awtUnlock();
            throw throwable;
        }
        XToolkit.awtUnlock();
        this.register();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInterned() {
        if (this.atom == 0L) {
            XToolkit.awtLock();
            try {
                this.atom = XlibWrapper.InternAtom(this.display, this.name, 1);
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                XToolkit.awtUnlock();
                throw throwable;
            }
            XToolkit.awtUnlock();
            if (this.atom == 0L) {
                return false;
            }
            this.register();
            return true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValues(long l, String string, boolean bl) {
        this.display = l;
        this.name = string;
        if (bl) {
            XToolkit.awtLock();
            try {
                this.atom = XlibWrapper.InternAtom(l, string, 0);
                Object var6_4 = null;
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                XToolkit.awtUnlock();
                throw throwable;
            }
            XToolkit.awtUnlock();
            {
            }
        }
        this.register();
    }

    public void setValues(long l, long l2) {
        this.display = l;
        this.atom = l2;
        this.register();
    }

    public void setValues(long l, String string, long l2) {
        this.display = l;
        this.atom = l2;
        this.name = string;
        this.register();
    }

    static int getAtomSize() {
        return Native.getLongSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    XAtom[] getAtomListProperty(long l) {
        int n;
        WindowPropertyGetter windowPropertyGetter;
        block9: {
            block8: {
                block7: {
                    if (this.atom == 0L) {
                        throw new IllegalStateException("Atom should be initialized");
                    }
                    this.checkWindow(l);
                    windowPropertyGetter = new WindowPropertyGetter(l, this, 0L, 65535L, false, 4L);
                    int n2 = windowPropertyGetter.execute();
                    if (n2 == 0 && windowPropertyGetter.getData() != 0L) break block7;
                    XAtom[] xAtomArray = emptyList;
                    Object var11_7 = null;
                    windowPropertyGetter.dispose();
                    return xAtomArray;
                }
                if (windowPropertyGetter.getActualType() == 4L && windowPropertyGetter.getActualFormat() == 32) break block8;
                XAtom[] xAtomArray = emptyList;
                Object var11_8 = null;
                windowPropertyGetter.dispose();
                return xAtomArray;
            }
            n = windowPropertyGetter.getNumberOfItems();
            if (n != 0) break block9;
            XAtom[] xAtomArray = emptyList;
            Object var11_9 = null;
            windowPropertyGetter.dispose();
            return xAtomArray;
        }
        try {
            long l2 = windowPropertyGetter.getData();
            XAtom[] xAtomArray = new XAtom[n];
            for (int i = 0; i < n; ++i) {
                xAtomArray[i] = XAtom.get(XAtom.getAtom(l2 + (long)(i * XAtom.getAtomSize())));
            }
            XAtom[] xAtomArray2 = xAtomArray;
            Object var11_10 = null;
            windowPropertyGetter.dispose();
            return xAtomArray2;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            windowPropertyGetter.dispose();
            throw throwable;
        }
    }

    XAtomList getAtomListPropertyList(long l) {
        return new XAtomList(this.getAtomListProperty(l));
    }

    XAtomList getAtomListPropertyList(XBaseWindow xBaseWindow) {
        return this.getAtomListPropertyList(xBaseWindow.getWindow());
    }

    XAtom[] getAtomListProperty(XBaseWindow xBaseWindow) {
        return this.getAtomListProperty(xBaseWindow.getWindow());
    }

    void setAtomListProperty(long l, XAtom[] xAtomArray) {
        long l2 = XAtom.toData(xAtomArray);
        this.setAtomData(l, 4L, l2, xAtomArray.length);
        unsafe.freeMemory(l2);
    }

    void setAtomListProperty(long l, XAtomList xAtomList) {
        long l2 = xAtomList.getAtomsData();
        this.setAtomData(l, 4L, l2, xAtomList.size());
        unsafe.freeMemory(l2);
    }

    public void setAtomListProperty(XBaseWindow xBaseWindow, XAtom[] xAtomArray) {
        this.setAtomListProperty(xBaseWindow.getWindow(), xAtomArray);
    }

    public void setAtomListProperty(XBaseWindow xBaseWindow, XAtomList xAtomList) {
        this.setAtomListProperty(xBaseWindow.getWindow(), xAtomList);
    }

    long getAtom() {
        return this.atom;
    }

    void putAtom(long l) {
        Native.putLong(l, this.atom);
    }

    static long getAtom(long l) {
        return Native.getLong(l);
    }

    static long toData(XAtom[] xAtomArray) {
        long l = unsafe.allocateMemory(XAtom.getAtomSize() * xAtomArray.length);
        for (int i = 0; i < xAtomArray.length; ++i) {
            if (xAtomArray[i] == null) continue;
            xAtomArray[i].putAtom(l + (long)(i * XAtom.getAtomSize()));
        }
        return l;
    }

    void checkWindow(long l) {
        if (l == 0L) {
            throw new IllegalArgumentException("Window must not be zero");
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof XAtom)) {
            return false;
        }
        XAtom xAtom = (XAtom)object;
        return this.atom == xAtom.atom && this.display == xAtom.display;
    }

    public int hashCode() {
        return (int)((this.atom ^ this.display) & 0xFFFFL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWindowProperty(long l, long l2) {
        if (this.atom == 0L) {
            throw new IllegalStateException("Atom should be initialized");
        }
        this.checkWindow(l);
        XToolkit.awtLock();
        try {
            Native.putWindow(XlibWrapper.larg1, l2);
            XlibWrapper.XChangeProperty(XToolkit.getDisplay(), l, this.atom, 33L, 32, 0, XlibWrapper.larg1, 1);
            Object var6_3 = null;
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            XToolkit.awtUnlock();
            throw throwable;
        }
        XToolkit.awtUnlock();
    }

    public void setWindowProperty(XBaseWindow xBaseWindow, XBaseWindow xBaseWindow2) {
        this.setWindowProperty(xBaseWindow.getWindow(), xBaseWindow2.getWindow());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getWindowProperty(long l) {
        WindowPropertyGetter windowPropertyGetter;
        block6: {
            block5: {
                if (this.atom == 0L) {
                    throw new IllegalStateException("Atom should be initialized");
                }
                this.checkWindow(l);
                windowPropertyGetter = new WindowPropertyGetter(l, this, 0L, 1L, false, 33L);
                try {
                    int n = windowPropertyGetter.execute();
                    if (n == 0 && windowPropertyGetter.getData() != 0L) break block5;
                    long l2 = 0L;
                    Object var8_7 = null;
                    windowPropertyGetter.dispose();
                    return l2;
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    windowPropertyGetter.dispose();
                    throw throwable;
                }
            }
            if (windowPropertyGetter.getActualType() == 33L && windowPropertyGetter.getActualFormat() == 32) break block6;
            long l3 = 0L;
            Object var8_8 = null;
            windowPropertyGetter.dispose();
            return l3;
        }
        long l4 = Native.getWindow(windowPropertyGetter.getData());
        Object var8_9 = null;
        windowPropertyGetter.dispose();
        return l4;
    }
}

