/*
 * Decompiled with CFR 0.152.
 */
package javax.sql.rowset.serial;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Vector;
import javax.sql.rowset.RowSetWarning;
import javax.sql.rowset.serial.SerialException;
import sun.reflect.CallerSensitive;
import sun.reflect.misc.FieldUtil;

public class SerialJavaObject
implements Serializable,
Cloneable {
    private Object obj;
    private transient Field[] fields;
    static final long serialVersionUID = -1465795139032831023L;
    Vector chain;

    public SerialJavaObject(Object object) throws SerialException {
        int n;
        Class<?> clazz = object.getClass();
        boolean bl = false;
        Class<?>[] classArray = clazz.getInterfaces();
        for (n = 0; n < classArray.length; ++n) {
            String string = classArray[n].getName();
            if (string != "java.io.Serializable") continue;
            bl = true;
        }
        n = 0;
        this.fields = clazz.getFields();
        for (int i = 0; i < this.fields.length; ++i) {
            if (this.fields[i].getModifiers() != 8) continue;
            n = 1;
        }
        try {
            if (!bl) {
                throw new RowSetWarning("Test");
            }
        }
        catch (RowSetWarning rowSetWarning) {
            this.setWarning(rowSetWarning);
        }
        if (n != 0) {
            throw new SerialException("Located static fields in object instance. Cannot serialize");
        }
        this.obj = object;
    }

    public Object getObject() throws SerialException {
        return this.obj;
    }

    @CallerSensitive
    public Field[] getFields() throws SerialException {
        if (this.fields != null) {
            Class<?> clazz = this.obj.getClass();
            return FieldUtil.getFields(clazz);
        }
        throw new SerialException("SerialJavaObject does not contain a serialized object instance");
    }

    private void setWarning(RowSetWarning rowSetWarning) {
        if (this.chain == null) {
            this.chain = new Vector();
        }
        this.chain.add(rowSetWarning);
    }
}

