/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentSkipListMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentNavigableMap<K, V>,
Cloneable,
Serializable {
    private static final long serialVersionUID = -8627078645895051609L;
    private static final Random seedGenerator = new Random();
    private static final Object BASE_HEADER = new Object();
    private volatile transient HeadIndex<K, V> head;
    private final Comparator<? super K> comparator;
    private transient int randomSeed;
    private transient KeySet keySet;
    private transient EntrySet entrySet;
    private transient Values values;
    private transient ConcurrentNavigableMap<K, V> descendingMap;
    private static final AtomicReferenceFieldUpdater<ConcurrentSkipListMap, HeadIndex> headUpdater = AtomicReferenceFieldUpdater.newUpdater(ConcurrentSkipListMap.class, HeadIndex.class, "head");
    private static final int EQ = 1;
    private static final int LT = 2;
    private static final int GT = 0;

    final void initialize() {
        this.keySet = null;
        this.entrySet = null;
        this.values = null;
        this.descendingMap = null;
        this.randomSeed = seedGenerator.nextInt() | 0x100;
        this.head = new HeadIndex(new Node(null, BASE_HEADER, null), null, null, 1);
    }

    private boolean casHead(HeadIndex<K, V> headIndex, HeadIndex<K, V> headIndex2) {
        return headUpdater.compareAndSet(this, headIndex, headIndex2);
    }

    private Comparable<? super K> comparable(Object object) throws ClassCastException {
        if (object == null) {
            throw new NullPointerException();
        }
        if (this.comparator != null) {
            return new ComparableUsingComparator<K>(object, this.comparator);
        }
        return (Comparable)object;
    }

    int compare(K k, K k2) throws ClassCastException {
        Comparator<K> comparator = this.comparator;
        if (comparator != null) {
            return comparator.compare(k, k2);
        }
        return ((Comparable)k).compareTo(k2);
    }

    boolean inHalfOpenRange(K k, K k2, K k3) {
        if (k == null) {
            throw new NullPointerException();
        }
        return !(k2 != null && this.compare(k, k2) < 0 || k3 != null && this.compare(k, k3) >= 0);
    }

    boolean inOpenRange(K k, K k2, K k3) {
        if (k == null) {
            throw new NullPointerException();
        }
        return !(k2 != null && this.compare(k, k2) < 0 || k3 != null && this.compare(k, k3) > 0);
    }

    private Node<K, V> findPredecessor(Comparable<? super K> comparable) {
        Index index;
        if (comparable == null) {
            throw new NullPointerException();
        }
        block0: while (true) {
            index = this.head;
            Index index2 = index.right;
            while (true) {
                Object object;
                if (index2 != null) {
                    object = index2.node;
                    Object k = ((Node)object).key;
                    if (((Node)object).value == null) {
                        if (!index.unlink(index2)) continue block0;
                        index2 = index.right;
                        continue;
                    }
                    if (comparable.compareTo(k) > 0) {
                        index = index2;
                        index2 = index2.right;
                        continue;
                    }
                }
                if ((object = index.down) == null) break block0;
                index = object;
                index2 = ((Index)object).right;
            }
            break;
        }
        return index.node;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private Node<K, V> findNode(Comparable<? super K> var1_1) {
        block0: while (true) {
            var2_2 /* !! */  = this.findPredecessor(var1_1);
            var3_3 = var2_2 /* !! */ .next;
            while (true) {
                if (var3_3 == null) {
                    return null;
                }
                var4_4 = var3_3.next;
                if (var3_3 != var2_2 /* !! */ .next) continue block0;
                var5_5 = var3_3.value;
                if (var5_5 == null) {
                    var3_3.helpDelete(var2_2 /* !! */ , var4_4);
                    continue block0;
                }
                if (var5_5 != var3_3 && var2_2 /* !! */ .value != null) ** break;
                continue block0;
                var6_6 = var1_1.compareTo(var3_3.key);
                if (var6_6 == 0) {
                    return var3_3;
                }
                if (var6_6 < 0) {
                    return null;
                }
                var2_2 /* !! */  = var3_3;
                var3_3 = var4_4;
            }
            break;
        }
    }

    private V doGet(Object object) {
        Object object2;
        int n;
        Object k;
        Node node;
        Comparable<K> comparable = this.comparable(object);
        Node node2 = null;
        Index index = this.head;
        Index index2 = index.right;
        while (true) {
            if (index2 != null && (node = index2.node) != node2 && (k = node.key) != null) {
                n = comparable.compareTo(k);
                if (n > 0) {
                    index = index2;
                    index2 = index2.right;
                    continue;
                }
                if (n == 0) {
                    Object object3 = node.value;
                    return (V)(object3 != null ? object3 : this.getUsingFindNode(comparable));
                }
                node2 = node;
            }
            if ((object2 = index.down) == null) break;
            index = object2;
            index2 = ((Index)object2).right;
        }
        node = index.node.next;
        while (node != null) {
            k = node.key;
            if (k != null) {
                n = comparable.compareTo(k);
                if (n == 0) {
                    object2 = node.value;
                    return (V)(object2 != null ? object2 : this.getUsingFindNode(comparable));
                }
                if (n < 0) break;
            }
            node = node.next;
        }
        return null;
    }

    private V getUsingFindNode(Comparable<? super K> comparable) {
        Node<? super K, V> node;
        Object object;
        do {
            if ((node = this.findNode(comparable)) != null) continue;
            return null;
        } while ((object = node.value) == null);
        return (V)object;
    }

    private V doPut(K k, V v, boolean bl) {
        Node node;
        Comparable<K> comparable = this.comparable(k);
        block0: while (true) {
            Node node2 = this.findPredecessor(comparable);
            Node node3 = node2.next;
            while (node3 != null) {
                node = node3.next;
                if (node3 != node2.next) continue block0;
                Object object = node3.value;
                if (object == null) {
                    node3.helpDelete(node2, node);
                    continue block0;
                }
                if (object == node3 || node2.value == null) continue block0;
                int n = comparable.compareTo(node3.key);
                if (n > 0) {
                    node2 = node3;
                    node3 = node;
                    continue;
                }
                if (n != 0) break;
                if (!bl && !node3.casValue(object, v)) continue block0;
                return (V)object;
            }
            if (node2.casNext(node3, node = new Node(k, v, node3))) break;
        }
        int n = this.randomLevel();
        if (n > 0) {
            this.insertIndex(node, n);
        }
        return null;
    }

    private int randomLevel() {
        int n = this.randomSeed;
        n ^= n << 13;
        n ^= n >>> 17;
        n ^= n << 5;
        this.randomSeed = n;
        if ((n & 0x8001) != 0) {
            return 0;
        }
        int n2 = 1;
        while (((n >>>= 1) & 1) != 0) {
            ++n2;
        }
        return n2;
    }

    private void insertIndex(Node<K, V> node, int n) {
        HeadIndex<K, V> headIndex = this.head;
        int n2 = headIndex.level;
        if (n <= n2) {
            Index<K, V> index = null;
            for (int i = 1; i <= n; ++i) {
                index = new Index<K, V>(node, index, null);
            }
            this.addIndex(index, headIndex, n);
        } else {
            int n3;
            HeadIndex<K, V> headIndex2;
            Index[] indexArray;
            block7: {
                int n4;
                HeadIndex<K, V> headIndex3;
                n = n2 + 1;
                indexArray = new Index[n + 1];
                Index<K, V> index = null;
                for (int i = 1; i <= n; ++i) {
                    indexArray[i] = index = new Index<K, V>(node, index, null);
                }
                do {
                    headIndex2 = this.head;
                    n4 = headIndex2.level;
                    if (n <= n4) {
                        n3 = n;
                        break block7;
                    }
                    headIndex3 = headIndex2;
                    Node node2 = headIndex2.node;
                    for (int i = n4 + 1; i <= n; ++i) {
                        headIndex3 = new HeadIndex<K, V>(node2, headIndex3, indexArray[i], i);
                    }
                } while (!this.casHead(headIndex2, headIndex3));
                n3 = n4;
            }
            this.addIndex(indexArray[n3], headIndex2, n3);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void addIndex(Index<K, V> var1_1, HeadIndex<K, V> var2_2, int var3_3) {
        var4_4 = var3_3;
        var5_5 = this.comparable(var1_1.node.key);
        if (var5_5 == null) {
            throw new NullPointerException();
        }
        block0: while (true) {
            var6_6 = var2_2.level;
            var7_7 = var2_2;
            var8_8 = var7_7.right;
            var9_9 = var1_1;
            while (true) {
                if (var8_8 != null) {
                    var10_10 = var8_8.node;
                    var11_11 = var5_5.compareTo(var10_10.key);
                    if (var10_10.value == null) {
                        if (!var7_7.unlink(var8_8)) continue block0;
                        var8_8 = var7_7.right;
                        continue;
                    }
                    if (var11_11 > 0) {
                        var7_7 = var8_8;
                        var8_8 = var8_8.right;
                        continue;
                    }
                }
                if (var6_6 == var4_4) {
                    if (var9_9.indexesDeletedNode()) {
                        this.findNode(var5_5);
                        return;
                    }
                    if (var7_7.link(var8_8, var9_9)) ** break;
                    continue block0;
                    if (--var4_4 == 0) {
                        if (var9_9.indexesDeletedNode()) {
                            this.findNode(var5_5);
                        }
                        return;
                    }
                }
                if (--var6_6 >= var4_4 && var6_6 < var3_3) {
                    var9_9 = var9_9.down;
                }
                var7_7 = var7_7.down;
                var8_8 = var7_7.right;
            }
            break;
        }
    }

    final V doRemove(Object object, Object object2) {
        Object object3;
        Node node;
        Node node2;
        Node node3;
        Comparable<K> comparable = this.comparable(object);
        block0: while (true) {
            node3 = this.findPredecessor(comparable);
            node2 = node3.next;
            while (true) {
                if (node2 == null) {
                    return null;
                }
                node = node2.next;
                if (node2 != node3.next) continue block0;
                object3 = node2.value;
                if (object3 == null) {
                    node2.helpDelete(node3, node);
                    continue block0;
                }
                if (object3 == node2 || node3.value == null) continue block0;
                int n = comparable.compareTo(node2.key);
                if (n < 0) {
                    return null;
                }
                if (n <= 0) break;
                node3 = node2;
                node2 = node;
            }
            if (object2 != null && !object2.equals(object3)) {
                return null;
            }
            if (node2.casValue(object3, null)) break;
        }
        if (!node2.appendMarker(node) || !node3.casNext(node2, node)) {
            this.findNode(comparable);
        } else {
            this.findPredecessor(comparable);
            if (this.head.right == null) {
                this.tryReduceLevel();
            }
        }
        return (V)object3;
    }

    private void tryReduceLevel() {
        HeadIndex headIndex;
        HeadIndex headIndex2;
        HeadIndex<K, V> headIndex3 = this.head;
        if (headIndex3.level > 3 && (headIndex2 = (HeadIndex)headIndex3.down) != null && (headIndex = (HeadIndex)headIndex2.down) != null && headIndex.right == null && headIndex2.right == null && headIndex3.right == null && this.casHead(headIndex3, headIndex2) && headIndex3.right != null) {
            this.casHead(headIndex2, headIndex3);
        }
    }

    Node<K, V> findFirst() {
        while (true) {
            Node node = this.head.node;
            Node node2 = node.next;
            if (node2 == null) {
                return null;
            }
            if (node2.value != null) {
                return node2;
            }
            node2.helpDelete(node, node2.next);
        }
    }

    Map.Entry<K, V> doRemoveFirstEntry() {
        Object object;
        Node node;
        Node node2;
        Node node3;
        while (true) {
            node3 = this.head.node;
            node2 = node3.next;
            if (node2 == null) {
                return null;
            }
            node = node2.next;
            if (node2 != node3.next) continue;
            object = node2.value;
            if (object == null) {
                node2.helpDelete(node3, node);
                continue;
            }
            if (node2.casValue(object, null)) break;
        }
        if (!node2.appendMarker(node) || !node3.casNext(node2, node)) {
            this.findFirst();
        }
        this.clearIndexToFirst();
        return new AbstractMap.SimpleImmutableEntry(node2.key, object);
    }

    private void clearIndexToFirst() {
        block0: while (true) {
            Index index = this.head;
            do {
                Index index2;
                if ((index2 = index.right) != null && index2.indexesDeletedNode() && !index.unlink(index2)) continue block0;
            } while ((index = index.down) != null);
            break;
        }
        if (this.head.right == null) {
            this.tryReduceLevel();
        }
    }

    Node<K, V> findLast() {
        Index index = this.head;
        while (true) {
            Index index2;
            if ((index2 = index.right) != null) {
                if (index2.indexesDeletedNode()) {
                    index.unlink(index2);
                    index = this.head;
                    continue;
                }
                index = index2;
                continue;
            }
            Index index3 = index.down;
            if (index3 != null) {
                index = index3;
                continue;
            }
            Node node = index.node;
            Node node2 = node.next;
            while (true) {
                if (node2 == null) {
                    return node.isBaseHeader() ? null : node;
                }
                Node node3 = node2.next;
                if (node2 != node.next) break;
                Object object = node2.value;
                if (object == null) {
                    node2.helpDelete(node, node3);
                    break;
                }
                if (object == node2 || node.value == null) break;
                node = node2;
                node2 = node3;
            }
            index = this.head;
        }
    }

    private Node<K, V> findPredecessorOfLast() {
        Index index;
        block0: while (true) {
            index = this.head;
            while (true) {
                Index index2;
                Index index3;
                if ((index3 = index.right) != null) {
                    if (index3.indexesDeletedNode()) {
                        index.unlink(index3);
                        continue block0;
                    }
                    if (index3.node.next != null) {
                        index = index3;
                        continue;
                    }
                }
                if ((index2 = index.down) == null) break block0;
                index = index2;
            }
            break;
        }
        return index.node;
    }

    Map.Entry<K, V> doRemoveLastEntry() {
        Object object;
        Node node;
        Node node2;
        Node node3;
        block0: while (true) {
            node3 = this.findPredecessorOfLast();
            node2 = node3.next;
            if (node2 == null) {
                if (!node3.isBaseHeader()) continue;
                return null;
            }
            while (true) {
                node = node2.next;
                if (node2 != node3.next) continue block0;
                object = node2.value;
                if (object == null) {
                    node2.helpDelete(node3, node);
                    continue block0;
                }
                if (object == node2 || node3.value == null) continue block0;
                if (node == null) break;
                node3 = node2;
                node2 = node;
            }
            if (node2.casValue(object, null)) break;
        }
        Object k = node2.key;
        Comparable<K> comparable = this.comparable(k);
        if (!node2.appendMarker(node) || !node3.casNext(node2, node)) {
            this.findNode(comparable);
        } else {
            this.findPredecessor(comparable);
            if (this.head.right == null) {
                this.tryReduceLevel();
            }
        }
        return new AbstractMap.SimpleImmutableEntry(k, object);
    }

    /*
     * Unable to fully structure code
     */
    Node<K, V> findNear(K var1_1, int var2_2) {
        var3_3 = this.comparable(var1_1);
        block0: while (true) {
            var4_4 = this.findPredecessor(var3_3);
            var5_5 = var4_4.next;
            while (true) {
                if (var5_5 == null) {
                    return (var2_2 & 2) == 0 || var4_4.isBaseHeader() != false ? null : var4_4;
                }
                var6_6 = var5_5.next;
                if (var5_5 != var4_4.next) continue block0;
                var7_7 = var5_5.value;
                if (var7_7 == null) {
                    var5_5.helpDelete(var4_4, var6_6);
                    continue block0;
                }
                if (var7_7 != var5_5 && var4_4.value != null) ** break;
                continue block0;
                var8_8 = var3_3.compareTo(var5_5.key);
                if (var8_8 == 0 && (var2_2 & 1) != 0 || var8_8 < 0 && (var2_2 & 2) == 0) {
                    return var5_5;
                }
                if (var8_8 <= 0 && (var2_2 & 2) != 0) {
                    return var4_4.isBaseHeader() != false ? null : var4_4;
                }
                var4_4 = var5_5;
                var5_5 = var6_6;
            }
            break;
        }
    }

    AbstractMap.SimpleImmutableEntry<K, V> getNear(K k, int n) {
        Node<K, V> node;
        AbstractMap.SimpleImmutableEntry<K, V> simpleImmutableEntry;
        do {
            if ((node = this.findNear(k, n)) != null) continue;
            return null;
        } while ((simpleImmutableEntry = node.createSnapshot()) == null);
        return simpleImmutableEntry;
    }

    public ConcurrentSkipListMap() {
        this.comparator = null;
        this.initialize();
    }

    public ConcurrentSkipListMap(Comparator<? super K> comparator) {
        this.comparator = comparator;
        this.initialize();
    }

    public ConcurrentSkipListMap(Map<? extends K, ? extends V> map) {
        this.comparator = null;
        this.initialize();
        this.putAll(map);
    }

    public ConcurrentSkipListMap(SortedMap<K, ? extends V> sortedMap) {
        this.comparator = sortedMap.comparator();
        this.initialize();
        this.buildFromSorted(sortedMap);
    }

    @Override
    public ConcurrentSkipListMap<K, V> clone() {
        ConcurrentSkipListMap concurrentSkipListMap = null;
        try {
            concurrentSkipListMap = (ConcurrentSkipListMap)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        concurrentSkipListMap.initialize();
        concurrentSkipListMap.buildFromSorted(this);
        return concurrentSkipListMap;
    }

    private void buildFromSorted(SortedMap<K, ? extends V> sortedMap) {
        if (sortedMap == null) {
            throw new NullPointerException();
        }
        HeadIndex<K, V> headIndex = this.head;
        Node node = headIndex.node;
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i <= headIndex.level; ++i) {
            arrayList.add(null);
        }
        Index index = headIndex;
        for (int i = headIndex.level; i > 0; --i) {
            arrayList.set(i, index);
            index = index.down;
        }
        for (Map.Entry<K, V> entry : sortedMap.entrySet()) {
            int n = this.randomLevel();
            if (n > headIndex.level) {
                n = headIndex.level + 1;
            }
            K k = entry.getKey();
            V v = entry.getValue();
            if (k == null || v == null) {
                throw new NullPointerException();
            }
            Node node2 = new Node(k, v, null);
            node.next = node2;
            node = node2;
            if (n <= 0) continue;
            Index index2 = null;
            for (int i = 1; i <= n; ++i) {
                index2 = new Index(node2, index2, null);
                if (i > headIndex.level) {
                    headIndex = new HeadIndex<K, V>(headIndex.node, headIndex, index2, i);
                }
                if (i < arrayList.size()) {
                    ((Index)arrayList.get((int)i)).right = index2;
                    arrayList.set(i, index2);
                    continue;
                }
                arrayList.add(index2);
            }
        }
        this.head = headIndex;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        Node<K, V> node = this.findFirst();
        while (node != null) {
            V v = node.getValidValue();
            if (v != null) {
                objectOutputStream.writeObject(node.key);
                objectOutputStream.writeObject(v);
            }
            node = node.next;
        }
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object;
        objectInputStream.defaultReadObject();
        this.initialize();
        HeadIndex<Object, V> headIndex = this.head;
        Node node = headIndex.node;
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i <= headIndex.level; ++i) {
            arrayList.add(null);
        }
        Index index = headIndex;
        for (int i = headIndex.level; i > 0; --i) {
            arrayList.set(i, index);
            index = index.down;
        }
        while ((object = objectInputStream.readObject()) != null) {
            Object object2 = objectInputStream.readObject();
            if (object2 == null) {
                throw new NullPointerException();
            }
            Object object3 = object;
            Object object4 = object2;
            int n = this.randomLevel();
            if (n > headIndex.level) {
                n = headIndex.level + 1;
            }
            Node node2 = new Node(object3, object4, null);
            node.next = node2;
            node = node2;
            if (n <= 0) continue;
            Index index2 = null;
            for (int i = 1; i <= n; ++i) {
                index2 = new Index(node2, index2, null);
                if (i > headIndex.level) {
                    headIndex = new HeadIndex<Object, V>(headIndex.node, headIndex, index2, i);
                }
                if (i < arrayList.size()) {
                    ((Index)arrayList.get((int)i)).right = index2;
                    arrayList.set(i, index2);
                    continue;
                }
                arrayList.add(index2);
            }
        }
        this.head = headIndex;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.doGet(object) != null;
    }

    @Override
    public V get(Object object) {
        return this.doGet(object);
    }

    @Override
    public V put(K k, V v) {
        if (v == null) {
            throw new NullPointerException();
        }
        return this.doPut(k, v, false);
    }

    @Override
    public V remove(Object object) {
        return this.doRemove(object, null);
    }

    @Override
    public boolean containsValue(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        Node<K, V> node = this.findFirst();
        while (node != null) {
            V v = node.getValidValue();
            if (v != null && object.equals(v)) {
                return true;
            }
            node = node.next;
        }
        return false;
    }

    @Override
    public int size() {
        long l = 0L;
        Node<K, V> node = this.findFirst();
        while (node != null) {
            if (node.getValidValue() != null) {
                ++l;
            }
            node = node.next;
        }
        return l >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l;
    }

    @Override
    public boolean isEmpty() {
        return this.findFirst() == null;
    }

    @Override
    public void clear() {
        this.initialize();
    }

    @Override
    public NavigableSet<K> keySet() {
        KeySet keySet = this.keySet;
        return keySet != null ? keySet : (this.keySet = new KeySet(this));
    }

    @Override
    public NavigableSet<K> navigableKeySet() {
        KeySet keySet = this.keySet;
        return keySet != null ? keySet : (this.keySet = new KeySet(this));
    }

    @Override
    public Collection<V> values() {
        Values values = this.values;
        return values != null ? values : (this.values = new Values(this));
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet entrySet = this.entrySet;
        return entrySet != null ? entrySet : (this.entrySet = new EntrySet(this));
    }

    @Override
    public ConcurrentNavigableMap<K, V> descendingMap() {
        ConcurrentNavigableMap<K, V> concurrentNavigableMap = this.descendingMap;
        return concurrentNavigableMap != null ? concurrentNavigableMap : (this.descendingMap = new SubMap(this, null, false, null, false, true));
    }

    @Override
    public NavigableSet<K> descendingKeySet() {
        return this.descendingMap().navigableKeySet();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Map)) {
            return false;
        }
        Map map = (Map)object;
        try {
            for (Map.Entry<K, V> entry : this.entrySet()) {
                if (entry.getValue().equals(map.get(entry.getKey()))) continue;
                return false;
            }
            for (Map.Entry<K, V> entry : map.entrySet()) {
                K k = entry.getKey();
                V v = entry.getValue();
                if (k != null && v != null && v.equals(this.get(k))) continue;
                return false;
            }
            return true;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    @Override
    public V putIfAbsent(K k, V v) {
        if (v == null) {
            throw new NullPointerException();
        }
        return this.doPut(k, v, true);
    }

    @Override
    public boolean remove(Object object, Object object2) {
        if (object == null) {
            throw new NullPointerException();
        }
        if (object2 == null) {
            return false;
        }
        return this.doRemove(object, object2) != null;
    }

    @Override
    public boolean replace(K k, V v, V v2) {
        if (v == null || v2 == null) {
            throw new NullPointerException();
        }
        Comparable<K> comparable = this.comparable(k);
        while (true) {
            Node<K, V> node;
            if ((node = this.findNode(comparable)) == null) {
                return false;
            }
            Object object = node.value;
            if (object == null) continue;
            if (!v.equals(object)) {
                return false;
            }
            if (node.casValue(object, v2)) break;
        }
        return true;
    }

    @Override
    public V replace(K k, V v) {
        Node<K, V> node;
        Object object;
        if (v == null) {
            throw new NullPointerException();
        }
        Comparable<K> comparable = this.comparable(k);
        do {
            if ((node = this.findNode(comparable)) != null) continue;
            return null;
        } while ((object = node.value) == null || !node.casValue(object, v));
        return (V)object;
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.comparator;
    }

    @Override
    public K firstKey() {
        Node<K, V> node = this.findFirst();
        if (node == null) {
            throw new NoSuchElementException();
        }
        return node.key;
    }

    @Override
    public K lastKey() {
        Node<K, V> node = this.findLast();
        if (node == null) {
            throw new NoSuchElementException();
        }
        return node.key;
    }

    @Override
    public ConcurrentNavigableMap<K, V> subMap(K k, boolean bl, K k2, boolean bl2) {
        if (k == null || k2 == null) {
            throw new NullPointerException();
        }
        return new SubMap(this, k, bl, k2, bl2, false);
    }

    @Override
    public ConcurrentNavigableMap<K, V> headMap(K k, boolean bl) {
        if (k == null) {
            throw new NullPointerException();
        }
        return new SubMap(this, null, false, k, bl, false);
    }

    @Override
    public ConcurrentNavigableMap<K, V> tailMap(K k, boolean bl) {
        if (k == null) {
            throw new NullPointerException();
        }
        return new SubMap(this, k, bl, null, false, false);
    }

    @Override
    public ConcurrentNavigableMap<K, V> subMap(K k, K k2) {
        return this.subMap((Object)k, true, (Object)k2, false);
    }

    @Override
    public ConcurrentNavigableMap<K, V> headMap(K k) {
        return this.headMap((Object)k, false);
    }

    @Override
    public ConcurrentNavigableMap<K, V> tailMap(K k) {
        return this.tailMap((Object)k, true);
    }

    @Override
    public Map.Entry<K, V> lowerEntry(K k) {
        return this.getNear(k, 2);
    }

    @Override
    public K lowerKey(K k) {
        Node<K, V> node = this.findNear(k, 2);
        return node == null ? null : (K)node.key;
    }

    @Override
    public Map.Entry<K, V> floorEntry(K k) {
        return this.getNear(k, 3);
    }

    @Override
    public K floorKey(K k) {
        Node<K, V> node = this.findNear(k, 3);
        return node == null ? null : (K)node.key;
    }

    @Override
    public Map.Entry<K, V> ceilingEntry(K k) {
        return this.getNear(k, 1);
    }

    @Override
    public K ceilingKey(K k) {
        Node<K, V> node = this.findNear(k, 1);
        return node == null ? null : (K)node.key;
    }

    @Override
    public Map.Entry<K, V> higherEntry(K k) {
        return this.getNear(k, 0);
    }

    @Override
    public K higherKey(K k) {
        Node<K, V> node = this.findNear(k, 0);
        return node == null ? null : (K)node.key;
    }

    @Override
    public Map.Entry<K, V> firstEntry() {
        Node<K, V> node;
        AbstractMap.SimpleImmutableEntry<K, V> simpleImmutableEntry;
        do {
            if ((node = this.findFirst()) != null) continue;
            return null;
        } while ((simpleImmutableEntry = node.createSnapshot()) == null);
        return simpleImmutableEntry;
    }

    @Override
    public Map.Entry<K, V> lastEntry() {
        Node<K, V> node;
        AbstractMap.SimpleImmutableEntry<K, V> simpleImmutableEntry;
        do {
            if ((node = this.findLast()) != null) continue;
            return null;
        } while ((simpleImmutableEntry = node.createSnapshot()) == null);
        return simpleImmutableEntry;
    }

    @Override
    public Map.Entry<K, V> pollFirstEntry() {
        return this.doRemoveFirstEntry();
    }

    @Override
    public Map.Entry<K, V> pollLastEntry() {
        return this.doRemoveLastEntry();
    }

    Iterator<K> keyIterator() {
        return new KeyIterator();
    }

    Iterator<V> valueIterator() {
        return new ValueIterator();
    }

    Iterator<Map.Entry<K, V>> entryIterator() {
        return new EntryIterator();
    }

    static final <E> List<E> toList(Collection<E> collection) {
        ArrayList<E> arrayList = new ArrayList<E>();
        for (E e : collection) {
            arrayList.add(e);
        }
        return arrayList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class SubMap<K, V>
    extends AbstractMap<K, V>
    implements ConcurrentNavigableMap<K, V>,
    Cloneable,
    Serializable {
        private static final long serialVersionUID = -7647078645895051609L;
        private final ConcurrentSkipListMap<K, V> m;
        private final K lo;
        private final K hi;
        private final boolean loInclusive;
        private final boolean hiInclusive;
        private final boolean isDescending;
        private transient KeySet<K> keySetView;
        private transient Set<Map.Entry<K, V>> entrySetView;
        private transient Collection<V> valuesView;

        SubMap(ConcurrentSkipListMap<K, V> concurrentSkipListMap, K k, boolean bl, K k2, boolean bl2, boolean bl3) {
            if (k != null && k2 != null && concurrentSkipListMap.compare(k, k2) > 0) {
                throw new IllegalArgumentException("inconsistent range");
            }
            this.m = concurrentSkipListMap;
            this.lo = k;
            this.hi = k2;
            this.loInclusive = bl;
            this.hiInclusive = bl2;
            this.isDescending = bl3;
        }

        private boolean tooLow(K k) {
            int n;
            return this.lo != null && ((n = this.m.compare(k, this.lo)) < 0 || n == 0 && !this.loInclusive);
        }

        private boolean tooHigh(K k) {
            int n;
            return this.hi != null && ((n = this.m.compare(k, this.hi)) > 0 || n == 0 && !this.hiInclusive);
        }

        private boolean inBounds(K k) {
            return !this.tooLow(k) && !this.tooHigh(k);
        }

        private void checkKeyBounds(K k) throws IllegalArgumentException {
            if (k == null) {
                throw new NullPointerException();
            }
            if (!this.inBounds(k)) {
                throw new IllegalArgumentException("key out of range");
            }
        }

        private boolean isBeforeEnd(Node<K, V> node) {
            if (node == null) {
                return false;
            }
            if (this.hi == null) {
                return true;
            }
            Object k = node.key;
            if (k == null) {
                return true;
            }
            int n = this.m.compare(k, this.hi);
            return n <= 0 && (n != 0 || this.hiInclusive);
        }

        private Node<K, V> loNode() {
            if (this.lo == null) {
                return this.m.findFirst();
            }
            if (this.loInclusive) {
                return this.m.findNear(this.lo, 0 | 1);
            }
            return this.m.findNear(this.lo, 0);
        }

        private Node<K, V> hiNode() {
            if (this.hi == null) {
                return this.m.findLast();
            }
            if (this.hiInclusive) {
                return this.m.findNear(this.hi, 2 | 1);
            }
            return this.m.findNear(this.hi, 2);
        }

        private K lowestKey() {
            Node<K, V> node = this.loNode();
            if (this.isBeforeEnd(node)) {
                return node.key;
            }
            throw new NoSuchElementException();
        }

        private K highestKey() {
            Object k;
            Node<K, V> node = this.hiNode();
            if (node != null && this.inBounds(k = node.key)) {
                return k;
            }
            throw new NoSuchElementException();
        }

        private Map.Entry<K, V> lowestEntry() {
            Node<K, V> node;
            AbstractMap.SimpleImmutableEntry<K, V> simpleImmutableEntry;
            do {
                if (this.isBeforeEnd(node = this.loNode())) continue;
                return null;
            } while ((simpleImmutableEntry = node.createSnapshot()) == null);
            return simpleImmutableEntry;
        }

        private Map.Entry<K, V> highestEntry() {
            Node<K, V> node;
            AbstractMap.SimpleImmutableEntry<K, V> simpleImmutableEntry;
            do {
                if ((node = this.hiNode()) != null && this.inBounds(node.key)) continue;
                return null;
            } while ((simpleImmutableEntry = node.createSnapshot()) == null);
            return simpleImmutableEntry;
        }

        private Map.Entry<K, V> removeLowest() {
            Object k;
            V v;
            do {
                Node<K, V> node;
                if ((node = this.loNode()) == null) {
                    return null;
                }
                k = node.key;
                if (this.inBounds(k)) continue;
                return null;
            } while ((v = this.m.doRemove(k, null)) == null);
            return new AbstractMap.SimpleImmutableEntry(k, v);
        }

        private Map.Entry<K, V> removeHighest() {
            Object k;
            V v;
            do {
                Node<K, V> node;
                if ((node = this.hiNode()) == null) {
                    return null;
                }
                k = node.key;
                if (this.inBounds(k)) continue;
                return null;
            } while ((v = this.m.doRemove(k, null)) == null);
            return new AbstractMap.SimpleImmutableEntry(k, v);
        }

        private Map.Entry<K, V> getNearEntry(K k, int n) {
            Object k2;
            Node<K, V> node;
            V v;
            if (this.isDescending) {
                n = (n & 2) == 0 ? (n |= 2) : (n &= ~2);
            }
            if (this.tooLow(k)) {
                return (n & 2) != 0 ? null : this.lowestEntry();
            }
            if (this.tooHigh(k)) {
                return (n & 2) != 0 ? this.highestEntry() : null;
            }
            do {
                if ((node = this.m.findNear(k, n)) == null || !this.inBounds(node.key)) {
                    return null;
                }
                k2 = node.key;
            } while ((v = node.getValidValue()) == null);
            return new AbstractMap.SimpleImmutableEntry(k2, v);
        }

        private K getNearKey(K k, int n) {
            Object k2;
            Node<K, V> node;
            V v;
            if (this.isDescending) {
                n = (n & 2) == 0 ? (n |= 2) : (n &= ~2);
            }
            if (this.tooLow(k)) {
                Node<K, V> node2;
                if ((n & 2) == 0 && this.isBeforeEnd(node2 = this.loNode())) {
                    return node2.key;
                }
                return null;
            }
            if (this.tooHigh(k)) {
                Object k3;
                Node<K, V> node3;
                if ((n & 2) != 0 && (node3 = this.hiNode()) != null && this.inBounds(k3 = node3.key)) {
                    return k3;
                }
                return null;
            }
            do {
                if ((node = this.m.findNear(k, n)) == null || !this.inBounds(node.key)) {
                    return null;
                }
                k2 = node.key;
            } while ((v = node.getValidValue()) == null);
            return k2;
        }

        @Override
        public boolean containsKey(Object object) {
            if (object == null) {
                throw new NullPointerException();
            }
            Object object2 = object;
            return this.inBounds(object2) && this.m.containsKey(object2);
        }

        @Override
        public V get(Object object) {
            if (object == null) {
                throw new NullPointerException();
            }
            Object object2 = object;
            return !this.inBounds(object2) ? null : (V)this.m.get(object2);
        }

        @Override
        public V put(K k, V v) {
            this.checkKeyBounds(k);
            return this.m.put(k, v);
        }

        @Override
        public V remove(Object object) {
            Object object2 = object;
            return !this.inBounds(object2) ? null : (V)this.m.remove(object2);
        }

        @Override
        public int size() {
            long l = 0L;
            Node<K, V> node = this.loNode();
            while (this.isBeforeEnd(node)) {
                if (node.getValidValue() != null) {
                    ++l;
                }
                node = node.next;
            }
            return l >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l;
        }

        @Override
        public boolean isEmpty() {
            return !this.isBeforeEnd(this.loNode());
        }

        @Override
        public boolean containsValue(Object object) {
            if (object == null) {
                throw new NullPointerException();
            }
            Node<K, V> node = this.loNode();
            while (this.isBeforeEnd(node)) {
                V v = node.getValidValue();
                if (v != null && object.equals(v)) {
                    return true;
                }
                node = node.next;
            }
            return false;
        }

        @Override
        public void clear() {
            Node<K, V> node = this.loNode();
            while (this.isBeforeEnd(node)) {
                if (node.getValidValue() != null) {
                    this.m.remove(node.key);
                }
                node = node.next;
            }
        }

        @Override
        public V putIfAbsent(K k, V v) {
            this.checkKeyBounds(k);
            return this.m.putIfAbsent(k, v);
        }

        @Override
        public boolean remove(Object object, Object object2) {
            Object object3 = object;
            return this.inBounds(object3) && this.m.remove(object3, object2);
        }

        @Override
        public boolean replace(K k, V v, V v2) {
            this.checkKeyBounds(k);
            return this.m.replace(k, v, v2);
        }

        @Override
        public V replace(K k, V v) {
            this.checkKeyBounds(k);
            return this.m.replace(k, v);
        }

        @Override
        public Comparator<? super K> comparator() {
            Comparator<K> comparator = this.m.comparator();
            if (this.isDescending) {
                return Collections.reverseOrder(comparator);
            }
            return comparator;
        }

        private SubMap<K, V> newSubMap(K k, boolean bl, K k2, boolean bl2) {
            if (this.isDescending) {
                K k3 = k;
                k = k2;
                k2 = k3;
                boolean bl3 = bl;
                bl = bl2;
                bl2 = bl3;
            }
            if (this.lo != null) {
                if (k == null) {
                    k = this.lo;
                    bl = this.loInclusive;
                } else {
                    int n = this.m.compare(k, this.lo);
                    if (n < 0 || n == 0 && !this.loInclusive && bl) {
                        throw new IllegalArgumentException("key out of range");
                    }
                }
            }
            if (this.hi != null) {
                if (k2 == null) {
                    k2 = this.hi;
                    bl2 = this.hiInclusive;
                } else {
                    int n = this.m.compare(k2, this.hi);
                    if (n > 0 || n == 0 && !this.hiInclusive && bl2) {
                        throw new IllegalArgumentException("key out of range");
                    }
                }
            }
            return new SubMap<K, V>(this.m, k, bl, k2, bl2, this.isDescending);
        }

        @Override
        public SubMap<K, V> subMap(K k, boolean bl, K k2, boolean bl2) {
            if (k == null || k2 == null) {
                throw new NullPointerException();
            }
            return this.newSubMap(k, bl, k2, bl2);
        }

        @Override
        public SubMap<K, V> headMap(K k, boolean bl) {
            if (k == null) {
                throw new NullPointerException();
            }
            return this.newSubMap(null, false, k, bl);
        }

        @Override
        public SubMap<K, V> tailMap(K k, boolean bl) {
            if (k == null) {
                throw new NullPointerException();
            }
            return this.newSubMap(k, bl, null, false);
        }

        @Override
        public SubMap<K, V> subMap(K k, K k2) {
            return this.subMap((Object)k, true, (Object)k2, false);
        }

        @Override
        public SubMap<K, V> headMap(K k) {
            return this.headMap((Object)k, false);
        }

        @Override
        public SubMap<K, V> tailMap(K k) {
            return this.tailMap((Object)k, true);
        }

        @Override
        public SubMap<K, V> descendingMap() {
            return new SubMap<K, V>(this.m, this.lo, this.loInclusive, this.hi, this.hiInclusive, !this.isDescending);
        }

        @Override
        public Map.Entry<K, V> ceilingEntry(K k) {
            return this.getNearEntry(k, 0 | 1);
        }

        @Override
        public K ceilingKey(K k) {
            return this.getNearKey(k, 0 | 1);
        }

        @Override
        public Map.Entry<K, V> lowerEntry(K k) {
            return this.getNearEntry(k, 2);
        }

        @Override
        public K lowerKey(K k) {
            return this.getNearKey(k, 2);
        }

        @Override
        public Map.Entry<K, V> floorEntry(K k) {
            return this.getNearEntry(k, 2 | 1);
        }

        @Override
        public K floorKey(K k) {
            return this.getNearKey(k, 2 | 1);
        }

        @Override
        public Map.Entry<K, V> higherEntry(K k) {
            return this.getNearEntry(k, 0);
        }

        @Override
        public K higherKey(K k) {
            return this.getNearKey(k, 0);
        }

        @Override
        public K firstKey() {
            return this.isDescending ? this.highestKey() : this.lowestKey();
        }

        @Override
        public K lastKey() {
            return this.isDescending ? this.lowestKey() : this.highestKey();
        }

        @Override
        public Map.Entry<K, V> firstEntry() {
            return this.isDescending ? this.highestEntry() : this.lowestEntry();
        }

        @Override
        public Map.Entry<K, V> lastEntry() {
            return this.isDescending ? this.lowestEntry() : this.highestEntry();
        }

        @Override
        public Map.Entry<K, V> pollFirstEntry() {
            return this.isDescending ? this.removeHighest() : this.removeLowest();
        }

        @Override
        public Map.Entry<K, V> pollLastEntry() {
            return this.isDescending ? this.removeLowest() : this.removeHighest();
        }

        @Override
        public NavigableSet<K> keySet() {
            KeySet<K> keySet = this.keySetView;
            return keySet != null ? keySet : (this.keySetView = new KeySet(this));
        }

        @Override
        public NavigableSet<K> navigableKeySet() {
            KeySet<K> keySet = this.keySetView;
            return keySet != null ? keySet : (this.keySetView = new KeySet(this));
        }

        @Override
        public Collection<V> values() {
            Collection<V> collection = this.valuesView;
            return collection != null ? collection : (this.valuesView = new Values<V>(this));
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            Set<Map.Entry<K, V>> set = this.entrySetView;
            return set != null ? set : (this.entrySetView = new EntrySet<K, V>(this));
        }

        @Override
        public NavigableSet<K> descendingKeySet() {
            return ((SubMap)this.descendingMap()).navigableKeySet();
        }

        Iterator<K> keyIterator() {
            return new SubMapKeyIterator();
        }

        Iterator<V> valueIterator() {
            return new SubMapValueIterator();
        }

        Iterator<Map.Entry<K, V>> entryIterator() {
            return new SubMapEntryIterator();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class SubMapEntryIterator
        extends SubMapIter<Map.Entry<K, V>> {
            SubMapEntryIterator() {
            }

            @Override
            public Map.Entry<K, V> next() {
                Node node = this.next;
                Object object = this.nextValue;
                this.advance();
                return new AbstractMap.SimpleImmutableEntry(node.key, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class SubMapKeyIterator
        extends SubMapIter<K> {
            SubMapKeyIterator() {
            }

            @Override
            public K next() {
                Node node = this.next;
                this.advance();
                return node.key;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class SubMapValueIterator
        extends SubMapIter<V> {
            SubMapValueIterator() {
            }

            @Override
            public V next() {
                Object object = this.nextValue;
                this.advance();
                return object;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        abstract class SubMapIter<T>
        implements Iterator<T> {
            Node<K, V> lastReturned;
            Node<K, V> next;
            V nextValue;

            SubMapIter() {
                block3: {
                    Object object;
                    do {
                        Node node = this.next = SubMap.this.isDescending ? SubMap.this.hiNode() : SubMap.this.loNode();
                        if (this.next == null) break block3;
                    } while ((object = this.next.value) == null || object == this.next);
                    if (!SubMap.this.inBounds(this.next.key)) {
                        this.next = null;
                    } else {
                        this.nextValue = object;
                    }
                }
            }

            @Override
            public final boolean hasNext() {
                return this.next != null;
            }

            final void advance() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                this.lastReturned = this.next;
                if (SubMap.this.isDescending) {
                    this.descend();
                } else {
                    this.ascend();
                }
            }

            private void ascend() {
                block3: {
                    Object object;
                    do {
                        this.next = this.next.next;
                        if (this.next == null) break block3;
                    } while ((object = this.next.value) == null || object == this.next);
                    if (SubMap.this.tooHigh(this.next.key)) {
                        this.next = null;
                    } else {
                        this.nextValue = object;
                    }
                }
            }

            private void descend() {
                block3: {
                    Object object;
                    do {
                        this.next = SubMap.this.m.findNear(this.lastReturned.key, 2);
                        if (this.next == null) break block3;
                    } while ((object = this.next.value) == null || object == this.next);
                    if (SubMap.this.tooLow(this.next.key)) {
                        this.next = null;
                    } else {
                        this.nextValue = object;
                    }
                }
            }

            @Override
            public void remove() {
                Node node = this.lastReturned;
                if (node == null) {
                    throw new IllegalStateException();
                }
                SubMap.this.m.remove(node.key);
                this.lastReturned = null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class EntrySet<K1, V1>
    extends AbstractSet<Map.Entry<K1, V1>> {
        private final ConcurrentNavigableMap<K1, V1> m;

        EntrySet(ConcurrentNavigableMap<K1, V1> concurrentNavigableMap) {
            this.m = concurrentNavigableMap;
        }

        @Override
        public Iterator<Map.Entry<K1, V1>> iterator() {
            if (this.m instanceof ConcurrentSkipListMap) {
                return ((ConcurrentSkipListMap)this.m).entryIterator();
            }
            return ((SubMap)this.m).entryIterator();
        }

        @Override
        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object v = this.m.get(entry.getKey());
            return v != null && v.equals(entry.getValue());
        }

        @Override
        public boolean remove(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return this.m.remove(entry.getKey(), entry.getValue());
        }

        @Override
        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        @Override
        public int size() {
            return this.m.size();
        }

        @Override
        public void clear() {
            this.m.clear();
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Set)) {
                return false;
            }
            Collection collection = (Collection)object;
            try {
                return this.containsAll(collection) && collection.containsAll(this);
            }
            catch (ClassCastException classCastException) {
                return false;
            }
            catch (NullPointerException nullPointerException) {
                return false;
            }
        }

        @Override
        public Object[] toArray() {
            return ConcurrentSkipListMap.toList(this).toArray();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return ConcurrentSkipListMap.toList(this).toArray(TArray);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Values<E>
    extends AbstractCollection<E> {
        private final ConcurrentNavigableMap<Object, E> m;

        Values(ConcurrentNavigableMap<Object, E> concurrentNavigableMap) {
            this.m = concurrentNavigableMap;
        }

        @Override
        public Iterator<E> iterator() {
            if (this.m instanceof ConcurrentSkipListMap) {
                return ((ConcurrentSkipListMap)this.m).valueIterator();
            }
            return ((SubMap)this.m).valueIterator();
        }

        @Override
        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        @Override
        public int size() {
            return this.m.size();
        }

        @Override
        public boolean contains(Object object) {
            return this.m.containsValue(object);
        }

        @Override
        public void clear() {
            this.m.clear();
        }

        @Override
        public Object[] toArray() {
            return ConcurrentSkipListMap.toList(this).toArray();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return ConcurrentSkipListMap.toList(this).toArray(TArray);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class KeySet<E>
    extends AbstractSet<E>
    implements NavigableSet<E> {
        private final ConcurrentNavigableMap<E, Object> m;

        KeySet(ConcurrentNavigableMap<E, Object> concurrentNavigableMap) {
            this.m = concurrentNavigableMap;
        }

        @Override
        public int size() {
            return this.m.size();
        }

        @Override
        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            return this.m.containsKey(object);
        }

        @Override
        public boolean remove(Object object) {
            return this.m.remove(object) != null;
        }

        @Override
        public void clear() {
            this.m.clear();
        }

        @Override
        public E lower(E e) {
            return this.m.lowerKey(e);
        }

        @Override
        public E floor(E e) {
            return this.m.floorKey(e);
        }

        @Override
        public E ceiling(E e) {
            return this.m.ceilingKey(e);
        }

        @Override
        public E higher(E e) {
            return this.m.higherKey(e);
        }

        @Override
        public Comparator<? super E> comparator() {
            return this.m.comparator();
        }

        @Override
        public E first() {
            return (E)this.m.firstKey();
        }

        @Override
        public E last() {
            return (E)this.m.lastKey();
        }

        @Override
        public E pollFirst() {
            Map.Entry entry = this.m.pollFirstEntry();
            return entry == null ? null : (E)entry.getKey();
        }

        @Override
        public E pollLast() {
            Map.Entry entry = this.m.pollLastEntry();
            return entry == null ? null : (E)entry.getKey();
        }

        @Override
        public Iterator<E> iterator() {
            if (this.m instanceof ConcurrentSkipListMap) {
                return ((ConcurrentSkipListMap)this.m).keyIterator();
            }
            return ((SubMap)this.m).keyIterator();
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Set)) {
                return false;
            }
            Collection collection = (Collection)object;
            try {
                return this.containsAll(collection) && collection.containsAll(this);
            }
            catch (ClassCastException classCastException) {
                return false;
            }
            catch (NullPointerException nullPointerException) {
                return false;
            }
        }

        @Override
        public Object[] toArray() {
            return ConcurrentSkipListMap.toList(this).toArray();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return ConcurrentSkipListMap.toList(this).toArray(TArray);
        }

        @Override
        public Iterator<E> descendingIterator() {
            return this.descendingSet().iterator();
        }

        @Override
        public NavigableSet<E> subSet(E e, boolean bl, E e2, boolean bl2) {
            return new KeySet<E>(this.m.subMap(e, bl, e2, bl2));
        }

        @Override
        public NavigableSet<E> headSet(E e, boolean bl) {
            return new KeySet<E>(this.m.headMap(e, bl));
        }

        @Override
        public NavigableSet<E> tailSet(E e, boolean bl) {
            return new KeySet<E>(this.m.tailMap(e, bl));
        }

        @Override
        public NavigableSet<E> subSet(E e, E e2) {
            return this.subSet(e, true, e2, false);
        }

        @Override
        public NavigableSet<E> headSet(E e) {
            return this.headSet(e, false);
        }

        @Override
        public NavigableSet<E> tailSet(E e) {
            return this.tailSet(e, true);
        }

        @Override
        public NavigableSet<E> descendingSet() {
            return new KeySet<E>(this.m.descendingMap());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class EntryIterator
    extends Iter<Map.Entry<K, V>> {
        EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            Node node = this.next;
            Object object = this.nextValue;
            this.advance();
            return new AbstractMap.SimpleImmutableEntry(node.key, object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class KeyIterator
    extends Iter<K> {
        KeyIterator() {
        }

        @Override
        public K next() {
            Node node = this.next;
            this.advance();
            return node.key;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ValueIterator
    extends Iter<V> {
        ValueIterator() {
        }

        @Override
        public V next() {
            Object object = this.nextValue;
            this.advance();
            return object;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class Iter<T>
    implements Iterator<T> {
        Node<K, V> lastReturned;
        Node<K, V> next;
        V nextValue;

        Iter() {
            block1: {
                Object object;
                do {
                    this.next = ConcurrentSkipListMap.this.findFirst();
                    if (this.next == null) break block1;
                } while ((object = this.next.value) == null || object == this.next);
                this.nextValue = object;
            }
        }

        @Override
        public final boolean hasNext() {
            return this.next != null;
        }

        final void advance() {
            block2: {
                Object object;
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                this.lastReturned = this.next;
                do {
                    this.next = this.next.next;
                    if (this.next == null) break block2;
                } while ((object = this.next.value) == null || object == this.next);
                this.nextValue = object;
            }
        }

        @Override
        public void remove() {
            Node node = this.lastReturned;
            if (node == null) {
                throw new IllegalStateException();
            }
            ConcurrentSkipListMap.this.remove(node.key);
            this.lastReturned = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ComparableUsingComparator<K>
    implements Comparable<K> {
        final K actualKey;
        final Comparator<? super K> cmp;

        ComparableUsingComparator(K k, Comparator<? super K> comparator) {
            this.actualKey = k;
            this.cmp = comparator;
        }

        @Override
        public int compareTo(K k) {
            return this.cmp.compare(this.actualKey, k);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class HeadIndex<K, V>
    extends Index<K, V> {
        final int level;

        HeadIndex(Node<K, V> node, Index<K, V> index, Index<K, V> index2, int n) {
            super(node, index, index2);
            this.level = n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Index<K, V> {
        final Node<K, V> node;
        final Index<K, V> down;
        volatile Index<K, V> right;
        static final AtomicReferenceFieldUpdater<Index, Index> rightUpdater = AtomicReferenceFieldUpdater.newUpdater(Index.class, Index.class, "right");

        Index(Node<K, V> node, Index<K, V> index, Index<K, V> index2) {
            this.node = node;
            this.down = index;
            this.right = index2;
        }

        final boolean casRight(Index<K, V> index, Index<K, V> index2) {
            return rightUpdater.compareAndSet(this, index, index2);
        }

        final boolean indexesDeletedNode() {
            return this.node.value == null;
        }

        final boolean link(Index<K, V> index, Index<K, V> index2) {
            Node<K, V> node = this.node;
            index2.right = index;
            return node.value != null && this.casRight(index, index2);
        }

        final boolean unlink(Index<K, V> index) {
            return !this.indexesDeletedNode() && this.casRight(index, index.right);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Node<K, V> {
        final K key;
        volatile Object value;
        volatile Node<K, V> next;
        static final AtomicReferenceFieldUpdater<Node, Node> nextUpdater = AtomicReferenceFieldUpdater.newUpdater(Node.class, Node.class, "next");
        static final AtomicReferenceFieldUpdater<Node, Object> valueUpdater = AtomicReferenceFieldUpdater.newUpdater(Node.class, Object.class, "value");

        Node(K k, Object object, Node<K, V> node) {
            this.key = k;
            this.value = object;
            this.next = node;
        }

        Node(Node<K, V> node) {
            this.key = null;
            this.value = this;
            this.next = node;
        }

        boolean casValue(Object object, Object object2) {
            return valueUpdater.compareAndSet(this, object, object2);
        }

        boolean casNext(Node<K, V> node, Node<K, V> node2) {
            return nextUpdater.compareAndSet(this, node, node2);
        }

        boolean isMarker() {
            return this.value == this;
        }

        boolean isBaseHeader() {
            return this.value == BASE_HEADER;
        }

        boolean appendMarker(Node<K, V> node) {
            return this.casNext(node, new Node<K, V>(node));
        }

        void helpDelete(Node<K, V> node, Node<K, V> node2) {
            if (node2 == this.next && this == node.next) {
                if (node2 == null || node2.value != node2) {
                    this.appendMarker(node2);
                } else {
                    node.casNext(this, node2.next);
                }
            }
        }

        V getValidValue() {
            Object object = this.value;
            if (object == this || object == BASE_HEADER) {
                return null;
            }
            return (V)object;
        }

        AbstractMap.SimpleImmutableEntry<K, V> createSnapshot() {
            V v = this.getValidValue();
            if (v == null) {
                return null;
            }
            return new AbstractMap.SimpleImmutableEntry<K, V>(this.key, v);
        }
    }
}

