/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import com.sun.beans.editors.BooleanEditor;
import com.sun.beans.editors.ByteEditor;
import com.sun.beans.editors.DoubleEditor;
import com.sun.beans.editors.EnumEditor;
import com.sun.beans.editors.FloatEditor;
import com.sun.beans.editors.IntegerEditor;
import com.sun.beans.editors.LongEditor;
import com.sun.beans.editors.ShortEditor;
import java.beans.Introspector;
import java.beans.PropertyEditor;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyEditorManager {
    private static final String DEFAULT_SEARCH_PATH = "sun.beans.editors";
    private static final String DEFAULT_SEARCH_PATH_NEW = "com.sun.beans.editors";
    private static String[] searchPath = new String[]{"sun.beans.editors"};
    private static Hashtable registry;

    public static void registerEditor(Class<?> clazz, Class<?> clazz2) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPropertiesAccess();
        }
        PropertyEditorManager.initialize();
        if (clazz2 == null) {
            registry.remove(clazz);
        } else {
            registry.put(clazz, clazz2);
        }
    }

    public static synchronized PropertyEditor findEditor(Class<?> clazz) {
        PropertyEditorManager.initialize();
        Class clazz2 = (Class)registry.get(clazz);
        if (clazz2 != null) {
            try {
                Object t = clazz2.newInstance();
                return (PropertyEditor)t;
            }
            catch (Exception exception) {
                System.err.println("Couldn't instantiate type editor \"" + clazz2.getName() + "\" : " + exception);
            }
        }
        String string = clazz.getName() + "Editor";
        try {
            return (PropertyEditor)Introspector.instantiate(clazz, string);
        }
        catch (Exception exception) {
            int n = string.lastIndexOf(46) + 1;
            if (n > 0) {
                string = string.substring(n);
            }
            for (String string2 : searchPath) {
                String string3 = (DEFAULT_SEARCH_PATH.equals(string2) ? DEFAULT_SEARCH_PATH_NEW : string2) + '.' + string;
                try {
                    return (PropertyEditor)Introspector.instantiate(clazz, string3);
                }
                catch (Exception exception2) {
                }
            }
            if (null != clazz.getEnumConstants()) {
                return new EnumEditor(clazz);
            }
            return null;
        }
    }

    public static synchronized String[] getEditorSearchPath() {
        String[] stringArray = new String[searchPath.length];
        System.arraycopy(searchPath, 0, stringArray, 0, searchPath.length);
        return stringArray;
    }

    public static synchronized void setEditorSearchPath(String[] stringArray) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPropertiesAccess();
        }
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        searchPath = stringArray;
    }

    private static synchronized void initialize() {
        if (registry != null) {
            return;
        }
        registry = new Hashtable();
        registry.put(Byte.TYPE, ByteEditor.class);
        registry.put(Short.TYPE, ShortEditor.class);
        registry.put(Integer.TYPE, IntegerEditor.class);
        registry.put(Long.TYPE, LongEditor.class);
        registry.put(Boolean.TYPE, BooleanEditor.class);
        registry.put(Float.TYPE, FloatEditor.class);
        registry.put(Double.TYPE, DoubleEditor.class);
    }
}

