/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.model.wsdl;

import com.sun.istack.internal.NotNull;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLFault;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLOperation;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLPortType;
import com.sun.xml.internal.ws.model.wsdl.AbstractExtensibleImpl;
import com.sun.xml.internal.ws.model.wsdl.WSDLFaultImpl;
import com.sun.xml.internal.ws.model.wsdl.WSDLInputImpl;
import com.sun.xml.internal.ws.model.wsdl.WSDLMessageImpl;
import com.sun.xml.internal.ws.model.wsdl.WSDLModelImpl;
import com.sun.xml.internal.ws.model.wsdl.WSDLOutputImpl;
import com.sun.xml.internal.ws.model.wsdl.WSDLPartImpl;
import com.sun.xml.internal.ws.model.wsdl.WSDLPortTypeImpl;
import com.sun.xml.internal.ws.util.QNameMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WSDLOperationImpl
extends AbstractExtensibleImpl
implements WSDLOperation {
    private final QName name;
    private String parameterOrder;
    private WSDLInputImpl input;
    private WSDLOutputImpl output;
    private final List<WSDLFaultImpl> faults;
    private final QNameMap<WSDLFaultImpl> faultMap;
    protected Iterable<WSDLMessageImpl> messages;
    private final WSDLPortType owner;
    private final Map<String, String> faultActionMap;

    public WSDLOperationImpl(XMLStreamReader xsr, WSDLPortTypeImpl owner, QName name) {
        super(xsr);
        this.name = name;
        this.faults = new ArrayList<WSDLFaultImpl>();
        this.faultMap = new QNameMap();
        this.faultActionMap = new HashMap<String, String>();
        this.owner = owner;
    }

    @Override
    public QName getName() {
        return this.name;
    }

    public String getParameterOrder() {
        return this.parameterOrder;
    }

    public void setParameterOrder(String parameterOrder) {
        this.parameterOrder = parameterOrder;
    }

    @Override
    public WSDLInputImpl getInput() {
        return this.input;
    }

    public void setInput(WSDLInputImpl input) {
        this.input = input;
    }

    @Override
    public WSDLOutputImpl getOutput() {
        return this.output;
    }

    @Override
    public boolean isOneWay() {
        return this.output == null;
    }

    public void setOutput(WSDLOutputImpl output) {
        this.output = output;
    }

    public Iterable<WSDLFaultImpl> getFaults() {
        return this.faults;
    }

    @Override
    public WSDLFault getFault(QName faultDetailName) {
        WSDLFaultImpl fault = this.faultMap.get(faultDetailName);
        if (fault != null) {
            return fault;
        }
        for (WSDLFaultImpl fi : this.faults) {
            assert (fi.getMessage().parts().iterator().hasNext());
            WSDLPartImpl part = fi.getMessage().parts().iterator().next();
            if (!part.getDescriptor().name().equals(faultDetailName)) continue;
            this.faultMap.put(faultDetailName, fi);
            return fi;
        }
        return null;
    }

    public Map<String, String> getFaultActionMap() {
        return this.faultActionMap;
    }

    WSDLPortType getOwner() {
        return this.owner;
    }

    @Override
    @NotNull
    public QName getPortTypeName() {
        return this.owner.getName();
    }

    public void addFault(WSDLFaultImpl fault) {
        this.faults.add(fault);
    }

    public void freez(WSDLModelImpl root) {
        assert (this.input != null);
        this.input.freeze(root);
        if (this.output != null) {
            this.output.freeze(root);
        }
        for (WSDLFaultImpl fault : this.faults) {
            fault.freeze(root);
        }
    }
}

