/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.algorithms.implementations;

import com.sun.org.apache.xml.internal.security.algorithms.JCEMapper;
import com.sun.org.apache.xml.internal.security.algorithms.MessageDigestAlgorithm;
import com.sun.org.apache.xml.internal.security.algorithms.SignatureAlgorithmSpi;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureException;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public abstract class IntegrityHmac
extends SignatureAlgorithmSpi {
    static Logger log = Logger.getLogger(IntegrityHmacSHA1.class.getName());
    private Mac _macAlgorithm = null;
    private boolean _HMACOutputLengthSet = false;
    int _HMACOutputLength = 0;

    public abstract String engineGetURI();

    abstract int getDigestLength();

    public IntegrityHmac() throws XMLSignatureException {
        String string = JCEMapper.translateURItoJCEID(this.engineGetURI());
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Created IntegrityHmacSHA1 using " + string);
        }
        try {
            this._macAlgorithm = Mac.getInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Object[] objectArray = new Object[]{string, noSuchAlgorithmException.getLocalizedMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", objectArray);
        }
    }

    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws XMLSignatureException {
        throw new XMLSignatureException("empty");
    }

    public void reset() {
        this._HMACOutputLength = 0;
    }

    protected boolean engineVerify(byte[] byArray) throws XMLSignatureException {
        try {
            if (this._HMACOutputLengthSet && this._HMACOutputLength < this.getDigestLength()) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "HMACOutputLength must not be less than " + this.getDigestLength());
                }
                throw new XMLSignatureException("errorMessages.XMLSignatureException");
            }
            byte[] byArray2 = this._macAlgorithm.doFinal();
            return MessageDigestAlgorithm.isEqual(byArray2, byArray);
        }
        catch (IllegalStateException illegalStateException) {
            throw new XMLSignatureException("empty", illegalStateException);
        }
    }

    protected void engineInitVerify(Key key) throws XMLSignatureException {
        if (!(key instanceof SecretKey)) {
            String string = key.getClass().getName();
            String string2 = SecretKey.class.getName();
            Object[] objectArray = new Object[]{string, string2};
            throw new XMLSignatureException("algorithms.WrongKeyForThisOperation", objectArray);
        }
        try {
            this._macAlgorithm.init(key);
        }
        catch (InvalidKeyException invalidKeyException) {
            Mac mac = this._macAlgorithm;
            try {
                this._macAlgorithm = Mac.getInstance(this._macAlgorithm.getAlgorithm());
            }
            catch (Exception exception) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Exception when reinstantiating Mac:" + exception);
                }
                this._macAlgorithm = mac;
            }
            throw new XMLSignatureException("empty", invalidKeyException);
        }
    }

    protected byte[] engineSign() throws XMLSignatureException {
        try {
            if (this._HMACOutputLengthSet && this._HMACOutputLength < this.getDigestLength()) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "HMACOutputLength must not be less than " + this.getDigestLength());
                }
                throw new XMLSignatureException("errorMessages.XMLSignatureException");
            }
            return this._macAlgorithm.doFinal();
        }
        catch (IllegalStateException illegalStateException) {
            throw new XMLSignatureException("empty", illegalStateException);
        }
    }

    private static byte[] reduceBitLength(byte[] byArray, int n) {
        int n2 = n / 8;
        int n3 = n % 8;
        byte[] byArray2 = new byte[n2 + (n3 == 0 ? 0 : 1)];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        if (n3 > 0) {
            byte[] byArray3 = new byte[]{0, -128, -64, -32, -16, -8, -4, -2};
            byArray2[n2] = (byte)(byArray[n2] & byArray3[n3]);
        }
        return byArray2;
    }

    protected void engineInitSign(Key key) throws XMLSignatureException {
        if (!(key instanceof SecretKey)) {
            String string = key.getClass().getName();
            String string2 = SecretKey.class.getName();
            Object[] objectArray = new Object[]{string, string2};
            throw new XMLSignatureException("algorithms.WrongKeyForThisOperation", objectArray);
        }
        try {
            this._macAlgorithm.init(key);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new XMLSignatureException("empty", invalidKeyException);
        }
    }

    protected void engineInitSign(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws XMLSignatureException {
        if (!(key instanceof SecretKey)) {
            String string = key.getClass().getName();
            String string2 = SecretKey.class.getName();
            Object[] objectArray = new Object[]{string, string2};
            throw new XMLSignatureException("algorithms.WrongKeyForThisOperation", objectArray);
        }
        try {
            this._macAlgorithm.init(key, algorithmParameterSpec);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new XMLSignatureException("empty", invalidKeyException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new XMLSignatureException("empty", invalidAlgorithmParameterException);
        }
    }

    protected void engineInitSign(Key key, SecureRandom secureRandom) throws XMLSignatureException {
        throw new XMLSignatureException("algorithms.CannotUseSecureRandomOnMAC");
    }

    protected void engineUpdate(byte[] byArray) throws XMLSignatureException {
        try {
            this._macAlgorithm.update(byArray);
        }
        catch (IllegalStateException illegalStateException) {
            throw new XMLSignatureException("empty", illegalStateException);
        }
    }

    protected void engineUpdate(byte by) throws XMLSignatureException {
        try {
            this._macAlgorithm.update(by);
        }
        catch (IllegalStateException illegalStateException) {
            throw new XMLSignatureException("empty", illegalStateException);
        }
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) throws XMLSignatureException {
        try {
            this._macAlgorithm.update(byArray, n, n2);
        }
        catch (IllegalStateException illegalStateException) {
            throw new XMLSignatureException("empty", illegalStateException);
        }
    }

    protected String engineGetJCEAlgorithmString() {
        log.log(Level.FINE, "engineGetJCEAlgorithmString()");
        return this._macAlgorithm.getAlgorithm();
    }

    protected String engineGetJCEProviderName() {
        return this._macAlgorithm.getProvider().getName();
    }

    protected void engineSetHMACOutputLength(int n) {
        this._HMACOutputLength = n;
        this._HMACOutputLengthSet = true;
    }

    protected void engineGetContextFromElement(Element element) {
        super.engineGetContextFromElement(element);
        if (element == null) {
            throw new IllegalArgumentException("element null");
        }
        Text text = XMLUtils.selectDsNodeText(element.getFirstChild(), "HMACOutputLength", 0);
        if (text != null) {
            this._HMACOutputLength = Integer.parseInt(text.getData());
            this._HMACOutputLengthSet = true;
        }
    }

    public void engineAddContextToElement(Element element) {
        if (element == null) {
            throw new IllegalArgumentException("null element");
        }
        if (this._HMACOutputLengthSet) {
            Document document = element.getOwnerDocument();
            Element element2 = XMLUtils.createElementInSignatureSpace(document, "HMACOutputLength");
            Text text = document.createTextNode(new Integer(this._HMACOutputLength).toString());
            element2.appendChild(text);
            XMLUtils.addReturnToElement(element);
            element.appendChild(element2);
            XMLUtils.addReturnToElement(element);
        }
    }

    public static class IntegrityHmacMD5
    extends IntegrityHmac {
        public String engineGetURI() {
            return "http://www.w3.org/2001/04/xmldsig-more#hmac-md5";
        }

        int getDigestLength() {
            return 128;
        }
    }

    public static class IntegrityHmacRIPEMD160
    extends IntegrityHmac {
        public String engineGetURI() {
            return "http://www.w3.org/2001/04/xmldsig-more#hmac-ripemd160";
        }

        int getDigestLength() {
            return 160;
        }
    }

    public static class IntegrityHmacSHA512
    extends IntegrityHmac {
        public String engineGetURI() {
            return "http://www.w3.org/2001/04/xmldsig-more#hmac-sha512";
        }

        int getDigestLength() {
            return 512;
        }
    }

    public static class IntegrityHmacSHA384
    extends IntegrityHmac {
        public String engineGetURI() {
            return "http://www.w3.org/2001/04/xmldsig-more#hmac-sha384";
        }

        int getDigestLength() {
            return 384;
        }
    }

    public static class IntegrityHmacSHA256
    extends IntegrityHmac {
        public String engineGetURI() {
            return "http://www.w3.org/2001/04/xmldsig-more#hmac-sha256";
        }

        int getDigestLength() {
            return 256;
        }
    }

    public static class IntegrityHmacSHA1
    extends IntegrityHmac {
        public String engineGetURI() {
            return "http://www.w3.org/2000/09/xmldsig#hmac-sha1";
        }

        int getDigestLength() {
            return 160;
        }
    }
}

