/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.dom;

import com.sun.org.apache.xerces.internal.dom.DOMMessageFormatter;
import com.sun.org.apache.xerces.internal.dom.DOMStringListImpl;
import com.sun.org.apache.xerces.internal.dom.ObjectFactory;
import com.sun.org.apache.xerces.internal.impl.Constants;
import com.sun.org.apache.xerces.internal.impl.XMLEntityManager;
import com.sun.org.apache.xerces.internal.impl.XMLErrorReporter;
import com.sun.org.apache.xerces.internal.impl.dv.DTDDVFactory;
import com.sun.org.apache.xerces.internal.impl.msg.XMLMessageFormatter;
import com.sun.org.apache.xerces.internal.impl.validation.ValidationManager;
import com.sun.org.apache.xerces.internal.util.DOMEntityResolverWrapper;
import com.sun.org.apache.xerces.internal.util.DOMErrorHandlerWrapper;
import com.sun.org.apache.xerces.internal.util.MessageFormatter;
import com.sun.org.apache.xerces.internal.util.ParserConfigurationSettings;
import com.sun.org.apache.xerces.internal.util.SymbolTable;
import com.sun.org.apache.xerces.internal.utils.XMLSecurityManager;
import com.sun.org.apache.xerces.internal.xni.XMLDTDContentModelHandler;
import com.sun.org.apache.xerces.internal.xni.XMLDTDHandler;
import com.sun.org.apache.xerces.internal.xni.XMLDocumentHandler;
import com.sun.org.apache.xerces.internal.xni.XNIException;
import com.sun.org.apache.xerces.internal.xni.grammars.XMLGrammarPool;
import com.sun.org.apache.xerces.internal.xni.parser.XMLComponent;
import com.sun.org.apache.xerces.internal.xni.parser.XMLComponentManager;
import com.sun.org.apache.xerces.internal.xni.parser.XMLConfigurationException;
import com.sun.org.apache.xerces.internal.xni.parser.XMLEntityResolver;
import com.sun.org.apache.xerces.internal.xni.parser.XMLErrorHandler;
import com.sun.org.apache.xerces.internal.xni.parser.XMLInputSource;
import com.sun.org.apache.xerces.internal.xni.parser.XMLParserConfiguration;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Vector;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMErrorHandler;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMStringList;
import org.w3c.dom.ls.LSResourceResolver;

public class DOMConfigurationImpl
extends ParserConfigurationSettings
implements XMLParserConfiguration,
DOMConfiguration {
    protected static final String XERCES_VALIDATION = "http://xml.org/sax/features/validation";
    protected static final String XERCES_NAMESPACES = "http://xml.org/sax/features/namespaces";
    protected static final String SCHEMA = "http://apache.org/xml/features/validation/schema";
    protected static final String SCHEMA_FULL_CHECKING = "http://apache.org/xml/features/validation/schema-full-checking";
    protected static final String DYNAMIC_VALIDATION = "http://apache.org/xml/features/validation/dynamic";
    protected static final String NORMALIZE_DATA = "http://apache.org/xml/features/validation/schema/normalized-value";
    protected static final String SEND_PSVI = "http://apache.org/xml/features/validation/schema/augment-psvi";
    protected static final String DTD_VALIDATOR_FACTORY_PROPERTY = "http://apache.org/xml/properties/internal/datatype-validator-factory";
    protected static final String ENTITY_MANAGER = "http://apache.org/xml/properties/internal/entity-manager";
    protected static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    protected static final String XML_STRING = "http://xml.org/sax/properties/xml-string";
    protected static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    protected static final String GRAMMAR_POOL = "http://apache.org/xml/properties/internal/grammar-pool";
    protected static final String ERROR_HANDLER = "http://apache.org/xml/properties/internal/error-handler";
    protected static final String ENTITY_RESOLVER = "http://apache.org/xml/properties/internal/entity-resolver";
    protected static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    protected static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    protected static final String VALIDATION_MANAGER = "http://apache.org/xml/properties/internal/validation-manager";
    XMLDocumentHandler fDocumentHandler;
    protected short features = 0;
    protected static final short NAMESPACES = 1;
    protected static final short DTNORMALIZATION = 2;
    protected static final short ENTITIES = 4;
    protected static final short CDATA = 8;
    protected static final short SPLITCDATA = 16;
    protected static final short COMMENTS = 32;
    protected static final short VALIDATE = 64;
    protected static final short PSVI = 128;
    protected static final short WELLFORMED = 256;
    protected static final short NSDECL = 512;
    protected static final short INFOSET_TRUE_PARAMS = 801;
    protected static final short INFOSET_FALSE_PARAMS = 14;
    protected static final short INFOSET_MASK = 815;
    protected SymbolTable fSymbolTable;
    protected ArrayList fComponents;
    protected ValidationManager fValidationManager;
    protected Locale fLocale;
    protected XMLErrorReporter fErrorReporter;
    protected final DOMErrorHandlerWrapper fErrorHandlerWrapper = new DOMErrorHandlerWrapper();
    private DOMStringList fRecognizedParameters;
    private static final String SECURITY_MANAGER = "http://apache.org/xml/properties/security-manager";

    protected DOMConfigurationImpl() {
        this(null, null);
    }

    protected DOMConfigurationImpl(SymbolTable symbolTable) {
        this(symbolTable, null);
    }

    protected DOMConfigurationImpl(SymbolTable symbolTable, XMLComponentManager parentSettings) {
        super(parentSettings);
        MessageFormatter xmft;
        this.fRecognizedFeatures = new ArrayList();
        this.fRecognizedProperties = new ArrayList();
        this.fFeatures = new HashMap();
        this.fProperties = new HashMap();
        String[] recognizedFeatures = new String[]{XERCES_VALIDATION, XERCES_NAMESPACES, SCHEMA, SCHEMA_FULL_CHECKING, DYNAMIC_VALIDATION, NORMALIZE_DATA, SEND_PSVI};
        this.addRecognizedFeatures(recognizedFeatures);
        this.setFeature(XERCES_VALIDATION, false);
        this.setFeature(SCHEMA, false);
        this.setFeature(SCHEMA_FULL_CHECKING, false);
        this.setFeature(DYNAMIC_VALIDATION, false);
        this.setFeature(NORMALIZE_DATA, false);
        this.setFeature(XERCES_NAMESPACES, true);
        this.setFeature(SEND_PSVI, true);
        String[] recognizedProperties = new String[]{XML_STRING, SYMBOL_TABLE, ERROR_HANDLER, ENTITY_RESOLVER, ERROR_REPORTER, ENTITY_MANAGER, VALIDATION_MANAGER, GRAMMAR_POOL, JAXP_SCHEMA_SOURCE, JAXP_SCHEMA_LANGUAGE, DTD_VALIDATOR_FACTORY_PROPERTY, SECURITY_MANAGER};
        this.addRecognizedProperties(recognizedProperties);
        this.features = (short)(this.features | 1);
        this.features = (short)(this.features | 4);
        this.features = (short)(this.features | 0x20);
        this.features = (short)(this.features | 8);
        this.features = (short)(this.features | 0x10);
        this.features = (short)(this.features | 0x100);
        this.features = (short)(this.features | 0x200);
        if (symbolTable == null) {
            symbolTable = new SymbolTable();
        }
        this.fSymbolTable = symbolTable;
        this.fComponents = new ArrayList();
        this.setProperty(SYMBOL_TABLE, this.fSymbolTable);
        this.fErrorReporter = new XMLErrorReporter();
        this.setProperty(ERROR_REPORTER, this.fErrorReporter);
        this.addComponent(this.fErrorReporter);
        this.setProperty(DTD_VALIDATOR_FACTORY_PROPERTY, DTDDVFactory.getInstance());
        XMLEntityManager manager = new XMLEntityManager();
        this.setProperty(ENTITY_MANAGER, manager);
        this.addComponent(manager);
        this.fValidationManager = this.createValidationManager();
        this.setProperty(VALIDATION_MANAGER, this.fValidationManager);
        this.setProperty(SECURITY_MANAGER, new XMLSecurityManager(true));
        if (this.fErrorReporter.getMessageFormatter("http://www.w3.org/TR/1998/REC-xml-19980210") == null) {
            xmft = new XMLMessageFormatter();
            this.fErrorReporter.putMessageFormatter("http://www.w3.org/TR/1998/REC-xml-19980210", xmft);
            this.fErrorReporter.putMessageFormatter("http://www.w3.org/TR/1999/REC-xml-names-19990114", xmft);
        }
        if (this.fErrorReporter.getMessageFormatter("http://www.w3.org/TR/xml-schema-1") == null) {
            xmft = null;
            try {
                xmft = (MessageFormatter)ObjectFactory.newInstance("com.sun.org.apache.xerces.internal.impl.xs.XSMessageFormatter", ObjectFactory.findClassLoader(), true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (xmft != null) {
                this.fErrorReporter.putMessageFormatter("http://www.w3.org/TR/xml-schema-1", xmft);
            }
        }
        try {
            this.setLocale(Locale.getDefault());
        }
        catch (XNIException e) {
            // empty catch block
        }
    }

    public void parse(XMLInputSource inputSource) throws XNIException, IOException {
    }

    public void setDocumentHandler(XMLDocumentHandler documentHandler) {
        this.fDocumentHandler = documentHandler;
    }

    public XMLDocumentHandler getDocumentHandler() {
        return this.fDocumentHandler;
    }

    public void setDTDHandler(XMLDTDHandler dtdHandler) {
    }

    public XMLDTDHandler getDTDHandler() {
        return null;
    }

    public void setDTDContentModelHandler(XMLDTDContentModelHandler handler) {
    }

    public XMLDTDContentModelHandler getDTDContentModelHandler() {
        return null;
    }

    public void setEntityResolver(XMLEntityResolver resolver) {
        if (resolver != null) {
            this.fProperties.put(ENTITY_RESOLVER, resolver);
        }
    }

    public XMLEntityResolver getEntityResolver() {
        return (XMLEntityResolver)this.fProperties.get(ENTITY_RESOLVER);
    }

    public void setErrorHandler(XMLErrorHandler errorHandler) {
        if (errorHandler != null) {
            this.fProperties.put(ERROR_HANDLER, errorHandler);
        }
    }

    public XMLErrorHandler getErrorHandler() {
        return (XMLErrorHandler)this.fProperties.get(ERROR_HANDLER);
    }

    public void setFeature(String featureId, boolean state) throws XMLConfigurationException {
        super.setFeature(featureId, state);
    }

    public void setProperty(String propertyId, Object value) throws XMLConfigurationException {
        super.setProperty(propertyId, value);
    }

    public void setLocale(Locale locale) throws XNIException {
        this.fLocale = locale;
        this.fErrorReporter.setLocale(locale);
    }

    public Locale getLocale() {
        return this.fLocale;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setParameter(String name, Object value) throws DOMException {
        boolean found = true;
        if (value instanceof Boolean) {
            boolean state = (Boolean)value;
            if (name.equalsIgnoreCase("comments")) {
                this.features = (short)(state ? this.features | 0x20 : this.features & 0xFFFFFFDF);
            } else if (name.equalsIgnoreCase("datatype-normalization")) {
                this.setFeature(NORMALIZE_DATA, state);
                this.features = (short)(state ? this.features | 2 : this.features & 0xFFFFFFFD);
                if (state) {
                    this.features = (short)(this.features | 0x40);
                }
            } else if (name.equalsIgnoreCase("namespaces")) {
                this.features = (short)(state ? this.features | 1 : this.features & 0xFFFFFFFE);
            } else if (name.equalsIgnoreCase("cdata-sections")) {
                this.features = (short)(state ? this.features | 8 : this.features & 0xFFFFFFF7);
            } else if (name.equalsIgnoreCase("entities")) {
                this.features = (short)(state ? this.features | 4 : this.features & 0xFFFFFFFB);
            } else if (name.equalsIgnoreCase("split-cdata-sections")) {
                this.features = (short)(state ? this.features | 0x10 : this.features & 0xFFFFFFEF);
            } else if (name.equalsIgnoreCase("validate")) {
                this.features = (short)(state ? this.features | 0x40 : this.features & 0xFFFFFFBF);
            } else if (name.equalsIgnoreCase("well-formed")) {
                this.features = (short)(state ? this.features | 0x100 : this.features & 0xFFFFFEFF);
            } else if (name.equalsIgnoreCase("namespace-declarations")) {
                this.features = (short)(state ? this.features | 0x200 : this.features & 0xFFFFFDFF);
            } else if (name.equalsIgnoreCase("infoset")) {
                if (state) {
                    this.features = (short)(this.features | 0x321);
                    this.features = (short)(this.features & 0xFFFFFFF1);
                    this.setFeature(NORMALIZE_DATA, false);
                }
            } else if (name.equalsIgnoreCase("normalize-characters") || name.equalsIgnoreCase("canonical-form") || name.equalsIgnoreCase("validate-if-schema") || name.equalsIgnoreCase("check-character-normalization")) {
                if (state) {
                    String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{name});
                    throw new DOMException(9, msg);
                }
            } else if (name.equalsIgnoreCase("element-content-whitespace")) {
                if (!state) {
                    String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{name});
                    throw new DOMException(9, msg);
                }
            } else if (name.equalsIgnoreCase(SEND_PSVI)) {
                if (!state) {
                    String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{name});
                    throw new DOMException(9, msg);
                }
            } else if (name.equalsIgnoreCase("psvi")) {
                this.features = (short)(state ? this.features | 0x80 : this.features & 0xFFFFFF7F);
            } else {
                found = false;
            }
        }
        if (found) {
            if (value instanceof Boolean) return;
        }
        found = true;
        if (name.equalsIgnoreCase("error-handler")) {
            if (!(value instanceof DOMErrorHandler) && value != null) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "TYPE_MISMATCH_ERR", new Object[]{name});
                throw new DOMException(17, msg);
            }
            this.fErrorHandlerWrapper.setErrorHandler((DOMErrorHandler)value);
            this.setErrorHandler(this.fErrorHandlerWrapper);
            return;
        }
        if (name.equalsIgnoreCase("resource-resolver")) {
            if (!(value instanceof LSResourceResolver) && value != null) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "TYPE_MISMATCH_ERR", new Object[]{name});
                throw new DOMException(17, msg);
            }
            try {
                this.setEntityResolver(new DOMEntityResolverWrapper((LSResourceResolver)value));
                return;
            }
            catch (XMLConfigurationException e) {
                return;
            }
        }
        if (name.equalsIgnoreCase("schema-location")) {
            if (!(value instanceof String) && value != null) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "TYPE_MISMATCH_ERR", new Object[]{name});
                throw new DOMException(17, msg);
            }
            try {
                this.setProperty(JAXP_SCHEMA_SOURCE, value);
                return;
            }
            catch (XMLConfigurationException e) {
                return;
            }
        }
        if (name.equalsIgnoreCase("schema-type")) {
            if (!(value instanceof String) && value != null) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "TYPE_MISMATCH_ERR", new Object[]{name});
                throw new DOMException(17, msg);
            }
            try {
                if (value == null) {
                    this.setProperty(JAXP_SCHEMA_LANGUAGE, null);
                    return;
                }
                if (value.equals(Constants.NS_XMLSCHEMA)) {
                    this.setProperty(JAXP_SCHEMA_LANGUAGE, Constants.NS_XMLSCHEMA);
                    return;
                }
                if (!value.equals(Constants.NS_DTD)) return;
                this.setProperty(JAXP_SCHEMA_LANGUAGE, Constants.NS_DTD);
                return;
            }
            catch (XMLConfigurationException e) {
                return;
            }
        }
        if (name.equalsIgnoreCase(SYMBOL_TABLE)) {
            if (value instanceof SymbolTable) {
                this.setProperty(SYMBOL_TABLE, value);
                return;
            }
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "TYPE_MISMATCH_ERR", new Object[]{name});
            throw new DOMException(17, msg);
        }
        if (!name.equalsIgnoreCase(GRAMMAR_POOL)) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_FOUND", new Object[]{name});
            throw new DOMException(8, msg);
        }
        if (value instanceof XMLGrammarPool) {
            this.setProperty(GRAMMAR_POOL, value);
            return;
        }
        String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "TYPE_MISMATCH_ERR", new Object[]{name});
        throw new DOMException(17, msg);
    }

    public Object getParameter(String name) throws DOMException {
        if (name.equalsIgnoreCase("comments")) {
            return (this.features & 0x20) != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equalsIgnoreCase("namespaces")) {
            return (this.features & 1) != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equalsIgnoreCase("datatype-normalization")) {
            return (this.features & 2) != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equalsIgnoreCase("cdata-sections")) {
            return (this.features & 8) != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equalsIgnoreCase("entities")) {
            return (this.features & 4) != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equalsIgnoreCase("split-cdata-sections")) {
            return (this.features & 0x10) != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equalsIgnoreCase("validate")) {
            return (this.features & 0x40) != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equalsIgnoreCase("well-formed")) {
            return (this.features & 0x100) != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equalsIgnoreCase("namespace-declarations")) {
            return (this.features & 0x200) != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equalsIgnoreCase("infoset")) {
            return (this.features & 0x32F) == 801 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equalsIgnoreCase("normalize-characters") || name.equalsIgnoreCase("canonical-form") || name.equalsIgnoreCase("validate-if-schema") || name.equalsIgnoreCase("check-character-normalization")) {
            return Boolean.FALSE;
        }
        if (name.equalsIgnoreCase(SEND_PSVI)) {
            return Boolean.TRUE;
        }
        if (name.equalsIgnoreCase("psvi")) {
            return (this.features & 0x80) != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equalsIgnoreCase("element-content-whitespace")) {
            return Boolean.TRUE;
        }
        if (name.equalsIgnoreCase("error-handler")) {
            return this.fErrorHandlerWrapper.getErrorHandler();
        }
        if (name.equalsIgnoreCase("resource-resolver")) {
            XMLEntityResolver entityResolver = this.getEntityResolver();
            if (entityResolver != null && entityResolver instanceof DOMEntityResolverWrapper) {
                return ((DOMEntityResolverWrapper)entityResolver).getEntityResolver();
            }
            return null;
        }
        if (name.equalsIgnoreCase("schema-type")) {
            return this.getProperty(JAXP_SCHEMA_LANGUAGE);
        }
        if (name.equalsIgnoreCase("schema-location")) {
            return this.getProperty(JAXP_SCHEMA_SOURCE);
        }
        if (name.equalsIgnoreCase(SYMBOL_TABLE)) {
            return this.getProperty(SYMBOL_TABLE);
        }
        if (name.equalsIgnoreCase(GRAMMAR_POOL)) {
            return this.getProperty(GRAMMAR_POOL);
        }
        String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_FOUND", new Object[]{name});
        throw new DOMException(8, msg);
    }

    public boolean canSetParameter(String name, Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof Boolean) {
            if (name.equalsIgnoreCase("comments") || name.equalsIgnoreCase("datatype-normalization") || name.equalsIgnoreCase("cdata-sections") || name.equalsIgnoreCase("entities") || name.equalsIgnoreCase("split-cdata-sections") || name.equalsIgnoreCase("namespaces") || name.equalsIgnoreCase("validate") || name.equalsIgnoreCase("well-formed") || name.equalsIgnoreCase("infoset") || name.equalsIgnoreCase("namespace-declarations")) {
                return true;
            }
            if (name.equalsIgnoreCase("normalize-characters") || name.equalsIgnoreCase("canonical-form") || name.equalsIgnoreCase("validate-if-schema") || name.equalsIgnoreCase("check-character-normalization")) {
                return !value.equals(Boolean.TRUE);
            }
            if (name.equalsIgnoreCase("element-content-whitespace") || name.equalsIgnoreCase(SEND_PSVI)) {
                return value.equals(Boolean.TRUE);
            }
            return false;
        }
        if (name.equalsIgnoreCase("error-handler")) {
            return value instanceof DOMErrorHandler;
        }
        if (name.equalsIgnoreCase("resource-resolver")) {
            return value instanceof LSResourceResolver;
        }
        if (name.equalsIgnoreCase("schema-location")) {
            return value instanceof String;
        }
        if (name.equalsIgnoreCase("schema-type")) {
            return value instanceof String && value.equals(Constants.NS_XMLSCHEMA);
        }
        if (name.equalsIgnoreCase(SYMBOL_TABLE)) {
            return value instanceof SymbolTable;
        }
        if (name.equalsIgnoreCase(GRAMMAR_POOL)) {
            return value instanceof XMLGrammarPool;
        }
        return false;
    }

    public DOMStringList getParameterNames() {
        if (this.fRecognizedParameters == null) {
            Vector<String> parameters = new Vector<String>();
            parameters.add("comments");
            parameters.add("datatype-normalization");
            parameters.add("cdata-sections");
            parameters.add("entities");
            parameters.add("split-cdata-sections");
            parameters.add("namespaces");
            parameters.add("validate");
            parameters.add("infoset");
            parameters.add("normalize-characters");
            parameters.add("canonical-form");
            parameters.add("validate-if-schema");
            parameters.add("check-character-normalization");
            parameters.add("well-formed");
            parameters.add("namespace-declarations");
            parameters.add("element-content-whitespace");
            parameters.add("error-handler");
            parameters.add("schema-type");
            parameters.add("schema-location");
            parameters.add("resource-resolver");
            parameters.add(GRAMMAR_POOL);
            parameters.add(SYMBOL_TABLE);
            parameters.add(SEND_PSVI);
            this.fRecognizedParameters = new DOMStringListImpl(parameters);
        }
        return this.fRecognizedParameters;
    }

    protected void reset() throws XNIException {
        if (this.fValidationManager != null) {
            this.fValidationManager.reset();
        }
        int count = this.fComponents.size();
        for (int i = 0; i < count; ++i) {
            XMLComponent c = (XMLComponent)this.fComponents.get(i);
            c.reset(this);
        }
    }

    protected void checkProperty(String propertyId) throws XMLConfigurationException {
        int suffixLength;
        if (propertyId.startsWith("http://xml.org/sax/properties/") && (suffixLength = propertyId.length() - "http://xml.org/sax/properties/".length()) == "xml-string".length() && propertyId.endsWith("xml-string")) {
            short type = 1;
            throw new XMLConfigurationException(type, propertyId);
        }
        super.checkProperty(propertyId);
    }

    protected void addComponent(XMLComponent component) {
        if (this.fComponents.contains(component)) {
            return;
        }
        this.fComponents.add(component);
        String[] recognizedFeatures = component.getRecognizedFeatures();
        this.addRecognizedFeatures(recognizedFeatures);
        String[] recognizedProperties = component.getRecognizedProperties();
        this.addRecognizedProperties(recognizedProperties);
    }

    protected ValidationManager createValidationManager() {
        return new ValidationManager();
    }
}

