/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AudioFloatInputStream;
import com.sun.media.sound.ModelWavetable;
import com.sun.media.sound.SoftResampler;
import com.sun.media.sound.SoftResamplerStreamer;
import java.io.IOException;
import java.util.Arrays;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.VoiceStatus;

public abstract class SoftAbstractResampler
implements SoftResampler {
    public abstract int getPadding();

    public abstract void interpolate(float[] var1, float[] var2, float var3, float[] var4, float var5, float[] var6, int[] var7, int var8);

    public final SoftResamplerStreamer openStreamer() {
        return new ModelAbstractResamplerStream();
    }

    private class ModelAbstractResamplerStream
    implements SoftResamplerStreamer {
        AudioFloatInputStream stream;
        boolean stream_eof = false;
        int loopmode;
        boolean loopdirection = true;
        float loopstart;
        float looplen;
        float target_pitch;
        float[] current_pitch = new float[1];
        boolean started;
        boolean eof;
        int sector_pos = 0;
        int sector_size = 400;
        int sector_loopstart = -1;
        boolean markset = false;
        int marklimit = 0;
        int streampos = 0;
        int nrofchannels = 2;
        boolean noteOff_flag = false;
        float[][] ibuffer;
        boolean ibuffer_order = true;
        float[] sbuffer;
        int pad;
        int pad2;
        float[] ix = new float[1];
        int[] ox = new int[1];
        float samplerateconv = 1.0f;
        float pitchcorrection = 0.0f;

        ModelAbstractResamplerStream() {
            this.pad = SoftAbstractResampler.this.getPadding();
            this.pad2 = SoftAbstractResampler.this.getPadding() * 2;
            this.ibuffer = new float[2][this.sector_size + this.pad2];
            this.ibuffer_order = true;
        }

        public void noteOn(MidiChannel midiChannel, VoiceStatus voiceStatus, int n, int n2) {
        }

        public void noteOff(int n) {
            this.noteOff_flag = true;
        }

        public void open(ModelWavetable modelWavetable, float f) throws IOException {
            this.eof = false;
            this.nrofchannels = modelWavetable.getChannels();
            if (this.ibuffer.length < this.nrofchannels) {
                this.ibuffer = new float[this.nrofchannels][this.sector_size + this.pad2];
            }
            this.stream = modelWavetable.openStream();
            this.streampos = 0;
            this.stream_eof = false;
            this.pitchcorrection = modelWavetable.getPitchcorrection();
            this.samplerateconv = this.stream.getFormat().getSampleRate() / f;
            this.looplen = modelWavetable.getLoopLength();
            this.loopstart = modelWavetable.getLoopStart();
            this.sector_loopstart = (int)(this.loopstart / (float)this.sector_size);
            --this.sector_loopstart;
            this.sector_pos = 0;
            if (this.sector_loopstart < 0) {
                this.sector_loopstart = 0;
            }
            this.started = false;
            this.loopmode = modelWavetable.getLoopType();
            if (this.loopmode != 0) {
                this.markset = false;
                this.marklimit = this.nrofchannels * (int)(this.looplen + (float)this.pad2 + 1.0f);
            } else {
                this.markset = true;
            }
            this.target_pitch = this.samplerateconv;
            this.current_pitch[0] = this.samplerateconv;
            this.ibuffer_order = true;
            this.loopdirection = true;
            this.noteOff_flag = false;
            for (int i = 0; i < this.nrofchannels; ++i) {
                Arrays.fill(this.ibuffer[i], this.sector_size, this.sector_size + this.pad2, 0.0f);
            }
            this.ix[0] = this.pad;
            this.eof = false;
            this.ix[0] = this.sector_size + this.pad;
            this.sector_pos = -1;
            this.streampos = -this.sector_size;
            this.nextBuffer();
        }

        public void setPitch(float f) {
            this.target_pitch = (float)Math.exp((double)(this.pitchcorrection + f) * (Math.log(2.0) / 1200.0)) * this.samplerateconv;
            if (!this.started) {
                this.current_pitch[0] = this.target_pitch;
            }
        }

        public void nextBuffer() throws IOException {
            int n;
            if (this.ix[0] < (float)this.pad && this.markset) {
                this.stream.reset();
                this.ix[0] = this.ix[0] + (float)(this.streampos - this.sector_loopstart * this.sector_size);
                this.sector_pos = this.sector_loopstart;
                this.streampos = this.sector_pos * this.sector_size;
                this.ix[0] = this.ix[0] + (float)this.sector_size;
                --this.sector_pos;
                this.streampos -= this.sector_size;
                this.stream_eof = false;
            }
            if (this.ix[0] >= (float)(this.sector_size + this.pad) && this.stream_eof) {
                this.eof = true;
                return;
            }
            if (this.ix[0] >= (float)(this.sector_size * 4 + this.pad)) {
                n = (int)((this.ix[0] - (float)(this.sector_size * 4) + (float)this.pad) / (float)this.sector_size);
                this.ix[0] = this.ix[0] - (float)(this.sector_size * n);
                this.sector_pos += n;
                this.streampos += this.sector_size * n;
                this.stream.skip(this.sector_size * n);
            }
            while (this.ix[0] >= (float)(this.sector_size + this.pad)) {
                int n2;
                if (!this.markset && this.sector_pos + 1 == this.sector_loopstart) {
                    this.stream.mark(this.marklimit);
                    this.markset = true;
                }
                this.ix[0] = this.ix[0] - (float)this.sector_size;
                ++this.sector_pos;
                this.streampos += this.sector_size;
                for (n = 0; n < this.nrofchannels; ++n) {
                    float[] fArray = this.ibuffer[n];
                    for (n2 = 0; n2 < this.pad2; ++n2) {
                        fArray[n2] = fArray[n2 + this.sector_size];
                    }
                }
                if (this.nrofchannels == 1) {
                    n = this.stream.read(this.ibuffer[0], this.pad2, this.sector_size);
                } else {
                    int n3 = this.sector_size * this.nrofchannels;
                    if (this.sbuffer == null || this.sbuffer.length < n3) {
                        this.sbuffer = new float[n3];
                    }
                    if ((n2 = this.stream.read(this.sbuffer, 0, n3)) == -1) {
                        n = -1;
                    } else {
                        n = n2 / this.nrofchannels;
                        for (int i = 0; i < this.nrofchannels; ++i) {
                            float[] fArray = this.ibuffer[i];
                            int n4 = i;
                            int n5 = this.nrofchannels;
                            int n6 = this.pad2;
                            int n7 = 0;
                            while (n7 < n) {
                                fArray[n6] = this.sbuffer[n4];
                                ++n7;
                                n4 += n5;
                                ++n6;
                            }
                        }
                    }
                }
                if (n == -1) {
                    n = 0;
                    this.stream_eof = true;
                    for (int i = 0; i < this.nrofchannels; ++i) {
                        Arrays.fill(this.ibuffer[i], this.pad2, this.pad2 + this.sector_size, 0.0f);
                    }
                    return;
                }
                if (n != this.sector_size) {
                    for (int i = 0; i < this.nrofchannels; ++i) {
                        Arrays.fill(this.ibuffer[i], this.pad2 + n, this.pad2 + this.sector_size, 0.0f);
                    }
                }
                this.ibuffer_order = true;
            }
        }

        public void reverseBuffers() {
            this.ibuffer_order = !this.ibuffer_order;
            for (int i = 0; i < this.nrofchannels; ++i) {
                float[] fArray = this.ibuffer[i];
                int n = fArray.length - 1;
                int n2 = fArray.length / 2;
                for (int j = 0; j < n2; ++j) {
                    float f = fArray[j];
                    fArray[j] = fArray[n - j];
                    fArray[n - j] = f;
                }
            }
        }

        public int read(float[][] fArray, int n, int n2) throws IOException {
            if (this.eof) {
                return -1;
            }
            if (this.noteOff_flag && (this.loopmode & 2) != 0 && this.loopdirection) {
                this.loopmode = 0;
            }
            float f = (this.target_pitch - this.current_pitch[0]) / (float)n2;
            float[] fArray2 = this.current_pitch;
            this.started = true;
            int[] nArray = this.ox;
            nArray[0] = n;
            int n3 = n2 + n;
            float f2 = this.sector_size + this.pad;
            if (!this.loopdirection) {
                f2 = this.pad;
            }
            while (nArray[0] != n3) {
                int n4;
                float f3;
                int n5;
                float f4;
                this.nextBuffer();
                if (!this.loopdirection) {
                    if ((float)this.streampos < this.loopstart + (float)this.pad && this.ix[0] <= (f2 = this.loopstart - (float)this.streampos + (float)this.pad2)) {
                        if ((this.loopmode & 4) != 0) {
                            this.loopdirection = true;
                            f2 = this.sector_size + this.pad;
                            continue;
                        }
                        this.ix[0] = this.ix[0] + this.looplen;
                        f2 = this.pad;
                        continue;
                    }
                    if (this.ibuffer_order != this.loopdirection) {
                        this.reverseBuffers();
                    }
                    this.ix[0] = (float)(this.sector_size + this.pad2) - this.ix[0];
                    f2 = (float)(this.sector_size + this.pad2) - f2;
                    f2 += 1.0f;
                    f4 = this.ix[0];
                    n5 = nArray[0];
                    f3 = fArray2[0];
                    for (n4 = 0; n4 < this.nrofchannels; ++n4) {
                        if (fArray[n4] == null) continue;
                        this.ix[0] = f4;
                        nArray[0] = n5;
                        fArray2[0] = f3;
                        SoftAbstractResampler.this.interpolate(this.ibuffer[n4], this.ix, f2, fArray2, f, fArray[n4], nArray, n3);
                    }
                    this.ix[0] = (float)(this.sector_size + this.pad2) - this.ix[0];
                    f2 -= 1.0f;
                    f2 = (float)(this.sector_size + this.pad2) - f2;
                    if (!this.eof) continue;
                    fArray2[0] = this.target_pitch;
                    return nArray[0] - n;
                }
                if (this.loopmode != 0 && (float)(this.streampos + this.sector_size) > this.looplen + this.loopstart + (float)this.pad && this.ix[0] >= (f2 = this.loopstart + this.looplen - (float)this.streampos + (float)this.pad2)) {
                    if ((this.loopmode & 4) != 0 || (this.loopmode & 8) != 0) {
                        this.loopdirection = false;
                        f2 = this.pad;
                        continue;
                    }
                    f2 = this.sector_size + this.pad;
                    this.ix[0] = this.ix[0] - this.looplen;
                    continue;
                }
                if (this.ibuffer_order != this.loopdirection) {
                    this.reverseBuffers();
                }
                f4 = this.ix[0];
                n5 = nArray[0];
                f3 = fArray2[0];
                for (n4 = 0; n4 < this.nrofchannels; ++n4) {
                    if (fArray[n4] == null) continue;
                    this.ix[0] = f4;
                    nArray[0] = n5;
                    fArray2[0] = f3;
                    SoftAbstractResampler.this.interpolate(this.ibuffer[n4], this.ix, f2, fArray2, f, fArray[n4], nArray, n3);
                }
                if (!this.eof) continue;
                fArray2[0] = this.target_pitch;
                return nArray[0] - n;
            }
            fArray2[0] = this.target_pitch;
            return n2;
        }

        public void close() throws IOException {
            this.stream.close();
        }
    }
}

