/*
 * Decompiled with CFR 0.152.
 */
package com.sun.image.codec.jpeg;

import com.sun.image.codec.jpeg.JPEGDecodeParam;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.io.InputStream;
import java.io.OutputStream;
import sun.awt.image.codec.JPEGImageDecoderImpl;
import sun.awt.image.codec.JPEGImageEncoderImpl;
import sun.awt.image.codec.JPEGParam;

public class JPEGCodec {
    private JPEGCodec() {
    }

    public static JPEGImageDecoder createJPEGDecoder(InputStream inputStream) {
        return new JPEGImageDecoderImpl(inputStream);
    }

    public static JPEGImageDecoder createJPEGDecoder(InputStream inputStream, JPEGDecodeParam jPEGDecodeParam) {
        return new JPEGImageDecoderImpl(inputStream, jPEGDecodeParam);
    }

    public static JPEGImageEncoder createJPEGEncoder(OutputStream outputStream) {
        return new JPEGImageEncoderImpl(outputStream);
    }

    public static JPEGImageEncoder createJPEGEncoder(OutputStream outputStream, JPEGEncodeParam jPEGEncodeParam) {
        return new JPEGImageEncoderImpl(outputStream, jPEGEncodeParam);
    }

    public static JPEGEncodeParam getDefaultJPEGEncodeParam(BufferedImage bufferedImage) {
        return JPEGCodec.getDefaultJPEGEncodeParam(bufferedImage.getRaster(), JPEGCodec.getDefaultColorID(bufferedImage.getColorModel()));
    }

    public static JPEGEncodeParam getDefaultJPEGEncodeParam(int n, int n2) {
        return new JPEGParam(n2, n);
    }

    public static JPEGEncodeParam getDefaultJPEGEncodeParam(JPEGDecodeParam jPEGDecodeParam) {
        return new JPEGParam(jPEGDecodeParam);
    }

    public static JPEGEncodeParam getDefaultJPEGEncodeParam(Raster raster, int n) {
        return JPEGCodec.getDefaultJPEGEncodeParam(raster.getNumBands(), n);
    }

    private static int getDefaultColorID(ColorModel colorModel) {
        ColorSpace colorSpace = colorModel.getColorSpace();
        int n = colorSpace.getType();
        int n2 = -1;
        switch (n) {
            case 6: {
                n2 = 1;
                break;
            }
            case 5: {
                n2 = colorModel.hasAlpha() ? 6 : 2;
            }
            case 3: {
                try {
                    if (colorSpace == ColorSpace.getInstance(1002)) {
                        n2 = colorModel.hasAlpha() ? 10 : 5;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (n2 != -1) break;
                n2 = colorModel.hasAlpha() ? 7 : 3;
                break;
            }
            case 9: {
                n2 = 4;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        return n2;
    }
}

