/*
 * Decompiled with CFR 0.152.
 */
package com.sun.beans;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WeakCache<K, V> {
    private final Map<K, Reference<V>> map = new WeakHashMap<K, Reference<V>>();

    public V get(K k) {
        Reference<V> reference = this.map.get(k);
        if (reference == null) {
            return null;
        }
        V v = reference.get();
        if (v == null) {
            this.map.remove(k);
        }
        return v;
    }

    public void put(K k, V v) {
        if (v != null) {
            this.map.put(k, new WeakReference<V>(v));
        } else {
            this.map.remove(k);
        }
    }

    public void clear() {
        this.map.clear();
    }
}

