/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Date;
import sun.misc.IOUtils;
import sun.security.util.BitArray;
import sun.security.util.DerIndefLenConverter;
import sun.security.util.DerInputBuffer;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.ObjectIdentifier;

public class DerValue {
    public static final byte TAG_UNIVERSAL = 0;
    public static final byte TAG_APPLICATION = 64;
    public static final byte TAG_CONTEXT = -128;
    public static final byte TAG_PRIVATE = -64;
    public byte tag;
    protected DerInputBuffer buffer;
    public final DerInputStream data;
    private int length;
    public static final byte tag_Boolean = 1;
    public static final byte tag_Integer = 2;
    public static final byte tag_BitString = 3;
    public static final byte tag_OctetString = 4;
    public static final byte tag_Null = 5;
    public static final byte tag_ObjectId = 6;
    public static final byte tag_Enumerated = 10;
    public static final byte tag_UTF8String = 12;
    public static final byte tag_PrintableString = 19;
    public static final byte tag_T61String = 20;
    public static final byte tag_IA5String = 22;
    public static final byte tag_UtcTime = 23;
    public static final byte tag_GeneralizedTime = 24;
    public static final byte tag_GeneralString = 27;
    public static final byte tag_UniversalString = 28;
    public static final byte tag_BMPString = 30;
    public static final byte tag_Sequence = 48;
    public static final byte tag_SequenceOf = 48;
    public static final byte tag_Set = 49;
    public static final byte tag_SetOf = 49;

    public boolean isUniversal() {
        return (this.tag & 0xC0) == 0;
    }

    public boolean isApplication() {
        return (this.tag & 0xC0) == 64;
    }

    public boolean isContextSpecific() {
        return (this.tag & 0xC0) == 128;
    }

    public boolean isContextSpecific(byte by) {
        if (!this.isContextSpecific()) {
            return false;
        }
        return (this.tag & 0x1F) == by;
    }

    boolean isPrivate() {
        return (this.tag & 0xC0) == 192;
    }

    public boolean isConstructed() {
        return (this.tag & 0x20) == 32;
    }

    public boolean isConstructed(byte by) {
        if (!this.isConstructed()) {
            return false;
        }
        return (this.tag & 0x1F) == by;
    }

    public DerValue(String string) throws IOException {
        boolean bl = true;
        for (int i = 0; i < string.length(); ++i) {
            if (DerValue.isPrintableStringChar(string.charAt(i))) continue;
            bl = false;
            break;
        }
        this.data = this.init(bl ? (byte)19 : 12, string);
    }

    public DerValue(byte by, String string) throws IOException {
        this.data = this.init(by, string);
    }

    public DerValue(byte by, byte[] byArray) {
        this.tag = by;
        this.buffer = new DerInputBuffer((byte[])byArray.clone());
        this.length = byArray.length;
        this.data = new DerInputStream(this.buffer);
        this.data.mark(Integer.MAX_VALUE);
    }

    DerValue(DerInputBuffer derInputBuffer) throws IOException {
        this.tag = (byte)derInputBuffer.read();
        byte by = (byte)derInputBuffer.read();
        this.length = DerInputStream.getLength(by & 0xFF, derInputBuffer);
        if (this.length == -1) {
            DerInputBuffer derInputBuffer2 = derInputBuffer.dup();
            int n = derInputBuffer2.available();
            int n2 = 2;
            byte[] byArray = new byte[n + n2];
            byArray[0] = this.tag;
            byArray[1] = by;
            DataInputStream dataInputStream = new DataInputStream(derInputBuffer2);
            dataInputStream.readFully(byArray, n2, n);
            dataInputStream.close();
            DerIndefLenConverter derIndefLenConverter = new DerIndefLenConverter();
            derInputBuffer2 = new DerInputBuffer(derIndefLenConverter.convert(byArray));
            if (this.tag != derInputBuffer2.read()) {
                throw new IOException("Indefinite length encoding not supported");
            }
            this.length = DerInputStream.getLength(derInputBuffer2);
            this.buffer = derInputBuffer2.dup();
            this.buffer.truncate(this.length);
            this.data = new DerInputStream(this.buffer);
            derInputBuffer.skip(this.length + n2);
        } else {
            this.buffer = derInputBuffer.dup();
            this.buffer.truncate(this.length);
            this.data = new DerInputStream(this.buffer);
            derInputBuffer.skip(this.length);
        }
    }

    public DerValue(byte[] byArray) throws IOException {
        this.data = this.init(true, new ByteArrayInputStream(byArray));
    }

    public DerValue(byte[] byArray, int n, int n2) throws IOException {
        this.data = this.init(true, new ByteArrayInputStream(byArray, n, n2));
    }

    public DerValue(InputStream inputStream) throws IOException {
        this.data = this.init(false, inputStream);
    }

    private DerInputStream init(byte by, String string) throws IOException {
        String string2 = null;
        this.tag = by;
        switch (by) {
            case 19: 
            case 22: 
            case 27: {
                string2 = "ASCII";
                break;
            }
            case 20: {
                string2 = "ISO-8859-1";
                break;
            }
            case 30: {
                string2 = "UnicodeBigUnmarked";
                break;
            }
            case 12: {
                string2 = "UTF8";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported DER string type");
            }
        }
        byte[] byArray = string.getBytes(string2);
        this.length = byArray.length;
        this.buffer = new DerInputBuffer(byArray);
        DerInputStream derInputStream = new DerInputStream(this.buffer);
        derInputStream.mark(Integer.MAX_VALUE);
        return derInputStream;
    }

    private DerInputStream init(boolean bl, InputStream inputStream) throws IOException {
        this.tag = (byte)inputStream.read();
        byte by = (byte)inputStream.read();
        this.length = DerInputStream.getLength(by & 0xFF, inputStream);
        if (this.length == -1) {
            int n = inputStream.available();
            int n2 = 2;
            byte[] byArray = new byte[n + n2];
            byArray[0] = this.tag;
            byArray[1] = by;
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            dataInputStream.readFully(byArray, n2, n);
            dataInputStream.close();
            DerIndefLenConverter derIndefLenConverter = new DerIndefLenConverter();
            inputStream = new ByteArrayInputStream(derIndefLenConverter.convert(byArray));
            if (this.tag != inputStream.read()) {
                throw new IOException("Indefinite length encoding not supported");
            }
            this.length = DerInputStream.getLength(inputStream);
        }
        if (this.length == 0) {
            return null;
        }
        if (bl && inputStream.available() != this.length) {
            throw new IOException("extra data given to DerValue constructor");
        }
        byte[] byArray = IOUtils.readFully(inputStream, this.length, true);
        this.buffer = new DerInputBuffer(byArray);
        return new DerInputStream(this.buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encode(DerOutputStream derOutputStream) throws IOException {
        derOutputStream.write(this.tag);
        derOutputStream.putLength(this.length);
        if (this.length > 0) {
            byte[] byArray = new byte[this.length];
            DerInputStream derInputStream = this.data;
            synchronized (derInputStream) {
                this.buffer.reset();
                if (this.buffer.read(byArray) != this.length) {
                    throw new IOException("short DER value read (encode)");
                }
                derOutputStream.write(byArray);
            }
        }
    }

    public final DerInputStream getData() {
        return this.data;
    }

    public final byte getTag() {
        return this.tag;
    }

    public boolean getBoolean() throws IOException {
        if (this.tag != 1) {
            throw new IOException("DerValue.getBoolean, not a BOOLEAN " + this.tag);
        }
        if (this.length != 1) {
            throw new IOException("DerValue.getBoolean, invalid length " + this.length);
        }
        return this.buffer.read() != 0;
    }

    public ObjectIdentifier getOID() throws IOException {
        if (this.tag != 6) {
            throw new IOException("DerValue.getOID, not an OID " + this.tag);
        }
        return new ObjectIdentifier(this.buffer);
    }

    private byte[] append(byte[] byArray, byte[] byArray2) {
        if (byArray == null) {
            return byArray2;
        }
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }

    public byte[] getOctetString() throws IOException {
        if (this.tag != 4 && !this.isConstructed((byte)4)) {
            throw new IOException("DerValue.getOctetString, not an Octet String: " + this.tag);
        }
        byte[] byArray = new byte[this.length];
        if (this.buffer.read(byArray) != this.length) {
            throw new IOException("short read on DerValue buffer");
        }
        if (this.isConstructed()) {
            DerInputStream derInputStream = new DerInputStream(byArray);
            byArray = null;
            while (derInputStream.available() != 0) {
                byArray = this.append(byArray, derInputStream.getOctetString());
            }
        }
        return byArray;
    }

    public int getInteger() throws IOException {
        if (this.tag != 2) {
            throw new IOException("DerValue.getInteger, not an int " + this.tag);
        }
        return this.buffer.getInteger(this.data.available());
    }

    public BigInteger getBigInteger() throws IOException {
        if (this.tag != 2) {
            throw new IOException("DerValue.getBigInteger, not an int " + this.tag);
        }
        return this.buffer.getBigInteger(this.data.available(), false);
    }

    public BigInteger getPositiveBigInteger() throws IOException {
        if (this.tag != 2) {
            throw new IOException("DerValue.getBigInteger, not an int " + this.tag);
        }
        return this.buffer.getBigInteger(this.data.available(), true);
    }

    public int getEnumerated() throws IOException {
        if (this.tag != 10) {
            throw new IOException("DerValue.getEnumerated, incorrect tag: " + this.tag);
        }
        return this.buffer.getInteger(this.data.available());
    }

    public byte[] getBitString() throws IOException {
        if (this.tag != 3) {
            throw new IOException("DerValue.getBitString, not a bit string " + this.tag);
        }
        return this.buffer.getBitString();
    }

    public BitArray getUnalignedBitString() throws IOException {
        if (this.tag != 3) {
            throw new IOException("DerValue.getBitString, not a bit string " + this.tag);
        }
        return this.buffer.getUnalignedBitString();
    }

    public String getAsString() throws IOException {
        if (this.tag == 12) {
            return this.getUTF8String();
        }
        if (this.tag == 19) {
            return this.getPrintableString();
        }
        if (this.tag == 20) {
            return this.getT61String();
        }
        if (this.tag == 22) {
            return this.getIA5String();
        }
        if (this.tag == 30) {
            return this.getBMPString();
        }
        if (this.tag == 27) {
            return this.getGeneralString();
        }
        return null;
    }

    public byte[] getBitString(boolean bl) throws IOException {
        if (!bl && this.tag != 3) {
            throw new IOException("DerValue.getBitString, not a bit string " + this.tag);
        }
        return this.buffer.getBitString();
    }

    public BitArray getUnalignedBitString(boolean bl) throws IOException {
        if (!bl && this.tag != 3) {
            throw new IOException("DerValue.getBitString, not a bit string " + this.tag);
        }
        return this.buffer.getUnalignedBitString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getDataBytes() throws IOException {
        byte[] byArray = new byte[this.length];
        DerInputStream derInputStream = this.data;
        synchronized (derInputStream) {
            this.data.reset();
            this.data.getBytes(byArray);
        }
        return byArray;
    }

    public String getPrintableString() throws IOException {
        if (this.tag != 19) {
            throw new IOException("DerValue.getPrintableString, not a string " + this.tag);
        }
        return new String(this.getDataBytes(), "ASCII");
    }

    public String getT61String() throws IOException {
        if (this.tag != 20) {
            throw new IOException("DerValue.getT61String, not T61 " + this.tag);
        }
        return new String(this.getDataBytes(), "ISO-8859-1");
    }

    public String getIA5String() throws IOException {
        if (this.tag != 22) {
            throw new IOException("DerValue.getIA5String, not IA5 " + this.tag);
        }
        return new String(this.getDataBytes(), "ASCII");
    }

    public String getBMPString() throws IOException {
        if (this.tag != 30) {
            throw new IOException("DerValue.getBMPString, not BMP " + this.tag);
        }
        return new String(this.getDataBytes(), "UnicodeBigUnmarked");
    }

    public String getUTF8String() throws IOException {
        if (this.tag != 12) {
            throw new IOException("DerValue.getUTF8String, not UTF-8 " + this.tag);
        }
        return new String(this.getDataBytes(), "UTF8");
    }

    public String getGeneralString() throws IOException {
        if (this.tag != 27) {
            throw new IOException("DerValue.getGeneralString, not GeneralString " + this.tag);
        }
        return new String(this.getDataBytes(), "ASCII");
    }

    public Date getUTCTime() throws IOException {
        if (this.tag != 23) {
            throw new IOException("DerValue.getUTCTime, not a UtcTime: " + this.tag);
        }
        return this.buffer.getUTCTime(this.data.available());
    }

    public Date getGeneralizedTime() throws IOException {
        if (this.tag != 24) {
            throw new IOException("DerValue.getGeneralizedTime, not a GeneralizedTime: " + this.tag);
        }
        return this.buffer.getGeneralizedTime(this.data.available());
    }

    public boolean equals(Object object) {
        if (object instanceof DerValue) {
            return this.equals((DerValue)object);
        }
        return false;
    }

    public boolean equals(DerValue derValue) {
        if (this == derValue) {
            return true;
        }
        if (this.tag != derValue.tag) {
            return false;
        }
        if (this.data == derValue.data) {
            return true;
        }
        return System.identityHashCode(this.data) > System.identityHashCode(derValue.data) ? DerValue.doEquals(this, derValue) : DerValue.doEquals(derValue, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean doEquals(DerValue derValue, DerValue derValue2) {
        DerInputStream derInputStream = derValue.data;
        synchronized (derInputStream) {
            DerInputStream derInputStream2 = derValue2.data;
            synchronized (derInputStream2) {
                derValue.data.reset();
                derValue2.data.reset();
                return derValue.buffer.equals(derValue2.buffer);
            }
        }
    }

    public String toString() {
        try {
            String string = this.getAsString();
            if (string != null) {
                return "\"" + string + "\"";
            }
            if (this.tag == 5) {
                return "[DerValue, null]";
            }
            if (this.tag == 6) {
                return "OID." + this.getOID();
            }
            return "[DerValue, tag = " + this.tag + ", length = " + this.length + "]";
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("misformatted DER value");
        }
    }

    public byte[] toByteArray() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        this.encode(derOutputStream);
        this.data.reset();
        return derOutputStream.toByteArray();
    }

    public DerInputStream toDerInputStream() throws IOException {
        if (this.tag == 48 || this.tag == 49) {
            return new DerInputStream(this.buffer);
        }
        throw new IOException("toDerInputStream rejects tag type " + this.tag);
    }

    public int length() {
        return this.length;
    }

    public static boolean isPrintableStringChar(char c) {
        if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') {
            return true;
        }
        switch (c) {
            case ' ': 
            case '\'': 
            case '(': 
            case ')': 
            case '+': 
            case ',': 
            case '-': 
            case '.': 
            case '/': 
            case ':': 
            case '=': 
            case '?': {
                return true;
            }
        }
        return false;
    }

    public static byte createTag(byte by, boolean bl, byte by2) {
        byte by3 = (byte)(by | by2);
        if (bl) {
            by3 = (byte)(by3 | 0x20);
        }
        return by3;
    }

    public void resetTag(byte by) {
        this.tag = by;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

