/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CertPath;
import java.security.cert.CertPathParameters;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertPathValidatorResult;
import java.security.cert.CertPathValidatorSpi;
import java.security.cert.Certificate;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.PolicyNode;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import sun.security.action.GetBooleanSecurityPropertyAction;
import sun.security.provider.certpath.AlgorithmChecker;
import sun.security.provider.certpath.BasicChecker;
import sun.security.provider.certpath.ConstraintsChecker;
import sun.security.provider.certpath.CrlRevocationChecker;
import sun.security.provider.certpath.KeyChecker;
import sun.security.provider.certpath.OCSPChecker;
import sun.security.provider.certpath.PKIXMasterCertPathValidator;
import sun.security.provider.certpath.PolicyChecker;
import sun.security.provider.certpath.PolicyNodeImpl;
import sun.security.provider.certpath.UntrustedChecker;
import sun.security.util.Debug;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PKIXCertPathValidator
extends CertPathValidatorSpi {
    private static final Debug debug = Debug.getInstance("certpath");
    private Date testDate;
    private List<PKIXCertPathChecker> userCheckers;
    private String sigProvider;
    private BasicChecker basicChecker;
    private boolean ocspEnabled = false;
    private boolean onlyEECert = false;

    /*
     * WARNING - void declaration
     */
    @Override
    public CertPathValidatorResult engineValidate(CertPath certPath, CertPathParameters certPathParameters) throws CertPathValidatorException, InvalidAlgorithmParameterException {
        if (debug != null) {
            debug.println("PKIXCertPathValidator.engineValidate()...");
        }
        if (!(certPathParameters instanceof PKIXParameters)) {
            throw new InvalidAlgorithmParameterException("inappropriate parameters, must be an instance of PKIXParameters");
        }
        if (!certPath.getType().equals("X.509") && !certPath.getType().equals("X509")) {
            throw new InvalidAlgorithmParameterException("inappropriate certification path type specified, must be X.509 or X509");
        }
        PKIXParameters pKIXParameters = (PKIXParameters)certPathParameters;
        Set<TrustAnchor> set = pKIXParameters.getTrustAnchors();
        for (TrustAnchor object2 : set) {
            if (object2.getNameConstraints() == null) continue;
            throw new InvalidAlgorithmParameterException("name constraints in trust anchor not supported");
        }
        ArrayList<? extends Certificate> arrayList = new ArrayList<Certificate>(certPath.getCertificates());
        if (debug != null) {
            if (arrayList.isEmpty()) {
                debug.println("PKIXCertPathValidator.engineValidate() certList is empty");
            }
            debug.println("PKIXCertPathValidator.engineValidate() reversing certpath...");
        }
        Collections.reverse(arrayList);
        this.populateVariables(pKIXParameters);
        Object var6_7 = null;
        if (!arrayList.isEmpty()) {
            X509Certificate x509Certificate = (X509Certificate)arrayList.get(0);
        }
        CertPathValidatorException certPathValidatorException = null;
        for (TrustAnchor trustAnchor : set) {
            X509Certificate x509Certificate = trustAnchor.getTrustedCert();
            if (x509Certificate != null) {
                void var6_9;
                if (debug != null) {
                    debug.println("PKIXCertPathValidator.engineValidate() anchor.getTrustedCert() != null");
                }
                if (!this.isWorthTrying(x509Certificate, (X509Certificate)var6_9)) continue;
                if (debug != null) {
                    debug.println("anchor.getTrustedCert().getSubjectX500Principal() = " + x509Certificate.getSubjectX500Principal());
                }
            } else if (debug != null) {
                debug.println("PKIXCertPathValidator.engineValidate(): anchor.getTrustedCert() == null");
            }
            try {
                PolicyNodeImpl policyNodeImpl = new PolicyNodeImpl(null, "2.5.29.32.0", null, false, Collections.singleton("2.5.29.32.0"), false);
                PolicyNode policyNode = this.doValidate(trustAnchor, certPath, (List<X509Certificate>)arrayList, pKIXParameters, policyNodeImpl);
                return new PKIXCertPathValidatorResult(trustAnchor, policyNode, this.basicChecker.getPublicKey());
            }
            catch (CertPathValidatorException certPathValidatorException2) {
                certPathValidatorException = certPathValidatorException2;
            }
        }
        if (certPathValidatorException != null) {
            throw certPathValidatorException;
        }
        throw new CertPathValidatorException("Path does not chain with any of the trust anchors");
    }

    private boolean isWorthTrying(X509Certificate x509Certificate, X509Certificate x509Certificate2) throws CertPathValidatorException {
        if (debug != null) {
            debug.println("PKIXCertPathValidator.isWorthTrying() checking if this trusted cert is worth trying ...");
        }
        if (x509Certificate2 == null) {
            return true;
        }
        X500Principal x500Principal = x509Certificate.getSubjectX500Principal();
        if (x500Principal.equals(x509Certificate2.getIssuerX500Principal())) {
            if (debug != null) {
                debug.println("YES - try this trustedCert");
            }
            return true;
        }
        if (debug != null) {
            debug.println("NO - don't try this trustedCert");
        }
        return false;
    }

    private void populateVariables(PKIXParameters pKIXParameters) throws CertPathValidatorException {
        this.testDate = pKIXParameters.getDate();
        if (this.testDate == null) {
            this.testDate = new Date(System.currentTimeMillis());
        }
        this.userCheckers = pKIXParameters.getCertPathCheckers();
        this.sigProvider = pKIXParameters.getSigProvider();
        if (pKIXParameters.isRevocationEnabled()) {
            this.ocspEnabled = AccessController.doPrivileged(new GetBooleanSecurityPropertyAction("ocsp.enable"));
            this.onlyEECert = AccessController.doPrivileged(new GetBooleanSecurityPropertyAction("com.sun.security.onlyCheckRevocationOfEECert"));
        }
    }

    private PolicyNode doValidate(TrustAnchor trustAnchor, CertPath certPath, List<X509Certificate> list, PKIXParameters pKIXParameters, PolicyNodeImpl policyNodeImpl) throws CertPathValidatorException {
        Object object;
        ArrayList<PKIXCertPathChecker> arrayList = new ArrayList<PKIXCertPathChecker>();
        int n = list.size();
        this.basicChecker = new BasicChecker(trustAnchor, this.testDate, this.sigProvider, false);
        AlgorithmChecker algorithmChecker = new AlgorithmChecker(trustAnchor);
        KeyChecker keyChecker = new KeyChecker(n, pKIXParameters.getTargetCertConstraints());
        ConstraintsChecker constraintsChecker = new ConstraintsChecker(n);
        PolicyChecker policyChecker = new PolicyChecker(pKIXParameters.getInitialPolicies(), n, pKIXParameters.isExplicitPolicyRequired(), pKIXParameters.isPolicyMappingInhibited(), pKIXParameters.isAnyPolicyInhibited(), pKIXParameters.getPolicyQualifiersRejected(), policyNodeImpl);
        UntrustedChecker untrustedChecker = new UntrustedChecker();
        X509Certificate x509Certificate = trustAnchor.getTrustedCert();
        if (x509Certificate != null) {
            untrustedChecker.check(x509Certificate, Collections.<String>emptySet());
        }
        arrayList.add(untrustedChecker);
        arrayList.add(algorithmChecker);
        arrayList.add(keyChecker);
        arrayList.add(constraintsChecker);
        arrayList.add(policyChecker);
        arrayList.add(this.basicChecker);
        if (pKIXParameters.isRevocationEnabled()) {
            if (this.ocspEnabled) {
                object = new OCSPChecker(certPath, pKIXParameters, this.onlyEECert);
                arrayList.add((PKIXCertPathChecker)object);
            }
            object = new CrlRevocationChecker(trustAnchor, pKIXParameters, list, this.onlyEECert);
            arrayList.add((PKIXCertPathChecker)object);
        }
        arrayList.addAll(this.userCheckers);
        object = new PKIXMasterCertPathValidator(arrayList);
        ((PKIXMasterCertPathValidator)object).validate(certPath, list);
        return policyChecker.getPolicyTree();
    }
}

