/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.crypto;

import java.util.ArrayList;
import javax.crypto.Cipher;
import sun.security.krb5.Config;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KrbCryptoException;
import sun.security.krb5.KrbException;
import sun.security.krb5.internal.KdcErrException;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.KrbApErrException;
import sun.security.krb5.internal.crypto.Aes128CtsHmacSha1EType;
import sun.security.krb5.internal.crypto.Aes256CtsHmacSha1EType;
import sun.security.krb5.internal.crypto.ArcFourHmacEType;
import sun.security.krb5.internal.crypto.Des3CbcHmacSha1KdEType;
import sun.security.krb5.internal.crypto.DesCbcCrcEType;
import sun.security.krb5.internal.crypto.DesCbcMd5EType;
import sun.security.krb5.internal.crypto.NullEType;

public abstract class EType {
    private static final boolean DEBUG = Krb5.DEBUG;
    private static final int[] BUILTIN_ETYPES = new int[]{3, 1, 23, 16, 17, 18};
    private static final int[] BUILTIN_ETYPES_NOAES256 = new int[]{3, 1, 23, 16, 17};

    public static EType getInstance(int n) throws KdcErrException {
        EType eType = null;
        String string = null;
        switch (n) {
            case 0: {
                eType = new NullEType();
                string = "sun.security.krb5.internal.crypto.NullEType";
                break;
            }
            case 1: {
                eType = new DesCbcCrcEType();
                string = "sun.security.krb5.internal.crypto.DesCbcCrcEType";
                break;
            }
            case 3: {
                eType = new DesCbcMd5EType();
                string = "sun.security.krb5.internal.crypto.DesCbcMd5EType";
                break;
            }
            case 16: {
                eType = new Des3CbcHmacSha1KdEType();
                string = "sun.security.krb5.internal.crypto.Des3CbcHmacSha1KdEType";
                break;
            }
            case 17: {
                eType = new Aes128CtsHmacSha1EType();
                string = "sun.security.krb5.internal.crypto.Aes128CtsHmacSha1EType";
                break;
            }
            case 18: {
                eType = new Aes256CtsHmacSha1EType();
                string = "sun.security.krb5.internal.crypto.Aes256CtsHmacSha1EType";
                break;
            }
            case 23: {
                eType = new ArcFourHmacEType();
                string = "sun.security.krb5.internal.crypto.ArcFourHmacEType";
                break;
            }
            default: {
                String string2 = "encryption type = " + EType.toString(n) + " (" + n + ")";
                throw new KdcErrException(14, string2);
            }
        }
        if (DEBUG) {
            System.out.println(">>> EType: " + string);
        }
        return eType;
    }

    public abstract int eType();

    public abstract int minimumPadSize();

    public abstract int confounderSize();

    public abstract int checksumType();

    public abstract int checksumSize();

    public abstract int blockSize();

    public abstract int keyType();

    public abstract int keySize();

    public abstract byte[] encrypt(byte[] var1, byte[] var2, int var3) throws KrbCryptoException;

    public abstract byte[] encrypt(byte[] var1, byte[] var2, byte[] var3, int var4) throws KrbCryptoException;

    public abstract byte[] decrypt(byte[] var1, byte[] var2, int var3) throws KrbApErrException, KrbCryptoException;

    public abstract byte[] decrypt(byte[] var1, byte[] var2, byte[] var3, int var4) throws KrbApErrException, KrbCryptoException;

    public int dataSize(byte[] byArray) {
        return byArray.length - this.startOfData();
    }

    public int padSize(byte[] byArray) {
        return byArray.length - this.confounderSize() - this.checksumSize() - this.dataSize(byArray);
    }

    public int startOfChecksum() {
        return this.confounderSize();
    }

    public int startOfData() {
        return this.confounderSize() + this.checksumSize();
    }

    public int startOfPad(byte[] byArray) {
        return this.confounderSize() + this.checksumSize() + this.dataSize(byArray);
    }

    public byte[] decryptedData(byte[] byArray) {
        int n = this.dataSize(byArray);
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, this.startOfData(), byArray2, 0, n);
        return byArray2;
    }

    public static int[] getBuiltInDefaults() {
        int n = 0;
        try {
            n = Cipher.getMaxAllowedKeyLength("AES");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n < 256) {
            return BUILTIN_ETYPES_NOAES256;
        }
        return BUILTIN_ETYPES;
    }

    public static int[] getDefaults(String string) {
        try {
            return Config.getInstance().defaultEtype(string);
        }
        catch (KrbException krbException) {
            if (DEBUG) {
                System.out.println("Exception while getting " + string + krbException.getMessage());
                System.out.println("Using defaults des-cbc-md5, des-cbc-crc, des3-cbc-sha1, aes128cts, aes256cts, rc4-hmac");
            }
            return EType.getBuiltInDefaults();
        }
    }

    public static int[] getDefaults(String string, EncryptionKey[] encryptionKeyArray) throws KrbException {
        int n;
        int[] nArray = EType.getDefaults(string);
        if (nArray == null) {
            throw new KrbException("No supported encryption types listed in " + string);
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>(nArray.length);
        for (n = 0; n < nArray.length; ++n) {
            if (EncryptionKey.findKey(nArray[n], encryptionKeyArray) == null) continue;
            arrayList.add(nArray[n]);
        }
        n = arrayList.size();
        if (n <= 0) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < encryptionKeyArray.length; ++i) {
                stringBuffer.append(EType.toString(encryptionKeyArray[i].getEType()));
                stringBuffer.append(" ");
            }
            throw new KrbException("Do not have keys of types listed in " + string + " available; only have keys of following type: " + stringBuffer.toString());
        }
        nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = (Integer)arrayList.get(i);
        }
        return nArray;
    }

    public static boolean isSupported(int n, int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            if (n != nArray[i]) continue;
            return true;
        }
        return false;
    }

    public static boolean isSupported(int n) {
        int[] nArray = EType.getBuiltInDefaults();
        return EType.isSupported(n, nArray);
    }

    public static String toString(int n) {
        switch (n) {
            case 0: {
                return "NULL";
            }
            case 1: {
                return "DES CBC mode with CRC-32";
            }
            case 2: {
                return "DES CBC mode with MD4";
            }
            case 3: {
                return "DES CBC mode with MD5";
            }
            case 4: {
                return "reserved";
            }
            case 5: {
                return "DES3 CBC mode with MD5";
            }
            case 6: {
                return "reserved";
            }
            case 7: {
                return "DES3 CBC mode with SHA1";
            }
            case 9: {
                return "DSA with SHA1- Cms0ID";
            }
            case 10: {
                return "MD5 with RSA encryption - Cms0ID";
            }
            case 11: {
                return "SHA1 with RSA encryption - Cms0ID";
            }
            case 12: {
                return "RC2 CBC mode with Env0ID";
            }
            case 13: {
                return "RSA encryption with Env0ID";
            }
            case 14: {
                return "RSAES-0AEP-ENV-0ID";
            }
            case 15: {
                return "DES-EDE3-CBC-ENV-0ID";
            }
            case 16: {
                return "DES3 CBC mode with SHA1-KD";
            }
            case 17: {
                return "AES128 CTS mode with HMAC SHA1-96";
            }
            case 18: {
                return "AES256 CTS mode with HMAC SHA1-96";
            }
            case 23: {
                return "RC4 with HMAC";
            }
            case 24: {
                return "RC4 with HMAC EXP";
            }
        }
        return "Unknown (" + n + ")";
    }
}

