/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss.wrapper;

import java.io.UnsupportedEncodingException;
import java.security.Provider;
import java.util.Vector;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;
import sun.security.jgss.GSSCaller;
import sun.security.jgss.GSSExceptionImpl;
import sun.security.jgss.GSSUtil;
import sun.security.jgss.spi.GSSContextSpi;
import sun.security.jgss.spi.GSSCredentialSpi;
import sun.security.jgss.spi.GSSNameSpi;
import sun.security.jgss.spi.MechanismFactory;
import sun.security.jgss.wrapper.GSSCredElement;
import sun.security.jgss.wrapper.GSSLibStub;
import sun.security.jgss.wrapper.GSSNameElement;
import sun.security.jgss.wrapper.NativeGSSContext;
import sun.security.jgss.wrapper.SunNativeProvider;

public final class NativeGSSFactory
implements MechanismFactory {
    GSSLibStub cStub = null;
    private final GSSCaller caller;

    private GSSCredElement getCredFromSubject(GSSNameElement gSSNameElement, boolean bl) throws GSSException {
        GSSCredElement gSSCredElement;
        Oid oid = this.cStub.getMech();
        Vector vector = GSSUtil.searchSubject(gSSNameElement, oid, bl, GSSCredElement.class);
        if (vector != null && vector.isEmpty() && GSSUtil.useSubjectCredsOnly(this.caller)) {
            throw new GSSException(13);
        }
        GSSCredElement gSSCredElement2 = gSSCredElement = vector == null || vector.isEmpty() ? null : (GSSCredElement)vector.firstElement();
        if (gSSCredElement != null) {
            gSSCredElement.doServicePermCheck();
        }
        return gSSCredElement;
    }

    public NativeGSSFactory(GSSCaller gSSCaller) {
        this.caller = gSSCaller;
    }

    public void setMech(Oid oid) throws GSSException {
        this.cStub = GSSLibStub.getInstance(oid);
    }

    public GSSNameSpi getNameElement(String string, Oid oid) throws GSSException {
        try {
            byte[] byArray = string == null ? null : string.getBytes("UTF-8");
            return new GSSNameElement(byArray, oid, this.cStub);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new GSSExceptionImpl(11, unsupportedEncodingException);
        }
    }

    public GSSNameSpi getNameElement(byte[] byArray, Oid oid) throws GSSException {
        return new GSSNameElement(byArray, oid, this.cStub);
    }

    public GSSCredentialSpi getCredentialElement(GSSNameSpi gSSNameSpi, int n, int n2, int n3) throws GSSException {
        GSSCredElement gSSCredElement;
        GSSNameElement gSSNameElement = null;
        gSSNameElement = gSSNameSpi != null && !(gSSNameSpi instanceof GSSNameElement) ? (GSSNameElement)this.getNameElement(((Object)gSSNameSpi).toString(), gSSNameSpi.getStringNameType()) : (GSSNameElement)gSSNameSpi;
        if (n3 == 0) {
            n3 = 1;
        }
        if ((gSSCredElement = this.getCredFromSubject(gSSNameElement, n3 == 1)) == null) {
            if (n3 == 1) {
                gSSCredElement = new GSSCredElement(gSSNameElement, n, n3, this.cStub);
            } else if (n3 == 2) {
                if (gSSNameElement == null) {
                    gSSNameElement = GSSNameElement.DEF_ACCEPTOR;
                }
                gSSCredElement = new GSSCredElement(gSSNameElement, n2, n3, this.cStub);
            } else {
                throw new GSSException(11, -1, "Unknown usage mode requested");
            }
        }
        return gSSCredElement;
    }

    public GSSContextSpi getMechanismContext(GSSNameSpi gSSNameSpi, GSSCredentialSpi gSSCredentialSpi, int n) throws GSSException {
        if (gSSNameSpi == null) {
            throw new GSSException(3);
        }
        if (!(gSSNameSpi instanceof GSSNameElement)) {
            gSSNameSpi = (GSSNameElement)this.getNameElement(((Object)gSSNameSpi).toString(), gSSNameSpi.getStringNameType());
        }
        if (gSSCredentialSpi == null) {
            gSSCredentialSpi = this.getCredFromSubject(null, true);
        } else if (!(gSSCredentialSpi instanceof GSSCredElement)) {
            throw new GSSException(13);
        }
        return new NativeGSSContext((GSSNameElement)gSSNameSpi, (GSSCredElement)gSSCredentialSpi, n, this.cStub);
    }

    public GSSContextSpi getMechanismContext(GSSCredentialSpi gSSCredentialSpi) throws GSSException {
        if (gSSCredentialSpi == null) {
            gSSCredentialSpi = this.getCredFromSubject(null, false);
        } else if (!(gSSCredentialSpi instanceof GSSCredElement)) {
            throw new GSSException(13);
        }
        return new NativeGSSContext((GSSCredElement)gSSCredentialSpi, this.cStub);
    }

    public GSSContextSpi getMechanismContext(byte[] byArray) throws GSSException {
        return this.cStub.importContext(byArray);
    }

    public final Oid getMechanismOid() {
        return this.cStub.getMech();
    }

    public Provider getProvider() {
        return SunNativeProvider.INSTANCE;
    }

    public Oid[] getNameTypes() throws GSSException {
        return this.cStub.inquireNamesForMech();
    }
}

