/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.net.SocketException;
import sun.nio.ch.DatagramChannelImpl;
import sun.nio.ch.Net;
import sun.nio.ch.ServerSocketChannelImpl;
import sun.nio.ch.SocketChannelImpl;
import sun.nio.ch.SocketOpts;

class OptionAdaptor {
    private final SocketOpts.IP opts;

    OptionAdaptor(SocketChannelImpl socketChannelImpl) {
        this.opts = (SocketOpts.IP)socketChannelImpl.options();
    }

    OptionAdaptor(ServerSocketChannelImpl serverSocketChannelImpl) {
        this.opts = (SocketOpts.IP)serverSocketChannelImpl.options();
    }

    OptionAdaptor(DatagramChannelImpl datagramChannelImpl) {
        this.opts = (SocketOpts.IP)datagramChannelImpl.options();
    }

    private SocketOpts.IP opts() {
        return this.opts;
    }

    private SocketOpts.IP.TCP tcpOpts() {
        return (SocketOpts.IP.TCP)this.opts;
    }

    public void setTcpNoDelay(boolean bl) throws SocketException {
        try {
            this.tcpOpts().noDelay(bl);
        }
        catch (Exception exception) {
            Net.translateToSocketException(exception);
        }
    }

    public boolean getTcpNoDelay() throws SocketException {
        try {
            return this.tcpOpts().noDelay();
        }
        catch (Exception exception) {
            Net.translateToSocketException(exception);
            return false;
        }
    }

    public void setSoLinger(boolean bl, int n) throws SocketException {
        try {
            if (n > 65535) {
                n = 65535;
            }
            this.opts().linger(bl ? n : -1);
        }
        catch (Exception exception) {
            Net.translateToSocketException(exception);
        }
    }

    public int getSoLinger() throws SocketException {
        try {
            return this.opts().linger();
        }
        catch (Exception exception) {
            Net.translateToSocketException(exception);
            return 0;
        }
    }

    public void setOOBInline(boolean bl) throws SocketException {
        try {
            this.opts().outOfBandInline(bl);
        }
        catch (Exception exception) {
            Net.translateToSocketException(exception);
        }
    }

    public boolean getOOBInline() throws SocketException {
        try {
            return this.opts().outOfBandInline();
        }
        catch (Exception exception) {
            Net.translateToSocketException(exception);
            return false;
        }
    }

    public void setSendBufferSize(int n) throws SocketException {
        try {
            this.opts().sendBufferSize(n);
        }
        catch (Exception exception) {
            Net.translateToSocketException(exception);
        }
    }

    public int getSendBufferSize() throws SocketException {
        try {
            return this.opts().sendBufferSize();
        }
        catch (Exception exception) {
            Net.translateToSocketException(exception);
            return 0;
        }
    }

    public void setReceiveBufferSize(int n) throws SocketException {
        try {
            this.opts().receiveBufferSize(n);
        }
        catch (Exception exception) {
            Net.translateToSocketException(exception);
        }
    }

    public int getReceiveBufferSize() throws SocketException {
        try {
            return this.opts().receiveBufferSize();
        }
        catch (Exception exception) {
            Net.translateToSocketException(exception);
            return 0;
        }
    }

    public void setKeepAlive(boolean bl) throws SocketException {
        try {
            this.opts().keepAlive(bl);
        }
        catch (Exception exception) {
            Net.translateToSocketException(exception);
        }
    }

    public boolean getKeepAlive() throws SocketException {
        try {
            return this.opts().keepAlive();
        }
        catch (Exception exception) {
            Net.translateToSocketException(exception);
            return false;
        }
    }

    public void setTrafficClass(int n) throws SocketException {
        if (n < 0 || n > 255) {
            throw new IllegalArgumentException("tc is not in range 0 -- 255");
        }
        try {
            this.opts().typeOfService(n);
        }
        catch (Exception exception) {
            Net.translateToSocketException(exception);
        }
    }

    public int getTrafficClass() throws SocketException {
        try {
            return this.opts().typeOfService();
        }
        catch (Exception exception) {
            Net.translateToSocketException(exception);
            return 0;
        }
    }

    public void setReuseAddress(boolean bl) throws SocketException {
        try {
            this.opts().reuseAddress(bl);
        }
        catch (Exception exception) {
            Net.translateToSocketException(exception);
        }
    }

    public boolean getReuseAddress() throws SocketException {
        try {
            return this.opts().reuseAddress();
        }
        catch (Exception exception) {
            Net.translateToSocketException(exception);
            return false;
        }
    }

    public void setBroadcast(boolean bl) throws SocketException {
        try {
            this.opts().broadcast(bl);
        }
        catch (Exception exception) {
            Net.translateToSocketException(exception);
        }
    }

    public boolean getBroadcast() throws SocketException {
        try {
            return this.opts().broadcast();
        }
        catch (Exception exception) {
            Net.translateToSocketException(exception);
            return false;
        }
    }
}

