/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.jar;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import sun.misc.IOUtils;
import sun.net.www.ParseUtil;
import sun.net.www.protocol.jar.URLJarFileCallBack;

public class URLJarFile
extends JarFile {
    private static URLJarFileCallBack callback = null;
    private URLJarFileCloseController closeController = null;
    private static int BUF_SIZE = 2048;
    private Manifest superMan;
    private Attributes superAttr;
    private Map superEntries;

    static JarFile getJarFile(URL uRL) throws IOException {
        return URLJarFile.getJarFile(uRL, null);
    }

    static JarFile getJarFile(URL uRL, URLJarFileCloseController uRLJarFileCloseController) throws IOException {
        if (URLJarFile.isFileURL(uRL)) {
            return new URLJarFile(uRL, uRLJarFileCloseController);
        }
        return URLJarFile.retrieve(uRL, uRLJarFileCloseController);
    }

    public URLJarFile(File file) throws IOException {
        this(file, null);
    }

    public URLJarFile(File file, URLJarFileCloseController uRLJarFileCloseController) throws IOException {
        super(file, true, 5);
        this.closeController = uRLJarFileCloseController;
    }

    private URLJarFile(URL uRL, URLJarFileCloseController uRLJarFileCloseController) throws IOException {
        super(ParseUtil.decode(uRL.getFile()));
        this.closeController = uRLJarFileCloseController;
    }

    private static boolean isFileURL(URL uRL) {
        String string;
        return uRL.getProtocol().equalsIgnoreCase("file") && ((string = uRL.getHost()) == null || string.equals("") || string.equals("~") || string.equalsIgnoreCase("localhost"));
    }

    protected void finalize() throws IOException {
        this.close();
    }

    public ZipEntry getEntry(String string) {
        ZipEntry zipEntry = super.getEntry(string);
        if (zipEntry != null) {
            if (zipEntry instanceof JarEntry) {
                return new URLJarFileEntry((JarEntry)zipEntry);
            }
            throw new InternalError(super.getClass() + " returned unexpected entry type " + zipEntry.getClass());
        }
        return null;
    }

    public Manifest getManifest() throws IOException {
        if (!this.isSuperMan()) {
            return null;
        }
        Manifest manifest = new Manifest();
        Attributes attributes = manifest.getMainAttributes();
        attributes.putAll((Map<?, ?>)((Map)this.superAttr.clone()));
        if (this.superEntries != null) {
            Map<String, Attributes> map = manifest.getEntries();
            for (Object k : this.superEntries.keySet()) {
                Attributes attributes2 = (Attributes)this.superEntries.get(k);
                map.put((String)k, (Attributes)attributes2.clone());
            }
        }
        return manifest;
    }

    public void close() throws IOException {
        if (this.closeController != null) {
            this.closeController.close(this);
        }
        super.close();
    }

    private synchronized boolean isSuperMan() throws IOException {
        if (this.superMan == null) {
            this.superMan = super.getManifest();
        }
        if (this.superMan != null) {
            this.superAttr = this.superMan.getMainAttributes();
            this.superEntries = this.superMan.getEntries();
            return true;
        }
        return false;
    }

    private static JarFile retrieve(URL uRL) throws IOException {
        return URLJarFile.retrieve(uRL, null);
    }

    private static JarFile retrieve(URL uRL, final URLJarFileCloseController uRLJarFileCloseController) throws IOException {
        if (callback != null) {
            return callback.retrieve(uRL);
        }
        JarFile jarFile = null;
        final InputStream inputStream = uRL.openConnection().getInputStream();
        try {
            jarFile = (JarFile)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    URLJarFile uRLJarFile;
                    FileOutputStream fileOutputStream;
                    block8: {
                        fileOutputStream = null;
                        File file = null;
                        try {
                            file = IOUtils.createTempFile("jar_cache", null);
                            file.deleteOnExit();
                            fileOutputStream = new FileOutputStream(file);
                            int n = 0;
                            byte[] byArray = new byte[BUF_SIZE];
                            while ((n = inputStream.read(byArray)) != -1) {
                                ((OutputStream)fileOutputStream).write(byArray, 0, n);
                            }
                            ((OutputStream)fileOutputStream).close();
                            fileOutputStream = null;
                            uRLJarFile = new URLJarFile(file, uRLJarFileCloseController);
                            Object var7_7 = null;
                            if (inputStream == null) break block8;
                        }
                        catch (IOException iOException) {
                            try {
                                if (file != null) {
                                    file.delete();
                                }
                                throw iOException;
                            }
                            catch (Throwable throwable) {
                                block9: {
                                    Object var7_8 = null;
                                    if (inputStream != null) {
                                        inputStream.close();
                                    }
                                    if (fileOutputStream == null) break block9;
                                    ((OutputStream)fileOutputStream).close();
                                }
                                throw throwable;
                            }
                        }
                        inputStream.close();
                    }
                    if (fileOutputStream != null) {
                        ((OutputStream)fileOutputStream).close();
                    }
                    return uRLJarFile;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
        return jarFile;
    }

    public static void setCallBack(URLJarFileCallBack uRLJarFileCallBack) {
        callback = uRLJarFileCallBack;
    }

    public static interface URLJarFileCloseController {
        public void close(JarFile var1);
    }

    private class URLJarFileEntry
    extends JarEntry {
        private JarEntry je;

        URLJarFileEntry(JarEntry jarEntry) {
            super(jarEntry);
            this.je = jarEntry;
        }

        public Attributes getAttributes() throws IOException {
            Attributes attributes;
            Map map;
            if (URLJarFile.this.isSuperMan() && (map = URLJarFile.this.superEntries) != null && (attributes = (Attributes)map.get(this.getName())) != null) {
                return (Attributes)attributes.clone();
            }
            return null;
        }

        public Certificate[] getCertificates() {
            Certificate[] certificateArray = this.je.getCertificates();
            return certificateArray == null ? null : (Certificate[])certificateArray.clone();
        }

        public CodeSigner[] getCodeSigners() {
            CodeSigner[] codeSignerArray = this.je.getCodeSigners();
            return codeSignerArray == null ? null : (CodeSigner[])codeSignerArray.clone();
        }
    }
}

