/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.http;

import java.io.IOException;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.Arrays;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import sun.net.www.protocol.http.HttpCallerInfo;

public class NegotiateCallbackHandler
implements CallbackHandler {
    private String username;
    private char[] password;
    private final HttpCallerInfo hci;

    public NegotiateCallbackHandler(HttpCallerInfo httpCallerInfo) {
        this.hci = httpCallerInfo;
    }

    public void handle(Callback[] callbackArray) throws UnsupportedCallbackException, IOException {
        for (int i = 0; i < callbackArray.length; ++i) {
            Object object;
            Callback callback = callbackArray[i];
            if (callback instanceof NameCallback) {
                if (this.username == null) {
                    object = Authenticator.requestPasswordAuthentication(this.hci.host, this.hci.addr, this.hci.port, this.hci.protocol, this.hci.prompt, this.hci.scheme, this.hci.url, this.hci.authType);
                    this.username = ((PasswordAuthentication)object).getUserName();
                    this.password = ((PasswordAuthentication)object).getPassword();
                }
                object = (NameCallback)callback;
                ((NameCallback)object).setName(this.username);
                continue;
            }
            if (callback instanceof PasswordCallback) {
                object = (PasswordCallback)callback;
                if (this.password == null) {
                    PasswordAuthentication passwordAuthentication = Authenticator.requestPasswordAuthentication(this.hci.host, this.hci.addr, this.hci.port, this.hci.protocol, this.hci.prompt, this.hci.scheme, this.hci.url, this.hci.authType);
                    this.username = passwordAuthentication.getUserName();
                    this.password = passwordAuthentication.getPassword();
                }
                ((PasswordCallback)object).setPassword(this.password);
                Arrays.fill(this.password, ' ');
                continue;
            }
            throw new UnsupportedCallbackException(callback, "Call back not supported");
        }
    }
}

