/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.http;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import sun.net.www.http.ClientVector;
import sun.net.www.http.HttpClient;
import sun.net.www.http.KeepAliveEntry;
import sun.net.www.http.KeepAliveKey;
import sun.security.action.GetIntegerAction;

public class KeepAliveCache
extends ConcurrentHashMap
implements Runnable {
    private static final long serialVersionUID = -2937172892064557949L;
    static final int MAX_CONNECTIONS = 5;
    static int result = -1;
    static final int LIFETIME = 5000;
    private Thread keepAliveTimer = null;

    static int getMaxConnections() {
        if (result == -1 && (result = AccessController.doPrivileged(new GetIntegerAction("http.maxConnections", 5)).intValue()) <= 0) {
            result = 5;
        }
        return result;
    }

    public synchronized void put(URL uRL, Object object, HttpClient httpClient) {
        ClientVector clientVector;
        Object object2;
        boolean bl;
        boolean bl2 = bl = this.keepAliveTimer == null;
        if (!bl && !this.keepAliveTimer.isAlive()) {
            bl = true;
        }
        if (bl) {
            this.clear();
            object2 = this;
            AccessController.doPrivileged(new PrivilegedAction((KeepAliveCache)object2){
                final /* synthetic */ KeepAliveCache val$cache;
                {
                    this.val$cache = keepAliveCache2;
                }

                public Object run() {
                    ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
                    ThreadGroup threadGroup2 = null;
                    while ((threadGroup2 = threadGroup.getParent()) != null) {
                        threadGroup = threadGroup2;
                    }
                    KeepAliveCache.this.keepAliveTimer = new Thread(threadGroup, this.val$cache, "Keep-Alive-Timer");
                    KeepAliveCache.this.keepAliveTimer.setDaemon(true);
                    KeepAliveCache.this.keepAliveTimer.setPriority(8);
                    KeepAliveCache.this.keepAliveTimer.start();
                    return null;
                }
            });
        }
        if ((clientVector = (ClientVector)super.get(object2 = new KeepAliveKey(uRL, object))) == null) {
            int n = httpClient.getKeepAliveTimeout();
            clientVector = new ClientVector(n > 0 ? n * 1000 : 5000);
            clientVector.put(httpClient);
            super.put(object2, clientVector);
        } else {
            clientVector.put(httpClient);
        }
    }

    public synchronized void remove(HttpClient httpClient, Object object) {
        KeepAliveKey keepAliveKey = new KeepAliveKey(httpClient.url, object);
        ClientVector clientVector = (ClientVector)super.get(keepAliveKey);
        if (clientVector != null) {
            clientVector.remove(httpClient);
            if (clientVector.empty()) {
                this.removeVector(keepAliveKey);
            }
        }
    }

    synchronized void removeVector(KeepAliveKey keepAliveKey) {
        super.remove(keepAliveKey);
    }

    public synchronized Object get(URL uRL, Object object) {
        KeepAliveKey keepAliveKey = new KeepAliveKey(uRL, object);
        ClientVector clientVector = (ClientVector)super.get(keepAliveKey);
        if (clientVector == null) {
            return null;
        }
        return clientVector.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        do {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            KeepAliveCache keepAliveCache = this;
            synchronized (keepAliveCache) {
                long l = System.currentTimeMillis();
                Iterator<Object> iterator = this.keySet().iterator();
                ArrayList<KeepAliveKey> arrayList = new ArrayList<KeepAliveKey>();
                while (iterator.hasNext()) {
                    ClientVector clientVector;
                    KeepAliveKey keepAliveKey = (KeepAliveKey)iterator.next();
                    ClientVector clientVector2 = clientVector = (ClientVector)this.get(keepAliveKey);
                    synchronized (clientVector2) {
                        int n;
                        for (n = 0; n < clientVector.size(); ++n) {
                            KeepAliveEntry keepAliveEntry = (KeepAliveEntry)clientVector.elementAt(n);
                            if (l - keepAliveEntry.idleStartTime <= (long)clientVector.nap) break;
                            HttpClient httpClient = keepAliveEntry.hc;
                            httpClient.closeServer();
                        }
                        clientVector.subList(0, n).clear();
                        if (clientVector.size() == 0) {
                            arrayList.add(keepAliveKey);
                        }
                    }
                }
                iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    this.removeVector((KeepAliveKey)iterator.next());
                }
            }
        } while (this.size() > 0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        throw new NotSerializableException();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        throw new NotSerializableException();
    }
}

