/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.Choice;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.peer.ChoicePeer;
import sun.awt.motif.MComponentPeer;
import sun.awt.motif.MToolkit;

class MChoicePeer
extends MComponentPeer
implements ChoicePeer {
    boolean inUpCall = false;

    native void create(MComponentPeer var1);

    native void pReshape(int var1, int var2, int var3, int var4);

    native void pSelect(int var1, boolean var2);

    native void appendItems(String[] var1);

    void initialize() {
        Choice choice = (Choice)this.target;
        int n = choice.countItems();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = choice.getItem(i);
        }
        if (n > 0) {
            this.appendItems(stringArray);
            this.pSelect(choice.getSelectedIndex(), true);
        }
        super.initialize();
    }

    public MChoicePeer(Choice choice) {
        super(choice);
    }

    public boolean isFocusable() {
        return true;
    }

    public Dimension getMinimumSize() {
        FontMetrics fontMetrics = this.getFontMetrics(this.target.getFont());
        Choice choice = (Choice)this.target;
        int n = 0;
        int n2 = choice.countItems();
        while (n2-- > 0) {
            n = Math.max(fontMetrics.stringWidth(choice.getItem(n2)), n);
        }
        return new Dimension(32 + n, Math.max(fontMetrics.getHeight() + 8, 15) + 5);
    }

    public native void setFont(Font var1);

    public void add(String string, int n) {
        this.addItem(string, n);
        Rectangle rectangle = this.target.getBounds();
        this.reshape(rectangle.x, rectangle.y, 0, 0);
    }

    public native void remove(int var1);

    public native void removeAll();

    public native void addItem(String var1, int var2);

    public native void setBackground(Color var1);

    public native void setForeground(Color var1);

    public void select(int n) {
        if (!this.inUpCall) {
            this.pSelect(n, false);
        }
    }

    void notifySelection(String string) {
        Choice choice = (Choice)this.target;
        ItemEvent itemEvent = new ItemEvent(choice, 701, string, 1);
        this.postEvent(itemEvent);
    }

    void action(final int n) {
        final Choice choice = (Choice)this.target;
        this.inUpCall = false;
        MToolkit.executeOnEventHandlerThread(choice, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                String string;
                Choice choice2 = choice;
                synchronized (choice2) {
                    if (n >= choice.getItemCount()) {
                        return;
                    }
                    MChoicePeer.this.inUpCall = true;
                    choice.select(n);
                    string = choice.getItem(n);
                    MChoicePeer.this.inUpCall = false;
                }
                MChoicePeer.this.notifySelection(string);
            }
        });
    }

    public void print(Graphics graphics) {
        Choice choice = (Choice)this.target;
        Dimension dimension = choice.size();
        Color color = choice.getBackground();
        Color color2 = choice.getForeground();
        graphics.setColor(color);
        graphics.fillRect(2, 2, dimension.width - 1, dimension.height - 1);
        this.draw3DRect(graphics, color, 1, 1, dimension.width - 2, dimension.height - 2, true);
        this.draw3DRect(graphics, color, dimension.width - 18, dimension.height / 2 - 3, 10, 6, true);
        graphics.setColor(color2);
        graphics.setFont(choice.getFont());
        FontMetrics fontMetrics = graphics.getFontMetrics();
        String string = choice.getSelectedItem();
        if (string == null) {
            string = "";
        }
        if (string != "") {
            graphics.drawString(string, 5, (dimension.height + fontMetrics.getMaxAscent() - fontMetrics.getMaxDescent()) / 2);
        }
        this.target.print(graphics);
    }

    public Dimension minimumSize() {
        return this.getMinimumSize();
    }

    protected void disposeImpl() {
        this.freeNativeData();
        super.disposeImpl();
    }

    private native void freeNativeData();
}

