/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.AWTPermission;
import java.awt.DisplayMode;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Window;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import sun.awt.DisplayChangedListener;
import sun.awt.SunDisplayChanger;
import sun.awt.X11ComponentPeer;
import sun.awt.X11GraphicsConfig;
import sun.awt.X11GraphicsEnvironment;
import sun.java2d.loops.SurfaceType;
import sun.java2d.opengl.GLXGraphicsConfig;
import sun.misc.ThreadGroupUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class X11GraphicsDevice
extends GraphicsDevice
implements DisplayChangedListener {
    int screen;
    HashMap x11ProxyKeyMap = new HashMap();
    private static AWTPermission fullScreenExclusivePermission;
    private static Boolean xrandrExtSupported;
    private final Object configLock = new Object();
    private SunDisplayChanger topLevels = new SunDisplayChanger();
    private DisplayMode origDisplayMode;
    private boolean shutdownHookRegistered;
    GraphicsConfiguration[] configs;
    GraphicsConfiguration defaultConfig;
    HashSet doubleBufferVisuals;

    public X11GraphicsDevice(int n) {
        this.screen = n;
    }

    private static native void initIDs();

    public int getScreen() {
        return this.screen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getProxyKeyFor(SurfaceType surfaceType) {
        HashMap hashMap = this.x11ProxyKeyMap;
        synchronized (hashMap) {
            Object object = this.x11ProxyKeyMap.get(surfaceType);
            if (object == null) {
                object = new Object();
                this.x11ProxyKeyMap.put(surfaceType, object);
            }
            return object;
        }
    }

    public native long getDisplay();

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public String getIDstring() {
        return ":0." + this.screen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GraphicsConfiguration[] getConfigurations() {
        if (this.configs == null) {
            Object object = this.configLock;
            synchronized (object) {
                this.makeConfigurations();
            }
        }
        return (GraphicsConfiguration[])this.configs.clone();
    }

    private void makeConfigurations() {
        if (this.configs == null) {
            int n = 1;
            int n2 = this.getNumConfigs(this.screen);
            GraphicsConfiguration[] graphicsConfigurationArray = new GraphicsConfiguration[n2];
            graphicsConfigurationArray[0] = this.defaultConfig == null ? this.getDefaultConfiguration() : this.defaultConfig;
            boolean bl = X11GraphicsEnvironment.isGLXAvailable();
            boolean bl2 = X11GraphicsDevice.isDBESupported();
            if (bl2 && this.doubleBufferVisuals == null) {
                this.doubleBufferVisuals = new HashSet();
                this.getDoubleBufferVisuals(this.screen);
            }
            while (n < n2) {
                int n3 = this.getConfigVisualId(n, this.screen);
                int n4 = this.getConfigDepth(n, this.screen);
                if (bl) {
                    graphicsConfigurationArray[n] = GLXGraphicsConfig.getConfig(this, n3);
                }
                if (graphicsConfigurationArray[n] == null) {
                    boolean bl3 = bl2 && this.doubleBufferVisuals.contains(new Integer(n3));
                    graphicsConfigurationArray[n] = X11GraphicsConfig.getConfig(this, n3, n4, this.getConfigColormap(n, this.screen), bl3);
                }
                ++n;
            }
            this.configs = graphicsConfigurationArray;
        }
    }

    public native int getNumConfigs(int var1);

    public native int getConfigVisualId(int var1, int var2);

    public native int getConfigDepth(int var1, int var2);

    public native int getConfigColormap(int var1, int var2);

    public static native boolean isDBESupported();

    private void addDoubleBufferVisual(int n) {
        this.doubleBufferVisuals.add(new Integer(n));
    }

    private native void getDoubleBufferVisuals(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GraphicsConfiguration getDefaultConfiguration() {
        if (this.defaultConfig == null) {
            Object object = this.configLock;
            synchronized (object) {
                this.makeDefaultConfiguration();
            }
        }
        return this.defaultConfig;
    }

    private void makeDefaultConfiguration() {
        if (this.defaultConfig == null) {
            int n = this.getConfigVisualId(0, this.screen);
            if (X11GraphicsEnvironment.isGLXAvailable()) {
                this.defaultConfig = GLXGraphicsConfig.getConfig(this, n);
                if (X11GraphicsEnvironment.isGLXVerbose()) {
                    if (this.defaultConfig != null) {
                        System.out.print("OpenGL pipeline enabled");
                    } else {
                        System.out.print("Could not enable OpenGL pipeline");
                    }
                    System.out.println(" for default config on screen " + this.screen);
                }
            }
            if (this.defaultConfig == null) {
                int n2 = this.getConfigDepth(0, this.screen);
                boolean bl = false;
                if (X11GraphicsDevice.isDBESupported() && this.doubleBufferVisuals == null) {
                    this.doubleBufferVisuals = new HashSet();
                    this.getDoubleBufferVisuals(this.screen);
                    bl = this.doubleBufferVisuals.contains(new Integer(n));
                }
                this.defaultConfig = X11GraphicsConfig.getConfig(this, n, n2, this.getConfigColormap(0, this.screen), bl);
            }
        }
    }

    private static native void enterFullScreenExclusive(long var0);

    private static native void exitFullScreenExclusive(long var0);

    private static native boolean initXrandrExtension();

    private static native DisplayMode getCurrentDisplayMode(int var0);

    private static native void enumDisplayModes(int var0, ArrayList<DisplayMode> var1);

    private static native void configDisplayMode(int var0, int var1, int var2, int var3);

    private static native void resetNativeData(int var0);

    private static synchronized boolean isXrandrExtensionSupported() {
        if (xrandrExtSupported == null) {
            xrandrExtSupported = X11GraphicsDevice.initXrandrExtension();
        }
        return xrandrExtSupported;
    }

    @Override
    public boolean isFullScreenSupported() {
        SecurityManager securityManager;
        boolean bl;
        boolean bl2 = bl = this.screen == 0 && X11GraphicsDevice.isXrandrExtensionSupported();
        if (bl && (securityManager = System.getSecurityManager()) != null) {
            if (fullScreenExclusivePermission == null) {
                fullScreenExclusivePermission = new AWTPermission("fullScreenExclusive");
            }
            try {
                securityManager.checkPermission(fullScreenExclusivePermission);
            }
            catch (SecurityException securityException) {
                return false;
            }
        }
        return bl;
    }

    @Override
    public boolean isDisplayChangeSupported() {
        return this.isFullScreenSupported() && this.getFullScreenWindow() != null;
    }

    private static void enterFullScreenExclusive(Window window) {
        X11ComponentPeer x11ComponentPeer = (X11ComponentPeer)((Object)window.getPeer());
        if (x11ComponentPeer != null) {
            X11GraphicsDevice.enterFullScreenExclusive(x11ComponentPeer.getContentWindow());
        }
    }

    private static void exitFullScreenExclusive(Window window) {
        X11ComponentPeer x11ComponentPeer = (X11ComponentPeer)((Object)window.getPeer());
        if (x11ComponentPeer != null) {
            X11GraphicsDevice.exitFullScreenExclusive(x11ComponentPeer.getContentWindow());
        }
    }

    @Override
    public synchronized void setFullScreenWindow(Window window) {
        Window window2 = this.getFullScreenWindow();
        if (window == window2) {
            return;
        }
        boolean bl = this.isFullScreenSupported();
        if (bl && window2 != null) {
            X11GraphicsDevice.exitFullScreenExclusive(window2);
            this.setDisplayMode(this.origDisplayMode);
        }
        super.setFullScreenWindow(window);
        if (bl && window != null) {
            if (this.origDisplayMode == null) {
                this.origDisplayMode = this.getDisplayMode();
            }
            X11GraphicsDevice.enterFullScreenExclusive(window);
        }
    }

    private DisplayMode getDefaultDisplayMode() {
        GraphicsConfiguration graphicsConfiguration = this.getDefaultConfiguration();
        Rectangle rectangle = graphicsConfiguration.getBounds();
        return new DisplayMode(rectangle.width, rectangle.height, -1, 0);
    }

    @Override
    public synchronized DisplayMode getDisplayMode() {
        if (this.isFullScreenSupported()) {
            return X11GraphicsDevice.getCurrentDisplayMode(this.screen);
        }
        if (this.origDisplayMode == null) {
            this.origDisplayMode = this.getDefaultDisplayMode();
        }
        return this.origDisplayMode;
    }

    @Override
    public synchronized DisplayMode[] getDisplayModes() {
        if (!this.isFullScreenSupported()) {
            return super.getDisplayModes();
        }
        ArrayList<DisplayMode> arrayList = new ArrayList<DisplayMode>();
        X11GraphicsDevice.enumDisplayModes(this.screen, arrayList);
        DisplayMode[] displayModeArray = new DisplayMode[arrayList.size()];
        return arrayList.toArray(displayModeArray);
    }

    @Override
    public synchronized void setDisplayMode(DisplayMode displayMode) {
        if (!this.isDisplayChangeSupported()) {
            super.setDisplayMode(displayMode);
            return;
        }
        Window window = this.getFullScreenWindow();
        if (window == null) {
            throw new IllegalStateException("Must be in fullscreen mode in order to set display mode");
        }
        if (this.getDisplayMode().equals(displayMode)) {
            return;
        }
        if (displayMode == null || (displayMode = this.getMatchingDisplayMode(displayMode)) == null) {
            throw new IllegalArgumentException("Invalid display mode");
        }
        if (!this.shutdownHookRegistered) {
            this.shutdownHookRegistered = true;
            PrivilegedAction<Void> privilegedAction = new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    ThreadGroup threadGroup = ThreadGroupUtils.getRootThreadGroup();
                    Runnable runnable = new Runnable(){

                        public void run() {
                            Window window = X11GraphicsDevice.this.getFullScreenWindow();
                            if (window != null) {
                                X11GraphicsDevice.exitFullScreenExclusive(window);
                                X11GraphicsDevice.this.setDisplayMode(X11GraphicsDevice.this.origDisplayMode);
                            }
                        }
                    };
                    Thread thread = new Thread(threadGroup, runnable, "Display-Change-Shutdown-Thread-" + X11GraphicsDevice.this.screen);
                    thread.setContextClassLoader(null);
                    Runtime.getRuntime().addShutdownHook(thread);
                    return null;
                }
            };
            AccessController.doPrivileged(privilegedAction);
        }
        X11GraphicsDevice.configDisplayMode(this.screen, displayMode.getWidth(), displayMode.getHeight(), displayMode.getRefreshRate());
        window.setBounds(0, 0, displayMode.getWidth(), displayMode.getHeight());
        ((X11GraphicsEnvironment)GraphicsEnvironment.getLocalGraphicsEnvironment()).displayChanged();
    }

    private synchronized DisplayMode getMatchingDisplayMode(DisplayMode displayMode) {
        DisplayMode[] displayModeArray;
        if (!this.isDisplayChangeSupported()) {
            return null;
        }
        for (DisplayMode displayMode2 : displayModeArray = this.getDisplayModes()) {
            if (!displayMode.equals(displayMode2) && (displayMode.getRefreshRate() != 0 || displayMode.getWidth() != displayMode2.getWidth() || displayMode.getHeight() != displayMode2.getHeight() || displayMode.getBitDepth() != displayMode2.getBitDepth())) continue;
            return displayMode2;
        }
        return null;
    }

    @Override
    public synchronized void displayChanged() {
        this.defaultConfig = null;
        this.configs = null;
        this.doubleBufferVisuals = null;
        X11GraphicsDevice.resetNativeData(this.screen);
        this.topLevels.notifyListeners();
    }

    @Override
    public void paletteChanged() {
    }

    public void addDisplayChangedListener(DisplayChangedListener displayChangedListener) {
        this.topLevels.add(displayChangedListener);
    }

    public void removeDisplayChangedListener(DisplayChangedListener displayChangedListener) {
        this.topLevels.remove(displayChangedListener);
    }

    public String toString() {
        return "X11GraphicsDevice[screen=" + this.screen + "]";
    }

    static {
        if (!GraphicsEnvironment.isHeadless()) {
            X11GraphicsDevice.initIDs();
        }
    }
}

