/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.nio.ByteOrder;
import java.util.Arrays;
import sun.awt.X11.Native;
import sun.awt.X11.WindowPropertyGetter;
import sun.awt.X11.XAtom;
import sun.awt.X11.XErrorHandler;
import sun.awt.X11.XException;
import sun.awt.X11.XSelection;
import sun.awt.X11.XSetWindowAttributes;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

class MotifDnDConstants {
    private static final Unsafe unsafe = XlibWrapper.unsafe;
    static final XAtom XA_MOTIF_ATOM_0 = XAtom.get("_MOTIF_ATOM_0");
    static final XAtom XA_MOTIF_DRAG_WINDOW = XAtom.get("_MOTIF_DRAG_WINDOW");
    static final XAtom XA_MOTIF_DRAG_TARGETS = XAtom.get("_MOTIF_DRAG_TARGETS");
    static final XAtom XA_MOTIF_DRAG_INITIATOR_INFO = XAtom.get("_MOTIF_DRAG_INITIATOR_INFO");
    static final XAtom XA_MOTIF_DRAG_RECEIVER_INFO = XAtom.get("_MOTIF_DRAG_RECEIVER_INFO");
    static final XAtom XA_MOTIF_DRAG_AND_DROP_MESSAGE = XAtom.get("_MOTIF_DRAG_AND_DROP_MESSAGE");
    static final XAtom XA_XmTRANSFER_SUCCESS = XAtom.get("XmTRANSFER_SUCCESS");
    static final XAtom XA_XmTRANSFER_FAILURE = XAtom.get("XmTRANSFER_FAILURE");
    static final XSelection MotifDnDSelection = new XSelection(XA_MOTIF_ATOM_0, null);
    public static final byte MOTIF_DND_PROTOCOL_VERSION = 0;
    public static final int MOTIF_PREFER_PREREGISTER_STYLE = 2;
    public static final int MOTIF_PREFER_DYNAMIC_STYLE = 4;
    public static final int MOTIF_DYNAMIC_STYLE = 5;
    public static final int MOTIF_PREFER_RECEIVER_STYLE = 6;
    public static final int MOTIF_INITIATOR_INFO_SIZE = 8;
    public static final int MOTIF_RECEIVER_INFO_SIZE = 16;
    public static final byte MOTIF_MESSAGE_REASON_MASK = 127;
    public static final byte MOTIF_MESSAGE_SENDER_MASK = -128;
    public static final byte MOTIF_MESSAGE_FROM_RECEIVER = -128;
    public static final byte MOTIF_MESSAGE_FROM_INITIATOR = 0;
    public static final int MOTIF_DND_ACTION_MASK = 15;
    public static final int MOTIF_DND_ACTION_SHIFT = 0;
    public static final int MOTIF_DND_STATUS_MASK = 240;
    public static final int MOTIF_DND_STATUS_SHIFT = 4;
    public static final int MOTIF_DND_ACTIONS_MASK = 3840;
    public static final int MOTIF_DND_ACTIONS_SHIFT = 8;
    public static final byte TOP_LEVEL_ENTER = 0;
    public static final byte TOP_LEVEL_LEAVE = 1;
    public static final byte DRAG_MOTION = 2;
    public static final byte DROP_SITE_ENTER = 3;
    public static final byte DROP_SITE_LEAVE = 4;
    public static final byte DROP_START = 5;
    public static final byte DROP_FINISH = 6;
    public static final byte DRAG_DROP_FINISH = 7;
    public static final byte OPERATION_CHANGED = 8;
    public static final int MOTIF_DND_NOOP = 0;
    public static final int MOTIF_DND_MOVE = 1;
    public static final int MOTIF_DND_COPY = 2;
    public static final int MOTIF_DND_LINK = 4;
    public static final byte MOTIF_NO_DROP_SITE = 1;
    public static final byte MOTIF_INVALID_DROP_SITE = 2;
    public static final byte MOTIF_VALID_DROP_SITE = 3;

    MotifDnDConstants() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long readMotifWindow() throws XException {
        long l = XlibWrapper.DefaultScreen(XToolkit.getDisplay());
        long l2 = XlibWrapper.RootWindow(XToolkit.getDisplay(), l);
        long l3 = 0L;
        WindowPropertyGetter windowPropertyGetter = new WindowPropertyGetter(l2, XA_MOTIF_DRAG_WINDOW, 0L, 1L, false, 0L);
        try {
            long l4;
            int n = windowPropertyGetter.execute(XErrorHandler.IgnoreBadWindowHandler.getInstance());
            if (n == 0 && windowPropertyGetter.getData() != 0L && windowPropertyGetter.getActualType() == 33L && windowPropertyGetter.getActualFormat() == 32 && windowPropertyGetter.getNumberOfItems() == 1) {
                l4 = windowPropertyGetter.getData();
                l3 = Native.getLong(l4);
            }
            l4 = l3;
            Object var11_6 = null;
            windowPropertyGetter.dispose();
            return l4;
        }
        catch (Throwable throwable) {
            Object var11_7 = null;
            windowPropertyGetter.dispose();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    private static long createMotifWindow() throws XException {
        long l;
        long l2;
        XSetWindowAttributes xSetWindowAttributes;
        assert (XToolkit.isAWTLockHeldByCurrentThread());
        long l3 = XlibWrapper.DefaultScreen(XToolkit.getDisplay());
        long l4 = XlibWrapper.RootWindow(XToolkit.getDisplay(), l3);
        long l5 = 0L;
        long l6 = XlibWrapper.XDisplayString(XToolkit.getDisplay());
        if (l6 == 0L) {
            throw new XException("XDisplayString returns NULL");
        }
        long l7 = XlibWrapper.XOpenDisplay(l6);
        if (l7 == 0L) {
            throw new XException("XOpenDisplay returns NULL");
        }
        XlibWrapper.XGrabServer(l7);
        try {
            XlibWrapper.XSetCloseDownMode(l7, 1);
            xSetWindowAttributes = new XSetWindowAttributes();
            xSetWindowAttributes.set_override_redirect(true);
            xSetWindowAttributes.set_event_mask(0x400000L);
            l5 = XlibWrapper.XCreateWindow(l7, l4, -10, -10, 1, 1, 0, 0, 2L, 0L, 2560L, xSetWindowAttributes.pData);
            if (l5 == 0L) {
                throw new XException("XCreateWindow returns NULL");
            }
            XlibWrapper.XMapWindow(l7, l5);
            l2 = Native.allocateLongArray(1);
            Native.putLong(l2, l5);
            XToolkit.WITH_XERROR_HANDLER(XErrorHandler.VerifyChangePropertyHandler.getInstance());
            XlibWrapper.XChangeProperty(XToolkit.getDisplay(), l4, XA_MOTIF_DRAG_WINDOW.getAtom(), 33L, 32, 0, l2, 1);
            XToolkit.RESTORE_XERROR_HANDLER();
            if (XToolkit.saved_error != null && XToolkit.saved_error.get_error_code() != 0) {
                throw new XException("Cannot write motif drag window handle.");
            }
            l = l5;
            {
                Object var16_8 = null;
                unsafe.freeMemory(l2);
            }
            Object var18_10 = null;
            xSetWindowAttributes.dispose();
            Object var20_12 = null;
        }
        catch (Throwable throwable) {
            Object var20_13 = null;
            XlibWrapper.XUngrabServer(l7);
            XlibWrapper.XCloseDisplay(l7);
            throw throwable;
        }
        XlibWrapper.XUngrabServer(l7);
        XlibWrapper.XCloseDisplay(l7);
        {
            return l;
            {
                catch (Throwable throwable) {
                    try {
                        Object var16_9 = null;
                        unsafe.freeMemory(l2);
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        Object var18_11 = null;
                        xSetWindowAttributes.dispose();
                        throw throwable2;
                    }
                }
            }
        }
    }

    private static long getMotifWindow() throws XException {
        long l = MotifDnDConstants.readMotifWindow();
        if (l == 0L) {
            l = MotifDnDConstants.createMotifWindow();
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long[][] getTargetListTable(long l) throws XException {
        long l2;
        WindowPropertyGetter windowPropertyGetter;
        block14: {
            block13: {
                windowPropertyGetter = new WindowPropertyGetter(l, XA_MOTIF_DRAG_TARGETS, 0L, 100000L, false, XA_MOTIF_DRAG_TARGETS.getAtom());
                int n = windowPropertyGetter.execute(XErrorHandler.IgnoreBadWindowHandler.getInstance());
                if (n == 0 && windowPropertyGetter.getActualType() == XA_MOTIF_DRAG_TARGETS.getAtom() && windowPropertyGetter.getData() != 0L) break block13;
                long[][] lArray = null;
                Object var18_5 = null;
                windowPropertyGetter.dispose();
                return lArray;
            }
            l2 = windowPropertyGetter.getData();
            if (unsafe.getByte(l2 + 1L) == 0) break block14;
            long[][] lArray = null;
            Object var18_6 = null;
            windowPropertyGetter.dispose();
            return lArray;
        }
        try {
            boolean bl = unsafe.getByte(l2 + 0L) != MotifDnDConstants.getByteOrderByte();
            short s = unsafe.getShort(l2 + 2L);
            if (bl) {
                s = Swapper.swap(s);
            }
            long[][] lArrayArray = new long[s][];
            ByteOrder byteOrder = ByteOrder.nativeOrder();
            if (bl) {
                byteOrder = byteOrder == ByteOrder.LITTLE_ENDIAN ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
            }
            long l3 = l2 + 8L;
            for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
                short s3 = unsafe.getShort(l3);
                l3 += 2L;
                if (bl) {
                    s3 = Swapper.swap(s3);
                }
                lArrayArray[s2] = new long[s3];
                for (short s4 = 0; s4 < s3; s4 = (short)(s4 + 1)) {
                    int n;
                    int n2 = 0;
                    if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                        for (n = 0; n < 4; ++n) {
                            n2 |= unsafe.getByte(l3 + (long)n) << 8 * n & 255 << 8 * n;
                        }
                    } else {
                        for (n = 0; n < 4; ++n) {
                            n2 |= unsafe.getByte(l3 + (long)n) << 8 * (3 - n) & 255 << 8 * (3 - n);
                        }
                    }
                    lArrayArray[s2][s4] = n2;
                    l3 += 4L;
                }
            }
            long[][] lArrayArray2 = lArrayArray;
            Object var18_7 = null;
            windowPropertyGetter.dispose();
            return lArrayArray2;
        }
        catch (Throwable throwable) {
            Object var18_8 = null;
            windowPropertyGetter.dispose();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putTargetListTable(long l, long[][] lArray) throws XException {
        assert (XToolkit.isAWTLockHeldByCurrentThread());
        int n = 8;
        for (int i = 0; i < lArray.length; ++i) {
            n += lArray[i].length * 4 + 2;
        }
        long l2 = unsafe.allocateMemory(n);
        try {
            unsafe.putByte(l2 + 0L, MotifDnDConstants.getByteOrderByte());
            unsafe.putByte(l2 + 1L, (byte)0);
            unsafe.putShort(l2 + 2L, (short)lArray.length);
            unsafe.putInt(l2 + 4L, n);
            long l3 = l2 + 8L;
            for (int i = 0; i < lArray.length; ++i) {
                unsafe.putShort(l3, (short)lArray[i].length);
                l3 += 2L;
                for (int j = 0; j < lArray[i].length; ++j) {
                    byte by;
                    int n2;
                    int n3 = (int)lArray[i][j];
                    if (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN) {
                        for (n2 = 0; n2 < 4; ++n2) {
                            by = (byte)((n3 & 255 << 8 * n2) >> 8 * n2);
                            unsafe.putByte(l3 + (long)n2, by);
                        }
                    } else {
                        for (n2 = 0; n2 < 4; ++n2) {
                            by = (byte)((n3 & 255 << 8 * n2) >> 8 * n2);
                            unsafe.putByte(l3 + (long)(3 - n2), by);
                        }
                    }
                    l3 += 4L;
                }
            }
            XToolkit.WITH_XERROR_HANDLER(XErrorHandler.VerifyChangePropertyHandler.getInstance());
            XlibWrapper.XChangeProperty(XToolkit.getDisplay(), l, XA_MOTIF_DRAG_TARGETS.getAtom(), XA_MOTIF_DRAG_TARGETS.getAtom(), 8, 0, l2, n);
            XToolkit.RESTORE_XERROR_HANDLER();
            if (XToolkit.saved_error != null && XToolkit.saved_error.get_error_code() != 0) {
                l = MotifDnDConstants.createMotifWindow();
                XToolkit.WITH_XERROR_HANDLER(XErrorHandler.VerifyChangePropertyHandler.getInstance());
                XlibWrapper.XChangeProperty(XToolkit.getDisplay(), l, XA_MOTIF_DRAG_TARGETS.getAtom(), XA_MOTIF_DRAG_TARGETS.getAtom(), 8, 0, l2, n);
                XToolkit.RESTORE_XERROR_HANDLER();
                if (XToolkit.saved_error != null && XToolkit.saved_error.get_error_code() != 0) {
                    throw new XException("Cannot write motif drag targets property.");
                }
            }
            Object var14_11 = null;
            unsafe.freeMemory(l2);
        }
        catch (Throwable throwable) {
            Object var14_12 = null;
            unsafe.freeMemory(l2);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static int getIndexForTargetList(long[] lArray) throws XException {
        int n;
        assert (XToolkit.isAWTLockHeldByCurrentThread());
        if (lArray.length > 0) {
            lArray = (long[])lArray.clone();
            Arrays.sort(lArray);
        }
        long l = MotifDnDConstants.getMotifWindow();
        XlibWrapper.XGrabServer(XToolkit.getDisplay());
        try {
            Object object = MotifDnDConstants.getTargetListTable(l);
            if (object != null) {
                for (int i = 0; i < ((long[][])object).length; ++i) {
                    int n2;
                    n = 1;
                    if (object[i].length == lArray.length) {
                        for (n2 = 0; n2 < object[i].length; ++n2) {
                            if (object[i][n2] == lArray[n2]) continue;
                            n = 0;
                            break;
                        }
                    } else {
                        n = 0;
                    }
                    if (n == 0) continue;
                    XlibWrapper.XUngrabServer(XToolkit.getDisplay());
                    n2 = i;
                    Object var8_7 = null;
                    XlibWrapper.XUngrabServer(XToolkit.getDisplay());
                    return n2;
                }
            } else {
                object = new long[2][];
                object[0] = new long[]{0L};
                object[1] = new long[]{31L};
            }
            long[][] lArrayArray = new long[((long[][])object).length + 1][];
            for (n = 0; n < ((long[][])object).length; ++n) {
                lArrayArray[n] = object[n];
            }
            lArrayArray[lArrayArray.length - 1] = lArray;
            MotifDnDConstants.putTargetListTable(l, lArrayArray);
            n = lArrayArray.length - 1;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            XlibWrapper.XUngrabServer(XToolkit.getDisplay());
            throw throwable;
        }
        Object var8_8 = null;
        XlibWrapper.XUngrabServer(XToolkit.getDisplay());
        return n;
    }

    static long[] getTargetListForIndex(int n) {
        long l = MotifDnDConstants.getMotifWindow();
        long[][] lArray = MotifDnDConstants.getTargetListTable(l);
        if (n < 0 || n >= lArray.length) {
            return new long[0];
        }
        return lArray[n];
    }

    static byte getByteOrderByte() {
        return ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? (byte)108 : 66;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeDragInitiatorInfoStruct(long l, int n) throws XException {
        assert (XToolkit.isAWTLockHeldByCurrentThread());
        long l2 = unsafe.allocateMemory(8L);
        try {
            unsafe.putByte(l2, MotifDnDConstants.getByteOrderByte());
            unsafe.putByte(l2 + 1L, (byte)0);
            unsafe.putShort(l2 + 2L, (short)n);
            unsafe.putInt(l2 + 4L, (int)XA_MOTIF_ATOM_0.getAtom());
            XToolkit.WITH_XERROR_HANDLER(XErrorHandler.VerifyChangePropertyHandler.getInstance());
            XlibWrapper.XChangeProperty(XToolkit.getDisplay(), l, XA_MOTIF_ATOM_0.getAtom(), XA_MOTIF_DRAG_INITIATOR_INFO.getAtom(), 8, 0, l2, 8);
            XToolkit.RESTORE_XERROR_HANDLER();
            if (XToolkit.saved_error != null && XToolkit.saved_error.get_error_code() != 0) {
                throw new XException("Cannot write drag initiator info");
            }
            Object var6_3 = null;
            unsafe.freeMemory(l2);
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            unsafe.freeMemory(l2);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeDragReceiverInfoStruct(long l) throws XException {
        assert (XToolkit.isAWTLockHeldByCurrentThread());
        int n = 16;
        long l2 = unsafe.allocateMemory(n);
        try {
            unsafe.putByte(l2, MotifDnDConstants.getByteOrderByte());
            unsafe.putByte(l2 + 1L, (byte)0);
            unsafe.putByte(l2 + 2L, (byte)5);
            unsafe.putByte(l2 + 3L, (byte)0);
            unsafe.putInt(l2 + 4L, (int)l);
            unsafe.putShort(l2 + 8L, (short)0);
            unsafe.putShort(l2 + 10L, (short)0);
            unsafe.putInt(l2 + 12L, n);
            XToolkit.WITH_XERROR_HANDLER(XErrorHandler.VerifyChangePropertyHandler.getInstance());
            XlibWrapper.XChangeProperty(XToolkit.getDisplay(), l, XA_MOTIF_DRAG_RECEIVER_INFO.getAtom(), XA_MOTIF_DRAG_RECEIVER_INFO.getAtom(), 8, 0, l2, n);
            XToolkit.RESTORE_XERROR_HANDLER();
            if (XToolkit.saved_error != null && XToolkit.saved_error.get_error_code() != 0) {
                throw new XException("Cannot write Motif receiver info property");
            }
            Object var6_3 = null;
            unsafe.freeMemory(l2);
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            unsafe.freeMemory(l2);
            throw throwable;
        }
    }

    public static int getMotifActionsForJavaActions(int n) {
        int n2 = 0;
        if ((n & 2) != 0) {
            n2 |= 1;
        }
        if ((n & 1) != 0) {
            n2 |= 2;
        }
        if ((n & 0x40000000) != 0) {
            n2 |= 4;
        }
        return n2;
    }

    public static int getJavaActionsForMotifActions(int n) {
        int n2 = 0;
        if ((n & 1) != 0) {
            n2 |= 2;
        }
        if ((n & 2) != 0) {
            n2 |= 1;
        }
        if ((n & 4) != 0) {
            n2 |= 0x40000000;
        }
        return n2;
    }

    public static final class Swapper {
        public static short swap(short s) {
            return (short)((s & 0xFF00) >>> 8 | (s & 0xFF) << 8);
        }

        public static int swap(int n) {
            return (n & 0xFF000000) >>> 24 | (n & 0xFF0000) >>> 8 | (n & 0xFF00) << 8 | (n & 0xFF) << 24;
        }

        public static short getShort(long l, byte by) {
            short s = unsafe.getShort(l);
            if (by != MotifDnDConstants.getByteOrderByte()) {
                return Swapper.swap(s);
            }
            return s;
        }

        public static int getInt(long l, byte by) {
            int n = unsafe.getInt(l);
            if (by != MotifDnDConstants.getByteOrderByte()) {
                return Swapper.swap(n);
            }
            return n;
        }
    }
}

