/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.MouseInfo;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.BreakIterator;
import java.util.concurrent.ArrayBlockingQueue;
import sun.awt.SunToolkit;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XTrayIconPeer;
import sun.awt.X11.XWindow;

public abstract class InfoWindow
extends Window {
    private Container container = new Container(){

        public Insets getInsets() {
            return new Insets(1, 1, 1, 1);
        }
    };
    private Closer closer;

    protected InfoWindow(Frame frame, Color color) {
        super(frame);
        this.setLayout(new BorderLayout());
        this.setBackground(color);
        this.add((Component)this.container, "Center");
        this.container.setLayout(new BorderLayout());
        this.closer = new Closer();
    }

    public Component add(Component component) {
        this.container.add(component, "Center");
        return component;
    }

    protected void setCloser(Runnable runnable, int n) {
        this.closer.set(runnable, n);
    }

    protected void show(Point point, int n) {
        assert (SunToolkit.isDispatchThreadForAppContext(this));
        this.pack();
        Dimension dimension = this.getSize();
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        if (point.x < dimension2.width / 2 && point.y < dimension2.height / 2) {
            this.setLocation(point.x + n, point.y + n);
        } else if (point.x >= dimension2.width / 2 && point.y < dimension2.height / 2) {
            this.setLocation(point.x - n - dimension.width, point.y + n);
        } else if (point.x < dimension2.width / 2 && point.y >= dimension2.height / 2) {
            this.setLocation(point.x + n, point.y - n - dimension.height);
        } else if (point.x >= dimension2.width / 2 && point.y >= dimension2.height / 2) {
            this.setLocation(point.x - n - dimension.width, point.y - n - dimension.height);
        }
        super.show();
        this.closer.schedule();
    }

    public void hide() {
        this.closer.close();
    }

    public static class Balloon
    extends InfoWindow {
        private final LiveArguments liveArguments;
        private final Object target;
        private static final int BALLOON_SHOW_TIME = 10000;
        private static final int BALLOON_TEXT_MAX_LENGTH = 256;
        private static final int BALLOON_WORD_LINE_MAX_LENGTH = 16;
        private static final int BALLOON_WORD_LINE_MAX_COUNT = 4;
        private static final int BALLOON_ICON_WIDTH = 32;
        private static final int BALLOON_ICON_HEIGHT = 32;
        private static final int BALLOON_TRAY_ICON_INDENT = 0;
        private static final Color BALLOON_CAPTION_BACKGROUND_COLOR = new Color(200, 200, 255);
        private static final Font BALLOON_CAPTION_FONT = new Font("Dialog", 1, 12);
        private Panel mainPanel = new Panel();
        private Panel captionPanel = new Panel();
        private Label captionLabel = new Label("");
        private Button closeButton = new Button("X");
        private Panel textPanel = new Panel();
        private XTrayIconPeer.IconCanvas iconCanvas = new XTrayIconPeer.IconCanvas(32, 32);
        private Label[] lineLabels = new Label[4];
        private ActionPerformer ap = new ActionPerformer();
        private Image iconImage;
        private Image errorImage;
        private Image warnImage;
        private Image infoImage;
        private boolean gtkImagesLoaded;
        private Displayer displayer = new Displayer();

        public Balloon(Frame frame, Object object, LiveArguments liveArguments) {
            super(frame, new Color(90, 80, 190));
            this.liveArguments = liveArguments;
            this.target = object;
            XTrayIconPeer.suppressWarningString(this);
            this.setCloser(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    if (Balloon.this.textPanel != null) {
                        Balloon.this.textPanel.removeAll();
                        Balloon.this.textPanel.setSize(0, 0);
                        Balloon.this.iconCanvas.setSize(0, 0);
                        XToolkit.awtLock();
                        try {
                            ((Balloon)Balloon.this).displayer.isDisplayed = false;
                            XToolkit.awtLockNotifyAll();
                            Object var2_1 = null;
                        }
                        catch (Throwable throwable) {
                            Object var2_2 = null;
                            XToolkit.awtUnlock();
                            throw throwable;
                        }
                        XToolkit.awtUnlock();
                        {
                        }
                    }
                }
            }, 10000);
            this.add(this.mainPanel);
            this.captionLabel.setFont(BALLOON_CAPTION_FONT);
            this.captionLabel.addMouseListener(this.ap);
            this.captionPanel.setLayout(new BorderLayout());
            this.captionPanel.add((Component)this.captionLabel, "West");
            this.captionPanel.add((Component)this.closeButton, "East");
            this.captionPanel.setBackground(BALLOON_CAPTION_BACKGROUND_COLOR);
            this.captionPanel.addMouseListener(this.ap);
            this.closeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Balloon.this.hide();
                }
            });
            this.mainPanel.setLayout(new BorderLayout());
            this.mainPanel.setBackground(Color.white);
            this.mainPanel.add((Component)this.captionPanel, "North");
            this.mainPanel.add((Component)this.iconCanvas, "West");
            this.mainPanel.add((Component)this.textPanel, "Center");
            this.iconCanvas.addMouseListener(this.ap);
            for (int i = 0; i < 4; ++i) {
                this.lineLabels[i] = new Label();
                this.lineLabels[i].addMouseListener(this.ap);
                this.lineLabels[i].setBackground(Color.white);
            }
            this.displayer.start();
        }

        public void display(String string, String string2, String string3) {
            if (!this.gtkImagesLoaded) {
                this.loadGtkImages();
            }
            this.displayer.display(string, string2, string3);
        }

        private void _display(String string, String string2, String string3) {
            this.captionLabel.setText(string);
            BreakIterator breakIterator = BreakIterator.getWordInstance();
            if (string2 != null) {
                int n;
                breakIterator.setText(string2);
                int n2 = breakIterator.first();
                int n3 = 0;
                do {
                    if ((n = breakIterator.next()) == -1 || string2.substring(n2, n).length() >= 50) {
                        this.lineLabels[n3].setText(string2.substring(n2, n == -1 ? breakIterator.last() : n));
                        this.textPanel.add(this.lineLabels[n3++]);
                        n2 = n;
                    }
                    if (n3 != 4) continue;
                    if (n == -1) break;
                    this.lineLabels[n3 - 1].setText(new String(this.lineLabels[n3 - 1].getText() + " ..."));
                    break;
                } while (n != -1);
                this.textPanel.setLayout(new GridLayout(n3, 1));
            }
            this.iconImage = "ERROR".equals(string3) ? this.errorImage : ("WARNING".equals(string3) ? this.warnImage : ("INFO".equals(string3) ? this.infoImage : null));
            if (this.iconImage != null) {
                Dimension dimension = this.textPanel.getSize();
                this.iconCanvas.setSize(32, 32 > dimension.height ? 32 : dimension.height);
                this.iconCanvas.validate();
            }
            SunToolkit.executeOnEventHandlerThread(this.target, new Runnable(){

                public void run() {
                    if (Balloon.this.liveArguments.isDisposed()) {
                        return;
                    }
                    Point point = Balloon.this.getParent().getLocationOnScreen();
                    Dimension dimension = Balloon.this.getParent().getSize();
                    Balloon.this.show(new Point(point.x + dimension.width / 2, point.y + dimension.height / 2), 0);
                    if (Balloon.this.iconImage != null) {
                        Balloon.this.iconCanvas.updateImage(Balloon.this.iconImage);
                    }
                }
            });
        }

        public void dispose() {
            this.displayer.interrupt();
            super.dispose();
        }

        private void loadGtkImages() {
            if (!this.gtkImagesLoaded) {
                this.errorImage = (Image)Toolkit.getDefaultToolkit().getDesktopProperty("gtk.icon.gtk-dialog-error.6.rtl");
                this.warnImage = (Image)Toolkit.getDefaultToolkit().getDesktopProperty("gtk.icon.gtk-dialog-warning.6.rtl");
                this.infoImage = (Image)Toolkit.getDefaultToolkit().getDesktopProperty("gtk.icon.gtk-dialog-info.6.rtl");
                this.gtkImagesLoaded = true;
            }
        }

        private static class Message {
            String caption;
            String text;
            String messageType;

            Message(String string, String string2, String string3) {
                this.caption = string;
                this.text = string2;
                this.messageType = string3;
            }
        }

        private class Displayer
        extends Thread {
            final int MAX_CONCURRENT_MSGS = 10;
            ArrayBlockingQueue<Message> messageQueue = new ArrayBlockingQueue(10);
            boolean isDisplayed;

            Displayer() {
                this.setDaemon(true);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (true) {
                    Object var4_2;
                    Message message = null;
                    try {
                        message = this.messageQueue.take();
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                    XToolkit.awtLock();
                    try {
                        while (this.isDisplayed) {
                            try {
                                XToolkit.awtLockWait();
                            }
                            catch (InterruptedException interruptedException) {
                                var4_2 = null;
                                XToolkit.awtUnlock();
                                return;
                            }
                        }
                        this.isDisplayed = true;
                        var4_2 = null;
                    }
                    catch (Throwable throwable) {
                        var4_2 = null;
                        XToolkit.awtUnlock();
                        throw throwable;
                    }
                    XToolkit.awtUnlock();
                    Balloon.this._display(message.caption, message.text, message.messageType);
                }
            }

            void display(String string, String string2, String string3) {
                this.messageQueue.offer(new Message(string, string2, string3));
            }
        }

        private class ActionPerformer
        extends MouseAdapter {
            private ActionPerformer() {
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                Balloon.this.hide();
                if (mouseEvent.getButton() == 1) {
                    ActionEvent actionEvent = new ActionEvent(Balloon.this.target, 1001, Balloon.this.liveArguments.getActionCommand(), mouseEvent.getWhen(), mouseEvent.getModifiers());
                    Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(actionEvent);
                }
            }
        }

        public static interface LiveArguments
        extends sun.awt.X11.InfoWindow$LiveArguments {
            public String getActionCommand();
        }
    }

    public static class Tooltip
    extends InfoWindow {
        private final Object target;
        private final LiveArguments liveArguments;
        private final Label textLabel = new Label("");
        private final Runnable starter = new Runnable(){

            public void run() {
                Tooltip.this.display();
            }
        };
        private static final int TOOLTIP_SHOW_TIME = 10000;
        private static final int TOOLTIP_START_DELAY_TIME = 1000;
        private static final int TOOLTIP_MAX_LENGTH = 64;
        private static final int TOOLTIP_MOUSE_CURSOR_INDENT = 5;
        private static final Color TOOLTIP_BACKGROUND_COLOR = new Color(255, 255, 220);
        private static final Font TOOLTIP_TEXT_FONT = XWindow.defaultFont;

        public Tooltip(Frame frame, Object object, LiveArguments liveArguments) {
            super(frame, Color.black);
            this.target = object;
            this.liveArguments = liveArguments;
            XTrayIconPeer.suppressWarningString(this);
            this.setCloser(null, 10000);
            this.textLabel.setBackground(TOOLTIP_BACKGROUND_COLOR);
            this.textLabel.setFont(TOOLTIP_TEXT_FONT);
            this.add(this.textLabel);
        }

        private void display() {
            String string = this.liveArguments.getTooltipString();
            if (string == null) {
                return;
            }
            if (string.length() > 64) {
                this.textLabel.setText(string.substring(0, 64));
            } else {
                this.textLabel.setText(string);
            }
            SunToolkit.executeOnEventHandlerThread(this.target, new Runnable(){

                public void run() {
                    if (Tooltip.this.liveArguments.isDisposed()) {
                        return;
                    }
                    Point point = (Point)AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            if (!Tooltip.this.isPointerOverTrayIcon(Tooltip.this.liveArguments.getBounds())) {
                                return null;
                            }
                            return MouseInfo.getPointerInfo().getLocation();
                        }
                    });
                    if (point == null) {
                        return;
                    }
                    Tooltip.this.show(new Point(point.x, point.y), 5);
                }
            });
        }

        public void enter() {
            XToolkit.schedule(this.starter, 1000L);
        }

        public void exit() {
            XToolkit.remove(this.starter);
            if (this.isVisible()) {
                this.hide();
            }
        }

        private boolean isPointerOverTrayIcon(Rectangle rectangle) {
            Point point = MouseInfo.getPointerInfo().getLocation();
            return point.x >= rectangle.x && point.x <= rectangle.x + rectangle.width && point.y >= rectangle.y && point.y <= rectangle.y + rectangle.height;
        }

        public static interface LiveArguments
        extends sun.awt.X11.InfoWindow$LiveArguments {
            public String getTooltipString();
        }
    }

    private static interface LiveArguments {
        public boolean isDisposed();

        public Rectangle getBounds();
    }

    private class Closer
    implements Runnable {
        Runnable action;
        int time;

        private Closer() {
        }

        public void run() {
            this.doClose();
        }

        void set(Runnable runnable, int n) {
            this.action = runnable;
            this.time = n;
        }

        void schedule() {
            XToolkit.schedule(this, this.time);
        }

        void close() {
            XToolkit.remove(this);
            this.doClose();
        }

        private void doClose() {
            SunToolkit.executeOnEventHandlerThread(InfoWindow.this, new Runnable(){

                public void run() {
                    InfoWindow.super.hide();
                    InfoWindow.this.invalidate();
                    if (Closer.this.action != null) {
                        Closer.this.action.run();
                    }
                }
            });
        }
    }
}

