/*
 * Decompiled with CFR 0.152.
 */
package sun.audio;

import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.audio.AudioDevice;

public final class AudioPlayer
extends Thread {
    private final AudioDevice devAudio = AudioDevice.device;
    private static final boolean DEBUG = false;
    public static final AudioPlayer player = AudioPlayer.getAudioPlayer();

    private static ThreadGroup getAudioThreadGroup() {
        ThreadGroup threadGroup = AudioPlayer.currentThread().getThreadGroup();
        while (threadGroup.getParent() != null && threadGroup.getParent().getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        return threadGroup;
    }

    private static AudioPlayer getAudioPlayer() {
        PrivilegedAction privilegedAction = new PrivilegedAction(){

            public Object run() {
                AudioPlayer audioPlayer = new AudioPlayer();
                audioPlayer.setPriority(10);
                audioPlayer.setDaemon(true);
                audioPlayer.start();
                return audioPlayer;
            }
        };
        AudioPlayer audioPlayer = (AudioPlayer)AccessController.doPrivileged(privilegedAction);
        return audioPlayer;
    }

    private AudioPlayer() {
        super(AudioPlayer.getAudioThreadGroup(), "Audio Player");
        this.devAudio.open();
    }

    public synchronized void start(InputStream inputStream) {
        this.devAudio.openChannel(inputStream);
        this.notify();
    }

    public synchronized void stop(InputStream inputStream) {
        this.devAudio.closeChannel(inputStream);
    }

    public void run() {
        this.devAudio.play();
        try {
            while (true) {
                Thread.sleep(5000L);
            }
        }
        catch (Exception exception) {
            return;
        }
    }
}

