/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.plaf.basic.BasicToolTipUI;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.text.View;
import sun.swing.plaf.synth.SynthUI;

class SynthToolTipUI
extends BasicToolTipUI
implements PropertyChangeListener,
SynthUI {
    private SynthStyle style;

    SynthToolTipUI() {
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthToolTipUI();
    }

    @Override
    protected void installDefaults(JComponent jComponent) {
        this.updateStyle(jComponent);
    }

    private void updateStyle(JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent, 1);
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        synthContext.dispose();
    }

    @Override
    protected void uninstallDefaults(JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
    }

    @Override
    protected void installListeners(JComponent jComponent) {
        jComponent.addPropertyChangeListener(this);
    }

    @Override
    protected void uninstallListeners(JComponent jComponent) {
        jComponent.removePropertyChangeListener(this);
    }

    @Override
    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    private SynthContext getContext(JComponent jComponent, int n) {
        return SynthContext.getContext(SynthContext.class, jComponent, SynthLookAndFeel.getRegion(jComponent), this.style, n);
    }

    private Region getRegion(JComponent jComponent) {
        return SynthLookAndFeel.getRegion(jComponent);
    }

    private int getComponentState(JComponent jComponent) {
        JComponent jComponent2 = ((JToolTip)jComponent).getComponent();
        if (jComponent2 != null && !jComponent2.isEnabled()) {
            return 8;
        }
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        synthContext.getPainter().paintToolTipBackground(synthContext, graphics, 0, 0, jComponent.getWidth(), jComponent.getHeight());
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    @Override
    public void paintBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        synthContext.getPainter().paintToolTipBorder(synthContext, graphics, n, n2, n3, n4);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
        JToolTip jToolTip = (JToolTip)synthContext.getComponent();
        String string = jToolTip.getToolTipText();
        Insets insets = jToolTip.getInsets();
        View view = (View)jToolTip.getClientProperty("html");
        if (view != null) {
            Rectangle rectangle = new Rectangle(insets.left, insets.top, jToolTip.getWidth() - (insets.left + insets.right), jToolTip.getHeight() - (insets.top + insets.bottom));
            view.paint(graphics, rectangle);
        } else {
            graphics.setColor(synthContext.getStyle().getColor(synthContext, ColorType.TEXT_FOREGROUND));
            graphics.setFont(this.style.getFont(synthContext));
            synthContext.getStyle().getGraphicsUtils(synthContext).paintText(synthContext, graphics, jToolTip.getTipText(), insets.left, insets.top, -1);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        Insets insets = jComponent.getInsets();
        Dimension dimension = new Dimension(insets.left + insets.right, insets.top + insets.bottom);
        String string = ((JToolTip)jComponent).getTipText();
        if (string != null) {
            View view;
            View view2 = view = jComponent != null ? (View)jComponent.getClientProperty("html") : null;
            if (view != null) {
                dimension.width += (int)view.getPreferredSpan(0);
                dimension.height += (int)view.getPreferredSpan(1);
            } else {
                Font font = synthContext.getStyle().getFont(synthContext);
                FontMetrics fontMetrics = jComponent.getFontMetrics(font);
                dimension.width += synthContext.getStyle().getGraphicsUtils(synthContext).computeStringWidth(synthContext, font, fontMetrics, string);
                dimension.height += fontMetrics.getHeight();
            }
        }
        synthContext.dispose();
        return dimension;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string;
        if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
            this.updateStyle((JToolTip)propertyChangeEvent.getSource());
        }
        if ((string = propertyChangeEvent.getPropertyName()).equals("tiptext") || "font".equals(string) || "foreground".equals(string)) {
            JToolTip jToolTip = (JToolTip)propertyChangeEvent.getSource();
            String string2 = jToolTip.getTipText();
            BasicHTML.updateRenderer(jToolTip, string2);
        }
    }
}

