/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote;

import com.sun.jmx.mbeanserver.Util;
import com.sun.jmx.remote.util.ClassLogger;
import com.sun.jmx.remote.util.EnvHelp;
import java.io.IOException;
import java.net.MalformedURLException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.StringTokenizer;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorProvider;
import javax.management.remote.JMXProviderException;
import javax.management.remote.JMXServiceURL;
import sun.reflect.misc.ReflectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMXConnectorFactory {
    public static final String DEFAULT_CLASS_LOADER = "jmx.remote.default.class.loader";
    public static final String PROTOCOL_PROVIDER_PACKAGES = "jmx.remote.protocol.provider.pkgs";
    public static final String PROTOCOL_PROVIDER_CLASS_LOADER = "jmx.remote.protocol.provider.class.loader";
    private static final String PROTOCOL_PROVIDER_DEFAULT_PACKAGE = "com.sun.jmx.remote.protocol";
    private static final ClassLogger logger = new ClassLogger("javax.management.remote.misc", "JMXConnectorFactory");

    private JMXConnectorFactory() {
    }

    public static JMXConnector connect(JMXServiceURL jMXServiceURL) throws IOException {
        return JMXConnectorFactory.connect(jMXServiceURL, null);
    }

    public static JMXConnector connect(JMXServiceURL jMXServiceURL, Map<String, ?> map) throws IOException {
        if (jMXServiceURL == null) {
            throw new NullPointerException("Null JMXServiceURL");
        }
        JMXConnector jMXConnector = JMXConnectorFactory.newJMXConnector(jMXServiceURL, map);
        jMXConnector.connect(map);
        return jMXConnector;
    }

    public static JMXConnector newJMXConnector(JMXServiceURL jMXServiceURL, Map<String, ?> map) throws IOException {
        Object object;
        Map<Object, Object> map2;
        if (map == null) {
            map2 = new HashMap();
        } else {
            EnvHelp.checkAttributes(map);
            map2 = new HashMap(map);
        }
        ClassLoader classLoader = JMXConnectorFactory.resolveClassLoader(map2);
        Class<JMXConnectorProvider> clazz = JMXConnectorProvider.class;
        String string = jMXServiceURL.getProtocol();
        JMXConnectorProvider jMXConnectorProvider = JMXConnectorFactory.getProvider(jMXServiceURL, map2, "ClientProvider", clazz, classLoader);
        IOException iOException = null;
        if (jMXConnectorProvider == null) {
            if (classLoader != null) {
                try {
                    object = JMXConnectorFactory.getConnectorAsService(classLoader, jMXServiceURL, map2);
                    if (object != null) {
                        return object;
                    }
                }
                catch (JMXProviderException jMXProviderException) {
                    throw jMXProviderException;
                }
                catch (IOException iOException2) {
                    iOException = iOException2;
                }
            }
            jMXConnectorProvider = JMXConnectorFactory.getProvider(string, PROTOCOL_PROVIDER_DEFAULT_PACKAGE, JMXConnectorFactory.class.getClassLoader(), "ClientProvider", clazz);
        }
        if (jMXConnectorProvider == null) {
            object = new MalformedURLException("Unsupported protocol: " + string);
            if (iOException == null) {
                throw object;
            }
            throw (MalformedURLException)EnvHelp.initCause(object, iOException);
        }
        map2 = Collections.unmodifiableMap(map2);
        return jMXConnectorProvider.newJMXConnector(jMXServiceURL, map2);
    }

    private static String resolvePkgs(Map map) throws JMXProviderException {
        Object object = null;
        if (map != null) {
            object = map.get(PROTOCOL_PROVIDER_PACKAGES);
        }
        if (object == null) {
            object = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    return System.getProperty(JMXConnectorFactory.PROTOCOL_PROVIDER_PACKAGES);
                }
            });
        }
        if (object == null) {
            return null;
        }
        if (!(object instanceof String)) {
            String string = "Value of jmx.remote.protocol.provider.pkgs parameter is not a String: " + object.getClass().getName();
            throw new JMXProviderException(string);
        }
        String string = (String)object;
        if (string.trim().equals("")) {
            return null;
        }
        if (string.startsWith("|") || string.endsWith("|") || string.indexOf("||") >= 0) {
            String string2 = "Value of jmx.remote.protocol.provider.pkgs contains an empty element: " + string;
            throw new JMXProviderException(string2);
        }
        return string;
    }

    static <T> T getProvider(JMXServiceURL jMXServiceURL, Map<String, Object> map, String string, Class<T> clazz, ClassLoader classLoader) throws IOException {
        String string2 = jMXServiceURL.getProtocol();
        String string3 = JMXConnectorFactory.resolvePkgs(map);
        Object object = null;
        if (string3 != null && (object = (Object)JMXConnectorFactory.getProvider(string2, string3, classLoader, string, clazz)) != null) {
            boolean bl = classLoader != object.getClass().getClassLoader();
            map.put(PROTOCOL_PROVIDER_CLASS_LOADER, bl ? JMXConnectorFactory.wrap(classLoader) : classLoader);
        }
        return (T)object;
    }

    static <T> Iterator<T> getProviderIterator(Class<T> clazz, ClassLoader classLoader) {
        ServiceLoader<T> serviceLoader = ServiceLoader.load(clazz, classLoader);
        return serviceLoader.iterator();
    }

    private static ClassLoader wrap(final ClassLoader classLoader) {
        return classLoader != null ? AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return new ClassLoader(classLoader){

                    @Override
                    protected Class<?> loadClass(String string, boolean bl) throws ClassNotFoundException {
                        ReflectUtil.checkPackageAccess(string);
                        return super.loadClass(string, bl);
                    }
                };
            }
        }) : null;
    }

    private static JMXConnector getConnectorAsService(ClassLoader classLoader, JMXServiceURL jMXServiceURL, Map<String, ?> map) throws IOException {
        Iterator<JMXConnectorProvider> iterator = JMXConnectorFactory.getProviderIterator(JMXConnectorProvider.class, classLoader);
        JMXConnector jMXConnector = null;
        IOException iOException = null;
        while (iterator.hasNext()) {
            try {
                jMXConnector = iterator.next().newJMXConnector(jMXServiceURL, map);
                return jMXConnector;
            }
            catch (JMXProviderException jMXProviderException) {
                throw jMXProviderException;
            }
            catch (Exception exception) {
                if (logger.traceOn()) {
                    logger.trace("getConnectorAsService", "URL[" + jMXServiceURL + "] Service provider exception: " + exception);
                }
                if (exception instanceof MalformedURLException || iOException != null) continue;
                if (iOException instanceof IOException) {
                    iOException = (IOException)exception;
                    continue;
                }
                iOException = EnvHelp.initCause(new IOException(exception.getMessage()), exception);
            }
        }
        if (iOException == null) {
            return null;
        }
        throw iOException;
    }

    static <T> T getProvider(String string, String string2, ClassLoader classLoader, String string3, Class<T> clazz) throws IOException {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "|");
        while (stringTokenizer.hasMoreTokens()) {
            Class<?> clazz2;
            String string4 = stringTokenizer.nextToken();
            String string5 = string4 + "." + JMXConnectorFactory.protocol2package(string) + "." + string3;
            try {
                clazz2 = Class.forName(string5, true, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                continue;
            }
            if (!clazz.isAssignableFrom(clazz2)) {
                String string6 = "Provider class does not implement " + clazz.getName() + ": " + clazz2.getName();
                throw new JMXProviderException(string6);
            }
            Class clazz3 = (Class)Util.cast(clazz2);
            try {
                return clazz3.newInstance();
            }
            catch (Exception exception) {
                String string7 = "Exception when instantiating provider [" + string5 + "]";
                throw new JMXProviderException(string7, exception);
            }
        }
        return null;
    }

    static ClassLoader resolveClassLoader(Map map) {
        ClassLoader classLoader = null;
        if (map != null) {
            try {
                classLoader = (ClassLoader)map.get(PROTOCOL_PROVIDER_CLASS_LOADER);
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException("The ClassLoader supplied in the environment map using the jmx.remote.protocol.provider.class.loader attribute is not an instance of java.lang.ClassLoader");
            }
        }
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        return classLoader;
    }

    private static String protocol2package(String string) {
        return string.replace('+', '.').replace('-', '_');
    }
}

