/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Map;
import java.util.WeakHashMap;
import javax.management.Descriptor;
import javax.management.DescriptorRead;
import javax.management.ImmutableDescriptor;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;

public class MBeanInfo
implements Cloneable,
Serializable,
DescriptorRead {
    static final long serialVersionUID = -6451021435135161911L;
    private transient Descriptor descriptor;
    private final String description;
    private final String className;
    private final MBeanAttributeInfo[] attributes;
    private final MBeanOperationInfo[] operations;
    private final MBeanConstructorInfo[] constructors;
    private final MBeanNotificationInfo[] notifications;
    private transient int hashCode;
    private final transient boolean arrayGettersSafe;
    private static final Map<Class, Boolean> arrayGettersSafeMap = new WeakHashMap<Class, Boolean>();

    public MBeanInfo(String string, String string2, MBeanAttributeInfo[] mBeanAttributeInfoArray, MBeanConstructorInfo[] mBeanConstructorInfoArray, MBeanOperationInfo[] mBeanOperationInfoArray, MBeanNotificationInfo[] mBeanNotificationInfoArray) throws IllegalArgumentException {
        this(string, string2, mBeanAttributeInfoArray, mBeanConstructorInfoArray, mBeanOperationInfoArray, mBeanNotificationInfoArray, null);
    }

    public MBeanInfo(String string, String string2, MBeanAttributeInfo[] mBeanAttributeInfoArray, MBeanConstructorInfo[] mBeanConstructorInfoArray, MBeanOperationInfo[] mBeanOperationInfoArray, MBeanNotificationInfo[] mBeanNotificationInfoArray, Descriptor descriptor) throws IllegalArgumentException {
        this.className = string;
        this.description = string2;
        if (mBeanAttributeInfoArray == null) {
            mBeanAttributeInfoArray = MBeanAttributeInfo.NO_ATTRIBUTES;
        }
        this.attributes = mBeanAttributeInfoArray;
        if (mBeanOperationInfoArray == null) {
            mBeanOperationInfoArray = MBeanOperationInfo.NO_OPERATIONS;
        }
        this.operations = mBeanOperationInfoArray;
        if (mBeanConstructorInfoArray == null) {
            mBeanConstructorInfoArray = MBeanConstructorInfo.NO_CONSTRUCTORS;
        }
        this.constructors = mBeanConstructorInfoArray;
        if (mBeanNotificationInfoArray == null) {
            mBeanNotificationInfoArray = MBeanNotificationInfo.NO_NOTIFICATIONS;
        }
        this.notifications = mBeanNotificationInfoArray;
        if (descriptor == null) {
            descriptor = ImmutableDescriptor.EMPTY_DESCRIPTOR;
        }
        this.descriptor = descriptor;
        this.arrayGettersSafe = MBeanInfo.arrayGettersSafe(this.getClass(), MBeanInfo.class);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public String getClassName() {
        return this.className;
    }

    public String getDescription() {
        return this.description;
    }

    public MBeanAttributeInfo[] getAttributes() {
        MBeanAttributeInfo[] mBeanAttributeInfoArray = this.nonNullAttributes();
        if (mBeanAttributeInfoArray.length == 0) {
            return mBeanAttributeInfoArray;
        }
        return (MBeanAttributeInfo[])mBeanAttributeInfoArray.clone();
    }

    private MBeanAttributeInfo[] fastGetAttributes() {
        if (this.arrayGettersSafe) {
            return this.nonNullAttributes();
        }
        return this.getAttributes();
    }

    private MBeanAttributeInfo[] nonNullAttributes() {
        return this.attributes == null ? MBeanAttributeInfo.NO_ATTRIBUTES : this.attributes;
    }

    public MBeanOperationInfo[] getOperations() {
        MBeanOperationInfo[] mBeanOperationInfoArray = this.nonNullOperations();
        if (mBeanOperationInfoArray.length == 0) {
            return mBeanOperationInfoArray;
        }
        return (MBeanOperationInfo[])mBeanOperationInfoArray.clone();
    }

    private MBeanOperationInfo[] fastGetOperations() {
        if (this.arrayGettersSafe) {
            return this.nonNullOperations();
        }
        return this.getOperations();
    }

    private MBeanOperationInfo[] nonNullOperations() {
        return this.operations == null ? MBeanOperationInfo.NO_OPERATIONS : this.operations;
    }

    public MBeanConstructorInfo[] getConstructors() {
        MBeanConstructorInfo[] mBeanConstructorInfoArray = this.nonNullConstructors();
        if (mBeanConstructorInfoArray.length == 0) {
            return mBeanConstructorInfoArray;
        }
        return (MBeanConstructorInfo[])mBeanConstructorInfoArray.clone();
    }

    private MBeanConstructorInfo[] fastGetConstructors() {
        if (this.arrayGettersSafe) {
            return this.nonNullConstructors();
        }
        return this.getConstructors();
    }

    private MBeanConstructorInfo[] nonNullConstructors() {
        return this.constructors == null ? MBeanConstructorInfo.NO_CONSTRUCTORS : this.constructors;
    }

    public MBeanNotificationInfo[] getNotifications() {
        MBeanNotificationInfo[] mBeanNotificationInfoArray = this.nonNullNotifications();
        if (mBeanNotificationInfoArray.length == 0) {
            return mBeanNotificationInfoArray;
        }
        return (MBeanNotificationInfo[])mBeanNotificationInfoArray.clone();
    }

    private MBeanNotificationInfo[] fastGetNotifications() {
        if (this.arrayGettersSafe) {
            return this.nonNullNotifications();
        }
        return this.getNotifications();
    }

    private MBeanNotificationInfo[] nonNullNotifications() {
        return this.notifications == null ? MBeanNotificationInfo.NO_NOTIFICATIONS : this.notifications;
    }

    public Descriptor getDescriptor() {
        return (Descriptor)ImmutableDescriptor.nonNullDescriptor(this.descriptor).clone();
    }

    public String toString() {
        return this.getClass().getName() + "[" + "description=" + this.getDescription() + ", " + "attributes=" + Arrays.asList(this.fastGetAttributes()) + ", " + "constructors=" + Arrays.asList(this.fastGetConstructors()) + ", " + "operations=" + Arrays.asList(this.fastGetOperations()) + ", " + "notifications=" + Arrays.asList(this.fastGetNotifications()) + ", " + "descriptor=" + this.getDescriptor() + "]";
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MBeanInfo)) {
            return false;
        }
        MBeanInfo mBeanInfo = (MBeanInfo)object;
        if (!(MBeanInfo.isEqual(this.getClassName(), mBeanInfo.getClassName()) && MBeanInfo.isEqual(this.getDescription(), mBeanInfo.getDescription()) && ((Object)this.getDescriptor()).equals(mBeanInfo.getDescriptor()))) {
            return false;
        }
        return Arrays.equals(mBeanInfo.fastGetAttributes(), this.fastGetAttributes()) && Arrays.equals(mBeanInfo.fastGetOperations(), this.fastGetOperations()) && Arrays.equals(mBeanInfo.fastGetConstructors(), this.fastGetConstructors()) && Arrays.equals(mBeanInfo.fastGetNotifications(), this.fastGetNotifications());
    }

    public int hashCode() {
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        this.hashCode = this.getClassName().hashCode() ^ ((Object)this.getDescriptor()).hashCode() ^ MBeanInfo.arrayHashCode(this.fastGetAttributes()) ^ MBeanInfo.arrayHashCode(this.fastGetOperations()) ^ MBeanInfo.arrayHashCode(this.fastGetConstructors()) ^ MBeanInfo.arrayHashCode(this.fastGetNotifications());
        return this.hashCode;
    }

    private static int arrayHashCode(Object[] objectArray) {
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            n ^= objectArray[i].hashCode();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean arrayGettersSafe(Class clazz, Class clazz2) {
        if (clazz == clazz2) {
            return true;
        }
        Map<Class, Boolean> map = arrayGettersSafeMap;
        synchronized (map) {
            Boolean bl = arrayGettersSafeMap.get(clazz);
            if (bl == null) {
                try {
                    ArrayGettersSafeAction arrayGettersSafeAction = new ArrayGettersSafeAction(clazz, clazz2);
                    bl = AccessController.doPrivileged(arrayGettersSafeAction);
                }
                catch (Exception exception) {
                    bl = false;
                }
                arrayGettersSafeMap.put(clazz, bl);
            }
            return bl;
        }
    }

    private static boolean isEqual(String string, String string2) {
        boolean bl = string == null ? string2 == null : string.equals(string2);
        return bl;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.descriptor.getClass() == ImmutableDescriptor.class) {
            objectOutputStream.write(1);
            String[] stringArray = this.descriptor.getFieldNames();
            objectOutputStream.writeObject(stringArray);
            objectOutputStream.writeObject(this.descriptor.getFieldValues(stringArray));
        } else {
            objectOutputStream.write(0);
            objectOutputStream.writeObject(this.descriptor);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        switch (objectInputStream.read()) {
            case 1: {
                String[] stringArray = (String[])objectInputStream.readObject();
                if (stringArray.length == 0) {
                    this.descriptor = ImmutableDescriptor.EMPTY_DESCRIPTOR;
                    break;
                }
                Object[] objectArray = (Object[])objectInputStream.readObject();
                this.descriptor = new ImmutableDescriptor(stringArray, objectArray);
                break;
            }
            case 0: {
                this.descriptor = (Descriptor)objectInputStream.readObject();
                if (this.descriptor != null) break;
                this.descriptor = ImmutableDescriptor.EMPTY_DESCRIPTOR;
                break;
            }
            case -1: {
                this.descriptor = ImmutableDescriptor.EMPTY_DESCRIPTOR;
                break;
            }
            default: {
                throw new StreamCorruptedException("Got unexpected byte.");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ArrayGettersSafeAction
    implements PrivilegedAction<Boolean> {
        private final Class<?> subclass;
        private final Class<?> immutableClass;

        ArrayGettersSafeAction(Class<?> clazz, Class<?> clazz2) {
            this.subclass = clazz;
            this.immutableClass = clazz2;
        }

        @Override
        public Boolean run() {
            Method[] methodArray = this.immutableClass.getMethods();
            for (int i = 0; i < methodArray.length; ++i) {
                Method method = methodArray[i];
                String string = method.getName();
                if (!string.startsWith("get") || method.getParameterTypes().length != 0 || !method.getReturnType().isArray()) continue;
                try {
                    Method method2 = this.subclass.getMethod(string, new Class[0]);
                    if (method2.equals(method)) continue;
                    return false;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    return false;
                }
            }
            return true;
        }
    }
}

