/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.awt.font.NumericShaper;
import java.awt.font.TextAttribute;
import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import sun.font.FontManagerNativeLibrary;
import sun.text.CodePointIterator;

public final class Bidi {
    byte dir;
    byte baselevel;
    int length;
    int[] runs;
    int[] cws;
    public static final int DIRECTION_LEFT_TO_RIGHT = 0;
    public static final int DIRECTION_RIGHT_TO_LEFT = 1;
    public static final int DIRECTION_DEFAULT_LEFT_TO_RIGHT = -2;
    public static final int DIRECTION_DEFAULT_RIGHT_TO_LEFT = -1;
    private static final int DIR_MIXED = 2;
    private static final char NUMLEVELS = '>';
    private static final int RMASK = 57378;

    public Bidi(String string, int n) {
        if (string == null) {
            throw new IllegalArgumentException("paragraph is null");
        }
        Bidi.nativeBidiChars(this, string.toCharArray(), 0, null, 0, string.length(), n);
    }

    public Bidi(AttributedCharacterIterator attributedCharacterIterator) {
        int n;
        Serializable serializable;
        if (attributedCharacterIterator == null) {
            throw new IllegalArgumentException("paragraph is null");
        }
        int n2 = -2;
        byte[] byArray = null;
        int n3 = attributedCharacterIterator.getBeginIndex();
        int n4 = attributedCharacterIterator.getEndIndex();
        int n5 = n4 - n3;
        int n6 = 0;
        char[] cArray = new char[n5];
        char c = attributedCharacterIterator.first();
        while (true) {
            if (c == '\uffff') break;
            cArray[n6++] = c;
            c = attributedCharacterIterator.next();
        }
        attributedCharacterIterator.first();
        try {
            serializable = (Boolean)attributedCharacterIterator.getAttribute(TextAttribute.RUN_DIRECTION);
            if (serializable != null) {
                n2 = TextAttribute.RUN_DIRECTION_LTR.equals(serializable) ? 0 : 1;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        try {
            serializable = (NumericShaper)attributedCharacterIterator.getAttribute(TextAttribute.NUMERIC_SHAPING);
            if (serializable != null) {
                ((NumericShaper)serializable).shape(cArray, 0, cArray.length);
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        int n7 = n3;
        do {
            attributedCharacterIterator.setIndex(n7);
            Object object = attributedCharacterIterator.getAttribute(TextAttribute.BIDI_EMBEDDING);
            n = attributedCharacterIterator.getRunLimit(TextAttribute.BIDI_EMBEDDING);
            if (object == null) continue;
            try {
                int n8 = (Integer)object;
                if (n8 < -61 || n8 >= 61) continue;
                byte by = (byte)(n8 < 0 ? -n8 | 0x80 : n8);
                if (byArray == null) {
                    byArray = new byte[n5];
                }
                for (int i = n7 - n3; i < n - n3; ++i) {
                    byArray[i] = by;
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        } while ((n7 = n) < n4);
        Bidi.nativeBidiChars(this, cArray, 0, byArray, 0, cArray.length, n2);
    }

    public Bidi(char[] cArray, int n, byte[] byArray, int n2, int n3, int n4) {
        if (cArray == null) {
            throw new IllegalArgumentException("text is null");
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("bad length: " + n3);
        }
        if (n < 0 || n3 > cArray.length - n) {
            throw new IllegalArgumentException("bad range: " + n + " length: " + n3 + " for text of length: " + cArray.length);
        }
        if (byArray != null && (n2 < 0 || n3 > byArray.length - n2)) {
            throw new IllegalArgumentException("bad range: " + n2 + " length: " + n3 + " for embeddings of length: " + cArray.length);
        }
        if (byArray != null) {
            int n5 = n2 + n3;
            for (int i = n2; i < n5; ++i) {
                if (byArray[i] >= 0) continue;
                byte[] byArray2 = new byte[n3];
                System.arraycopy(byArray, n2, byArray2, 0, n3);
                i -= n2;
                while (i < n3) {
                    if (byArray2[i] < 0) {
                        byArray2[i] = (byte)(-byArray2[i] | 0x80);
                    }
                    ++i;
                }
                byArray = byArray2;
                n2 = 0;
                break;
            }
        }
        Bidi.nativeBidiChars(this, cArray, n, byArray, n2, n3, n4);
    }

    private Bidi(int n, int n2, int n3, int[] nArray, int[] nArray2) {
        this.reset(n, n2, n3, nArray, nArray2);
    }

    private void reset(int n, int n2, int n3, int[] nArray, int[] nArray2) {
        this.dir = (byte)n;
        this.baselevel = (byte)n2;
        this.length = n3;
        this.runs = nArray;
        this.cws = nArray2;
    }

    public Bidi createLineBidi(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        if (n == 0 && n2 == this.length) {
            return this;
        }
        int n7 = n2 - n;
        if (n < 0 || n2 < n || n2 > this.length) {
            throw new IllegalArgumentException("range " + n + " to " + n2 + " is invalid for paragraph of length " + this.length);
        }
        if (this.runs == null) {
            return new Bidi(this.dir, this.baselevel, n7, null, null);
        }
        int n8 = -1;
        int[] nArray = null;
        if (this.cws != null) {
            n6 = this.cws.length;
            for (int i = 0; i < n6; ++i) {
                if (this.cws[i] < n) continue;
                for (n6 = i; n6 < this.cws.length && this.cws[n6] < n2; ++n6) {
                }
                n5 = n2 - 1;
                while (n6 > i && this.cws[n6 - 1] == n5) {
                    n8 = n5--;
                    --n6;
                }
                if (n8 == n) {
                    return new Bidi(this.dir, this.baselevel, n7, null, null);
                }
                n4 = n6 - i;
                if (n4 <= 0) break;
                nArray = new int[n4];
                for (n3 = 0; n3 < n4; ++n3) {
                    nArray[n3] = this.cws[i + n3] - n;
                }
                break;
            }
        }
        int[] nArray2 = null;
        n6 = this.baselevel;
        n5 = n8 == -1 ? n2 : n8;
        n3 = this.runs.length;
        byte by = this.dir;
        for (n4 = 0; n4 < this.runs.length; n4 += 2) {
            if (this.runs[n4] <= n) continue;
            for (n3 = n4; n3 < this.runs.length && this.runs[n3] < n5; n3 += 2) {
            }
            if (n3 > n4 || this.runs[n4 + 1] != this.baselevel) {
                if (n8 != -1 && (n3 += 2) > n4 && this.runs[n3 - 1] != this.baselevel) {
                    nArray2 = new int[n3 - n4 + 2];
                    nArray2[n3 - n4] = n7;
                    nArray2[n3 - n4 + 1] = this.baselevel;
                } else {
                    n5 = n2;
                    nArray2 = new int[n3 - n4];
                }
                int n9 = 0;
                for (int i = n4; i < n3; i += 2) {
                    nArray2[n9++] = this.runs[i] - n;
                    nArray2[n9++] = this.runs[i + 1];
                }
                nArray2[n9 - 2] = n5 - n;
                break;
            }
            by = (this.runs[n4 + 1] & 1) == 0 ? (byte)0 : 1;
            break;
        }
        return new Bidi(by, this.baselevel, n7, nArray2, nArray);
    }

    public boolean isMixed() {
        return this.dir == 2;
    }

    public boolean isLeftToRight() {
        return this.dir == 0;
    }

    public boolean isRightToLeft() {
        return this.dir == 1;
    }

    public int getLength() {
        return this.length;
    }

    public boolean baseIsLeftToRight() {
        return (this.baselevel & 1) == 0;
    }

    public int getBaseLevel() {
        return this.baselevel;
    }

    public int getLevelAt(int n) {
        if (this.runs == null || n < 0 || n >= this.length) {
            return this.baselevel;
        }
        int n2 = 0;
        while (n >= this.runs[n2]) {
            n2 += 2;
        }
        return this.runs[n2 + 1];
    }

    public int getRunCount() {
        return this.runs == null ? 1 : this.runs.length / 2;
    }

    public int getRunLevel(int n) {
        return this.runs == null ? this.baselevel : this.runs[n * 2 + 1];
    }

    public int getRunStart(int n) {
        return this.runs == null || n == 0 ? 0 : this.runs[n * 2 - 2];
    }

    public int getRunLimit(int n) {
        return this.runs == null ? this.length : this.runs[n * 2];
    }

    public static boolean requiresBidi(char[] cArray, int n, int n2) {
        CodePointIterator codePointIterator = CodePointIterator.create(cArray, n, n2);
        int n3 = codePointIterator.next();
        while (n3 != -1) {
            int n4;
            if (n3 > 1424 && (0xE022 & 1 << (n4 = Bidi.nativeGetDirectionCode(n3))) != 0) {
                return true;
            }
            n3 = codePointIterator.next();
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public static void reorderVisually(byte[] var0, int var1_1, Object[] var2_2, int var3_3, int var4_4) {
        if (var4_4 < 0) {
            throw new IllegalArgumentException("count " + var4_4 + " must be >= 0");
        }
        if (var1_1 < 0 || var1_1 + var4_4 > var0.length) {
            throw new IllegalArgumentException("levelStart " + var1_1 + " and count " + var4_4 + " out of range [0, " + var0.length + "]");
        }
        if (var3_3 < 0 || var3_3 + var4_4 > var2_2.length) {
            throw new IllegalArgumentException("objectStart " + var3_3 + " and count " + var4_4 + " out of range [0, " + var2_2.length + "]");
        }
        var5_5 = 63;
        var6_6 = 0;
        var7_7 = var1_1 + var4_4;
        for (var8_8 = var1_1; var8_8 < var7_7; ++var8_8) {
            var9_9 = var0[var8_8];
            if (var9_9 > var6_6) {
                var6_6 = var9_9;
            }
            if ((var9_9 & 1) == 0 || var9_9 >= var5_5) continue;
            var5_5 = var9_9;
        }
        var8_8 = var3_3 - var1_1;
        while (var6_6 >= var5_5) {
            var9_9 = var1_1;
            block2: while (true) {
                if (var9_9 < var7_7 && var0[var9_9] < var6_6) {
                    ++var9_9;
                    continue;
                }
                if ((var10_10 = var9_9++) == var7_7) break;
                while (var9_9 < var7_7 && var0[var9_9] >= var6_6) {
                    ++var9_9;
                }
                var11_11 = var9_9 - 1;
                var10_10 += var8_8;
                var11_11 += var8_8;
                while (true) {
                    if (var10_10 < var11_11) ** break;
                    continue block2;
                    var12_12 = var2_2[var10_10];
                    var2_2[var10_10] = var2_2[var11_11];
                    var2_2[var11_11] = var12_12;
                    ++var10_10;
                    --var11_11;
                }
                break;
            }
            var6_6 = (byte)(var6_6 - 1);
        }
    }

    private static native int nativeGetDirectionCode(int var0);

    private static synchronized native void nativeBidiChars(Bidi var0, char[] var1, int var2, byte[] var3, int var4, int var5, int var6);

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append("[dir: " + this.dir);
        stringBuffer.append(" baselevel: " + this.baselevel);
        stringBuffer.append(" length: " + this.length);
        if (this.runs == null) {
            stringBuffer.append(" runs: null");
        } else {
            stringBuffer.append(" runs: [");
            for (n = 0; n < this.runs.length; n += 2) {
                if (n != 0) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(this.runs[n]);
                stringBuffer.append('/');
                stringBuffer.append(this.runs[n + 1]);
            }
            stringBuffer.append(']');
        }
        if (this.cws == null) {
            stringBuffer.append(" cws: null");
        } else {
            stringBuffer.append(" cws: [");
            for (n = 0; n < this.cws.length; ++n) {
                if (n != 0) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(Integer.toHexString(this.cws[n]));
            }
            stringBuffer.append(']');
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    static {
        FontManagerNativeLibrary.load();
    }
}

