/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.utils.resolver.implementations;

import com.sun.org.apache.xml.internal.security.signature.XMLSignatureInput;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolverException;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolverSpi;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ResolverXPointer
extends ResourceResolverSpi {
    static Logger log = Logger.getLogger(ResolverXPointer.class.getName());
    private static final String XP = "#xpointer(id(";
    private static final int XP_LENGTH = "#xpointer(id(".length();

    public boolean engineIsThreadSafe() {
        return true;
    }

    public XMLSignatureInput engineResolve(Attr attr, String string) throws ResourceResolverException {
        Object object;
        Node node = null;
        Document document = attr.getOwnerElement().getOwnerDocument();
        String string2 = attr.getNodeValue();
        if (ResolverXPointer.isXPointerSlash(string2)) {
            node = document;
        } else if (ResolverXPointer.isXPointerId(string2)) {
            Object[] objectArray;
            object = ResolverXPointer.getXPointerId(string2);
            node = document.getElementById((String)object);
            if (this.secureValidation && !XMLUtils.protectAgainstWrappingAttack((Node)(objectArray = attr.getOwnerDocument().getDocumentElement()), (String)object)) {
                Object[] objectArray2 = new Object[]{object};
                throw new ResourceResolverException("signature.Verification.MultipleIDs", objectArray2, attr, string);
            }
            if (node == null) {
                objectArray = new Object[]{object};
                throw new ResourceResolverException("signature.Verification.MissingID", objectArray, attr, string);
            }
        }
        object = new XMLSignatureInput(node);
        ((XMLSignatureInput)object).setMIMEType("text/xml");
        if (string != null && string.length() > 0) {
            ((XMLSignatureInput)object).setSourceURI(string.concat(attr.getNodeValue()));
        } else {
            ((XMLSignatureInput)object).setSourceURI(attr.getNodeValue());
        }
        return object;
    }

    public boolean engineCanResolve(Attr attr, String string) {
        if (attr == null) {
            return false;
        }
        String string2 = attr.getNodeValue();
        return ResolverXPointer.isXPointerSlash(string2) || ResolverXPointer.isXPointerId(string2);
    }

    private static boolean isXPointerSlash(String string) {
        return string.equals("#xpointer(/)");
    }

    private static boolean isXPointerId(String string) {
        if (string.startsWith(XP) && string.endsWith("))")) {
            String string2 = string.substring(XP_LENGTH, string.length() - 2);
            int n = string2.length() - 1;
            if (string2.charAt(0) == '\"' && string2.charAt(n) == '\"' || string2.charAt(0) == '\'' && string2.charAt(n) == '\'') {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Id=" + string2.substring(1, n));
                }
                return true;
            }
        }
        return false;
    }

    private static String getXPointerId(String string) {
        if (string.startsWith(XP) && string.endsWith("))")) {
            String string2 = string.substring(XP_LENGTH, string.length() - 2);
            int n = string2.length() - 1;
            if (string2.charAt(0) == '\"' && string2.charAt(n) == '\"' || string2.charAt(0) == '\'' && string2.charAt(n) == '\'') {
                return string2.substring(1, n);
            }
        }
        return null;
    }
}

