/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.keys.keyresolver;

import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverException;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverSpi;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.implementations.DSAKeyValueResolver;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.implementations.RSAKeyValueResolver;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.implementations.RetrievalMethodResolver;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.implementations.X509CertificateResolver;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.implementations.X509IssuerSerialResolver;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.implementations.X509SKIResolver;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.implementations.X509SubjectNameResolver;
import com.sun.org.apache.xml.internal.security.keys.storage.StorageResolver;
import com.sun.org.apache.xml.internal.security.utils.JavaUtils;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.SecretKey;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyResolver {
    private static Logger log = Logger.getLogger(KeyResolver.class.getName());
    private static List<KeyResolver> resolverVector = new CopyOnWriteArrayList<KeyResolver>();
    private final KeyResolverSpi resolverSpi;

    private KeyResolver(KeyResolverSpi keyResolverSpi) {
        this.resolverSpi = keyResolverSpi;
    }

    public static int length() {
        return resolverVector.size();
    }

    public static final X509Certificate getX509Certificate(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        for (KeyResolver keyResolver : resolverVector) {
            Object[] objectArray;
            if (keyResolver == null) {
                objectArray = new Object[]{element != null && element.getNodeType() == 1 ? element.getTagName() : "null"};
                throw new KeyResolverException("utils.resolver.noClass", objectArray);
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "check resolvability by class " + keyResolver.getClass());
            }
            if ((objectArray = keyResolver.resolveX509Certificate(element, string, storageResolver)) == null) continue;
            return objectArray;
        }
        Object[] objectArray = new Object[]{element != null && element.getNodeType() == 1 ? element.getTagName() : "null"};
        throw new KeyResolverException("utils.resolver.noClass", objectArray);
    }

    public static final PublicKey getPublicKey(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        for (KeyResolver keyResolver : resolverVector) {
            Object[] objectArray;
            if (keyResolver == null) {
                objectArray = new Object[]{element != null && element.getNodeType() == 1 ? element.getTagName() : "null"};
                throw new KeyResolverException("utils.resolver.noClass", objectArray);
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "check resolvability by class " + keyResolver.getClass());
            }
            if ((objectArray = keyResolver.resolvePublicKey(element, string, storageResolver)) == null) continue;
            return objectArray;
        }
        Object[] objectArray = new Object[]{element != null && element.getNodeType() == 1 ? element.getTagName() : "null"};
        throw new KeyResolverException("utils.resolver.noClass", objectArray);
    }

    public static void register(String string, boolean bl) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        JavaUtils.checkRegisterPermission();
        KeyResolverSpi keyResolverSpi = (KeyResolverSpi)Class.forName(string).newInstance();
        keyResolverSpi.setGlobalResolver(bl);
        KeyResolver.register(keyResolverSpi, false);
    }

    public static void registerAtStart(String string, boolean bl) {
        JavaUtils.checkRegisterPermission();
        KeyResolverSpi keyResolverSpi = null;
        Exception exception = null;
        try {
            keyResolverSpi = (KeyResolverSpi)Class.forName(string).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            exception = classNotFoundException;
        }
        catch (IllegalAccessException illegalAccessException) {
            exception = illegalAccessException;
        }
        catch (InstantiationException instantiationException) {
            exception = instantiationException;
        }
        if (exception != null) {
            throw (IllegalArgumentException)new IllegalArgumentException("Invalid KeyResolver class name").initCause(exception);
        }
        keyResolverSpi.setGlobalResolver(bl);
        KeyResolver.register(keyResolverSpi, true);
    }

    public static void register(KeyResolverSpi keyResolverSpi, boolean bl) {
        JavaUtils.checkRegisterPermission();
        KeyResolver keyResolver = new KeyResolver(keyResolverSpi);
        if (bl) {
            resolverVector.add(0, keyResolver);
        } else {
            resolverVector.add(keyResolver);
        }
    }

    public static void registerClassNames(List<String> list) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        JavaUtils.checkRegisterPermission();
        ArrayList<KeyResolver> arrayList = new ArrayList<KeyResolver>(list.size());
        for (String string : list) {
            KeyResolverSpi keyResolverSpi = (KeyResolverSpi)Class.forName(string).newInstance();
            keyResolverSpi.setGlobalResolver(false);
            arrayList.add(new KeyResolver(keyResolverSpi));
        }
        resolverVector.addAll(arrayList);
    }

    public static void registerDefaultResolvers() {
        ArrayList<KeyResolver> arrayList = new ArrayList<KeyResolver>();
        arrayList.add(new KeyResolver(new RSAKeyValueResolver()));
        arrayList.add(new KeyResolver(new DSAKeyValueResolver()));
        arrayList.add(new KeyResolver(new X509CertificateResolver()));
        arrayList.add(new KeyResolver(new X509SKIResolver()));
        arrayList.add(new KeyResolver(new RetrievalMethodResolver()));
        arrayList.add(new KeyResolver(new X509SubjectNameResolver()));
        arrayList.add(new KeyResolver(new X509IssuerSerialResolver()));
        resolverVector.addAll(arrayList);
    }

    public PublicKey resolvePublicKey(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        return this.resolverSpi.engineLookupAndResolvePublicKey(element, string, storageResolver);
    }

    public X509Certificate resolveX509Certificate(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        return this.resolverSpi.engineLookupResolveX509Certificate(element, string, storageResolver);
    }

    public SecretKey resolveSecretKey(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        return this.resolverSpi.engineLookupAndResolveSecretKey(element, string, storageResolver);
    }

    public void setProperty(String string, String string2) {
        this.resolverSpi.engineSetProperty(string, string2);
    }

    public String getProperty(String string) {
        return this.resolverSpi.engineGetProperty(string);
    }

    public boolean understandsProperty(String string) {
        return this.resolverSpi.understandsProperty(string);
    }

    public String resolverClassName() {
        return this.resolverSpi.getClass().getName();
    }

    public static Iterator<KeyResolverSpi> iterator() {
        return new ResolverIterator(resolverVector);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ResolverIterator
    implements Iterator<KeyResolverSpi> {
        List<KeyResolver> res;
        Iterator<KeyResolver> it;

        public ResolverIterator(List<KeyResolver> list) {
            this.res = list;
            this.it = this.res.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public KeyResolverSpi next() {
            KeyResolver keyResolver = this.it.next();
            if (keyResolver == null) {
                throw new RuntimeException("utils.resolver.noClass");
            }
            return keyResolver.resolverSpi;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Can't remove resolvers using the iterator");
        }
    }
}

