/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.SoftAbstractResampler;

public final class SoftLanczosResampler
extends SoftAbstractResampler {
    float[][] sinc_table;
    int sinc_table_fsize = 2000;
    int sinc_table_size = 5;
    int sinc_table_center = this.sinc_table_size / 2;

    public SoftLanczosResampler() {
        this.sinc_table = new float[this.sinc_table_fsize][];
        for (int i = 0; i < this.sinc_table_fsize; ++i) {
            this.sinc_table[i] = SoftLanczosResampler.sincTable(this.sinc_table_size, (float)(-i) / (float)this.sinc_table_fsize);
        }
    }

    public static double sinc(double d) {
        return d == 0.0 ? 1.0 : Math.sin(Math.PI * d) / (Math.PI * d);
    }

    public static float[] sincTable(int n, float f) {
        int n2 = n / 2;
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            float f2 = (float)(-n2 + i) + f;
            fArray[i] = f2 < -2.0f || f2 > 2.0f ? 0.0f : (f2 == 0.0f ? 1.0f : (float)(2.0 * Math.sin(Math.PI * (double)f2) * Math.sin(Math.PI * (double)f2 / 2.0) / (Math.PI * (double)f2 * (Math.PI * (double)f2))));
        }
        return fArray;
    }

    public int getPadding() {
        return this.sinc_table_size / 2 + 2;
    }

    public void interpolate(float[] fArray, float[] fArray2, float f, float[] fArray3, float f2, float[] fArray4, int[] nArray, int n) {
        float f3;
        float f4 = fArray3[0];
        int n2 = nArray[0];
        float f5 = f;
        int n3 = n;
        if (f2 == 0.0f) {
            for (f3 = fArray2[0]; f3 < f5 && n2 < n3; f3 += f4) {
                int n4 = (int)f3;
                float[] fArray5 = this.sinc_table[(int)((f3 - (float)n4) * (float)this.sinc_table_fsize)];
                int n5 = n4 - this.sinc_table_center;
                float f6 = 0.0f;
                int n6 = 0;
                while (n6 < this.sinc_table_size) {
                    f6 += fArray[n5] * fArray5[n6];
                    ++n6;
                    ++n5;
                }
                fArray4[n2++] = f6;
            }
        } else {
            while (f3 < f5 && n2 < n3) {
                int n7 = (int)f3;
                float[] fArray6 = this.sinc_table[(int)((f3 - (float)n7) * (float)this.sinc_table_fsize)];
                int n8 = n7 - this.sinc_table_center;
                float f7 = 0.0f;
                int n9 = 0;
                while (n9 < this.sinc_table_size) {
                    f7 += fArray[n8] * fArray6[n9];
                    ++n9;
                    ++n8;
                }
                fArray4[n2++] = f7;
                f3 += f4;
                f4 += f2;
            }
        }
        fArray2[0] = f3;
        nArray[0] = n2;
        fArray3[0] = f4;
    }
}

